/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.internal.client.zzad;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.ads.mediation.NetworkExtras;
import com.google.android.gms.ads.mediation.customevent.CustomEvent;
import com.google.android.gms.common.internal.zzaa;
import java.util.Date;
import java.util.Set;

public final class AdRequest {
    public static final int ERROR_CODE_INTERNAL_ERROR = 0;
    public static final int ERROR_CODE_INVALID_REQUEST = 1;
    public static final int ERROR_CODE_NETWORK_ERROR = 2;
    public static final int ERROR_CODE_NO_FILL = 3;
    public static final int GENDER_UNKNOWN = 0;
    public static final int GENDER_MALE = 1;
    public static final int GENDER_FEMALE = 2;
    public static final int MAX_CONTENT_URL_LENGTH = 512;
    public static final String DEVICE_ID_EMULATOR = zzad.DEVICE_ID_EMULATOR;
    private final zzad zzpg;

    private AdRequest(Builder builder) {
        this.zzpg = new zzad(builder.zzph);
    }

    public Date getBirthday() {
        return this.zzpg.getBirthday();
    }

    public String getContentUrl() {
        return this.zzpg.getContentUrl();
    }

    public int getGender() {
        return this.zzpg.getGender();
    }

    public Set<String> getKeywords() {
        return this.zzpg.getKeywords();
    }

    public Location getLocation() {
        return this.zzpg.getLocation();
    }

    @Deprecated
    public <T extends NetworkExtras> T getNetworkExtras(Class<T> clazz) {
        return this.zzpg.getNetworkExtras(clazz);
    }

    public <T extends MediationAdapter> Bundle getNetworkExtrasBundle(Class<T> clazz) {
        return this.zzpg.getNetworkExtrasBundle(clazz);
    }

    public <T extends CustomEvent> Bundle getCustomEventExtrasBundle(Class<T> clazz) {
        return this.zzpg.getCustomEventExtrasBundle(clazz);
    }

    public boolean isTestDevice(Context context) {
        return this.zzpg.isTestDevice(context);
    }

    public zzad zzaX() {
        return this.zzpg;
    }

    public static final class Builder {
        private final zzad.zza zzph = new zzad.zza();

        public Builder() {
            this.zzph.zzG(DEVICE_ID_EMULATOR);
        }

        public Builder addKeyword(String string) {
            this.zzph.zzF(string);
            return this;
        }

        public Builder addNetworkExtras(NetworkExtras networkExtras) {
            this.zzph.zza(networkExtras);
            return this;
        }

        public Builder addNetworkExtrasBundle(Class<? extends MediationAdapter> clazz, Bundle bundle) {
            this.zzph.zza(clazz, bundle);
            if (clazz.equals(AdMobAdapter.class) && bundle.getBoolean("_emulatorLiveAds")) {
                this.zzph.zzH(DEVICE_ID_EMULATOR);
            }
            return this;
        }

        public Builder addCustomEventExtrasBundle(Class<? extends CustomEvent> clazz, Bundle bundle) {
            this.zzph.zzb(clazz, bundle);
            return this;
        }

        public Builder addTestDevice(String string) {
            this.zzph.zzG(string);
            return this;
        }

        public AdRequest build() {
            return new AdRequest(this);
        }

        public Builder setBirthday(Date date) {
            this.zzph.zza(date);
            return this;
        }

        public Builder setContentUrl(String string) {
            zzaa.zzb((Object)string, (Object)"Content URL must be non-null.");
            zzaa.zzh((String)string, (Object)"Content URL must be non-empty.");
            zzaa.zzb((string.length() <= 512 ? 1 : 0) != 0, (String)"Content URL must not exceed %d in length.  Provided length was %d.", (Object[])new Object[]{512, string.length()});
            this.zzph.zzI(string);
            return this;
        }

        public Builder setGender(int n) {
            this.zzph.zzr(n);
            return this;
        }

        public Builder setLocation(Location location) {
            this.zzph.zzb(location);
            return this;
        }

        public Builder setRequestAgent(String string) {
            this.zzph.zzK(string);
            return this;
        }

        public Builder tagForChildDirectedTreatment(boolean bl) {
            this.zzph.zzm(bl);
            return this;
        }

        public Builder setIsDesignedForFamilies(boolean bl) {
            this.zzph.zzn(bl);
            return this;
        }
    }
}

