/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.overlay.zzz;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzpi;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzmb
@TargetApi(value=14)
public class zzd
extends zzj
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzMc = new HashMap<Integer, String>();
    private final zzz zzMd;
    private final boolean zzMe;
    private int zzMf = 0;
    private int zzMg = 0;
    private MediaPlayer zzMh;
    private Uri zzMi;
    private int zzMj;
    private int zzMk;
    private int zzMl;
    private int zzMm;
    private int zzMn;
    private zzy zzMo;
    private boolean zzMp;
    private int zzMq;
    private zzi zzMr;

    public zzd(Context context, boolean bl, boolean bl2, zzz zzz2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzMd = zzz2;
        this.zzMp = bl;
        this.zzMe = bl2;
        this.zzMd.zza(this);
    }

    @Override
    public String zzhd() {
        String string = String.valueOf(this.zzMp ? " spherical" : "");
        return string.length() != 0 ? "MediaPlayer".concat(string) : new String("MediaPlayer");
    }

    @Override
    public void zza(zzi zzi2) {
        this.zzMr = zzi2;
    }

    @Override
    public void setVideoPath(String string) {
        this.setVideoURI(Uri.parse((String)string));
    }

    public void setVideoURI(Uri uri) {
        this.zzMi = uri;
        this.zzMq = 0;
        this.zzhe();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void stop() {
        zzpe.v("AdMediaPlayerView stop");
        if (this.zzMh != null) {
            this.zzMh.stop();
            this.zzMh.release();
            this.zzMh = null;
            this.zzI(0);
            this.zzJ(0);
        }
        this.zzMd.onStop();
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzpe.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzMj = mediaPlayer.getVideoWidth();
        this.zzMk = mediaPlayer.getVideoHeight();
        if (this.zzMj != 0 && this.zzMk != 0) {
            this.requestLayout();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        zzpe.v("AdMediaPlayerView prepared");
        this.zzI(2);
        this.zzMd.zzhz();
        zzpi.zzWR.post(new Runnable(){

            @Override
            public void run() {
                if (zzd.this.zzMr != null) {
                    zzd.this.zzMr.zzhz();
                }
            }
        });
        this.zzMj = mediaPlayer.getVideoWidth();
        this.zzMk = mediaPlayer.getVideoHeight();
        if (this.zzMq != 0) {
            this.seekTo(this.zzMq);
        }
        this.zzhf();
        int n = this.zzMj;
        int n2 = this.zzMk;
        zzpe.zzbd((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzMg == 3) {
            this.play();
        }
        this.zzhh();
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        zzpe.v("AdMediaPlayerView completion");
        this.zzI(5);
        this.zzJ(5);
        zzpi.zzWR.post(new Runnable(){

            @Override
            public void run() {
                if (zzd.this.zzMr != null) {
                    zzd.this.zzMr.zzhB();
                }
            }
        });
    }

    public boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzMc.get(n);
        String string2 = zzMc.get(n2);
        zzpe.v(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string).append(":").append(string2).toString());
        return true;
    }

    public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        final String string = zzMc.get(n);
        final String string2 = zzMc.get(n2);
        zzpe.zzbe((String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string).append(":").append(string2).toString());
        this.zzI(-1);
        this.zzJ(-1);
        zzpi.zzWR.post(new Runnable(){

            @Override
            public void run() {
                if (zzd.this.zzMr != null) {
                    zzd.this.zzMr.zzk(string, string2);
                }
            }
        });
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzMl = n;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzpe.v("AdMediaPlayerView surface created");
        this.zzhe();
        zzpi.zzWR.post(new Runnable(){

            @Override
            public void run() {
                if (zzd.this.zzMr != null) {
                    zzd.this.zzMr.zzhy();
                }
            }
        });
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, final int n, final int n2) {
        boolean bl;
        zzpe.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzMg == 3;
        boolean bl3 = bl = this.zzMj == n && this.zzMk == n2;
        if (this.zzMh != null && bl2 && bl) {
            if (this.zzMq != 0) {
                this.seekTo(this.zzMq);
            }
            this.play();
        }
        if (this.zzMo != null) {
            this.zzMo.zzi(n, n2);
        }
        zzpi.zzWR.post(new Runnable(){

            @Override
            public void run() {
                if (zzd.this.zzMr != null) {
                    zzd.this.zzMr.zzf(n, n2);
                }
            }
        });
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzpe.v("AdMediaPlayerView surface destroyed");
        if (this.zzMh != null && this.zzMq == 0) {
            this.zzMq = this.zzMh.getCurrentPosition();
        }
        if (this.zzMo != null) {
            this.zzMo.zzhP();
        }
        zzpi.zzWR.post(new Runnable(){

            @Override
            public void run() {
                if (zzd.this.zzMr != null) {
                    zzd.this.zzMr.onPaused();
                    zzd.this.zzMr.zzhC();
                }
            }
        });
        this.zzy(true);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzMd.zzb(this);
        this.zzNj.zza(surfaceTexture, this.zzMr);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = zzd.getDefaultSize((int)this.zzMj, (int)n);
        int n4 = zzd.getDefaultSize((int)this.zzMk, (int)n2);
        if (this.zzMj > 0 && this.zzMk > 0 && this.zzMo == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzMj * n4 < n3 * this.zzMk) {
                    n3 = n4 * this.zzMj / this.zzMk;
                } else if (this.zzMj * n4 > n3 * this.zzMk) {
                    n4 = n3 * this.zzMk / this.zzMj;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzMk / this.zzMj;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzMj / this.zzMk;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzMj;
                n4 = this.zzMk;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzMj / this.zzMk;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzMk / this.zzMj;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzMo != null) {
            this.zzMo.zzi(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzMm > 0 && this.zzMm != n3 || this.zzMn > 0 && this.zzMn != n4) {
                this.zzhf();
            }
            this.zzMm = n3;
            this.zzMn = n4;
        }
    }

    public String toString() {
        String string = String.valueOf(this.getClass().getName());
        String string2 = String.valueOf(Integer.toHexString(this.hashCode()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
    }

    private void zzhe() {
        zzpe.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzMi == null || surfaceTexture == null) {
            return;
        }
        this.zzy(false);
        try {
            Surface surface;
            this.zzMh = zzv.zzda().zzhO();
            this.zzMh.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzMh.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzMh.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzMh.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzMh.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzMh.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzMl = 0;
            if (this.zzMp) {
                this.zzMo = new zzy(this.getContext());
                this.zzMo.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzMo.start();
                surface = this.zzMo.zzhQ();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzMo.zzhP();
                    this.zzMo = null;
                }
            }
            this.zzMh.setDataSource(this.getContext(), this.zzMi);
            surface = zzv.zzdb().zza(surfaceTexture);
            this.zzMh.setSurface(surface);
            this.zzMh.setAudioStreamType(3);
            this.zzMh.setScreenOnWhilePlaying(true);
            this.zzMh.prepareAsync();
            this.zzI(1);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string = String.valueOf(this.zzMi);
            zzpe.zzc((String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to initialize MediaPlayer at ").append(string).toString(), (Throwable)exception);
            this.onError(this.zzMh, 1, 0);
        }
    }

    private void zzhf() {
        if (!this.zzMe) {
            return;
        }
        if (this.zzhg() && this.zzMh.getCurrentPosition() > 0 && this.zzMg != 3) {
            long l;
            zzpe.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzMh.start();
            int n = this.zzMh.getCurrentPosition();
            long l2 = zzv.zzcP().currentTimeMillis();
            while (this.zzhg() && this.zzMh.getCurrentPosition() == n && (l = zzv.zzcP().currentTimeMillis()) - l2 <= 250L) {
            }
            this.zzMh.pause();
            this.zzhh();
        }
    }

    private void zzy(boolean bl) {
        zzpe.v("AdMediaPlayerView release");
        if (this.zzMo != null) {
            this.zzMo.zzhP();
            this.zzMo = null;
        }
        if (this.zzMh != null) {
            this.zzMh.reset();
            this.zzMh.release();
            this.zzMh = null;
            this.zzI(0);
            if (bl) {
                this.zzMg = 0;
                this.zzJ(0);
            }
        }
    }

    @Override
    public void play() {
        zzpe.v("AdMediaPlayerView play");
        if (this.zzhg()) {
            this.zzMh.start();
            this.zzI(3);
            this.zzNj.zzhA();
            zzpi.zzWR.post(new Runnable(){

                @Override
                public void run() {
                    if (zzd.this.zzMr != null) {
                        zzd.this.zzMr.zzhA();
                    }
                }
            });
        }
        this.zzJ(3);
    }

    @Override
    public void pause() {
        zzpe.v("AdMediaPlayerView pause");
        if (this.zzhg() && this.zzMh.isPlaying()) {
            this.zzMh.pause();
            this.zzI(4);
            zzpi.zzWR.post(new Runnable(){

                @Override
                public void run() {
                    if (zzd.this.zzMr != null) {
                        zzd.this.zzMr.onPaused();
                    }
                }
            });
        }
        this.zzJ(4);
    }

    @Override
    public int getDuration() {
        if (this.zzhg()) {
            return this.zzMh.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.zzhg()) {
            return this.zzMh.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(int n) {
        zzpe.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzhg()) {
            this.zzMh.seekTo(n);
            this.zzMq = 0;
        } else {
            this.zzMq = n;
        }
    }

    private boolean zzhg() {
        return this.zzMh != null && this.zzMf != -1 && this.zzMf != 0 && this.zzMf != 1;
    }

    @Override
    public void zza(float f, float f2) {
        if (this.zzMo != null) {
            this.zzMo.zzb(f, f2);
        }
    }

    @Override
    public int getVideoWidth() {
        if (this.zzMh != null) {
            return this.zzMh.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.zzMh != null) {
            return this.zzMh.getVideoHeight();
        }
        return 0;
    }

    @Override
    public void zzhh() {
        this.zza(this.zzNk.zzie());
    }

    private void zza(float f) {
        if (this.zzMh != null) {
            try {
                this.zzMh.setVolume(f, f);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzpe.zzbe((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private void zzI(int n) {
        if (n == 3) {
            this.zzMd.zzib();
            this.zzNk.zzib();
        } else if (this.zzMf == 3) {
            this.zzMd.zzic();
            this.zzNk.zzic();
        }
        this.zzMf = n;
    }

    private void zzJ(int n) {
        this.zzMg = n;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzMc.put(-1004, "MEDIA_ERROR_IO");
            zzMc.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzMc.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzMc.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzMc.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzMc.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzMc.put(1, "MEDIA_ERROR_UNKNOWN");
        zzMc.put(1, "MEDIA_INFO_UNKNOWN");
        zzMc.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzMc.put(701, "MEDIA_INFO_BUFFERING_START");
        zzMc.put(702, "MEDIA_INFO_BUFFERING_END");
        zzMc.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzMc.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzMc.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzMc.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzMc.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

