/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.internal.zzaq;
import com.google.android.gms.internal.zzav;
import com.google.android.gms.internal.zzaw;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zzhv;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzif;
import com.google.android.gms.internal.zzih;
import com.google.android.gms.internal.zzii;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzps;
import com.google.android.gms.internal.zzqp;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzmb
public final class zzhw {
    public static final zzhx zzHd = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
        }
    };
    public static final zzhx zzHe = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            String string2 = map.get("urls");
            if (TextUtils.isEmpty((CharSequence)string2)) {
                zzpe.zzbe((String)"URLs missing in canOpenURLs GMSG.");
                return;
            }
            String[] stringArray = string2.split(",");
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            PackageManager packageManager = zzqp2.getContext().getPackageManager();
            for (String string3 : stringArray) {
                String[] stringArray2 = string3.split(";", 2);
                String string4 = stringArray2[0].trim();
                String string5 = stringArray2.length > 1 ? stringArray2[1].trim() : "android.intent.action.VIEW";
                Uri uri = Uri.parse((String)string4);
                Intent intent = new Intent(string5, uri);
                ResolveInfo resolveInfo = packageManager.resolveActivity(intent, 65536);
                hashMap.put(string3, resolveInfo != null);
            }
            zzqp2.zza("openableURLs", hashMap);
        }
    };
    public static final zzhx zzHf = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            JSONArray jSONArray;
            JSONObject jSONObject;
            PackageManager packageManager = zzqp2.getContext().getPackageManager();
            String string2 = map.get("data");
            try {
                jSONObject = new JSONObject(string2);
            }
            catch (JSONException jSONException) {
                zzqp2.zzb("openableIntents", new JSONObject());
                return;
            }
            try {
                jSONArray = jSONObject.getJSONArray("intents");
            }
            catch (JSONException jSONException) {
                zzqp2.zzb("openableIntents", new JSONObject());
                return;
            }
            JSONObject jSONObject2 = new JSONObject();
            for (int i = 0; i < jSONArray.length(); ++i) {
                ResolveInfo resolveInfo;
                JSONObject jSONObject3;
                try {
                    jSONObject3 = jSONArray.getJSONObject(i);
                }
                catch (JSONException jSONException) {
                    zzpe.zzb((String)"Error parsing the intent data.", (Throwable)jSONException);
                    continue;
                }
                String string3 = jSONObject3.optString("id");
                String string4 = jSONObject3.optString("u");
                String string5 = jSONObject3.optString("i");
                String string6 = jSONObject3.optString("m");
                String string7 = jSONObject3.optString("p");
                String string8 = jSONObject3.optString("c");
                jSONObject3.optString("f");
                jSONObject3.optString("e");
                Intent intent = new Intent();
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    intent.setData(Uri.parse((String)string4));
                }
                if (!TextUtils.isEmpty((CharSequence)string5)) {
                    intent.setAction(string5);
                }
                if (!TextUtils.isEmpty((CharSequence)string6)) {
                    intent.setType(string6);
                }
                if (!TextUtils.isEmpty((CharSequence)string7)) {
                    intent.setPackage(string7);
                }
                if (!TextUtils.isEmpty((CharSequence)string8) && ((ResolveInfo)(resolveInfo = string8.split("/", 2))).length == 2) {
                    intent.setComponent(new ComponentName((String)resolveInfo[0], (String)resolveInfo[1]));
                }
                boolean bl = (resolveInfo = packageManager.resolveActivity(intent, 65536)) != null;
                try {
                    jSONObject2.put(string3, bl);
                    continue;
                }
                catch (JSONException jSONException) {
                    zzpe.zzb((String)"Error constructing openable urls response.", (Throwable)jSONException);
                }
            }
            zzqp2.zzb("openableIntents", jSONObject2);
        }
    };
    public static final zzhx zzHg = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            Object object;
            String string2 = map.get("u");
            if (string2 == null) {
                zzpe.zzbe((String)"URL missing from click GMSG.");
                return;
            }
            Uri uri = Uri.parse((String)string2);
            try {
                object = zzqp2.zzkX();
                if (object != null && ((zzav)object).zzc(uri)) {
                    uri = ((zzav)object).zza(uri, zzqp2.getContext(), zzqp2.getView());
                }
            }
            catch (zzaw zzaw2) {
                String string3 = String.valueOf(string2);
                zzpe.zzbe((String)(string3.length() != 0 ? "Unable to append parameter to URL: ".concat(string3) : new String("Unable to append parameter to URL: ")));
            }
            string2 = uri.toString();
            object = new zzps(zzqp2.getContext(), zzqp2.zzkY().zzaZ, string2);
            ((zzpd)object).zziw();
        }
    };
    public static final zzhx zzHh = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            zze zze2 = zzqp2.zzkT();
            if (zze2 != null) {
                zze2.close();
            } else {
                zze zze3 = zzqp2.zzkU();
                if (zze3 != null) {
                    zze3.close();
                } else {
                    zzpe.zzbe((String)"A GMSG tried to close something that wasn't an overlay.");
                }
            }
        }
    };
    public static final zzhx zzHi = new zzhx(){

        private void zzd(zzqp zzqp2) {
            zzn zzn2;
            zzpe.zzbd((String)"Received support message, responding.");
            zzd zzd2 = zzqp2.zzbz();
            if (zzd2 != null && (zzn2 = zzd2.zzsO) != null) {
                zzqp2.getContext();
            }
            zzn2 = new JSONObject();
            try {
                zzn2.put("event", "checkSupport");
                zzn2.put("supports", false);
                zzqp2.zzb("appStreaming", (JSONObject)zzn2);
            }
            catch (Throwable throwable) {}
        }

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            if ("checkSupport".equals(map.get("action"))) {
                this.zzd(zzqp2);
                return;
            }
            zze zze2 = zzqp2.zzkT();
            if (zze2 != null) {
                zze2.zzg(zzqp2, map);
            }
        }
    };
    public static final zzhx zzHj = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            zzqp2.zzK("1".equals(map.get("custom_close")));
        }
    };
    public static final zzhx zzHk = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            String string2 = map.get("u");
            if (string2 == null) {
                zzpe.zzbe((String)"URL missing from httpTrack GMSG.");
                return;
            }
            zzps zzps2 = new zzps(zzqp2.getContext(), zzqp2.zzkY().zzaZ, string2);
            zzps2.zziw();
        }
    };
    public static final zzhx zzHl = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            String string2 = String.valueOf(map.get("string"));
            zzpe.zzbd((String)(string2.length() != 0 ? "Received log message: ".concat(string2) : new String("Received log message: ")));
        }
    };
    public static final zzhx zzHm = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            zzgs zzgs2 = zzqp2.zzll();
            if (zzgs2 != null) {
                zzgs2.zzfR();
            }
        }
    };
    public static final zzhx zzHn = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            String string2 = map.get("tx");
            String string3 = map.get("ty");
            String string4 = map.get("td");
            try {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                zzav zzav2 = zzqp2.zzkX();
                if (zzav2 != null) {
                    zzaq zzaq2 = zzav2.zzW();
                    zzaq2.zza(n, n2, n3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                zzpe.zzbe((String)"Could not parse touch parameters from gmsg.");
            }
        }
    };
    public static final zzhx zzHo = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            if (!zzfx.zzCX.get().booleanValue()) {
                return;
            }
            String string2 = map.get("disabled");
            boolean bl = Boolean.parseBoolean(string2);
            zzqp2.zzL(!bl);
        }
    };
    public static final zzhx zzHp = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            String string2 = map.get("action");
            if ("pause".equals(string2)) {
                zzqp2.zzbV();
            } else if ("resume".equals(string2)) {
                zzqp2.zzbW();
            }
        }
    };
    public static final zzhx zzHq = new zzih();
    public static final zzhx zzHr = new zzii();
    public static final zzhx zzHs = new zzim();
    public static final zzhx zzHt = new zzhv();
    public static final zzif zzHu = new zzif();
    public static final zzhx zzHv = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            if (map.keySet().contains("start")) {
                zzqp2.zzkV().zzlu();
                return;
            }
            if (map.keySet().contains("stop")) {
                zzqp2.zzkV().zzlv();
                return;
            }
            if (map.keySet().contains("cancel")) {
                zzqp2.zzkV().zzlw();
                return;
            }
        }
    };
    public static final zzhx zzHw = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            if (map.keySet().contains("start")) {
                zzqp2.zzM(true);
            }
            if (map.keySet().contains("stop")) {
                zzqp2.zzM(false);
            }
        }
    };
    public static final zzhx zzHx = new zzhx(){

        @Override
        public void zza(zzqp zzqp2, Map<String, String> map) {
            WindowManager windowManager = (WindowManager)zzqp2.getContext().getSystemService("window");
            Map<String, Integer> map2 = zzv.zzcJ().zza((View)zzqp2, windowManager);
            zzqp2.zza("locationReady", map2);
            zzpe.zzbe((String)"GET LOCATION COMPILED");
        }
    };
}

