/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzfx;
import com.google.android.gms.internal.zzhx;
import com.google.android.gms.internal.zzmb;
import com.google.android.gms.internal.zzpe;
import com.google.android.gms.internal.zzqo;
import com.google.android.gms.internal.zzqp;
import java.util.Map;
import org.json.JSONObject;

@zzmb
public final class zzih
implements zzhx {
    private boolean zzHT;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                n2 = zzeh.zzeO().zzb(context, Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzpe.zzbe((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    @Override
    public void zza(zzqp zzqp2, Map<String, String> map) {
        Object object;
        String string2 = map.get("action");
        if (string2 == null) {
            zzpe.zzbe((String)"Action missing from video GMSG.");
            return;
        }
        if (zzpe.zzai((int)3)) {
            object = new JSONObject(map);
            object.remove("google.afma.Notify_dt");
            String string3 = String.valueOf(object.toString());
            zzpe.zzbc((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Video GMSG: ").append(string2).append(" ").append(string3).toString());
        }
        if ("background".equals(string2)) {
            object = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object)) {
                zzpe.zzbe((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object);
                zzqp2.setBackgroundColor(n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzpe.zzbe((String)"Invalid color parameter in video GMSG.");
            }
            return;
        }
        object = zzqp2.zzld();
        if (object == null) {
            zzpe.zzbe((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzqp2.getContext();
            int n2 = zzih.zza(context, map, "x", 0);
            int n3 = zzih.zza(context, map, "y", 0);
            int n4 = zzih.zza(context, map, "w", -1);
            int n5 = zzih.zza(context, map, "h", -1);
            if (zzfx.zzEb.get().booleanValue()) {
                n4 = Math.min(n4, zzqp2.getMeasuredWidth() - n2);
                n5 = Math.min(n5, zzqp2.getMeasuredHeight() - n3);
            }
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean(map.get("spherical"));
            if (bl && ((zzqo)object).zzkO() == null) {
                ((zzqo)object).zza(n2, n3, n4, n5, n, bl3);
            } else {
                ((zzqo)object).zze(n2, n3, n4, n5);
            }
        } else {
            zzl zzl2 = ((zzqo)object).zzkO();
            if (zzl2 == null) {
                zzl.zzi(zzqp2);
                return;
            }
            if ("click".equals(string2)) {
                Context context = zzqp2.getContext();
                int n = zzih.zza(context, map, "x", 0);
                int n6 = zzih.zza(context, map, "y", 0);
                long l = SystemClock.uptimeMillis();
                MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
                zzl2.zzf(motionEvent);
                motionEvent.recycle();
            } else if ("currentTime".equals(string2)) {
                String string4 = map.get("time");
                if (string4 == null) {
                    zzpe.zzbe((String)"Time parameter missing from currentTime video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string4);
                    int n = (int)(f * 1000.0f);
                    zzl2.seekTo(n);
                }
                catch (NumberFormatException numberFormatException) {
                    String string5 = String.valueOf(string4);
                    zzpe.zzbe((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                }
            } else if ("hide".equals(string2)) {
                zzl2.setVisibility(4);
            } else if ("load".equals(string2)) {
                zzl2.zzgq();
            } else if ("muted".equals(string2)) {
                boolean bl4 = Boolean.parseBoolean(map.get("muted"));
                if (bl4) {
                    zzl2.zzhE();
                } else {
                    zzl2.zzhF();
                }
            } else if ("pause".equals(string2)) {
                zzl2.pause();
            } else if ("play".equals(string2)) {
                zzl2.play();
            } else if ("show".equals(string2)) {
                zzl2.setVisibility(0);
            } else if ("src".equals(string2)) {
                zzl2.zzaB(map.get("src"));
            } else if ("touchMove".equals(string2)) {
                Context context = zzqp2.getContext();
                int n = zzih.zza(context, map, "dx", 0);
                int n7 = zzih.zza(context, map, "dy", 0);
                zzl2.zza(n, n7);
                if (!this.zzHT) {
                    zze zze2 = zzqp2.zzkT();
                    zze2.zzhq();
                    this.zzHT = true;
                }
            } else if ("volume".equals(string2)) {
                String string6 = map.get("volume");
                if (string6 == null) {
                    zzpe.zzbe((String)"Level parameter missing from volume video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat(string6);
                    zzl2.zzb(f);
                }
                catch (NumberFormatException numberFormatException) {
                    String string7 = String.valueOf(string6);
                    zzpe.zzbe((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                }
            } else if ("watermark".equals(string2)) {
                zzl2.zzhG();
            } else {
                String string8 = String.valueOf(string2);
                zzpe.zzbe((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
            }
        }
    }
}

