/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.overlay.zzz;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzds;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzme
@TargetApi(value=14)
public class zzd
extends zzj
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzMK = new HashMap<Integer, String>();
    private final zzz zzML;
    private final boolean zzMM;
    private int zzMN = 0;
    private int zzMO = 0;
    private MediaPlayer zzMP;
    private Uri zzMQ;
    private int zzMR;
    private int zzMS;
    private int zzMT;
    private int zzMU;
    private int zzMV;
    private zzy zzMW;
    private boolean zzMX;
    private int zzMY;
    private zzi zzMZ;

    public zzd(Context context, boolean bl, boolean bl2, zzz zzz2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzML = zzz2;
        this.zzMX = bl;
        this.zzMM = bl2;
        this.zzML.zza(this);
    }

    @Override
    public String zzhy() {
        String string = String.valueOf(this.zzMX ? " spherical" : "");
        return string.length() != 0 ? "MediaPlayer".concat(string) : new String("MediaPlayer");
    }

    @Override
    public void zza(zzi zzi2) {
        this.zzMZ = zzi2;
    }

    @Override
    public void setVideoPath(String string) {
        this.setVideoURI(Uri.parse((String)string));
    }

    public void setVideoURI(Uri uri) {
        zzds zzds2 = zzds.zze(uri);
        this.zzMQ = zzds2 == null ? uri : Uri.parse((String)zzds2.url);
        this.zzMY = 0;
        this.zzhz();
        this.requestLayout();
        this.invalidate();
    }

    @Override
    public void stop() {
        zzpk.v("AdMediaPlayerView stop");
        if (this.zzMP != null) {
            this.zzMP.stop();
            this.zzMP.release();
            this.zzMP = null;
            this.zzK(0);
            this.zzL(0);
        }
        this.zzML.onStop();
    }

    public void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzpk.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzMR = mediaPlayer.getVideoWidth();
        this.zzMS = mediaPlayer.getVideoHeight();
        if (this.zzMR != 0 && this.zzMS != 0) {
            this.requestLayout();
        }
    }

    public void onPrepared(MediaPlayer mediaPlayer) {
        zzpk.v("AdMediaPlayerView prepared");
        this.zzK(2);
        this.zzML.zzhU();
        zzpo.zzXC.post(new Runnable(){

            @Override
            public void run() {
                if (zzd.this.zzMZ != null) {
                    zzd.this.zzMZ.zzhU();
                }
            }
        });
        this.zzMR = mediaPlayer.getVideoWidth();
        this.zzMS = mediaPlayer.getVideoHeight();
        if (this.zzMY != 0) {
            this.seekTo(this.zzMY);
        }
        this.zzhA();
        int n = this.zzMR;
        int n2 = this.zzMS;
        zzpk.zzbg((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzMO == 3) {
            this.play();
        }
        this.zzhC();
    }

    public void onCompletion(MediaPlayer mediaPlayer) {
        zzpk.v("AdMediaPlayerView completion");
        this.zzK(5);
        this.zzL(5);
        zzpo.zzXC.post(new Runnable(){

            @Override
            public void run() {
                if (zzd.this.zzMZ != null) {
                    zzd.this.zzMZ.zzhW();
                }
            }
        });
    }

    public boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzMK.get(n);
        String string2 = zzMK.get(n2);
        zzpk.v(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string).append(":").append(string2).toString());
        return true;
    }

    public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        final String string = zzMK.get(n);
        final String string2 = zzMK.get(n2);
        zzpk.zzbh((String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string).append(":").append(string2).toString());
        this.zzK(-1);
        this.zzL(-1);
        zzpo.zzXC.post(new Runnable(){

            @Override
            public void run() {
                if (zzd.this.zzMZ != null) {
                    zzd.this.zzMZ.zzl(string, string2);
                }
            }
        });
        return true;
    }

    public void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzMT = n;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzpk.v("AdMediaPlayerView surface created");
        this.zzhz();
        zzpo.zzXC.post(new Runnable(){

            @Override
            public void run() {
                if (zzd.this.zzMZ != null) {
                    zzd.this.zzMZ.zzhT();
                }
            }
        });
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, final int n, final int n2) {
        boolean bl;
        zzpk.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzMO == 3;
        boolean bl3 = bl = this.zzMR == n && this.zzMS == n2;
        if (this.zzMP != null && bl2 && bl) {
            if (this.zzMY != 0) {
                this.seekTo(this.zzMY);
            }
            this.play();
        }
        if (this.zzMW != null) {
            this.zzMW.zzj(n, n2);
        }
        zzpo.zzXC.post(new Runnable(){

            @Override
            public void run() {
                if (zzd.this.zzMZ != null) {
                    zzd.this.zzMZ.zzg(n, n2);
                }
            }
        });
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzpk.v("AdMediaPlayerView surface destroyed");
        if (this.zzMP != null && this.zzMY == 0) {
            this.zzMY = this.zzMP.getCurrentPosition();
        }
        if (this.zzMW != null) {
            this.zzMW.zzil();
        }
        zzpo.zzXC.post(new Runnable(){

            @Override
            public void run() {
                if (zzd.this.zzMZ != null) {
                    zzd.this.zzMZ.onPaused();
                    zzd.this.zzMZ.zzhX();
                }
            }
        });
        this.zzy(true);
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzML.zzb(this);
        this.zzNR.zza(surfaceTexture, this.zzMZ);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = zzd.getDefaultSize((int)this.zzMR, (int)n);
        int n4 = zzd.getDefaultSize((int)this.zzMS, (int)n2);
        if (this.zzMR > 0 && this.zzMS > 0 && this.zzMW == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzMR * n4 < n3 * this.zzMS) {
                    n3 = n4 * this.zzMR / this.zzMS;
                } else if (this.zzMR * n4 > n3 * this.zzMS) {
                    n4 = n3 * this.zzMS / this.zzMR;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzMS / this.zzMR;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzMR / this.zzMS;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzMR;
                n4 = this.zzMS;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzMR / this.zzMS;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzMS / this.zzMR;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzMW != null) {
            this.zzMW.zzj(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzMU > 0 && this.zzMU != n3 || this.zzMV > 0 && this.zzMV != n4) {
                this.zzhA();
            }
            this.zzMU = n3;
            this.zzMV = n4;
        }
    }

    public String toString() {
        String string = String.valueOf(this.getClass().getName());
        String string2 = String.valueOf(Integer.toHexString(this.hashCode()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
    }

    private void zzhz() {
        zzpk.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzMQ == null || surfaceTexture == null) {
            return;
        }
        this.zzy(false);
        try {
            Surface surface;
            this.zzMP = zzw.zzdd().zzik();
            this.zzMP.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzMP.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzMP.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzMP.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzMP.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzMP.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzMT = 0;
            if (this.zzMX) {
                this.zzMW = new zzy(this.getContext());
                this.zzMW.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzMW.start();
                surface = this.zzMW.zzim();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzMW.zzil();
                    this.zzMW = null;
                }
            }
            this.zzMP.setDataSource(this.getContext(), this.zzMQ);
            surface = zzw.zzde().zza(surfaceTexture);
            this.zzMP.setSurface(surface);
            this.zzMP.setAudioStreamType(3);
            this.zzMP.setScreenOnWhilePlaying(true);
            this.zzMP.prepareAsync();
            this.zzK(1);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string = String.valueOf(this.zzMQ);
            zzpk.zzc((String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to initialize MediaPlayer at ").append(string).toString(), (Throwable)exception);
            this.onError(this.zzMP, 1, 0);
        }
    }

    private void zzhA() {
        if (!this.zzMM) {
            return;
        }
        if (this.zzhB() && this.zzMP.getCurrentPosition() > 0 && this.zzMO != 3) {
            long l;
            zzpk.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzMP.start();
            int n = this.zzMP.getCurrentPosition();
            long l2 = zzw.zzcS().currentTimeMillis();
            while (this.zzhB() && this.zzMP.getCurrentPosition() == n && (l = zzw.zzcS().currentTimeMillis()) - l2 <= 250L) {
            }
            this.zzMP.pause();
            this.zzhC();
        }
    }

    private void zzy(boolean bl) {
        zzpk.v("AdMediaPlayerView release");
        if (this.zzMW != null) {
            this.zzMW.zzil();
            this.zzMW = null;
        }
        if (this.zzMP != null) {
            this.zzMP.reset();
            this.zzMP.release();
            this.zzMP = null;
            this.zzK(0);
            if (bl) {
                this.zzMO = 0;
                this.zzL(0);
            }
        }
    }

    @Override
    public void play() {
        zzpk.v("AdMediaPlayerView play");
        if (this.zzhB()) {
            this.zzMP.start();
            this.zzK(3);
            this.zzNR.zzhV();
            zzpo.zzXC.post(new Runnable(){

                @Override
                public void run() {
                    if (zzd.this.zzMZ != null) {
                        zzd.this.zzMZ.zzhV();
                    }
                }
            });
        }
        this.zzL(3);
    }

    @Override
    public void pause() {
        zzpk.v("AdMediaPlayerView pause");
        if (this.zzhB() && this.zzMP.isPlaying()) {
            this.zzMP.pause();
            this.zzK(4);
            zzpo.zzXC.post(new Runnable(){

                @Override
                public void run() {
                    if (zzd.this.zzMZ != null) {
                        zzd.this.zzMZ.onPaused();
                    }
                }
            });
        }
        this.zzL(4);
    }

    @Override
    public int getDuration() {
        if (this.zzhB()) {
            return this.zzMP.getDuration();
        }
        return -1;
    }

    @Override
    public int getCurrentPosition() {
        if (this.zzhB()) {
            return this.zzMP.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public void seekTo(int n) {
        zzpk.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzhB()) {
            this.zzMP.seekTo(n);
            this.zzMY = 0;
        } else {
            this.zzMY = n;
        }
    }

    private boolean zzhB() {
        return this.zzMP != null && this.zzMN != -1 && this.zzMN != 0 && this.zzMN != 1;
    }

    @Override
    public void zza(float f, float f2) {
        if (this.zzMW != null) {
            this.zzMW.zzb(f, f2);
        }
    }

    @Override
    public int getVideoWidth() {
        if (this.zzMP != null) {
            return this.zzMP.getVideoWidth();
        }
        return 0;
    }

    @Override
    public int getVideoHeight() {
        if (this.zzMP != null) {
            return this.zzMP.getVideoHeight();
        }
        return 0;
    }

    @Override
    public void zzhC() {
        this.zza(this.zzNS.zziA());
    }

    private void zza(float f) {
        if (this.zzMP != null) {
            try {
                this.zzMP.setVolume(f, f);
            }
            catch (IllegalStateException illegalStateException) {}
        } else {
            zzpk.zzbh((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
        }
    }

    private void zzK(int n) {
        if (n == 3) {
            this.zzML.zzix();
            this.zzNS.zzix();
        } else if (this.zzMN == 3) {
            this.zzML.zziy();
            this.zzNS.zziy();
        }
        this.zzMN = n;
    }

    private void zzL(int n) {
        this.zzMO = n;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzMK.put(-1004, "MEDIA_ERROR_IO");
            zzMK.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzMK.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzMK.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzMK.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzMK.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzMK.put(1, "MEDIA_ERROR_UNKNOWN");
        zzMK.put(1, "MEDIA_INFO_UNKNOWN");
        zzMK.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzMK.put(701, "MEDIA_INFO_BUFFERING_START");
        zzMK.put(702, "MEDIA_INFO_BUFFERING_END");
        zzMK.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzMK.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzMK.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzMK.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzMK.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

