/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.google.android.gms.ads.internal.overlay.zzaa;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.internal.zzc;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzqw;
import java.util.HashMap;

@zzme
public class zzl
extends FrameLayout
implements zzi {
    private final zzqw zzIs;
    private final FrameLayout zzNT;
    private final zzgl zzNU;
    private final zzaa zzNV;
    private final long zzNW;
    @Nullable
    private zzj zzNX;
    private boolean zzNY;
    private boolean zzNZ;
    private boolean zzOa;
    private boolean zzOb;
    private long zzOc;
    private long zzOd;
    private String zzIx;
    private Bitmap zzOe;
    private ImageView zzOf;
    private boolean zzOg;

    public static void zzi(zzqw zzqw2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzqw2.zza("onVideoEvent", hashMap);
    }

    public zzl(Context context, zzqw zzqw2, int n, boolean bl, zzgl zzgl2) {
        super(context);
        this.zzIs = zzqw2;
        this.zzNU = zzgl2;
        this.zzNT = new FrameLayout(context);
        this.addView((View)this.zzNT, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        zzc.zzt((Object)zzqw2.zzby());
        this.zzNX = zzqw2.zzby().zzsN.zza(context, zzqw2, n, bl, zzgl2);
        if (this.zzNX != null) {
            this.zzNT.addView((View)this.zzNX, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            if (zzgd.zzBG.get().booleanValue()) {
                this.zzic();
            }
        }
        this.zzOf = new ImageView(context);
        this.zzNW = zzgd.zzBK.get();
        this.zzOb = zzgd.zzBI.get();
        if (this.zzNU != null) {
            this.zzNU.zzh("spinner_used", this.zzOb ? "1" : "0");
        }
        this.zzNV = new zzaa(this);
        if (this.zzNX != null) {
            this.zzNX.zza(this);
        }
        if (this.zzNX == null) {
            this.zzl("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    private void zzh(int n, int n2) {
        if (!this.zzOb) {
            return;
        }
        n = Math.max(n / zzgd.zzBJ.get(), 1);
        n2 = Math.max(n2 / zzgd.zzBJ.get(), 1);
        if (this.zzOe != null && this.zzOe.getWidth() == n && this.zzOe.getHeight() == n2) {
            return;
        }
        this.zzOe = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.zzOg = false;
    }

    public void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzNT.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public void zzaC(String string2) {
        this.zzIx = string2;
    }

    public void zza(float f, float f2) {
        if (this.zzNX != null) {
            this.zzNX.zza(f, f2);
        }
    }

    public void zzib() {
        if (this.zzNX == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzIx)) {
            this.zzNX.setVideoPath(this.zzIx);
        } else {
            this.zza("no_src", new String[0]);
        }
    }

    public void pause() {
        if (this.zzNX == null) {
            return;
        }
        this.zzNX.pause();
    }

    public void play() {
        if (this.zzNX == null) {
            return;
        }
        this.zzNX.play();
    }

    public void seekTo(int n) {
        if (this.zzNX == null) {
            return;
        }
        this.zzNX.seekTo(n);
    }

    public void zzhZ() {
        if (this.zzNX == null) {
            return;
        }
        this.zzNX.zzhZ();
    }

    public void zzia() {
        if (this.zzNX == null) {
            return;
        }
        this.zzNX.zzia();
    }

    public void zzb(float f) {
        if (this.zzNX == null) {
            return;
        }
        this.zzNX.zzb(f);
    }

    @TargetApi(value=14)
    public void zzf(MotionEvent motionEvent) {
        if (this.zzNX == null) {
            return;
        }
        this.zzNX.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public void zzic() {
        if (this.zzNX == null) {
            return;
        }
        Context context = this.zzNX.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzNX.zzhy());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzNT.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzNT.bringChildToFront((View)textView);
    }

    @Override
    public void zzhT() {
        this.zzNV.resume();
        zzpo.zzXC.post(new Runnable(){

            @Override
            public void run() {
                zzl.this.zza("surfaceCreated", new String[0]);
            }
        });
    }

    @Override
    public void zzhU() {
        if (this.zzNX == null) {
            return;
        }
        if (this.zzOd == 0L) {
            float f = (float)this.zzNX.getDuration() / 1000.0f;
            int n = this.zzNX.getVideoWidth();
            int n2 = this.zzNX.getVideoHeight();
            this.zza("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public void zzhV() {
        this.zzii();
        this.zzNY = true;
    }

    @Override
    public void onPaused() {
        this.zza("pause", new String[0]);
        this.zzij();
        this.zzNY = false;
    }

    @Override
    public void zzhW() {
        this.zza("ended", new String[0]);
        this.zzij();
    }

    @Override
    public void zzl(String string2, @Nullable String string3) {
        this.zza("error", "what", string2, "extra", string3);
    }

    @Override
    public void zzhX() {
        this.zzif();
        this.zzNV.pause();
        this.zzOd = this.zzOc;
        zzpo.zzXC.post(new Runnable(){

            @Override
            public void run() {
                zzl.this.zza("surfaceDestroyed", new String[0]);
            }
        });
    }

    public void destroy() {
        this.zzNV.pause();
        if (this.zzNX != null) {
            this.zzNX.stop();
        }
        this.zzij();
    }

    void zzid() {
        if (this.zzNX == null) {
            return;
        }
        long l = this.zzNX.getCurrentPosition();
        if (this.zzOc != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zza("timeupdate", "time", String.valueOf(f));
            this.zzOc = l;
        }
    }

    @Override
    public void zzhY() {
        if (this.zzNY) {
            this.zzig();
        }
        this.zzie();
    }

    @Override
    public void zzg(int n, int n2) {
        this.zzh(n, n2);
    }

    @TargetApi(value=14)
    private void zzie() {
        if (this.zzOe == null) {
            return;
        }
        long l = zzw.zzcS().elapsedRealtime();
        if (this.zzNX.getBitmap(this.zzOe) != null) {
            this.zzOg = true;
        }
        long l2 = zzw.zzcS().elapsedRealtime() - l;
        if (zzpk.zzkI()) {
            zzpk.v(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
        }
        if (l2 > this.zzNW) {
            zzpk.zzbh((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
            this.zzOb = false;
            this.zzOe = null;
            if (this.zzNU != null) {
                this.zzNU.zzh("spinner_jank", Long.toString(l2));
            }
        }
    }

    private void zzif() {
        if (this.zzOg && this.zzOe != null && !this.zzih()) {
            this.zzOf.setImageBitmap(this.zzOe);
            this.zzOf.invalidate();
            this.zzNT.addView((View)this.zzOf, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.zzNT.bringChildToFront((View)this.zzOf);
        }
    }

    private void zzig() {
        if (this.zzih()) {
            this.zzNT.removeView((View)this.zzOf);
        }
    }

    private boolean zzih() {
        return this.zzOf.getParent() != null;
    }

    private void zza(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        for (String string4 : stringArray) {
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzIs.zza("onVideoEvent", hashMap);
    }

    private void zzii() {
        if (this.zzIs.zzlr() == null) {
            return;
        }
        if (this.zzNZ) {
            return;
        }
        WindowManager.LayoutParams layoutParams = this.zzIs.zzlr().getWindow().getAttributes();
        boolean bl = this.zzOa = (layoutParams.flags & 0x80) != 0;
        if (!this.zzOa) {
            this.zzIs.zzlr().getWindow().addFlags(128);
            this.zzNZ = true;
        }
    }

    private void zzij() {
        if (this.zzIs.zzlr() == null) {
            return;
        }
        if (this.zzNZ && !this.zzOa) {
            this.zzIs.zzlr().getWindow().clearFlags(128);
            this.zzNZ = false;
        }
    }
}

