/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.util.zzt;
import com.google.android.gms.internal.zzdb;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzqw;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
@TargetApi(value=14)
public class zzde
extends Thread {
    private boolean mStarted = false;
    private boolean zzxO = false;
    private boolean zzal = false;
    private final Object zzrJ;
    private final zzdc zzxP;
    private final zzmd zzxQ;
    private final int zzxR;
    private final int zzxp;
    private final int zzxS;
    private final int zzxr;
    private final int zzxT;
    private final int zzxU;
    private final int zzxV;
    private final int zzxW;
    private final String zzxX;

    public zzde(zzdc zzdc2, zzmd zzmd2) {
        this.zzxP = zzdc2;
        this.zzxQ = zzmd2;
        this.zzrJ = new Object();
        this.zzxp = zzgd.zzCd.get();
        this.zzxS = zzgd.zzCe.get();
        this.zzxr = zzgd.zzCf.get();
        this.zzxT = zzgd.zzCg.get();
        this.zzxU = zzgd.zzCj.get();
        this.zzxV = zzgd.zzCl.get();
        this.zzxW = zzgd.zzCm.get();
        this.zzxR = zzgd.zzCh.get();
        this.zzxX = zzgd.zzCo.get();
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzej() {
        Object object = this.zzrJ;
        synchronized (object) {
            if (this.mStarted) {
                zzpk.zzbf((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object object;
            try {
                if (this.zzek()) {
                    object = zzw.zzcP().getActivity();
                    if (object == null) {
                        zzpk.zzbf((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzem();
                    } else {
                        this.zza((Activity)object);
                    }
                } else {
                    zzpk.zzbf((String)"ContentFetchTask: sleeping");
                    this.zzem();
                }
                Thread.sleep(this.zzxR * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzpk.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Throwable throwable) {
                zzpk.zzb((String)"Error in ContentFetchTask", (Throwable)throwable);
                this.zzxQ.zza(throwable, "ContentFetchTask.run");
            }
            object = this.zzrJ;
            synchronized (object) {
                while (this.zzxO) {
                    try {
                        zzpk.zzbf((String)"ContentFetchTask: waiting");
                        this.zzrJ.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    boolean zzh(final @Nullable View view) {
        if (view == null) {
            return false;
        }
        view.post(new Runnable(){

            @Override
            public void run() {
                zzde.this.zzi(view);
            }
        });
        return true;
    }

    void zzi(View view) {
        try {
            zzdb zzdb2 = new zzdb(this.zzxp, this.zzxS, this.zzxr, this.zzxT, this.zzxU, this.zzxV, this.zzxW);
            zza zza2 = this.zza(view, zzdb2);
            zzdb2.zzeg();
            if (zza2.zzyf == 0 && zza2.zzyg == 0) {
                return;
            }
            if (zza2.zzyg == 0 && zzdb2.zzeh() == 0) {
                return;
            }
            if (zza2.zzyg == 0 && this.zzxP.zza(zzdb2)) {
                return;
            }
            this.zzxP.zzc(zzdb2);
        }
        catch (Exception exception) {
            zzpk.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzxQ.zza(exception, "ContentFetchTask.fetchContent");
        }
    }

    boolean zzi(Context context) {
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager == null) {
            return false;
        }
        return powerManager.isScreenOn();
    }

    boolean zzek() {
        try {
            Context context = zzw.zzcP().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (!this.zza(runningAppProcessInfo) || keyguardManager.inKeyguardRestrictedInputMode() || !this.zzi(context)) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzw.zzcQ().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    boolean zza(ActivityManager.RunningAppProcessInfo runningAppProcessInfo) {
        return runningAppProcessInfo.importance == 100;
    }

    void zza(@Nullable Activity activity) {
        if (activity == null) {
            return;
        }
        View view = null;
        try {
            if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                view = activity.getWindow().getDecorView().findViewById(0x1020002);
            }
        }
        catch (Throwable throwable) {
            zzw.zzcQ().zza(throwable, "ContentFetchTask.extractContent");
            zzpk.zzbf((String)"Failed getting root view of activity. Content not extracted.");
        }
        if (view == null) {
            return;
        }
        this.zzh(view);
    }

    zza zza(@Nullable View view, zzdb zzdb2) {
        if (view == null) {
            return new zza(this, 0, 0);
        }
        Context context = zzw.zzcP().getContext();
        if (context != null) {
            int n = context.getResources().getIdentifier(zzgd.zzCn.get(), "id", context.getPackageName());
            String string2 = (String)view.getTag(n);
            if (!TextUtils.isEmpty((CharSequence)this.zzxX) && string2 != null && string2.equals(this.zzxX)) {
                return new zza(this, 0, 0);
            }
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            TextView textView = (TextView)view;
            CharSequence charSequence = textView.getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string3 = charSequence.toString();
                zzdb2.zzb(string3, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zza(this, 1, 0);
            }
            return new zza(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzqw)) {
            zzdb2.zzef();
            if (this.zza((WebView)view, zzdb2, bl)) {
                return new zza(this, 0, 1);
            }
            return new zza(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zza zza2 = this.zza(viewGroup.getChildAt(i), zzdb2);
                n += zza2.zzyf;
                n2 += zza2.zzyg;
            }
            return new zza(this, n, n2);
        }
        return new zza(this, 0, 0);
    }

    @TargetApi(value=19)
    boolean zza(final WebView webView, final zzdb zzdb2, final boolean bl) {
        if (!zzt.zzzl()) {
            return false;
        }
        zzdb2.zzef();
        webView.post(new Runnable(){
            ValueCallback<String> zzya = new ValueCallback<String>(){

                public void zzE(String string2) {
                    zzde.this.zza(zzdb2, webView, string2, bl);
                }

                public /* synthetic */ void onReceiveValue(Object object) {
                    this.zzE((String)object);
                }
            };

            @Override
            public void run() {
                if (webView.getSettings().getJavaScriptEnabled()) {
                    try {
                        webView.evaluateJavascript("(function() { return  {text:document.body.innerText}})();", this.zzya);
                    }
                    catch (Throwable throwable) {
                        this.zzya.onReceiveValue((Object)"");
                    }
                }
            }
        });
        return true;
    }

    void zza(zzdb zzdb2, WebView webView, String string2, boolean bl) {
        zzdb2.zzee();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                JSONObject jSONObject = new JSONObject(string2);
                String string3 = jSONObject.optString("text");
                if (!TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = String.valueOf(webView.getTitle());
                    zzdb2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzdb2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzdb2.zzdZ()) {
                this.zzxP.zzb(zzdb2);
            }
        }
        catch (JSONException jSONException) {
            zzpk.zzbf((String)"Json string may be malformed.");
        }
        catch (Throwable throwable) {
            zzpk.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzxQ.zza(throwable, "ContentFetchTask.processWebViewContent");
        }
    }

    public zzdb zzel() {
        return this.zzxP.zzei();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzxO = false;
            this.zzrJ.notifyAll();
            zzpk.zzbf((String)"ContentFetchThread: wakeup");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzem() {
        Object object = this.zzrJ;
        synchronized (object) {
            boolean bl = this.zzxO = true;
            zzpk.zzbf((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
        }
    }

    public boolean zzen() {
        return this.zzxO;
    }

    @zzme
    class zza {
        final int zzyf;
        final int zzyg;

        zza(zzde zzde2, int n, int n2) {
            this.zzyf = n;
            this.zzyg = n2;
        }
    }
}

