/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpn;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzqh;
import com.google.android.gms.internal.zzqw;
import java.io.BufferedOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
public class zzie
implements zzid {
    private final Context mContext;
    private final zzqh zztt;

    public zzie(Context context, zzqh zzqh2) {
        this.mContext = context;
        this.zztt = zzqh2;
    }

    protected zzb zzb(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            zzpk.zzb((String)"Error constructing http request.", (Throwable)malformedURLException);
        }
        ArrayList<zza> arrayList = new ArrayList<zza>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zza(string5, string6));
        }
        return new zzb(string2, uRL, arrayList, string4);
    }

    protected JSONObject zza(zzd zzd2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzd2.zzgl());
            if (zzd2.getBody() != null) {
                jSONObject.put("body", (Object)zzd2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zza zza2 : zzd2.zzgq()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zza2.getKey()).put("value", (Object)zza2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzd2.getResponseCode());
        }
        catch (JSONException jSONException) {
            zzpk.zzb((String)"Error constructing JSON for http response.", (Throwable)jSONException);
        }
        return jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected zzc zza(zzb zzb2) {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object2;
            httpURLConnection = (HttpURLConnection)zzb2.zzgm().openConnection();
            zzw.zzcM().zza(this.mContext, this.zztt.zzba, false, httpURLConnection);
            for (zza object32 : zzb2.zzgn()) {
                httpURLConnection.addRequestProperty(object32.getKey(), object32.getValue());
            }
            if (!TextUtils.isEmpty((CharSequence)zzb2.zzgo())) {
                httpURLConnection.setDoOutput(true);
                object2 = zzb2.zzgo().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(((Object)object2).length);
                BufferedOutputStream zzc2 = new BufferedOutputStream(httpURLConnection.getOutputStream());
                zzc2.write((byte[])object2);
                zzc2.close();
            }
            object2 = new ArrayList();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry<String, List<String>> entry : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : entry.getValue()) {
                        ((ArrayList)object2).add(new zza(entry.getKey(), string2));
                    }
                }
            }
            zzd zzd2 = new zzd(zzb2.zzgl(), httpURLConnection.getResponseCode(), (List<zza>)object2, zzw.zzcM().zza(new InputStreamReader(httpURLConnection.getInputStream())));
            zzc zzc2 = new zzc(this, true, zzd2, null);
            return zzc2;
        }
        catch (Exception exception) {
            zzc zzc3 = new zzc(this, false, null, exception.toString());
            return zzc3;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public JSONObject zzaa(String string2) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            zzpk.e((String)"The request is not a valid JSON.");
            try {
                return new JSONObject().put("success", false);
            }
            catch (JSONException jSONException2) {
                return new JSONObject();
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        String string3 = "";
        try {
            string3 = jSONObject.optString("http_request_id");
            zzb zzb2 = this.zzb(jSONObject);
            zzc zzc2 = this.zza(zzb2);
            if (zzc2.isSuccess()) {
                JSONObject jSONObject3 = this.zza(zzc2.zzgp());
                jSONObject2.put("response", (Object)jSONObject3);
                jSONObject2.put("success", true);
            } else {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)zzc2.getReason());
            }
        }
        catch (Exception exception) {
            try {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {}
        }
        return jSONObject2;
    }

    @Override
    public void zza(final zzqw zzqw2, final Map<String, String> map) {
        zzpn.zza(new Runnable(){

            @Override
            public void run() {
                zzpk.zzbf((String)"Received Http request.");
                String string2 = (String)map.get("http_request");
                final JSONObject jSONObject = zzie.this.zzaa(string2);
                if (jSONObject == null) {
                    zzpk.e((String)"Response should not be null.");
                    return;
                }
                zzpo.zzXC.post(new Runnable(){

                    @Override
                    public void run() {
                        zzqw2.zzb("fetchHttpRequestCompleted", jSONObject);
                        zzpk.zzbf((String)"Dispatched http response.");
                    }
                });
            }
        });
    }

    @zzme
    class zzc {
        private final zzd zzIh;
        private final boolean zzIi;
        private final String zzIj;

        public zzc(zzie zzie2, boolean bl, zzd zzd2, String string2) {
            this.zzIi = bl;
            this.zzIh = zzd2;
            this.zzIj = string2;
        }

        public String getReason() {
            return this.zzIj;
        }

        public zzd zzgp() {
            return this.zzIh;
        }

        public boolean isSuccess() {
            return this.zzIi;
        }
    }

    @zzme
    static class zzd {
        private final String zzId;
        private final int zzIk;
        private final List<zza> zzIl;
        private final String zzGr;

        public zzd(String string2, int n, List<zza> list, String string3) {
            this.zzId = string2;
            this.zzIk = n;
            this.zzIl = list == null ? new ArrayList<zza>() : list;
            this.zzGr = string3;
        }

        public String zzgl() {
            return this.zzId;
        }

        public int getResponseCode() {
            return this.zzIk;
        }

        public Iterable<zza> zzgq() {
            return this.zzIl;
        }

        public String getBody() {
            return this.zzGr;
        }
    }

    @zzme
    static class zzb {
        private final String zzId;
        private final URL zzIe;
        private final ArrayList<zza> zzIf;
        private final String zzIg;

        public zzb(String string2, URL uRL, ArrayList<zza> arrayList, String string3) {
            this.zzId = string2;
            this.zzIe = uRL;
            this.zzIf = arrayList == null ? new ArrayList() : arrayList;
            this.zzIg = string3;
        }

        public String zzgl() {
            return this.zzId;
        }

        public URL zzgm() {
            return this.zzIe;
        }

        public ArrayList<zza> zzgn() {
            return this.zzIf;
        }

        public String zzgo() {
            return this.zzIg;
        }
    }

    @zzme
    static class zza {
        private final String zzAX;
        private final String mValue;

        public zza(String string2, String string3) {
            this.zzAX = string2;
            this.mValue = string3;
        }

        public String getKey() {
            return this.zzAX;
        }

        public String getValue() {
            return this.mValue;
        }
    }
}

