/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzhc;
import com.google.android.gms.internal.zzjq;
import com.google.android.gms.internal.zzjr;
import com.google.android.gms.internal.zzjt;
import com.google.android.gms.internal.zzjv;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzkb;
import com.google.android.gms.internal.zzkc;
import com.google.android.gms.internal.zzkd;
import com.google.android.gms.internal.zzkh;
import com.google.android.gms.internal.zzkp;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpo;
import com.google.android.gms.internal.zzqh;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
public class zzju
implements zzjv.zza {
    private final String zzKW;
    private final zzka zzsz;
    private final long zzKX;
    private final zzjr zzKY;
    private final zzjq zzKZ;
    private zzec zzum;
    private final zzeg zzus;
    private final Context mContext;
    private final Object zzrJ = new Object();
    private final zzqh zztt;
    private final boolean zzwf;
    private final zzhc zztp;
    private final List<String> zztq;
    private final boolean zzLa;
    private zzkb zzLb;
    private int zzLc = -2;
    private zzkd zzLd;

    public zzju(Context context, String string2, zzka zzka2, zzjr zzjr2, zzjq zzjq2, zzec zzec2, zzeg zzeg2, zzqh zzqh2, boolean bl, boolean bl2, zzhc zzhc2, List<String> list) {
        this.mContext = context;
        this.zzsz = zzka2;
        this.zzKZ = zzjq2;
        this.zzKW = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string2) ? this.zzgV() : string2;
        this.zzKY = zzjr2;
        this.zzKX = zzjr2.zzKE != -1L ? zzjr2.zzKE : 10000L;
        this.zzum = zzec2;
        this.zzus = zzeg2;
        this.zztt = zzqh2;
        this.zzwf = bl;
        this.zzLa = bl2;
        this.zztp = zzhc2;
        this.zztq = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.zzrJ;
        synchronized (object) {
            try {
                if (this.zzLb != null) {
                    this.zzLb.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzLc = -1;
            this.zzrJ.notify();
        }
    }

    private String zzgV() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzKZ.zzKr)) {
                return this.zzsz.zzat(this.zzKZ.zzKr) ? "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter" : "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzpk.zzbh((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zzF(int n) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzLc = n;
            this.zzrJ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zza(int n, zzkd zzkd2) {
        Object object = this.zzrJ;
        synchronized (object) {
            this.zzLc = n;
            this.zzLd = zzkd2;
            this.zzrJ.notify();
        }
    }

    protected zzkb zza(MediationAdapter mediationAdapter) {
        return new zzkh(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzjv zza(long l, long l2) {
        Object object = this.zzrJ;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            final zzjt zzjt2 = new zzjt();
            zzpo.zzXC.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = zzju.this.zzrJ;
                    synchronized (object) {
                        if (zzju.this.zzLc != -2) {
                            return;
                        }
                        zzju.this.zzLb = zzju.this.zzgX();
                        if (zzju.this.zzLb == null) {
                            zzju.this.zzF(4);
                            return;
                        }
                        if (zzju.this.zzgY() && !zzju.this.zzG(1)) {
                            String string2 = zzju.this.zzKW;
                            zzpk.zzbh((String)new StringBuilder(56 + String.valueOf(string2).length()).append("Ignoring adapter ").append(string2).append(" as delayed impression is not supported").toString());
                            zzju.this.zzF(2);
                            return;
                        }
                        zzjt2.zza(zzju.this);
                        zzju.this.zza(zzjt2);
                    }
                }
            });
            long l4 = this.zza(l3, this.zzKX, l, l2);
            return new zzjv(this.zzKZ, this.zzLb, this.zzKW, zzjt2, this.zzLc, this.zzgW(), l4);
        }
    }

    private zzkd zzgW() {
        if (this.zzLc != 0 || !this.zzgY()) {
            return null;
        }
        try {
            if (this.zzG(4) && this.zzLd != null && this.zzLd.zzha() != 0) {
                return this.zzLd;
            }
        }
        catch (RemoteException remoteException) {
            zzpk.zzbh((String)"Could not get cpm value from MediationResponseMetadata");
        }
        return zzju.zzH(this.zzgZ());
    }

    private zzkb zzgX() {
        String string2 = String.valueOf(this.zzKW);
        zzpk.zzbg((String)(string2.length() != 0 ? "Instantiating mediation adapter: ".concat(string2) : new String("Instantiating mediation adapter: ")));
        if (!this.zzwf) {
            if (zzgd.zzDI.get().booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzKW)) {
                return this.zza((MediationAdapter)new AdMobAdapter());
            }
            if (zzgd.zzDJ.get().booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzKW)) {
                return this.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzKW)) {
                return new zzkh((MediationAdapter)new zzkp());
            }
        }
        try {
            return this.zzsz.zzas(this.zzKW);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(this.zzKW);
            zzpk.zza((String)(string3.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string3) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private void zza(zzjt zzjt2) {
        String string2 = this.zzap(this.zzKZ.zzKv);
        try {
            if (this.zztt.zzYX < 4100000) {
                if (this.zzus.zzzz) {
                    this.zzLb.zza(zzd.zzA((Object)this.mContext), this.zzum, string2, (zzkc)zzjt2);
                } else {
                    this.zzLb.zza(zzd.zzA((Object)this.mContext), this.zzus, this.zzum, string2, (zzkc)zzjt2);
                }
            } else if (this.zzwf) {
                this.zzLb.zza(zzd.zzA((Object)this.mContext), this.zzum, string2, this.zzKZ.zzKn, (zzkc)zzjt2, this.zztp, this.zztq);
            } else if (this.zzus.zzzz) {
                this.zzLb.zza(zzd.zzA((Object)this.mContext), this.zzum, string2, this.zzKZ.zzKn, (zzkc)zzjt2);
            } else if (this.zzLa) {
                if (this.zzKZ.zzKy != null) {
                    this.zzLb.zza(zzd.zzA((Object)this.mContext), this.zzum, string2, this.zzKZ.zzKn, (zzkc)zzjt2, new zzhc(zzju.zzaq(this.zzKZ.zzKC)), this.zzKZ.zzKB);
                } else {
                    this.zzLb.zza(zzd.zzA((Object)this.mContext), this.zzus, this.zzum, string2, this.zzKZ.zzKn, (zzkc)zzjt2);
                }
            } else {
                this.zzLb.zza(zzd.zzA((Object)this.mContext), this.zzus, this.zzum, string2, this.zzKZ.zzKn, (zzkc)zzjt2);
            }
        }
        catch (RemoteException remoteException) {
            zzpk.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzF(5);
        }
    }

    private long zza(long l, long l2, long l3, long l4) {
        while (this.zzLc == -2) {
            this.zzb(l, l2, l3, l4);
        }
        return zzw.zzcS().elapsedRealtime() - l;
    }

    private void zzb(long l, long l2, long l3, long l4) {
        long l5 = SystemClock.elapsedRealtime();
        long l6 = l2 - (l5 - l);
        long l7 = l4 - (l5 - l3);
        if (l6 <= 0L || l7 <= 0L) {
            zzpk.zzbg((String)"Timed out waiting for adapter.");
            this.zzLc = 3;
            return;
        }
        try {
            this.zzrJ.wait(Math.min(l6, l7));
        }
        catch (InterruptedException interruptedException) {
            this.zzLc = -1;
        }
    }

    private boolean zzG(int n) {
        Bundle bundle;
        try {
            bundle = this.zzwf ? this.zzLb.zzhf() : (this.zzus.zzzz ? this.zzLb.getInterstitialAdapterInfo() : this.zzLb.zzhe());
        }
        catch (RemoteException remoteException) {
            zzpk.zzbh((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private boolean zzgY() {
        return this.zzKY.zzKO != -1;
    }

    private String zzap(String string2) {
        if (string2 == null || !this.zzgY() || this.zzG(2)) {
            return string2;
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzpk.zzbh((String)"Could not remove field. Returning the original value");
            return string2;
        }
    }

    private int zzgZ() {
        JSONObject jSONObject;
        if (this.zzKZ.zzKv == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzKZ.zzKv);
        }
        catch (JSONException jSONException) {
            zzpk.zzbh((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzKW)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzG(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static zzkd zzH(final int n) {
        return new zzkd.zza(){

            public int zzha() throws RemoteException {
                return n;
            }
        };
    }

    private static NativeAdOptions zzaq(String string2) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string2 == null) {
            return builder.build();
        }
        try {
            JSONObject jSONObject = new JSONObject(string2);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string3 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation(zzju.zzar(string3));
        }
        catch (JSONException jSONException) {
            zzpk.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    private static int zzar(String string2) {
        if ("landscape".equals(string2)) {
            return 2;
        }
        if ("portrait".equals(string2)) {
            return 1;
        }
        return 0;
    }
}

