/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.app.DownloadManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Environment;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzfv;
import com.google.android.gms.internal.zzkw;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzqw;
import java.util.Map;

@zzme
public class zzkt
extends zzkw {
    private final Map<String, String> zzFP;
    private final Context mContext;

    public zzkt(zzqw zzqw2, Map<String, String> map) {
        super(zzqw2, "storePicture");
        this.zzFP = map;
        this.mContext = zzqw2.zzlr();
    }

    public void execute() {
        if (this.mContext == null) {
            this.zzaz("Activity context is not available");
            return;
        }
        zzfv zzfv2 = zzw.zzcM().zzN(this.mContext);
        if (!zzfv2.zzfn()) {
            this.zzaz("Feature is not supported by the device.");
            return;
        }
        final String string2 = this.zzFP.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzaz("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzaz(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        final String string4 = this.zzay(string2);
        if (!zzw.zzcM().zzaZ(string4)) {
            String string5 = String.valueOf(string4);
            this.zzaz(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzw.zzcQ().getResources();
        AlertDialog.Builder builder = zzw.zzcM().zzM(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.store_picture_title) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.store_picture_message) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.accept) : "Accept"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                DownloadManager downloadManager = (DownloadManager)zzkt.this.mContext.getSystemService("download");
                try {
                    DownloadManager.Request request = zzkt.this.zzk(string2, string4);
                    downloadManager.enqueue(request);
                }
                catch (IllegalStateException illegalStateException) {
                    zzkt.this.zzaz("Could not store picture.");
                }
            }
        });
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.decline) : "Decline"), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int n) {
                zzkt.this.zzaz("User canceled the download.");
            }
        });
        AlertDialog alertDialog = builder.create();
        alertDialog.show();
    }

    DownloadManager.Request zzk(String string2, String string3) {
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)string2));
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_PICTURES, string3);
        zzw.zzcO().zza(request);
        return request;
    }

    String zzay(String string2) {
        Uri uri = Uri.parse((String)string2);
        return uri.getLastPathSegment();
    }
}

