/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.Debug;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.ads.internal.zzx;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzj;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.internal.zzcs;
import com.google.android.gms.internal.zzdx;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzed;
import com.google.android.gms.internal.zzeg;
import com.google.android.gms.internal.zzel;
import com.google.android.gms.internal.zzeo;
import com.google.android.gms.internal.zzep;
import com.google.android.gms.internal.zzet;
import com.google.android.gms.internal.zzev;
import com.google.android.gms.internal.zzex;
import com.google.android.gms.internal.zzfa;
import com.google.android.gms.internal.zzfc;
import com.google.android.gms.internal.zzfr;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgj;
import com.google.android.gms.internal.zzgl;
import com.google.android.gms.internal.zzgp;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zzle;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzlq;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmf;
import com.google.android.gms.internal.zznq;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zznw;
import com.google.android.gms.internal.zzoo;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpc;
import com.google.android.gms.internal.zzpg;
import com.google.android.gms.internal.zzph;
import com.google.android.gms.internal.zzpk;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

@zzme
public abstract class zza
extends zzet.zza
implements zzq,
zzdx,
zzhz,
zzlq.zza,
zzmf.zza,
zzpg {
    protected zzgl zzsn;
    protected zzgj zzso;
    protected zzgj zzsp;
    protected boolean zzsq = false;
    protected final zzt zzsr;
    protected final zzx zzss;
    @Nullable
    protected transient zzec zzst;
    protected final zzcs zzsu;
    protected final zze zzsv;

    public zze zzby() {
        return this.zzsv;
    }

    zza(zzx zzx2, @Nullable zzt zzt2, zze zze2) {
        this.zzss = zzx2;
        this.zzsr = zzt2 != null ? zzt2 : new zzt(this);
        this.zzsv = zze2;
        zzw.zzcM().zzK(this.zzss.zzqn);
        zzw.zzcQ().zzc(this.zzss.zzqn, this.zzss.zzvn);
        zzw.zzcR().initialize(this.zzss.zzqn);
        this.zzsu = zzw.zzcQ().zzkx();
        zzw.zzcP().initialize(this.zzss.zzqn);
        this.zzbz();
    }

    private void zzbz() {
        if (zzgd.zzEz.get().booleanValue()) {
            Timer timer = new Timer();
            CountDownLatch countDownLatch = new CountDownLatch(zzgd.zzEB.get());
            TimerTask timerTask = this.zza(timer, countDownLatch);
            timer.schedule(timerTask, 0L, (long)zzgd.zzEA.get());
        }
    }

    private TimerTask zza(final Timer timer, final CountDownLatch countDownLatch) {
        return new TimerTask(){

            @Override
            public void run() {
                if ((long)zzgd.zzEB.get().intValue() != countDownLatch.getCount()) {
                    zzpk.zzbf((String)"Stopping method tracing");
                    Debug.stopMethodTracing();
                    if (countDownLatch.getCount() == 0L) {
                        timer.cancel();
                        return;
                    }
                }
                String string2 = String.valueOf(zza.this.zzss.zzqn.getPackageName()).concat("_adsTrace_");
                try {
                    zzpk.zzbf((String)"Starting method tracing");
                    countDownLatch.countDown();
                    long l = zzw.zzcS().currentTimeMillis();
                    Debug.startMethodTracing((String)new StringBuilder(20 + String.valueOf(string2).length()).append(string2).append(l).toString(), (int)zzgd.zzEC.get());
                }
                catch (Exception exception) {
                    zzpk.zzc((String)"Exception occurred while starting method tracing.", (Throwable)exception);
                    return;
                }
            }
        };
    }

    public void zzbA() {
        this.zzsn = new zzgl(zzgd.zzBZ.get(), "load_ad", this.zzss.zzvr.zzzy);
        this.zzso = new zzgj(-1L, null, null);
        this.zzsp = new zzgj(-1L, null, null);
    }

    public void destroy() {
        zzac.zzdj((String)"destroy must be called on the main UI thread.");
        this.zzsr.cancel();
        this.zzsu.zzk(this.zzss.zzvs);
        this.zzss.destroy();
    }

    public IObjectWrapper zzbB() {
        zzac.zzdj((String)"getAdFrame must be called on the main UI thread.");
        return zzd.zzA((Object)((Object)this.zzss.zzvo));
    }

    @Nullable
    public zzeg zzbC() {
        zzac.zzdj((String)"getAdSize must be called on the main UI thread.");
        return this.zzss.zzvr == null ? null : new zzfr(this.zzss.zzvr);
    }

    public boolean isReady() {
        zzac.zzdj((String)"isLoaded must be called on the main UI thread.");
        return this.zzss.zzvp == null && this.zzss.zzvq == null && this.zzss.zzvs != null;
    }

    public void setManualImpressionsEnabled(boolean bl) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    private zzec zza(zzec zzec2) {
        if (zzj.zzbb((Context)this.zzss.zzqn) && zzec2.zzzb != null) {
            return new zzed(zzec2).zza(null).zzeC();
        }
        return zzec2;
    }

    public boolean zzb(zzec zzec2) {
        zzac.zzdj((String)"loadAd must be called on the main UI thread.");
        zzw.zzcR().zzev();
        if (zzgd.zzCX.get().booleanValue()) {
            zzec.zzi((zzec)zzec2);
        }
        zzec2 = this.zza(zzec2);
        if (this.zzss.zzvp != null || this.zzss.zzvq != null) {
            if (this.zzst != null) {
                zzpk.zzbh((String)"Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            } else {
                zzpk.zzbh((String)"Loading already in progress, saving this object for future refreshes.");
            }
            this.zzst = zzec2;
            return false;
        }
        zzpk.zzbg((String)"Starting ad request.");
        this.zzbA();
        this.zzso = this.zzsn.zzfB();
        if (!zzec2.zzyW) {
            String string2 = String.valueOf(zzel.zzeT().zzad(this.zzss.zzqn));
            zzpk.zzbg((String)new StringBuilder(71 + String.valueOf(string2).length()).append("Use AdRequest.Builder.addTestDevice(\"").append(string2).append("\") to get test ads on this device.").toString());
        }
        this.zzsr.zzg(zzec2);
        this.zzsq = this.zza(zzec2, this.zzsn);
        return this.zzsq;
    }

    protected abstract boolean zza(zzec var1, zzgl var2);

    @Override
    public void zza(zzpb.zza zza2) {
        long l;
        if (zza2.zzWm.zzSr != -1L && !TextUtils.isEmpty((CharSequence)zza2.zzWm.zzSA) && (l = this.zzw(zza2.zzWm.zzSA)) != -1L) {
            zzgj zzgj2 = this.zzsn.zzc(zza2.zzWm.zzSr + l);
            this.zzsn.zza(zzgj2, "stc");
        }
        this.zzsn.zzX(zza2.zzWm.zzSA);
        this.zzsn.zza(this.zzso, "arf");
        this.zzsp = this.zzsn.zzfB();
        this.zzsn.zzh("gqi", zza2.zzWm.zzSB);
        this.zzss.zzvp = null;
        this.zzss.zzvt = zza2;
        this.zza(zza2, this.zzsn);
    }

    protected abstract void zza(zzpb.zza var1, zzgl var2);

    boolean zza(zzpb zzpb2) {
        return false;
    }

    @Override
    public void zzb(zzpb zzpb2) {
        this.zzsn.zza(this.zzsp, "awr");
        this.zzss.zzvq = null;
        if (zzpb2.errorCode != -2 && zzpb2.errorCode != 3) {
            zzw.zzcQ().zzb(this.zzss.zzdm());
        }
        if (zzpb2.errorCode == -1) {
            this.zzsq = false;
            return;
        }
        if (this.zza(zzpb2)) {
            zzpk.zzbf((String)"Ad refresh scheduled.");
        }
        if (zzpb2.errorCode != -2) {
            this.zzh(zzpb2.errorCode);
            return;
        }
        if (this.zzss.zzvM == null) {
            this.zzss.zzvM = new zzph(this.zzss.zzvl);
        }
        this.zzsu.zzj(this.zzss.zzvs);
        if (this.zza(this.zzss.zzvs, zzpb2)) {
            this.zzss.zzvs = zzpb2;
            this.zzss.zzdv();
            this.zzsn.zzh("is_mraid", this.zzss.zzvs.zzdD() ? "1" : "0");
            this.zzsn.zzh("is_mediation", this.zzss.zzvs.zzSn ? "1" : "0");
            if (this.zzss.zzvs.zzNH != null && this.zzss.zzvs.zzNH.zzlv() != null) {
                this.zzsn.zzh("is_delay_pl", this.zzss.zzvs.zzNH.zzlv().zzlR() ? "1" : "0");
            }
            this.zzsn.zza(this.zzso, "ttc");
            if (zzw.zzcQ().zzkk() != null) {
                zzw.zzcQ().zzkk().zza(this.zzsn);
            }
            if (this.zzss.zzdq()) {
                this.zzbJ();
            }
        }
        if (zzpb2.zzKI != null) {
            zzw.zzcM().zza(this.zzss.zzqn, zzpb2.zzKI);
        }
    }

    protected abstract boolean zza(@Nullable zzpb var1, zzpb var2);

    public void onAdClicked() {
        if (this.zzss.zzvs == null) {
            zzpk.zzbh((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        zzpk.zzbf((String)"Pinging click URLs.");
        if (this.zzss.zzvu != null) {
            this.zzss.zzvu.zzjW();
        }
        if (this.zzss.zzvs.zzKF != null) {
            String string2 = zzw.zzdl().zzF(this.zzss.zzqn);
            zzw.zzcM().zza(this.zzss.zzqn, this.zzss.zzvn.zzba, this.zza(string2, this.zzss.zzvs.zzKF));
            if (this.zzss.zzvs.zzKF.size() > 0) {
                zzw.zzdl().zzf(this.zzss.zzqn, string2);
            }
        }
        if (this.zzss.zzvv != null) {
            try {
                this.zzss.zzvv.onAdClicked();
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not notify onAdClicked event.", (Throwable)remoteException);
            }
        }
    }

    @Override
    public void zzbD() {
        this.zzbH();
    }

    @Override
    public void onAppEvent(String string2, @Nullable String string3) {
        if (this.zzss.zzvx != null) {
            try {
                this.zzss.zzvx.onAppEvent(string2, string3);
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not call the AppEventListener.", (Throwable)remoteException);
            }
        }
    }

    public void zzbE() {
        zzac.zzdj((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzss.zzvs == null) {
            zzpk.zzbh((String)"Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzpk.zzbf((String)"Pinging manual tracking URLs.");
        if (this.zzss.zzvs.zzSp != null && !this.zzss.zzvs.zzWk) {
            zzw.zzcM().zza(this.zzss.zzqn, this.zzss.zzvn.zzba, this.zzss.zzvs.zzSp);
            this.zzss.zzvs.zzWk = true;
            this.zzbL();
        }
    }

    public void pause() {
        zzac.zzdj((String)"pause must be called on the main UI thread.");
    }

    public void resume() {
        zzac.zzdj((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzc(zzec zzec2) {
        if (this.zzss.zzvo == null) {
            return false;
        }
        ViewParent viewParent = this.zzss.zzvo.getParent();
        if (!(viewParent instanceof View)) {
            return false;
        }
        View view = (View)viewParent;
        return zzw.zzcM().zza(view, view.getContext());
    }

    public void zzd(zzec zzec2) {
        if (this.zzc(zzec2)) {
            this.zzb(zzec2);
        } else {
            zzpk.zzbg((String)"Ad is not visible. Not refreshing ad.");
            this.zzsr.zzh(zzec2);
        }
    }

    public void zza(zzep zzep2) {
        zzac.zzdj((String)"setAdListener must be called on the main UI thread.");
        this.zzss.zzvw = zzep2;
    }

    public void zza(zznw zznw2) {
        zzac.zzdj((String)"setRewardedVideoAdListener can only be called from the UI thread.");
        this.zzss.zzvJ = zznw2;
    }

    public void setUserId(String string2) {
        zzpk.zzbh((String)"RewardedVideoAd.setUserId() is deprecated. Please do not call this method.");
    }

    public void zza(zzeo zzeo2) {
        zzac.zzdj((String)"setAdListener must be called on the main UI thread.");
        this.zzss.zzvv = zzeo2;
    }

    public void zza(zzeg zzeg2) {
        zzac.zzdj((String)"setAdSize must be called on the main UI thread.");
        this.zzss.zzvr = zzeg2;
        if (this.zzss.zzvs != null && this.zzss.zzvs.zzNH != null && this.zzss.zzvO == 0) {
            this.zzss.zzvs.zzNH.zza(zzeg2);
        }
        if (this.zzss.zzvo == null) {
            return;
        }
        if (this.zzss.zzvo.getChildCount() > 1) {
            this.zzss.zzvo.removeView(this.zzss.zzvo.getNextView());
        }
        this.zzss.zzvo.setMinimumWidth(zzeg2.widthPixels);
        this.zzss.zzvo.setMinimumHeight(zzeg2.heightPixels);
        this.zzss.zzvo.requestLayout();
    }

    public void zza(zzev zzev2) {
        zzac.zzdj((String)"setAppEventListener must be called on the main UI thread.");
        this.zzss.zzvx = zzev2;
    }

    public void zza(zzle zzle2) {
        throw new IllegalStateException("setInAppPurchaseListener is not supported for current ad type");
    }

    public void zza(zzgp zzgp2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    public void zza(zzli zzli2, String string2) {
        throw new IllegalStateException("setPlayStorePurchaseParams is not supported for current ad type");
    }

    public void zza(zzex zzex2) {
        zzac.zzdj((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzss.zzvy = zzex2;
    }

    public void stopLoading() {
        zzac.zzdj((String)"stopLoading must be called on the main UI thread.");
        this.zzsq = false;
        this.zzss.zzi(true);
    }

    public boolean isLoading() {
        return this.zzsq;
    }

    public zzfa zzbF() {
        return null;
    }

    public void zza(@Nullable zzft zzft2) {
        zzac.zzdj((String)"setVideoOptions must be called on the main UI thread.");
        this.zzss.zzvG = zzft2;
    }

    public void zza(@Nullable zzfc zzfc2) {
        zzac.zzdj((String)"setIconAdOptions must be called on the main UI thread.");
        this.zzss.zzvH = zzfc2;
    }

    long zzw(String string2) {
        int n = string2.indexOf("ufe");
        int n2 = string2.indexOf(44, n);
        if (n2 == -1) {
            n2 = string2.length();
        }
        try {
            return Long.parseLong(string2.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzpk.zzbh((String)"Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzpk.zzbh((String)"Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected void zzb(View view) {
        zzx.zza zza2 = this.zzss.zzvo;
        if (zza2 != null) {
            zza2.addView(view, zzw.zzcO().zzkT());
        }
    }

    protected void zzbG() {
        zzpk.zzbg((String)"Ad closing.");
        if (this.zzss.zzvw != null) {
            try {
                this.zzss.zzvw.onAdClosed();
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not call AdListener.onAdClosed().", (Throwable)remoteException);
            }
        }
        if (this.zzss.zzvJ != null) {
            try {
                this.zzss.zzvJ.onRewardedVideoAdClosed();
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdClosed().", (Throwable)remoteException);
            }
        }
    }

    protected void zzbH() {
        zzpk.zzbg((String)"Ad leaving application.");
        if (this.zzss.zzvw != null) {
            try {
                this.zzss.zzvw.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
            }
        }
        if (this.zzss.zzvJ != null) {
            try {
                this.zzss.zzvJ.onRewardedVideoAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not call  RewardedVideoAdListener.onRewardedVideoAdLeftApplication().", (Throwable)remoteException);
            }
        }
    }

    protected void zzbI() {
        zzpk.zzbg((String)"Ad opening.");
        if (this.zzss.zzvw != null) {
            try {
                this.zzss.zzvw.onAdOpened();
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not call AdListener.onAdOpened().", (Throwable)remoteException);
            }
        }
        if (this.zzss.zzvJ != null) {
            try {
                this.zzss.zzvJ.onRewardedVideoAdOpened();
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdOpened().", (Throwable)remoteException);
            }
        }
    }

    protected void zzbJ() {
        zzpk.zzbg((String)"Ad finished loading.");
        this.zzsq = false;
        if (this.zzss.zzvw != null) {
            try {
                this.zzss.zzvw.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
            }
        }
        if (this.zzss.zzvJ != null) {
            try {
                this.zzss.zzvJ.onRewardedVideoAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdLoaded().", (Throwable)remoteException);
            }
        }
    }

    protected void zzh(int n) {
        zzpk.zzbh((String)new StringBuilder(30).append("Failed to load ad: ").append(n).toString());
        this.zzsq = false;
        if (this.zzss.zzvw != null) {
            try {
                this.zzss.zzvw.onAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
            }
        }
        if (this.zzss.zzvJ != null) {
            try {
                this.zzss.zzvJ.onRewardedVideoAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzpk.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdFailedToLoad().", (Throwable)remoteException);
            }
        }
    }

    protected void zzbK() {
        if (this.zzss.zzvJ == null) {
            return;
        }
        try {
            this.zzss.zzvJ.onRewardedVideoStarted();
        }
        catch (RemoteException remoteException) {
            zzpk.zzc((String)"Could not call RewardedVideoAdListener.onVideoStarted().", (Throwable)remoteException);
        }
    }

    protected void zza(@Nullable zzoo zzoo2) {
        if (this.zzss.zzvJ == null) {
            return;
        }
        try {
            String string2 = "";
            int n = 1;
            if (zzoo2 != null) {
                string2 = zzoo2.type;
                n = zzoo2.zzVP;
            }
            this.zzss.zzvJ.zza((zznt)new zznq(string2, n));
        }
        catch (RemoteException remoteException) {
            zzpk.zzc((String)"Could not call RewardedVideoAdListener.onRewarded().", (Throwable)remoteException);
        }
    }

    protected void zzc(@Nullable zzpb zzpb2) {
        if (zzpb2 == null) {
            zzpk.zzbh((String)"Ad state was null when trying to ping impression URLs.");
            return;
        }
        zzpk.zzbf((String)"Pinging Impression URLs.");
        if (this.zzss.zzvu != null) {
            this.zzss.zzvu.zzjV();
        }
        if (zzpb2.zzKG != null && !zzpb2.zzWj) {
            String string2 = zzw.zzdl().zzF(this.zzss.zzqn);
            zzw.zzcM().zza(this.zzss.zzqn, this.zzss.zzvn.zzba, this.zza(string2, zzpb2.zzKG));
            zzpb2.zzWj = true;
            this.zzd(zzpb2);
            if (zzpb2.zzKG.size() > 0) {
                zzw.zzdl().zzg(this.zzss.zzqn, string2);
            }
        }
    }

    public void zzbL() {
        this.zzd(this.zzss.zzvs);
    }

    protected void zzd(zzpb zzpb2) {
        if (zzpb2 == null || TextUtils.isEmpty((CharSequence)zzpb2.zzSJ) || zzpb2.zzWl || !zzw.zzcU().zzkZ()) {
            return;
        }
        zzpk.zzbf((String)"Sending troubleshooting signals to the server.");
        zzw.zzcU().zza(this.zzss.zzqn, this.zzss.zzvn.zzba, zzpb2.zzSJ, this.zzss.zzvl);
        zzpb2.zzWl = true;
    }

    @Override
    public void zza(HashSet<zzpc> hashSet) {
        this.zzss.zza(hashSet);
    }

    protected String zze(String string2, String string3) {
        if (string2 == null || TextUtils.isEmpty((CharSequence)string3)) {
            return string3;
        }
        return zzw.zzcM().zzc(string3, "fbs_aeid", string2).toString();
    }

    protected List<String> zza(String string2, List<String> list) {
        if (string2 == null) {
            return list;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string3 : list) {
            arrayList.add(this.zze(string2, string3));
        }
        return arrayList;
    }
}

