/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.internal.zzec;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zziw;
import com.google.android.gms.internal.zzja;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzjc;
import com.google.android.gms.internal.zzje;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzni;
import com.google.android.gms.internal.zzpk;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@zzme
public class zziz {
    private final Map<zzja, zzjb> zzyE = new HashMap<zzja, zzjb>();
    private final LinkedList<zzja> zzJb = new LinkedList();
    @Nullable
    private zziw zzJc;

    void zza(zziw zziw2) {
        if (this.zzJc == null) {
            this.zzJc = zziw2.zzgu();
            this.restore();
        }
    }

    @Nullable
    zzjb.zza zza(zzec zzec2, String string2) {
        Object object;
        String string3;
        if (this.zzaj(string2)) {
            return null;
        }
        Context context = this.zzJc.getApplicationContext();
        zzni zzni2 = new zzni.zza(context).zzjC();
        int n = zzni2.zzUQ;
        zzec zzec3 = zziz.zzm(zzec2);
        zzja zzja2 = new zzja(zzec3, string3 = zziz.zzak(string2), n);
        zzjb zzjb2 = this.zzyE.get(zzja2);
        if (zzjb2 == null) {
            zziz.zza("Interstitial pool created at %s.", zzja2);
            zzjb2 = new zzjb(zzec3, string3, n);
            this.zzyE.put(zzja2, zzjb2);
        }
        this.zzJb.remove(zzja2);
        this.zzJb.add(zzja2);
        zzjb2.zzgA();
        while (this.zzJb.size() > zzgd.zzDg.get()) {
            object = this.zzJb.remove();
            zzjb zzjb3 = this.zzyE.get(object);
            zziz.zza("Evicting interstitial queue for %s.", (zzja)object);
            while (zzjb3.size() > 0) {
                zzjb.zza zza2 = zzjb3.zzo(null);
                if (zza2.zzJl) {
                    zzjc.zzgC().zzgE();
                }
                zza2.zzJh.zzcm();
            }
            this.zzyE.remove(object);
        }
        while (zzjb2.size() > 0) {
            long l;
            object = zzjb2.zzo(zzec3);
            if (((zzjb.zza)object).zzJl && (l = zzw.zzcS().currentTimeMillis() - ((zzjb.zza)object).zzJk) > 1000L * (long)zzgd.zzDi.get().intValue()) {
                zziz.zza("Expired interstitial at %s.", zzja2);
                zzjc.zzgC().zzgD();
                continue;
            }
            String string4 = ((zzjb.zza)object).zzJi != null ? " (inline) " : " ";
            zziz.zza(new StringBuilder(34 + String.valueOf(string4).length()).append("Pooled interstitial").append(string4).append("returned at %s.").toString(), zzja2);
            return object;
        }
        return null;
    }

    void zzb(zzec zzec2, String string2) {
        String string3;
        if (this.zzJc == null) {
            return;
        }
        Context context = this.zzJc.getApplicationContext();
        zzni zzni2 = new zzni.zza(context).zzjC();
        int n = zzni2.zzUQ;
        zzec zzec3 = zziz.zzm(zzec2);
        zzja zzja2 = new zzja(zzec3, string3 = zziz.zzak(string2), n);
        zzjb zzjb2 = this.zzyE.get(zzja2);
        if (zzjb2 == null) {
            zziz.zza("Interstitial pool created at %s.", zzja2);
            zzjb2 = new zzjb(zzec3, string3, n);
            this.zzyE.put(zzja2, zzjb2);
        }
        zzjb2.zza(this.zzJc, zzec2);
        zzjb2.zzgA();
        zziz.zza("Inline entry added to the queue at %s.", zzja2);
    }

    void zzgv() {
        if (this.zzJc == null) {
            return;
        }
        for (Map.Entry<zzja, zzjb> entry : this.zzyE.entrySet()) {
            int n;
            zzja zzja2 = entry.getKey();
            zzjb zzjb2 = entry.getValue();
            if (zzpk.zzak((int)2)) {
                n = zzjb2.size();
                int n2 = zzjb2.zzgy();
                if (n2 < n) {
                    zzpk.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zzja2));
                }
            }
            n = 0 + zzjb2.zzgz();
            while (zzjb2.size() < zzgd.zzDh.get()) {
                zziz.zza("Pooling and loading one new interstitial for %s.", zzja2);
                if (!zzjb2.zzb(this.zzJc)) continue;
                ++n;
            }
            zzjc.zzgC().zzE(n);
        }
        this.save();
    }

    void save() {
        if (this.zzJc == null) {
            return;
        }
        Context context = this.zzJc.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        for (Map.Entry<zzja, zzjb> entry : this.zzyE.entrySet()) {
            zzja zzja2 = entry.getKey();
            zzjb zzjb2 = entry.getValue();
            if (!zzjb2.zzgB()) continue;
            zzje zzje2 = new zzje(zzjb2);
            String string2 = zzje2.zzgL();
            String string3 = zzja2.toString();
            editor.putString(string3, string2);
            zziz.zza("Saved interstitial queue for %s.", zzja2);
        }
        editor.putString("PoolKeys", this.zzgw());
        editor.apply();
    }

    void restore() {
        if (this.zzJc == null) {
            return;
        }
        Context context = this.zzJc.getApplicationContext();
        SharedPreferences sharedPreferences = context.getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
        this.flush();
        try {
            zzja zzja2;
            HashMap<String, zzja> hashMap = new HashMap<String, zzja>();
            String[] stringArray = sharedPreferences.getAll().entrySet().iterator();
            while (stringArray.hasNext()) {
                String[] stringArray2 = stringArray.next();
                String string2 = (String)stringArray2.getKey();
                if (string2.equals("PoolKeys")) continue;
                String string3 = (String)stringArray2.getValue();
                zzje object = zzje.zzal(string3);
                zzja2 = new zzja(object.zzum, object.zzts, object.zzJf);
                if (this.zzyE.containsKey(zzja2)) continue;
                zzjb zzjb2 = new zzjb(object.zzum, object.zzts, object.zzJf);
                this.zzyE.put(zzja2, zzjb2);
                hashMap.put(zzja2.toString(), zzja2);
                zziz.zza("Restored interstitial queue for %s.", zzja2);
            }
            for (String string2 : stringArray = this.zzai(sharedPreferences.getString("PoolKeys", ""))) {
                zzja2 = (zzja)hashMap.get(string2);
                if (!this.zzyE.containsKey(zzja2)) continue;
                this.zzJb.add(zzja2);
            }
        }
        catch (IOException | RuntimeException exception) {
            zzw.zzcQ().zza(exception, "InterstitialAdPool.restore");
            zzpk.zzc((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
            this.zzyE.clear();
            this.zzJb.clear();
        }
    }

    void flush() {
        while (this.zzJb.size() > 0) {
            zzja zzja2 = this.zzJb.remove();
            zzjb zzjb2 = this.zzyE.get(zzja2);
            zziz.zza("Flushing interstitial queue for %s.", zzja2);
            while (zzjb2.size() > 0) {
                zzjb.zza zza2 = zzjb2.zzo(null);
                zza2.zzJh.zzcm();
            }
            this.zzyE.remove(zzja2);
        }
    }

    private String zzgw() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzJb.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zzja)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private String[] zzai(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private boolean zzaj(String string2) {
        try {
            return Pattern.matches(zzgd.zzDj.get(), string2);
        }
        catch (RuntimeException runtimeException) {
            zzw.zzcQ().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    static Set<String> zzj(zzec zzec2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(zzec2.extras.keySet());
        Bundle bundle = zzec2.zzzd.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            hashSet.addAll(bundle.keySet());
        }
        return hashSet;
    }

    static zzec zzk(zzec zzec2) {
        zzec zzec3 = zziz.zzn(zzec2);
        zziz.zzc(zzec3, "_skipMediation");
        return zzec3;
    }

    static boolean zzl(zzec zzec2) {
        Set<String> set = zziz.zzj(zzec2);
        return set.contains("_skipMediation");
    }

    static zzec zzm(zzec zzec2) {
        String[] stringArray;
        zzec zzec3 = zziz.zzn(zzec2);
        String string2 = zzgd.zzDf.get();
        for (String string3 : stringArray = string2.split(",")) {
            zziz.zzc(zzec3.zzzd, string3);
            String string4 = "com.google.ads.mediation.admob.AdMobAdapter/";
            if (!string3.startsWith(string4)) continue;
            String string5 = string3.replaceFirst(string4, "");
            zziz.zzc(zzec3.extras, string5);
        }
        return zzec3;
    }

    static String zzak(String string2) {
        try {
            Pattern pattern = Pattern.compile("([^/]+/[0-9]+).*");
            Matcher matcher = pattern.matcher(string2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        catch (RuntimeException runtimeException) {}
        return string2;
    }

    static zzec zzn(zzec zzec2) {
        Parcel parcel = Parcel.obtain();
        zzec2.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        zzec zzec3 = (zzec)zzec.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        if (zzgd.zzCX.get().booleanValue()) {
            zzec.zzi((zzec)zzec3);
        }
        return zzec3;
    }

    private static void zzc(zzec zzec2, String string2) {
        Bundle bundle = zzec2.zzzd;
        Bundle bundle2 = bundle.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle2 != null) {
            bundle2.putBoolean(string2, true);
        }
        zzec2.extras.putBoolean(string2, true);
    }

    private static void zzc(Bundle bundle, String string2) {
        String[] stringArray = string2.split("/", 2);
        if (stringArray.length == 0) {
            return;
        }
        String string3 = stringArray[0];
        if (stringArray.length == 1) {
            bundle.remove(string3);
            return;
        }
        Bundle bundle2 = bundle.getBundle(string3);
        if (bundle2 == null) {
            return;
        }
        zziz.zzc(bundle2, stringArray[1]);
    }

    private static void zza(String string2, zzja zzja2) {
        if (zzpk.zzak((int)2)) {
            zzpk.v(String.format(string2, zzja2));
        }
    }
}

