/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzid;
import com.google.android.gms.internal.zzie;
import com.google.android.gms.internal.zzii;
import com.google.android.gms.internal.zzjf;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjj;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmf;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzna;
import com.google.android.gms.internal.zznd;
import com.google.android.gms.internal.zzni;
import com.google.android.gms.internal.zzpb;
import com.google.android.gms.internal.zzpj;
import com.google.android.gms.internal.zzpk;
import com.google.android.gms.internal.zzpt;
import com.google.android.gms.internal.zzqe;
import com.google.android.gms.internal.zzqp;
import com.google.android.gms.internal.zzqw;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

@zzme
public class zzmx
extends zzpj {
    static final long zzSV = TimeUnit.SECONDS.toMillis(10L);
    private static final Object zztX = new Object();
    static boolean zzSW = false;
    private static zzji zzQn = null;
    private static zzie zzSX = null;
    private static zzii zzSY = null;
    private static zzid zzSZ = null;
    private final zzmf.zza zzRl;
    private final zzmk.zza zzRm;
    private final Object zzPU = new Object();
    private final Context mContext;
    private zzji.zzc zzTa;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public zzmx(Context context, zzmk.zza zza2, zzmf.zza zza3) {
        super(true);
        this.zzRl = zza3;
        this.mContext = context;
        this.zzRm = zza2;
        Object object = zztX;
        synchronized (object) {
            if (!zzSW) {
                zzSY = new zzii();
                zzSX = new zzie(context.getApplicationContext(), zza2.zzvn);
                zzSZ = new zzc();
                zzQn = new zzji(this.mContext.getApplicationContext(), this.zzRm.zzvn, zzgd.zzBh.get(), new zzb(), new zza());
                zzSW = true;
            }
        }
    }

    protected static void zzb(zzjf zzjf2) {
        zzjf2.zza("/loadAd", zzSY);
        zzjf2.zza("/fetchHttpRequest", zzSX);
        zzjf2.zza("/invalidRequest", zzSZ);
    }

    protected static void zzc(zzjf zzjf2) {
        zzjf2.zzb("/loadAd", zzSY);
        zzjf2.zzb("/fetchHttpRequest", zzSX);
        zzjf2.zzb("/invalidRequest", zzSZ);
    }

    @Override
    public void zzco() {
        zzpk.zzbf((String)"SdkLessAdLoaderBackgroundTask started.");
        String string2 = zzw.zzdl().zzF(this.mContext);
        zzmk zzmk2 = new zzmk(this.zzRm, -1L, zzw.zzdl().zzD(this.mContext), zzw.zzdl().zzE(this.mContext), string2);
        zzw.zzdl().zzh(this.mContext, string2);
        zzmn zzmn2 = this.zze(zzmk2);
        long l = zzw.zzcS().elapsedRealtime();
        final zzpb.zza zza2 = new zzpb.zza(zzmk2, zzmn2, null, null, zzmn2.errorCode, l, zzmn2.zzSr, null);
        zzqe.zzYP.post(new Runnable(){

            @Override
            public void run() {
                zzmx.this.zzRl.zza(zza2);
                if (zzmx.this.zzTa != null) {
                    zzmx.this.zzTa.release();
                    zzmx.this.zzTa = null;
                }
            }
        });
    }

    private zzmn zze(zzmk zzmk2) {
        JSONObject jSONObject;
        final String string2 = zzw.zzcM().zzkL();
        final JSONObject jSONObject2 = this.zza(zzmk2, string2);
        if (jSONObject2 == null) {
            return new zzmn(0);
        }
        long l = zzw.zzcS().elapsedRealtime();
        Future<JSONObject> future = zzSY.zzab(string2);
        zzqe.zzYP.post(new Runnable(){

            @Override
            public void run() {
                zzmx.this.zzTa = zzQn.zzgO();
                zzmx.this.zzTa.zza(new zzqp.zzc<zzjj>(){

                    public void zzb(zzjj zzjj2) {
                        try {
                            zzjj2.zza("AFMA_getAdapterLessMediationAd", jSONObject2);
                        }
                        catch (Exception exception) {
                            zzpk.zzb((String)"Error requesting an ad url", (Throwable)exception);
                            zzSY.zzac(string2);
                        }
                    }

                    @Override
                    public /* synthetic */ void zzd(Object object) {
                        this.zzb((zzjj)object);
                    }
                }, new zzqp.zza(){

                    @Override
                    public void run() {
                        zzSY.zzac(string2);
                    }
                });
            }
        });
        long l2 = zzSV - (zzw.zzcS().elapsedRealtime() - l);
        try {
            jSONObject = future.get(l2, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException exception) {
            return new zzmn(-1);
        }
        catch (TimeoutException timeoutException) {
            return new zzmn(2);
        }
        catch (ExecutionException executionException) {
            return new zzmn(0);
        }
        if (jSONObject == null) {
            return new zzmn(-1);
        }
        zzmn zzmn2 = zznd.zza(this.mContext, zzmk2, jSONObject.toString());
        if (zzmn2.errorCode != -3 && TextUtils.isEmpty((CharSequence)zzmn2.body)) {
            return new zzmn(3);
        }
        return zzmn2;
    }

    private JSONObject zza(zzmk zzmk2, String string2) {
        Bundle bundle = zzmk2.zzRy.extras.getBundle("sdk_less_server_data");
        if (bundle == null) {
            return null;
        }
        zzni zzni2 = null;
        try {
            zzni2 = zzw.zzcV().zzA(this.mContext).get();
        }
        catch (Exception exception) {
            zzpk.zzc((String)"Error grabbing device info: ", (Throwable)exception);
        }
        JSONObject jSONObject = zznd.zza(this.mContext, new zzna().zzf(zzmk2).zza(zzni2));
        if (jSONObject == null) {
            return null;
        }
        AdvertisingIdClient.Info info = null;
        try {
            info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.mContext);
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException | IllegalStateException throwable) {
            zzpk.zzc((String)"Cannot get advertising id info", (Throwable)throwable);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("request_id", string2);
        hashMap.put("request_param", jSONObject);
        hashMap.put("data", bundle);
        if (info != null) {
            hashMap.put("adid", info.getId());
            hashMap.put("lat", info.isLimitAdTrackingEnabled() ? 1 : 0);
        }
        try {
            return zzw.zzcM().zzQ(hashMap);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = this.zzPU;
        synchronized (object) {
            zzqe.zzYP.post(new Runnable(){

                @Override
                public void run() {
                    if (zzmx.this.zzTa != null) {
                        zzmx.this.zzTa.release();
                        zzmx.this.zzTa = null;
                    }
                }
            });
        }
    }

    public static class zza
    implements zzpt<zzjf> {
        public void zza(zzjf zzjf2) {
            zzmx.zzc(zzjf2);
        }

        @Override
        public /* synthetic */ void zzd(Object object) {
            this.zza((zzjf)object);
        }
    }

    public static class zzb
    implements zzpt<zzjf> {
        public void zza(zzjf zzjf2) {
            zzmx.zzb(zzjf2);
        }

        @Override
        public /* synthetic */ void zzd(Object object) {
            this.zza((zzjf)object);
        }
    }

    public static class zzc
    implements zzid {
        @Override
        public void zza(zzqw zzqw2, Map<String, String> map) {
            String string2 = map.get("request_id");
            String string3 = map.get("errors");
            String string4 = String.valueOf(string3);
            zzpk.zzbh((String)(string4.length() != 0 ? "Invalid request: ".concat(string4) : new String("Invalid request: ")));
            zzSY.zzac(string2);
        }
    }
}

