/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzw;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zza;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmw;
import com.google.android.gms.internal.zzpk;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzme
public final class zzmv
extends zza {
    public static final Parcelable.Creator<zzmv> CREATOR = new zzmw();
    ParcelFileDescriptor zzSQ;
    private Parcelable zzSR;
    private boolean zzSS;

    zzmv(ParcelFileDescriptor parcelFileDescriptor) {
        this.zzSQ = parcelFileDescriptor;
        this.zzSR = null;
        this.zzSS = true;
    }

    public zzmv(SafeParcelable safeParcelable) {
        this.zzSQ = null;
        this.zzSR = safeParcelable;
        this.zzSS = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzSS) {
            byte[] byArray;
            if (this.zzSQ == null) {
                zzpk.e((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzSQ));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                zzp.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzSR = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzSS = false;
        }
        return (T)((SafeParcelable)this.zzSR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzSQ == null) {
            byte[] byArray;
            Parcel parcel2 = Parcel.obtain();
            try {
                this.zzSR.writeToParcel(parcel2, 0);
                byArray = parcel2.marshall();
            }
            finally {
                parcel2.recycle();
            }
            this.zzSQ = this.zzj(byArray);
        }
        zzmw.zza(this, parcel, n);
    }

    protected <T> ParcelFileDescriptor zzj(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            Runnable runnable = new Runnable(this, (OutputStream)autoCloseOutputStream2, byArray){
                final /* synthetic */ OutputStream zzST;
                final /* synthetic */ byte[] zzSU;
                {
                    this.zzST = outputStream;
                    this.zzSU = byArray;
                }

                @Override
                public void run() {
                    DataOutputStream dataOutputStream = null;
                    try {
                        dataOutputStream = new DataOutputStream(this.zzST);
                        dataOutputStream.writeInt(this.zzSU.length);
                        dataOutputStream.write(this.zzSU);
                        zzp.closeQuietly((Closeable)dataOutputStream);
                    }
                    catch (IOException iOException) {
                        zzpk.zzb((String)"Error transporting the ad response", (Throwable)iOException);
                        zzw.zzcQ().zza(iOException, "LargeParcelTeleporter.pipeData.1");
                    }
                    finally {
                        if (dataOutputStream == null) {
                            zzp.closeQuietly((Closeable)this.zzST);
                        } else {
                            zzp.closeQuietly((Closeable)dataOutputStream);
                        }
                    }
                }
            };
            new Thread(runnable).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzpk.zzb((String)"Error transporting the ad response", (Throwable)iOException);
            zzw.zzcQ().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            zzp.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }
}

