/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzap;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.overlay.zzar;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzia;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzaaz
@TargetApi(value=14)
public final class zzd
extends zzy
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzOm = new HashMap<Integer, String>();
    private final zzar zzOn;
    private final boolean zzOo;
    private int zzOp = 0;
    private int zzOq = 0;
    private MediaPlayer zzOr;
    private Uri zzOs;
    private int zzOt;
    private int zzOu;
    private int zzOv;
    private int zzOw;
    private int zzOx;
    private zzap zzOy;
    private boolean zzOz;
    private int zzOA;
    private zzx zzOB;

    public zzd(Context context, boolean bl, boolean bl2, zzaq zzaq2, zzar zzar2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzOn = zzar2;
        this.zzOz = bl;
        this.zzOo = bl2;
        this.zzOn.zza(this);
    }

    @Override
    public final String zzfC() {
        String string = String.valueOf(this.zzOz ? " spherical" : "");
        if (string.length() != 0) {
            return "MediaPlayer".concat(string);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzx zzx2) {
        this.zzOB = zzx2;
    }

    @Override
    public final void setVideoPath(String string) {
        Uri uri = Uri.parse((String)string);
        zzd zzd2 = this;
        zzia zzia2 = zzia.zze(uri);
        zzd2.zzOs = zzia2 == null ? uri : Uri.parse((String)zzia2.url);
        zzd2.zzOA = 0;
        zzd2.zzfD();
        zzd2.requestLayout();
        zzd2.invalidate();
    }

    @Override
    public final void stop() {
        zzahd.v("AdMediaPlayerView stop");
        if (this.zzOr != null) {
            this.zzOr.stop();
            this.zzOr.release();
            this.zzOr = null;
            this.zzq(0);
            this.zzOq = 0;
        }
        this.zzOn.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzahd.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzOt = mediaPlayer.getVideoWidth();
        this.zzOu = mediaPlayer.getVideoHeight();
        if (this.zzOt != 0 && this.zzOu != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzahd.v("AdMediaPlayerView prepared");
        this.zzq(2);
        this.zzOn.zzfS();
        zzail.zzZt.post((Runnable)new zze(this));
        this.zzOt = mediaPlayer.getVideoWidth();
        this.zzOu = mediaPlayer.getVideoHeight();
        if (this.zzOA != 0) {
            this.seekTo(this.zzOA);
        }
        this.zzfE();
        int n = this.zzOt;
        int n2 = this.zzOu;
        zzahd.zzaS((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzOq == 3) {
            this.play();
        }
        this.zzfG();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzahd.v("AdMediaPlayerView completion");
        this.zzq(5);
        this.zzOq = 5;
        zzail.zzZt.post((Runnable)new zzf(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzOm.get(n);
        String string2 = zzOm.get(n2);
        zzahd.v(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string).append(":").append(string2).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzOm.get(n);
        String string2 = zzOm.get(n2);
        zzahd.zzaT((String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string).append(":").append(string2).toString());
        this.zzq(-1);
        this.zzOq = -1;
        zzail.zzZt.post((Runnable)new zzg(this, string, string2));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzOv = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzahd.v("AdMediaPlayerView surface created");
        this.zzfD();
        zzail.zzZt.post((Runnable)new zzh(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzahd.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzOq == 3;
        boolean bl3 = bl = this.zzOt == n && this.zzOu == n2;
        if (this.zzOr != null && bl2 && bl) {
            if (this.zzOA != 0) {
                this.seekTo(this.zzOA);
            }
            this.play();
        }
        if (this.zzOy != null) {
            this.zzOy.zzf(n, n2);
        }
        zzail.zzZt.post((Runnable)new zzi(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzahd.v("AdMediaPlayerView surface destroyed");
        if (this.zzOr != null && this.zzOA == 0) {
            this.zzOA = this.zzOr.getCurrentPosition();
        }
        if (this.zzOy != null) {
            this.zzOy.zzge();
        }
        zzail.zzZt.post((Runnable)new zzj(this));
        this.zzq(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzOn.zzb(this);
        this.zzPr.zza(surfaceTexture, this.zzOB);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzd.getDefaultSize((int)this.zzOt, (int)n);
        int n4 = zzd.getDefaultSize((int)this.zzOu, (int)n2);
        if (this.zzOt > 0 && this.zzOu > 0 && this.zzOy == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzOt * n4 < n3 * this.zzOu) {
                    n3 = n4 * this.zzOt / this.zzOu;
                } else if (this.zzOt * n4 > n3 * this.zzOu) {
                    n4 = n3 * this.zzOu / this.zzOt;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzOu / this.zzOt;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzOt / this.zzOu;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzOt;
                n4 = this.zzOu;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzOt / this.zzOu;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzOu / this.zzOt;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzOy != null) {
            this.zzOy.zzf(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzOw > 0 && this.zzOw != n3 || this.zzOx > 0 && this.zzOx != n4) {
                this.zzfE();
            }
            this.zzOw = n3;
            this.zzOx = n4;
        }
    }

    public final String toString() {
        String string = String.valueOf(this.getClass().getName());
        String string2 = String.valueOf(Integer.toHexString(this.hashCode()));
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
    }

    private final void zzfD() {
        zzahd.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzOs == null || surfaceTexture == null) {
            return;
        }
        this.zzq(false);
        try {
            Surface surface;
            zzbs.zzbP();
            this.zzOr = new MediaPlayer();
            this.zzOr.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzOr.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzOr.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzOr.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzOr.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzOr.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzOv = 0;
            if (this.zzOz) {
                this.zzOy = new zzap(this.getContext());
                this.zzOy.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzOy.start();
                surface = this.zzOy.zzgf();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzOy.zzge();
                    this.zzOy = null;
                }
            }
            this.zzOr.setDataSource(this.getContext(), this.zzOs);
            zzbs.zzbQ();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzOr.setSurface(surface);
            this.zzOr.setAudioStreamType(3);
            this.zzOr.setScreenOnWhilePlaying(true);
            this.zzOr.prepareAsync();
            this.zzq(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string = String.valueOf(this.zzOs);
            zzahd.zzc((String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to initialize MediaPlayer at ").append(string).toString(), (Throwable)exception);
            this.onError(this.zzOr, 1, 0);
            return;
        }
    }

    private final void zzfE() {
        if (!this.zzOo) {
            return;
        }
        if (this.zzfF() && this.zzOr.getCurrentPosition() > 0 && this.zzOq != 3) {
            zzahd.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzOr.start();
            int n = this.zzOr.getCurrentPosition();
            long l = zzbs.zzbE().currentTimeMillis();
            while (this.zzfF() && this.zzOr.getCurrentPosition() == n && zzbs.zzbE().currentTimeMillis() - l <= 250L) {
            }
            this.zzOr.pause();
            this.zzfG();
        }
    }

    private final void zzq(boolean bl) {
        zzahd.v("AdMediaPlayerView release");
        if (this.zzOy != null) {
            this.zzOy.zzge();
            this.zzOy = null;
        }
        if (this.zzOr != null) {
            this.zzOr.reset();
            this.zzOr.release();
            this.zzOr = null;
            this.zzq(0);
            if (bl) {
                this.zzOq = 0;
                this.zzOq = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzahd.v("AdMediaPlayerView play");
        if (this.zzfF()) {
            this.zzOr.start();
            this.zzq(3);
            this.zzPr.zzfT();
            zzail.zzZt.post((Runnable)new zzk(this));
        }
        this.zzOq = 3;
    }

    @Override
    public final void pause() {
        zzahd.v("AdMediaPlayerView pause");
        if (this.zzfF() && this.zzOr.isPlaying()) {
            this.zzOr.pause();
            this.zzq(4);
            zzail.zzZt.post((Runnable)new zzl(this));
        }
        this.zzOq = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzfF()) {
            return this.zzOr.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzfF()) {
            return this.zzOr.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzahd.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzfF()) {
            this.zzOr.seekTo(n);
            this.zzOA = 0;
            return;
        }
        this.zzOA = n;
    }

    private final boolean zzfF() {
        return this.zzOr != null && this.zzOp != -1 && this.zzOp != 0 && this.zzOp != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzOy != null) {
            this.zzOy.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzOr != null) {
            return this.zzOr.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzOr != null) {
            return this.zzOr.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzfG() {
        this.zza(this.zzPs.zzgl());
    }

    private final void zza(float f) {
        if (this.zzOr != null) {
            try {
                this.zzOr.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzahd.zzaT((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzq(int n) {
        if (n == 3) {
            this.zzOn.zzgi();
            this.zzPs.zzgi();
        } else if (this.zzOp == 3) {
            this.zzOn.zzgj();
            this.zzPs.zzgj();
        }
        this.zzOp = n;
    }

    static /* synthetic */ zzx zza(zzd zzd2) {
        return zzd2.zzOB;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzOm.put(-1004, "MEDIA_ERROR_IO");
            zzOm.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzOm.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzOm.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzOm.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzOm.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzOm.put(1, "MEDIA_ERROR_UNKNOWN");
        zzOm.put(1, "MEDIA_INFO_UNKNOWN");
        zzOm.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzOm.put(701, "MEDIA_INFO_BUFFERING_START");
        zzOm.put(702, "MEDIA_INFO_BUFFERING_END");
        zzOm.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzOm.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzOm.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzOm.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzOm.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

