/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Looper;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzaav;
import com.google.android.gms.internal.zzaaw;
import com.google.android.gms.internal.zzaax;
import com.google.android.gms.internal.zzaay;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzakq;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.WeakHashMap;

@zzaaz
public final class zzaau
implements zzaax {
    private static final Object zzuI = new Object();
    private static zzaax zzSi = null;
    private final Object zzSj = new Object();
    private final String mPackageName;
    private final zzakq zzuN;
    private final WeakHashMap<Thread, Boolean> zzSk = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzaax zzc(Context context, zzakq zzakq2) {
        Object object = zzuI;
        synchronized (object) {
            if (zzSi == null) {
                zzme<Boolean> zzme2 = zzmo.zzCf;
                if (zzbs.zzbK().zzd(zzme2).booleanValue()) {
                    String string = "unknown";
                    try {
                        string = context.getApplicationContext().getPackageName();
                    }
                    catch (Throwable throwable) {
                        zzahd.zzaT((String)"Cannot obtain package name, proceeding.");
                    }
                    zzSi = new zzaau(string, zzakq2);
                } else {
                    zzSi = new zzaay();
                }
            }
        }
        return zzSi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private zzaau(String string, zzakq zzakq2) {
        this.mPackageName = string;
        this.zzuN = zzakq2;
        Thread thread = Looper.getMainLooper().getThread();
        zzaau zzaau2 = this;
        if (thread != null) {
            Object object = zzaau2.zzSj;
            synchronized (object) {
                zzaau2.zzSk.put(thread, true);
            }
            object = thread.getUncaughtExceptionHandler();
            thread.setUncaughtExceptionHandler(new zzaaw(zzaau2, (Thread.UncaughtExceptionHandler)object));
        }
        zzaau zzaau3 = this;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new zzaav(zzaau3, uncaughtExceptionHandler));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void zza(Thread thread, Throwable throwable) {
        Throwable throwable2;
        zzaau zzaau2 = this;
        if (throwable2 == null) return;
        boolean bl = false;
        boolean bl2 = false;
        for (throwable2 = throwable; throwable2 != null; throwable2 = throwable2.getCause()) {
            for (StackTraceElement stackTraceElement : throwable2.getStackTrace()) {
                if (zzaau.zzat(stackTraceElement.getClassName())) {
                    bl = true;
                }
                if (!zzaau2.getClass().getName().equals(stackTraceElement.getClassName())) continue;
                bl2 = true;
            }
        }
        if (!bl) return;
        if (bl2) return;
        boolean bl3 = true;
        if (!bl3) return;
        throwable2 = throwable;
        this.zza(throwable2, "");
    }

    private static boolean zzat(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzme<String> zzme2 = zzmo.zzCh;
        if (string.startsWith(zzbs.zzbK().zzd(zzme2))) {
            return true;
        }
        try {
            return Class.forName(string).isAnnotationPresent(zzaaz.class);
        }
        catch (Exception exception) {
            String string2 = String.valueOf(string);
            zzahd.zza((String)(string2.length() != 0 ? "Fail to check class type for class ".concat(string2) : new String("Fail to check class type for class ")), (Throwable)exception);
            return false;
        }
    }

    @Override
    public final void zza(Throwable throwable, String string) {
        Throwable throwable2;
        Object object;
        Object object2;
        Serializable serializable;
        Throwable throwable3;
        Serializable serializable2 = throwable;
        Object object3 = zzmo.zzCg;
        if (zzbs.zzbK().zzd(object3).booleanValue()) {
            throwable3 = serializable2;
        } else {
            serializable = new LinkedList<Throwable>();
            for (object2 = serializable2; object2 != null; object2 = ((Throwable)object2).getCause()) {
                ((LinkedList)serializable).push(object2);
            }
            object = null;
            while (!((AbstractCollection)((Object)serializable)).isEmpty()) {
                object2 = (Throwable)((LinkedList)serializable).pop();
                StackTraceElement[] stackTraceElementArray = ((Throwable)object2).getStackTrace();
                ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
                arrayList.add(new StackTraceElement(object2.getClass().getName(), "<filtered>", "<filtered>", 1));
                boolean bl = false;
                StackTraceElement[] stackTraceElementArray2 = stackTraceElementArray;
                int n = stackTraceElementArray.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement stackTraceElement = stackTraceElementArray2[i];
                    if (zzaau.zzat(stackTraceElement.getClassName())) {
                        bl = true;
                        arrayList.add(stackTraceElement);
                        continue;
                    }
                    object3 = stackTraceElement.getClassName();
                    if (!TextUtils.isEmpty((CharSequence)object3) && (((String)object3).startsWith("android.") || ((String)object3).startsWith("java."))) {
                        arrayList.add(stackTraceElement);
                        continue;
                    }
                    StackTraceElement stackTraceElement2 = new StackTraceElement("<filtered>", "<filtered>", "<filtered>", 1);
                    arrayList.add(stackTraceElement2);
                }
                if (!bl) continue;
                object = object == null ? new Throwable(((Throwable)object2).getMessage()) : new Throwable(((Throwable)object2).getMessage(), (Throwable)object);
                ((Throwable)object).setStackTrace(arrayList.toArray(new StackTraceElement[0]));
            }
            throwable3 = throwable2 = object;
        }
        if (throwable3 == null) {
            return;
        }
        Class<?> clazz = throwable.getClass();
        ArrayList<String> arrayList = new ArrayList<String>();
        object2 = string;
        serializable = throwable2;
        serializable2 = clazz;
        zzaau zzaau2 = this;
        object = new StringWriter();
        ((Throwable)serializable).printStackTrace(new PrintWriter((Writer)object));
        Uri.Builder builder = new Uri.Builder().scheme("https").path("//pagead2.googlesyndication.com/pagead/gen_204").appendQueryParameter("id", "gmob-apps-report-exception").appendQueryParameter("os", Build.VERSION.RELEASE).appendQueryParameter("api", String.valueOf(Build.VERSION.SDK_INT));
        zzbs.zzby();
        arrayList.add(builder.appendQueryParameter("device", zzail.zzhP()).appendQueryParameter("js", zzaau2.zzuN.zzaS).appendQueryParameter("appid", zzaau2.mPackageName).appendQueryParameter("exceptiontype", ((Class)serializable2).getName()).appendQueryParameter("stacktrace", ((StringWriter)object).toString()).appendQueryParameter("eids", TextUtils.join((CharSequence)",", zzmo.zzdI())).appendQueryParameter("exceptionkey", (String)object2).appendQueryParameter("cl", "157865972").appendQueryParameter("rc", "dev").appendQueryParameter("session_id", zzbs.zzbC().getSessionId()).toString());
        zzbs.zzby();
        zzail.zza(arrayList, zzbs.zzbC().zzhs());
    }
}

