/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.CookieManager;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzabb;
import com.google.android.gms.internal.zzabd;
import com.google.android.gms.internal.zzabe;
import com.google.android.gms.internal.zzabf;
import com.google.android.gms.internal.zzabh;
import com.google.android.gms.internal.zzabi;
import com.google.android.gms.internal.zzabn;
import com.google.android.gms.internal.zzabo;
import com.google.android.gms.internal.zzabq;
import com.google.android.gms.internal.zzabr;
import com.google.android.gms.internal.zzabu;
import com.google.android.gms.internal.zzadf;
import com.google.android.gms.internal.zzags;
import com.google.android.gms.internal.zzahb;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzaif;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzajb;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzakq;
import com.google.android.gms.internal.zzalb;
import com.google.android.gms.internal.zzalf;
import com.google.android.gms.internal.zzij;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzvo;
import java.lang.constant.Constable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

@zzaaz
public final class zzabc
extends zzahb
implements zzabi {
    private final zzabb zzSo;
    private final zzabr zzSp;
    private final Object zzQV = new Object();
    private final Context mContext;
    private final zzij zzSq;
    private zzabq zzMQ;
    private Runnable zzQU;
    zzajb zzSr;
    private zzabu zzQT;
    private zzvo zzMy;

    public zzabc(Context context, zzabr zzabr2, zzabb zzabb2, zzij zzij2) {
        this.zzSo = zzabb2;
        this.mContext = context;
        this.zzSp = zzabr2;
        this.zzSq = zzij2;
    }

    final zzajb zza(zzakq zzakq2, zzalb<zzabq> zzalb2) {
        zzabc zzabc2 = this;
        zzalb<zzabq> zzalb3 = zzalb2;
        zzakq zzakq3 = zzakq2;
        Context context = this.mContext;
        zzabh zzabh2 = new zzabh(context);
        zzabc zzabc3 = zzabc2;
        zzalb<zzabq> zzalb4 = zzalb3;
        zzakq zzakq4 = zzakq3;
        Context context2 = context;
        if (zzabh2.zza(zzakq4)) {
            zzabc zzabc4 = zzabc3;
            zzalb<zzabq> zzalb5 = zzalb4;
            Context context3 = context2;
            zzahd.zzaC((String)"Fetching ad response from local ad request service.");
            zzabn zzabn2 = new zzabn(context3, zzalb5, zzabc4);
            zzabn2.zzgo();
            return zzabn2;
        }
        zzabc zzabc5 = zzabc3;
        zzalb<zzabq> zzalb6 = zzalb4;
        zzakq zzakq5 = zzakq4;
        Context context4 = context2;
        zzahd.zzaC((String)"Fetching ad response from remote ad request service.");
        zzji.zzdr();
        if (!zzakk.zzX((Context)context4)) {
            zzahd.zzaT((String)"Failed to connect to remote ad request service.");
            return null;
        }
        return new zzabo(context4, zzakq5, zzalb6, zzabc5);
    }

    @Override
    public final void zzbc() {
        Object object;
        zzahd.zzaC((String)"AdLoaderBackgroundTask started.");
        this.zzQU = new zzabd(this);
        zzme<Constable> zzme2 = zzmo.zzEN;
        zzail.zzZt.postDelayed(this.zzQU, zzbs.zzbK().zzd(zzme2).longValue());
        long l = zzbs.zzbE().elapsedRealtime();
        zzme2 = zzmo.zzEL;
        if (((Boolean)((Object)zzbs.zzbK().zzd(zzme2))).booleanValue() && this.zzSp.zzSB.extras != null && (object = this.zzSp.zzSB.extras.getString("_ad")) != null) {
            this.zzMQ = new zzabq(this.zzSp, l, null, null, null);
            this.zza(zzadf.zza(this.mContext, this.zzMQ, (String)object));
            return;
        }
        object = new zzalf();
        zzaif.zza(new zzabe(this, (zzalb)object));
        String string2 = zzbs.zzbX().zzu(this.mContext);
        String string3 = zzbs.zzbX().zzv(this.mContext);
        String string4 = zzbs.zzbX().zzw(this.mContext);
        zzbs.zzbX().zzh(this.mContext, string4);
        this.zzMQ = new zzabq(this.zzSp, l, string2, string3, string4);
        object.zzf(this.zzMQ);
    }

    private final void zzd(int n, String string2) {
        if (n == 3 || n == -1) {
            zzahd.zzaS((String)string2);
        } else {
            zzahd.zzaT((String)string2);
        }
        this.zzQT = this.zzQT == null ? new zzabu(n) : new zzabu(n, this.zzQT.zzMk);
        zzabq zzabq2 = this.zzMQ != null ? this.zzMQ : new zzabq(this.zzSp, -1L, null, null, null);
        zzags zzags2 = new zzags(zzabq2, this.zzQT, this.zzMy, null, n, -1L, this.zzQT.zzTu, null, this.zzSq);
        this.zzSo.zza(zzags2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(@NonNull zzabu zzabu2) {
        Object object;
        zzahd.zzaC((String)"Received ad response.");
        this.zzQT = zzabu2;
        long l = zzbs.zzbE().elapsedRealtime();
        Object object2 = this.zzQV;
        synchronized (object2) {
            this.zzSr = null;
        }
        zzbs.zzbC().zzf(this.mContext, this.zzQT.zzSX);
        Object object3 = zzmo.zzEb;
        if (zzbs.zzbK().zzd(object3).booleanValue()) {
            if (this.zzQT.zzTj) {
                zzbs.zzbC();
                String string2 = this.zzMQ.zzvU;
                object = string2;
                SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("admob", 0);
                Set set = Collections.emptySet();
                Set set2 = sharedPreferences.getStringSet("never_pool_slots", set);
                if (!set2.contains(object)) {
                    HashSet<String> hashSet = new HashSet<String>(set2);
                    hashSet.add((String)object);
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putStringSet("never_pool_slots", hashSet);
                    editor.apply();
                }
            } else {
                zzbs.zzbC();
                String string3 = this.zzMQ.zzvU;
                object = string3;
                SharedPreferences sharedPreferences = this.mContext.getSharedPreferences("admob", 0);
                Set set = Collections.emptySet();
                Set set3 = sharedPreferences.getStringSet("never_pool_slots", set);
                if (set3.contains(object)) {
                    HashSet hashSet = new HashSet(set3);
                    hashSet.remove(object);
                    SharedPreferences.Editor editor = sharedPreferences.edit();
                    editor.putStringSet("never_pool_slots", hashSet);
                    editor.apply();
                }
            }
        }
        zziv zziv2 = null;
        try {
            if (this.zzQT.errorCode != -2 && this.zzQT.errorCode != -3) {
                int n = this.zzQT.errorCode;
                throw new zzabf(new StringBuilder(66).append("There was a problem getting an ad response. ErrorCode: ").append(n).toString(), this.zzQT.errorCode);
            }
            object3 = this;
            if (((zzabc)object3).zzQT.errorCode != -3) {
                if (TextUtils.isEmpty((CharSequence)((zzabc)object3).zzQT.body)) {
                    throw new zzabf("No fill from ad server.", 3);
                }
                zzbs.zzbC().zze(((zzabc)object3).mContext, ((zzabc)object3).zzQT.zzSJ);
                if (((zzabc)object3).zzQT.zzTq) {
                    try {
                        ((zzabc)object3).zzMy = new zzvo(((zzabc)object3).zzQT.body);
                        zzbs.zzbC().zzz(((zzabc)object3).zzMy.zzMi);
                    }
                    catch (JSONException jSONException) {
                        zzahd.zzb((String)"Could not parse mediation config.", (Throwable)jSONException);
                        String string4 = String.valueOf(((zzabc)object3).zzQT.body);
                        throw new zzabf(string4.length() != 0 ? "Could not parse mediation config: ".concat(string4) : new String("Could not parse mediation config: "), 0);
                    }
                } else {
                    zzbs.zzbC().zzz(((zzabc)object3).zzQT.zzMi);
                }
                if (!TextUtils.isEmpty((CharSequence)((zzabc)object3).zzQT.zzSY)) {
                    object = zzmo.zzGi;
                    if (((Boolean)zzbs.zzbK().zzd(object)).booleanValue()) {
                        zzahd.zzaC((String)"Received cookie from server. Setting webview cookie in CookieManager.");
                        CookieManager cookieManager = zzbs.zzbA().zzS(((zzabc)object3).mContext);
                        if (cookieManager != null) {
                            cookieManager.setCookie("googleads.g.doubleclick.net", ((zzabc)object3).zzQT.zzSY);
                        }
                    }
                }
            }
            if (this.zzMQ.zzwa.zzAx != null) {
                zziv2 = this.zzb(this.zzMQ);
            }
        }
        catch (zzabf zzabf2) {
            this.zzd(zzabf2.getErrorCode(), zzabf2.getMessage());
            zzail.zzZt.removeCallbacks(this.zzQU);
            return;
        }
        zzbs.zzbC().zzx(this.zzQT.zzTA);
        zzbs.zzbC().zzy(this.zzQT.zzTN);
        JSONObject jSONObject = null;
        if (!TextUtils.isEmpty((CharSequence)this.zzQT.zzTy)) {
            try {
                jSONObject = new JSONObject(this.zzQT.zzTy);
            }
            catch (Exception exception) {
                zzahd.zzb((String)"Error parsing the JSON for Active View.", (Throwable)exception);
            }
        }
        zzags zzags2 = new zzags(this.zzMQ, this.zzQT, this.zzMy, zziv2, -2, l, this.zzQT.zzTu, jSONObject, this.zzSq);
        this.zzSo.zza(zzags2);
        zzail.zzZt.removeCallbacks(this.zzQU);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onStop() {
        Object object = this.zzQV;
        synchronized (object) {
            if (this.zzSr != null) {
                this.zzSr.cancel();
            }
            return;
        }
    }

    private final zziv zzb(zzabq zzabq2) throws zzabf {
        int n;
        zziv[] zzivArray;
        int n2;
        zzabc zzabc2 = this;
        if (zzabc2.zzMQ != null && zzabc2.zzMQ.zzwq != null && zzabc2.zzMQ.zzwq.size() > 1 && this.zzMy != null && !this.zzMy.zzMt) {
            return null;
        }
        if (this.zzQT.zzAz) {
            zziv[] zzivArray2 = zzabq2.zzwa.zzAx;
            n2 = zzabq2.zzwa.zzAx.length;
            for (int i = 0; i < n2; ++i) {
                zzivArray = zzivArray2[i];
                if (!zzivArray.zzAz) continue;
                return new zziv((zziv)zzivArray, zzabq2.zzwa.zzAx);
            }
        }
        if (this.zzQT.zzTt == null) {
            throw new zzabf("The ad response must specify one of the supported ad sizes.", 0);
        }
        String[] stringArray = this.zzQT.zzTt.split("x");
        if (stringArray.length != 2) {
            String string2 = String.valueOf(this.zzQT.zzTt);
            throw new zzabf(string2.length() != 0 ? "Invalid ad size format from the ad response: ".concat(string2) : new String("Invalid ad size format from the ad response: "), 0);
        }
        try {
            n = Integer.parseInt(stringArray[0]);
            n2 = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            String string3 = String.valueOf(this.zzQT.zzTt);
            throw new zzabf(string3.length() != 0 ? "Invalid ad size number from the ad response: ".concat(string3) : new String("Invalid ad size number from the ad response: "), 0);
        }
        zzivArray = zzabq2.zzwa.zzAx;
        int n3 = zzabq2.zzwa.zzAx.length;
        for (int i = 0; i < n3; ++i) {
            int n4;
            zziv zziv2 = zzivArray[i];
            float f = this.mContext.getResources().getDisplayMetrics().density;
            int n5 = zziv2.width == -1 ? (int)((float)zziv2.widthPixels / f) : zziv2.width;
            int n6 = n4 = zziv2.height == -2 ? (int)((float)zziv2.heightPixels / f) : zziv2.height;
            if (n != n5 || n2 != n4 || zziv2.zzAz) continue;
            return new zziv(zziv2, zzabq2.zzwa.zzAx);
        }
        String string4 = String.valueOf(this.zzQT.zzTt);
        throw new zzabf(string4.length() != 0 ? "The ad size from the ad response was not one of the requested sizes: ".concat(string4) : new String("The ad size from the ad response was not one of the requested sizes: "), 0);
    }

    static /* synthetic */ Object zza(zzabc zzabc2) {
        return zzabc2.zzQV;
    }

    static /* synthetic */ void zza(zzabc zzabc2, int n, String string2) {
        zzabc2.zzd(n, string2);
    }

    static /* synthetic */ zzabr zzb(zzabc zzabc2) {
        return zzabc2.zzSp;
    }

    static /* synthetic */ Runnable zzc(zzabc zzabc2) {
        return zzabc2.zzQU;
    }
}

