/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzaky;
import com.google.android.gms.internal.zzakz;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzaaz
public class zzaks<T>
implements zzaky<T> {
    private final Object mLock = new Object();
    private T mValue;
    private Throwable zzaaU;
    private boolean zzaaV;
    private boolean zzMT;
    private final zzakz zzaaW = new zzakz();

    @Override
    public final void zzc(Runnable runnable) {
        this.zzaaW.zzc(runnable);
    }

    @Override
    public final void zzd(Runnable runnable) {
        this.zzaaW.zzd(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzg(@Nullable T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzMT) {
                return;
            }
            if (this.zzil()) {
                zzbs.zzbC().zza(new IllegalStateException("Provided CallbackFuture with multiple values."), "CallbackFuture.provideValue");
                return;
            }
            this.zzaaV = true;
            this.mValue = t;
            this.mLock.notifyAll();
            this.zzaaW.zzim();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(Throwable throwable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzMT) {
                return;
            }
            if (this.zzil()) {
                zzbs.zzbC().zza(new IllegalStateException("Provided CallbackFuture with multiple values."), "CallbackFuture.provideException");
                return;
            }
            this.zzaaU = throwable;
            this.mLock.notifyAll();
            this.zzaaW.zzim();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws CancellationException, ExecutionException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzil()) {
                this.mLock.wait();
            }
            if (this.zzaaU != null) {
                throw new ExecutionException(this.zzaaU);
            }
            if (this.zzMT) {
                throw new CancellationException("CallbackFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzil()) {
                long l2 = timeUnit.toMillis(l);
                if (l2 != 0L) {
                    this.mLock.wait(l2);
                }
            }
            if (this.zzaaU != null) {
                throw new ExecutionException(this.zzaaU);
            }
            if (!this.zzaaV) {
                throw new TimeoutException("CallbackFuture timed out.");
            }
            if (this.zzMT) {
                throw new CancellationException("CallbackFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (!bl) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzil()) {
                return false;
            }
            this.zzMT = true;
            this.zzaaV = true;
            this.mLock.notifyAll();
            this.zzaaW.zzim();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzMT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzil();
        }
    }

    private final boolean zzil() {
        return this.zzaaU != null || this.zzaaV;
    }
}

