/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.zze;
import com.google.android.gms.internal.aif;
import com.google.android.gms.internal.zzax;
import com.google.android.gms.internal.zzbaz;
import com.google.android.gms.internal.zzbc;
import com.google.android.gms.internal.zzbv;
import com.google.android.gms.internal.zzccc;
import com.google.android.gms.internal.zzcn;
import com.google.android.gms.internal.zzcw;
import com.google.android.gms.internal.zzcx;
import com.google.android.gms.internal.zzcy;
import com.google.android.gms.internal.zzdc;
import com.google.android.gms.internal.zzdd;
import com.google.android.gms.internal.zzde;
import com.google.android.gms.internal.zzdg;
import com.google.android.gms.internal.zzea;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzdb {
    private static final String TAG = zzdb.class.getSimpleName();
    protected Context zzqG;
    private Context zzqH;
    private ExecutorService zzqI;
    private DexClassLoader zzqJ;
    private zzcw zzqK;
    private byte[] zzqL;
    private volatile AdvertisingIdClient zzqM = null;
    private volatile boolean zzqn = false;
    private Future zzqN = null;
    private volatile zzax zzqO = null;
    private Future zzqP = null;
    private zzcn zzqQ;
    private GoogleApiClient zzqR = null;
    protected boolean zzqS = false;
    private static Object zzqT = new Object();
    private boolean zzqU = false;
    private static zze zzqV = null;
    protected boolean zzqW = false;
    private Map<Pair<String, String>, zzea> zzqX;
    private boolean zzqY = false;

    public static zzdb zza(Context context, String string2, String string3, boolean bl) {
        zzdb zzdb2 = new zzdb(context);
        try {
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzdb zzdb3 = zzdb2;
            zzdb2.zzqI = Executors.newCachedThreadPool();
            boolean bl3 = bl2;
            Object object = zzdb3;
            zzdb3.zzqn = bl3;
            if (bl3) {
                ((zzdb)object).zzqN = ((zzdb)object).zzqI.submit(new zzdc((zzdb)object));
            }
            zzdb zzdb4 = zzdb3;
            zzdb4.zzqI.execute(new zzde(zzdb4));
            try {
                zzqV = zze.zzoU();
                zzdb4.zzqS = zze.zzau((Context)zzdb4.zzqG) > 0;
                boolean bl4 = zzdb4.zzqU = zzqV.isGooglePlayServicesAvailable(zzdb4.zzqG) == 0;
                if (zzdb4.zzqG.getApplicationContext() != null) {
                    zzdb4.zzqR = new GoogleApiClient.Builder(zzdb4.zzqG).addApi(zzbaz.API).build();
                }
            }
            catch (Throwable throwable) {}
            zzdb3.zza(0, true);
            if (zzdg.zzR()) {
                object = zzmo.zzFd;
                if (((Boolean)zzbs.zzbK().zzd(object)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            String string6 = string5;
            zzdb4 = zzdb3;
            zzdb3.zzqK = new zzcw(null);
            try {
                zzdb4.zzqL = zzdb4.zzqK.zzl(string6);
            }
            catch (zzcx zzcx2) {
                throw new zzcy(zzcx2);
            }
            string6 = string4;
            zzdb4 = zzdb3;
            try {
                String string7;
                File file = zzdb4.zzqG.getCacheDir();
                if (file == null && (file = zzdb4.zzqG.getDir("dex", 0)) == null) {
                    throw new zzcy();
                }
                String string8 = string7 = "1489418796403";
                File file2 = file;
                String string9 = string6;
                zzdb zzdb5 = zzdb4;
                File file3 = new File(String.format("%s/%s.jar", file2, string8));
                if (!file3.exists()) {
                    byte[] byArray = zzdb5.zzqK.zza(zzdb5.zzqL, string9);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzdb4.zzb(file, string7);
                try {
                    zzdb4.zzqJ = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzdb4.zzqG.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzdb.zza(file4);
                    zzdb4.zza(file, string7);
                    zzdb.zzm(String.format("%s/%s.dex", file, string7));
                    throw throwable;
                }
                zzdb.zza(file4);
                zzdb4.zza(file, string7);
                zzdb.zzm(String.format("%s/%s.dex", file, string7));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzcy(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzcy(iOException);
            }
            catch (zzcx zzcx3) {
                throw new zzcy(zzcx3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzcy(nullPointerException);
            }
            zzdb3.zzqQ = new zzcn(zzdb3);
            zzdb3.zzqY = true;
        }
        catch (zzcy zzcy2) {}
        return zzdb2;
    }

    public final Context getContext() {
        return this.zzqG;
    }

    public final boolean isInitialized() {
        return this.zzqY;
    }

    public final Context getApplicationContext() {
        return this.zzqH;
    }

    public final ExecutorService getExecutorService() {
        return this.zzqI;
    }

    public final DexClassLoader zzC() {
        return this.zzqJ;
    }

    public final zzcw zzD() {
        return this.zzqK;
    }

    public final byte[] zzE() {
        return this.zzqL;
    }

    public final GoogleApiClient zzF() {
        return this.zzqR;
    }

    public final boolean zzG() {
        return this.zzqS;
    }

    public final zzcn zzH() {
        return this.zzqQ;
    }

    public final boolean zzI() {
        return this.zzqU;
    }

    public final zzax zzJ() {
        return this.zzqO;
    }

    public final Future zzK() {
        return this.zzqP;
    }

    private zzdb(Context context) {
        this.zzqG = context;
        this.zzqH = context.getApplicationContext();
        this.zzqX = new HashMap<Pair<String, String>, zzea>();
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzdb.zza(file2);
            return;
        }
        zzbc zzbc2 = new zzbc();
        new zzbc().zzcJ = Build.VERSION.SDK.getBytes();
        zzbc2.zzcI = string2.getBytes();
        byte[] byArray2 = this.zzqK.zzc(this.zzqL, byArray).getBytes();
        zzbc2.data = byArray2;
        zzbc2.zzcH = zzbv.zzb(byArray2);
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = aif.zzd((aif)zzbc2);
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzdb.zza(file2);
        return;
        catch (zzcx | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdb.zza(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzdb.zza(file2);
            throw throwable;
        }
    }

    private static void zzm(String string2) {
        zzdb.zza(new File(string2));
    }

    private static void zza(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzbc zzbc2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzdb.zza(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzdb.zza(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                byte[] byArray2 = byArray;
                zzbc2 = (zzbc)aif.zza((aif)new zzbc(), (byte[])byArray2);
                if (string2.equals(new String(zzbc2.zzcI)) && Arrays.equals(zzbc2.zzcH, zzbv.zzb(zzbc2.data)) && Arrays.equals(zzbc2.zzcJ, Build.VERSION.SDK.getBytes())) break block30;
                zzdb.zza(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzqK.zza(this.zzqL, new String(zzbc2.data));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzcx | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzqX.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzqX.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzea(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zzc(String string2, String string3) {
        zzea zzea2 = this.zzqX.get(new Pair((Object)string2, (Object)string3));
        if (zzea2 == null) {
            return null;
        }
        return zzea2.zzX();
    }

    private final void zzL() {
        try {
            if (this.zzqM == null && this.zzqH != null) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzqH);
                advertisingIdClient.start();
                this.zzqM = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzqM = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzqU) {
            return;
        }
        Future<?> future = this.zzqI.submit(new zzdd(this, n, bl));
        if (n == 0) {
            this.zzqP = future;
        }
    }

    @VisibleForTesting
    final zzax zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzM();
    }

    private static boolean zza(int n, zzax zzax2) {
        if (n < 4) {
            if (zzax2 == null) {
                return true;
            }
            zzme<Boolean> zzme2 = zzmo.zzFg;
            if (zzbs.zzbK().zzd(zzme2).booleanValue() && (zzax2.zzaW == null || zzax2.zzaW.equals("0000000000000000000000000000000000000000000000000000000000000000"))) {
                return true;
            }
            zzme2 = zzmo.zzFh;
            if (zzbs.zzbK().zzd(zzme2).booleanValue() && (zzax2.zzcc == null || zzax2.zzcc.zzcA == null || zzax2.zzcc.zzcA == -2L)) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzax zzM() {
        zzax zzax2 = null;
        try {
            PackageInfo packageInfo = this.zzqG.getPackageManager().getPackageInfo(this.zzqG.getPackageName(), 0);
            zzax2 = zzccc.zzn((Context)this.zzqG, (String)this.zzqG.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zzax2;
    }

    public final AdvertisingIdClient zzN() {
        if (!this.zzqn) {
            return null;
        }
        if (this.zzqM != null) {
            return this.zzqM;
        }
        if (this.zzqN != null) {
            try {
                this.zzqN.get(2000L, TimeUnit.MILLISECONDS);
                this.zzqN = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzqN.cancel(true);
            }
        }
        return this.zzqM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzO() {
        try {
            Object object = zzqT;
            synchronized (object) {
                if (this.zzqW) {
                    return;
                }
                if (this.zzqU && this.zzqR != null) {
                    this.zzqR.connect();
                    this.zzqW = true;
                } else {
                    this.zzqW = false;
                }
                return;
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzP() {
        Object object = zzqT;
        synchronized (object) {
            if (this.zzqW && this.zzqR != null) {
                this.zzqR.disconnect();
                this.zzqW = false;
            }
            return;
        }
    }

    public final int zzy() {
        int n = Integer.MIN_VALUE;
        if (this.zzqQ != null) {
            n = zzcn.zzy();
        }
        return n;
    }

    static /* synthetic */ void zza(zzdb zzdb2) {
        zzdb2.zzL();
    }

    static /* synthetic */ zzax zza(zzdb zzdb2, zzax zzax2) {
        zzdb2.zzqO = zzax2;
        return zzdb2.zzqO;
    }

    static /* synthetic */ boolean zzb(int n, zzax zzax2) {
        return zzdb.zza(n, zzax2);
    }
}

