/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzaax;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzaaz
@TargetApi(value=14)
public final class zzgz
extends Thread {
    private boolean mStarted = false;
    private boolean zzyA = false;
    private boolean zzak = false;
    private final Object mLock;
    private final zzgu zzyB;
    private final zzaax zzyC;
    private final int zzyD;
    private final int zzxZ;
    private final int zzyE;
    private final int zzyb;
    private final int zzyF;
    private final int zzyG;
    private final int zzyH;
    private final int zzyI;
    private final String zzyJ;
    private final boolean zzyK;

    public zzgz(zzgu zzgu2, zzaax zzaax2) {
        this.zzyB = zzgu2;
        this.zzyC = zzaax2;
        this.mLock = new Object();
        zzme<Object> zzme2 = zzmo.zzCX;
        this.zzxZ = zzbs.zzbK().zzd(zzme2);
        zzme2 = zzmo.zzCY;
        this.zzyE = zzbs.zzbK().zzd(zzme2);
        zzme2 = zzmo.zzCZ;
        this.zzyb = zzbs.zzbK().zzd(zzme2);
        zzme2 = zzmo.zzDa;
        this.zzyF = zzbs.zzbK().zzd(zzme2);
        zzme2 = zzmo.zzDd;
        this.zzyG = zzbs.zzbK().zzd(zzme2);
        zzme2 = zzmo.zzDf;
        this.zzyH = zzbs.zzbK().zzd(zzme2);
        zzme2 = zzmo.zzDg;
        this.zzyI = zzbs.zzbK().zzd(zzme2);
        zzme2 = zzmo.zzDb;
        this.zzyD = zzbs.zzbK().zzd(zzme2);
        zzme2 = zzmo.zzDi;
        this.zzyJ = (String)((Object)zzbs.zzbK().zzd(zzme2));
        zzme2 = zzmo.zzDk;
        this.zzyK = (Boolean)((Object)zzbs.zzbK().zzd(zzme2));
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcL() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStarted) {
                zzahd.zzaC((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzgz.zzcM()) {
                    object = zzbs.zzbB().getActivity();
                    if (object == null) {
                        zzahd.zzaC((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzcO();
                    } else {
                        Activity activity = object;
                        zzgz zzgz2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Throwable throwable) {
                                zzbs.zzbC().zza(throwable, "ContentFetchTask.extractContent");
                                zzahd.zzaC((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                View view2 = view;
                                zzgz zzgz3 = zzgz2;
                                if (view2 != null) {
                                    view2.post((Runnable)new zzha(zzgz3, view2));
                                }
                            }
                        }
                    }
                } else {
                    zzahd.zzaC((String)"ContentFetchTask: sleeping");
                    this.zzcO();
                }
                Thread.sleep(this.zzyD * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzahd.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Throwable throwable) {
                zzahd.zzb((String)"Error in ContentFetchTask", (Throwable)throwable);
                this.zzyC.zza(throwable, "ContentFetchTask.run");
            }
            object = this.mLock;
            synchronized (object) {
                while (this.zzyA) {
                    try {
                        zzahd.zzaC((String)"ContentFetchTask: waiting");
                        this.mLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    final void zzf(View view) {
        try {
            zzgt zzgt2 = new zzgt(this.zzxZ, this.zzyE, this.zzyb, this.zzyF, this.zzyG, this.zzyH, this.zzyI);
            zzhd zzhd2 = this.zza(view, zzgt2);
            zzgt2.zzcI();
            if (zzhd2.zzyS == 0 && zzhd2.zzyT == 0) {
                return;
            }
            if (zzhd2.zzyT == 0 && zzgt2.zzcJ() == 0) {
                return;
            }
            if (zzhd2.zzyT == 0 && this.zzyB.zza(zzgt2)) {
                return;
            }
            this.zzyB.zzc(zzgt2);
            return;
        }
        catch (Exception exception) {
            zzahd.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzyC.zza(exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    private static boolean zzcM() {
        try {
            Context context = zzbs.zzbB().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzbs.zzbC().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    private final zzhd zza(@Nullable View view, zzgt zzgt2) {
        Object object;
        if (view == null) {
            return new zzhd(this, 0, 0);
        }
        Context context = zzbs.zzbB().getContext();
        if (context != null) {
            object = zzmo.zzDh;
            int n = context.getResources().getIdentifier(zzbs.zzbK().zzd(object), "id", context.getPackageName());
            String string2 = (String)view.getTag(n);
            if (!TextUtils.isEmpty((CharSequence)this.zzyJ) && string2 != null && string2.equals(this.zzyJ)) {
                return new zzhd(this, 0, 0);
            }
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string3 = charSequence.toString();
                zzgt2.zzb(string3, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzhd(this, 1, 0);
            }
            return new zzhd(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzalm)) {
            boolean bl2;
            zzgt2.zzcH();
            zzgt zzgt3 = zzgt2;
            WebView webView = (WebView)view;
            object = this;
            if (!zzs.zzsb()) {
                bl2 = false;
            } else {
                zzgt3.zzcH();
                webView.post((Runnable)new zzhb((zzgz)object, zzgt3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzhd(this, 0, 1);
            }
            return new zzhd(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzhd zzhd2 = this.zza(viewGroup.getChildAt(i), zzgt2);
                n += zzhd2.zzyS;
                n2 += zzhd2.zzyT;
            }
            return new zzhd(this, n, n2);
        }
        return new zzhd(this, 0, 0);
    }

    final void zza(zzgt zzgt2, WebView webView, String string2, boolean bl) {
        zzgt2.zzcG();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzyK && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = String.valueOf(webView.getTitle());
                    zzgt2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzgt2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzgt2.zzcB()) {
                this.zzyB.zzb(zzgt2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzahd.zzaC((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzahd.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzyC.zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzgt zzcN() {
        return this.zzyB.zzcK();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzyA = false;
            this.mLock.notifyAll();
            zzahd.zzaC((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzcO() {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.zzyA = true;
            zzahd.zzaC((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzcP() {
        return this.zzyA;
    }
}

