/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzahd;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzakq;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzon;
import com.google.android.gms.internal.zzvn;
import com.google.android.gms.internal.zzvo;
import com.google.android.gms.internal.zzvq;
import com.google.android.gms.internal.zzvs;
import com.google.android.gms.internal.zzvt;
import com.google.android.gms.internal.zzvu;
import com.google.android.gms.internal.zzvv;
import com.google.android.gms.internal.zzwd;
import com.google.android.gms.internal.zzwg;
import com.google.android.gms.internal.zzwj;
import com.google.android.gms.internal.zzwm;
import com.google.android.gms.internal.zzww;
import com.google.android.gms.internal.zzxp;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzaaz
public final class zzvr
implements zzvv {
    private final String zzMw;
    private final zzwd zzta;
    private final long zzMx;
    private final zzvo zzMy;
    private final zzvn zzMz;
    private zzir zzuW;
    private final zziv zzvc;
    private final Context mContext;
    private final Object mLock = new Object();
    private final zzakq zztZ;
    private final boolean zzwM;
    private final zzon zztV;
    private final List<String> zztW;
    private final List<String> zzMA;
    private final List<String> zzMB;
    private final boolean zzMC;
    private zzwg zzMD;
    private int zzME = -2;
    private zzwm zzMF;

    public zzvr(Context context, String string, zzwd zzwd2, zzvo zzvo2, zzvn zzvn2, zzir zzir2, zziv zziv2, zzakq zzakq2, boolean bl, boolean bl2, zzon zzon2, List<String> list, List<String> list2, List<String> list3) {
        this.mContext = context;
        this.zzta = zzwd2;
        this.zzMz = zzvn2;
        this.zzMw = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string) ? this.zzfi() : string;
        this.zzMy = zzvo2;
        this.zzMx = zzvo2.zzMd != -1L ? zzvo2.zzMd : 10000L;
        this.zzuW = zzir2;
        this.zzvc = zziv2;
        this.zztZ = zzakq2;
        this.zzwM = bl;
        this.zzMC = bl2;
        this.zztV = zzon2;
        this.zztW = list;
        this.zzMA = list2;
        this.zzMB = list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.zzMD != null) {
                    this.zzMD.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzahd.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzME = -1;
            this.mLock.notify();
            return;
        }
    }

    private final String zzfi() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzMz.zzLP)) {
                if (this.zzta.zzai(this.zzMz.zzLP)) {
                    return "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter";
                }
                return "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzahd.zzaT((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzo(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzME = n;
            this.mLock.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(int n, zzwm zzwm2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzME = 0;
            this.zzMF = zzwm2;
            this.mLock.notify();
            return;
        }
    }

    private static zzwg zza(MediationAdapter mediationAdapter) {
        return new zzww(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzvu zza(long l, long l2) {
        Object object = this.mLock;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            zzvq zzvq2 = new zzvq();
            zzail.zzZt.post((Runnable)new zzvs(this, zzvq2));
            long l4 = l2;
            long l5 = l;
            long l6 = this.zzMx;
            zzvr zzvr2 = this;
            while (zzvr2.zzME == -2) {
                long l7 = l4;
                long l8 = l5;
                long l9 = l6;
                long l10 = l3;
                zzvr zzvr3 = zzvr2;
                long l11 = SystemClock.elapsedRealtime();
                long l12 = l9 - (l11 - l10);
                long l13 = l7 - (l11 - l8);
                if (l12 <= 0L || l13 <= 0L) {
                    zzahd.zzaS((String)"Timed out waiting for adapter.");
                    zzvr3.zzME = 3;
                    continue;
                }
                try {
                    zzvr3.mLock.wait(Math.min(l12, l13));
                }
                catch (InterruptedException interruptedException) {
                    zzvr3.zzME = -1;
                }
            }
            long l14 = zzbs.zzbE().elapsedRealtime() - l3;
            return new zzvu(this.zzMz, this.zzMD, this.zzMw, zzvq2, this.zzME, this.zzfj(), l14);
        }
    }

    private final zzwm zzfj() {
        if (this.zzME != 0 || !this.zzfl()) {
            return null;
        }
        try {
            if (this.zzp(4) && this.zzMF != null && this.zzMF.zzfn() != 0) {
                return this.zzMF;
            }
        }
        catch (RemoteException remoteException) {
            zzahd.zzaT((String)"Could not get cpm value from MediationResponseMetadata");
        }
        int n = this.zzfm();
        return new zzvt(n);
    }

    private final zzwg zzfk() {
        String string = String.valueOf(this.zzMw);
        zzahd.zzaS((String)(string.length() != 0 ? "Instantiating mediation adapter: ".concat(string) : new String("Instantiating mediation adapter: ")));
        if (!this.zzwM && !this.zzMz.zzfh()) {
            zzme<Boolean> zzme2 = zzmo.zzEJ;
            if (zzbs.zzbK().zzd(zzme2).booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzMw)) {
                return zzvr.zza((MediationAdapter)new AdMobAdapter());
            }
            zzme2 = zzmo.zzEK;
            if (zzbs.zzbK().zzd(zzme2).booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzMw)) {
                return zzvr.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzMw)) {
                return new zzww((MediationAdapter)new zzxp());
            }
        }
        try {
            return this.zzta.zzah(this.zzMw);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(this.zzMw);
            zzahd.zza((String)(string2.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string2) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private final void zza(zzvq zzvq2) {
        String string = this.zzaf(this.zzMz.zzLT);
        try {
            if (this.zztZ.zzaaR < 4100000) {
                if (this.zzvc.zzAw) {
                    this.zzMD.zza(zzn.zzw((Object)this.mContext), this.zzuW, string, (zzwj)zzvq2);
                    return;
                }
                this.zzMD.zza(zzn.zzw((Object)this.mContext), this.zzvc, this.zzuW, string, (zzwj)zzvq2);
                return;
            }
            if (this.zzwM || this.zzMz.zzfh()) {
                ArrayList<String> arrayList = new ArrayList<String>(this.zztW);
                if (this.zzMA != null) {
                    for (String string2 : this.zzMA) {
                        String string3 = ":false";
                        if (this.zzMB != null && this.zzMB.contains(string2)) {
                            string3 = ":true";
                        }
                        String string4 = string3;
                        arrayList.add(new StringBuilder(7 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("custom:").append(string2).append(string4).toString());
                    }
                }
                this.zzMD.zza(zzn.zzw((Object)this.mContext), this.zzuW, string, this.zzMz.zzLL, (zzwj)zzvq2, this.zztV, arrayList);
                return;
            }
            if (this.zzvc.zzAw) {
                this.zzMD.zza(zzn.zzw((Object)this.mContext), this.zzuW, string, this.zzMz.zzLL, (zzwj)zzvq2);
                return;
            }
            if (this.zzMC) {
                if (this.zzMz.zzLW != null) {
                    this.zzMD.zza(zzn.zzw((Object)this.mContext), this.zzuW, string, this.zzMz.zzLL, (zzwj)zzvq2, new zzon(zzvr.zzag(this.zzMz.zzMa)), this.zzMz.zzLZ);
                    return;
                }
                this.zzMD.zza(zzn.zzw((Object)this.mContext), this.zzvc, this.zzuW, string, this.zzMz.zzLL, (zzwj)zzvq2);
                return;
            }
            this.zzMD.zza(zzn.zzw((Object)this.mContext), this.zzvc, this.zzuW, string, this.zzMz.zzLL, (zzwj)zzvq2);
            return;
        }
        catch (RemoteException remoteException) {
            zzahd.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzo(5);
            return;
        }
    }

    private final boolean zzp(int n) {
        Bundle bundle;
        try {
            bundle = this.zzwM ? this.zzMD.zzfs() : (this.zzvc.zzAw ? this.zzMD.getInterstitialAdapterInfo() : this.zzMD.zzfr());
        }
        catch (RemoteException remoteException) {
            zzahd.zzaT((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private final boolean zzfl() {
        return this.zzMy.zzMn != -1;
    }

    private final String zzaf(String string) {
        if (string == null || !this.zzfl() || this.zzp(2)) {
            return string;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzahd.zzaT((String)"Could not remove field. Returning the original value");
            return string;
        }
    }

    private final int zzfm() {
        JSONObject jSONObject;
        if (this.zzMz.zzLT == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzMz.zzLT);
        }
        catch (JSONException jSONException) {
            zzahd.zzaT((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzMw)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzp(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static NativeAdOptions zzag(String string) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string == null) {
            return builder.build();
        }
        try {
            String string2;
            JSONObject jSONObject = new JSONObject(string);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string3 = string2 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation("landscape".equals(string3) ? 2 : ("portrait".equals(string3) ? 1 : ("any".equals(string3) ? 0 : -1)));
        }
        catch (JSONException jSONException) {
            zzahd.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    static /* synthetic */ Object zza(zzvr zzvr2) {
        return zzvr2.mLock;
    }

    static /* synthetic */ int zzb(zzvr zzvr2) {
        return zzvr2.zzME;
    }

    static /* synthetic */ zzwg zza(zzvr zzvr2, zzwg zzwg2) {
        zzvr2.zzMD = zzwg2;
        return zzvr2.zzMD;
    }

    static /* synthetic */ zzwg zzc(zzvr zzvr2) {
        return zzvr2.zzfk();
    }

    static /* synthetic */ zzwg zzd(zzvr zzvr2) {
        return zzvr2.zzMD;
    }

    static /* synthetic */ boolean zze(zzvr zzvr2) {
        return zzvr2.zzfl();
    }

    static /* synthetic */ boolean zza(zzvr zzvr2, int n) {
        return zzvr2.zzp(1);
    }

    static /* synthetic */ String zzf(zzvr zzvr2) {
        return zzvr2.zzMw;
    }

    static /* synthetic */ void zza(zzvr zzvr2, zzvq zzvq2) {
        zzvr2.zza(zzvq2);
    }
}

