/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzaaz;
import com.google.android.gms.internal.zzail;
import com.google.android.gms.internal.zzalm;
import com.google.android.gms.internal.zzxu;
import com.google.android.gms.internal.zzxv;
import com.google.android.gms.internal.zzyg;
import java.util.Map;

@zzaaz
public final class zzxt
extends zzyg {
    private final Map<String, String> zzHd;
    private final Context mContext;
    private String zzNu;
    private long zzNv;
    private long zzNw;
    private String zzNx;
    private String zzNy;

    public zzxt(zzalm zzalm2, Map<String, String> map) {
        super(zzalm2, "createCalendarEvent");
        this.zzHd = map;
        this.mContext = zzalm2.zzir();
        zzxt zzxt2 = this;
        zzxt2.zzNu = zzxt2.zzal("description");
        zzxt2.zzNx = zzxt2.zzal("summary");
        zzxt2.zzNv = zzxt2.zzam("start_ticks");
        zzxt2.zzNw = zzxt2.zzam("end_ticks");
        zzxt2.zzNy = zzxt2.zzal("location");
    }

    private final String zzal(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzHd.get(string2))) {
            return "";
        }
        return this.zzHd.get(string2);
    }

    private final long zzam(String string2) {
        String string3 = this.zzHd.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzan("Activity context is not available.");
            return;
        }
        zzbs.zzby();
        if (!zzail.zzH(this.mContext).zzdG()) {
            this.zzan("This feature is not available on the device.");
            return;
        }
        zzbs.zzby();
        AlertDialog.Builder builder = zzail.zzG(this.mContext);
        Resources resources = zzbs.zzbC().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzxu(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzxv(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzNu);
        intent.putExtra("eventLocation", this.zzNy);
        intent.putExtra("description", this.zzNx);
        if (this.zzNv > -1L) {
            intent.putExtra("beginTime", this.zzNv);
        }
        if (this.zzNw > -1L) {
            intent.putExtra("endTime", this.zzNw);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzxt zzxt2) {
        return zzxt2.mContext;
    }
}

