/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.overlay.zzag;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzbi;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.ads.internal.zzbu;
import com.google.android.gms.ads.internal.zzc;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zzj;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzacp;
import com.google.android.gms.internal.zzacu;
import com.google.android.gms.internal.zzadc;
import com.google.android.gms.internal.zzaed;
import com.google.android.gms.internal.zzaey;
import com.google.android.gms.internal.zzafe;
import com.google.android.gms.internal.zzaff;
import com.google.android.gms.internal.zzafg;
import com.google.android.gms.internal.zzafl;
import com.google.android.gms.internal.zzafm;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjl;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkk;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzmz;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzqk;
import com.google.android.gms.internal.zzxf;
import com.google.android.gms.internal.zzxn;
import com.google.android.gms.internal.zzxx;
import com.google.android.gms.internal.zzzm;
import com.google.android.gms.internal.zzzo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

@zzzm
public abstract class zza
extends zzka
implements zzag,
zzafl,
zzim,
zzqk,
zzxx,
zzzo {
    protected zznb zzsM;
    private zzmz zzsN;
    private zzmz zzsO;
    protected boolean zzsP = false;
    protected final zzbi zzsQ;
    protected final zzbt zzsR;
    @Nullable
    protected transient zzir zzsS;
    protected final zzfh zzsT;
    protected final zzv zzsU;

    public final zzv zzak() {
        return this.zzsU;
    }

    zza(zzbt zzbt2, @Nullable zzbi zzbi2, zzv zzv2) {
        this.zzsR = zzbt2;
        this.zzsQ = new zzbi(this);
        this.zzsU = zzv2;
        zzbs.zzbz().zzE(this.zzsR.zzqF);
        zzbs.zzbD().zzd(this.zzsR.zzqF, this.zzsR.zzvV);
        zzbs.zzbE().initialize(this.zzsR.zzqF);
        this.zzsT = zzbs.zzbD().zzhG();
        zzbs.zzbC().initialize(this.zzsR.zzqF);
        zza zza2 = this;
        zzme<Long> zzme2 = zzmo.zzFG;
        if (zzbs.zzbL().zzd(zzme2).booleanValue()) {
            CountDownLatch countDownLatch;
            Timer timer = new Timer();
            zzme2 = zzmo.zzFI;
            CountDownLatch countDownLatch2 = countDownLatch = new CountDownLatch((Integer)((Object)zzbs.zzbL().zzd(zzme2)));
            Timer timer2 = timer;
            zzme2 = zza2;
            zzb zzb2 = new zzb((zza)((Object)zzme2), countDownLatch2, timer2);
            zzme2 = zzmo.zzFH;
            timer.schedule((TimerTask)zzb2, 0L, (long)zzbs.zzbL().zzd(zzme2));
        }
    }

    public void destroy() {
        zzbt zzbt2;
        zzbo.zzcz((String)"destroy must be called on the main UI thread.");
        this.zzsQ.cancel();
        this.zzsT.zzh(this.zzsR.zzwa);
        zzbt zzbt3 = zzbt2 = this.zzsR;
        if (zzbt2.zzvW != null) {
            zzbt3.zzvW.zzcg();
        }
        zzbt2.zzwe = null;
        zzbt2.zzwf = null;
        zzbt2.zzwq = null;
        zzbt2.zzwg = null;
        zzbt2.zze(false);
        if (zzbt2.zzvW != null) {
            zzbt2.zzvW.removeAllViews();
        }
        zzbt2.zzca();
        zzbt2.zzcb();
        zzbt2.zzwa = null;
    }

    public final IObjectWrapper zzal() {
        zzbo.zzcz((String)"getAdFrame must be called on the main UI thread.");
        return zzn.zzw((Object)((Object)this.zzsR.zzvW));
    }

    @Nullable
    public final zziv zzam() {
        zzbo.zzcz((String)"getAdSize must be called on the main UI thread.");
        if (this.zzsR.zzvZ == null) {
            return null;
        }
        return new zzlv(this.zzsR.zzvZ);
    }

    public final boolean isReady() {
        zzbo.zzcz((String)"isLoaded must be called on the main UI thread.");
        return this.zzsR.zzvX == null && this.zzsR.zzvY == null && this.zzsR.zzwa != null;
    }

    public void setManualImpressionsEnabled(boolean bl) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    public boolean zza(zzir zzir2) {
        zzbo.zzcz((String)"loadAd must be called on the main UI thread.");
        zzbs.zzbE().zzcX();
        Object object = zzmo.zzDT;
        if (zzbs.zzbL().zzd(object).booleanValue()) {
            zzir.zzh((zzir)zzir2);
        }
        Object object2 = zzir2;
        zzir zzir3 = zzir2 = zzj.zzaI((Context)this.zzsR.zzqF) && object2.zzzX != null ? new zzis(object2).zza(null).zzdj() : object2;
        if (this.zzsR.zzvX != null || this.zzsR.zzvY != null) {
            if (this.zzsS != null) {
                zzafq.zzaT((String)"Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            } else {
                zzafq.zzaT((String)"Loading already in progress, saving this object for future refreshes.");
            }
            this.zzsS = zzir2;
            return false;
        }
        zzafq.zzaS((String)"Starting ad request.");
        object = this;
        object2 = zzmo.zzCS;
        this.zzsM = new zznb((Boolean)zzbs.zzbL().zzd(object2), "load_ad", ((zza)object).zzsR.zzvZ.zzAu);
        ((zza)object).zzsN = new zzmz(-1L, null, null);
        ((zza)object).zzsO = new zzmz(-1L, null, null);
        this.zzsN = this.zzsM.zzdS();
        if (zzir2.zzzS) {
            zzafq.zzaS((String)"This request is sent from a test device.");
        } else {
            zzji.zzds();
            String string = String.valueOf(zzaix.zzV((Context)this.zzsR.zzqF));
            zzafq.zzaS((String)new StringBuilder(71 + String.valueOf(string).length()).append("Use AdRequest.Builder.addTestDevice(\"").append(string).append("\") to get test ads on this device.").toString());
        }
        this.zzsQ.zzf(zzir2);
        this.zzsP = this.zza(zzir2, this.zzsM);
        return this.zzsP;
    }

    protected abstract boolean zza(zzir var1, zznb var2);

    @Override
    public final void zza(zzaff zzaff2) {
        long l;
        if (zzaff2.zzXY.zzTs != -1L && !TextUtils.isEmpty((CharSequence)zzaff2.zzXY.zzTB) && (l = zza.zzr(zzaff2.zzXY.zzTB)) != -1L) {
            zzmz zzmz2 = this.zzsM.zzc(zzaff2.zzXY.zzTs + l);
            this.zzsM.zza(zzmz2, "stc");
        }
        this.zzsM.zzO(zzaff2.zzXY.zzTB);
        this.zzsM.zza(this.zzsN, "arf");
        this.zzsO = this.zzsM.zzdS();
        this.zzsM.zzh("gqi", zzaff2.zzXY.zzTC);
        this.zzsR.zzvX = null;
        this.zzsR.zzwb = zzaff2;
        zzaff2.zzXX.zza(new zzc(this, zzaff2));
        zzaff2.zzXX.zzdf();
        this.zza(zzaff2, this.zzsM);
    }

    protected abstract void zza(zzaff var1, zznb var2);

    boolean zza(zzafe zzafe2) {
        return false;
    }

    @Override
    public void zzb(zzafe zzafe2) {
        this.zzsM.zza(this.zzsO, "awr");
        this.zzsR.zzvY = null;
        if (zzafe2.errorCode != -2 && zzafe2.errorCode != 3) {
            zzbs.zzbD().zzb(this.zzsR.zzbZ());
        }
        if (zzafe2.errorCode == -1) {
            this.zzsP = false;
            return;
        }
        if (this.zza(zzafe2)) {
            zzafq.zzaC((String)"Ad refresh scheduled.");
        }
        if (zzafe2.errorCode != -2) {
            this.zze(zzafe2.errorCode);
            return;
        }
        if (this.zzsR.zzwt == null) {
            this.zzsR.zzwt = new zzafm(this.zzsR.zzvT);
        }
        this.zzsT.zzg(this.zzsR.zzwa);
        if (this.zza(this.zzsR.zzwa, zzafe2)) {
            this.zzsR.zzwa = zzafe2;
            zzbt zzbt2 = this.zzsR;
            if (zzbt2.zzwc != null) {
                if (zzbt2.zzwa != null) {
                    zzbt2.zzwc.zzh(zzbt2.zzwa.zzXR);
                    zzbt2.zzwc.zzi(zzbt2.zzwa.zzXS);
                    zzbt2.zzwc.zzw(zzbt2.zzwa.zzTo);
                }
                zzbt2.zzwc.zzv(zzbt2.zzvZ.zzAv);
            }
            this.zzsM.zzh("is_mraid", this.zzsR.zzwa.zzcn() ? "1" : "0");
            this.zzsM.zzh("is_mediation", this.zzsR.zzwa.zzTo ? "1" : "0");
            if (this.zzsR.zzwa.zzPg != null && this.zzsR.zzwa.zzPg.zziw() != null) {
                this.zzsM.zzh("is_delay_pl", this.zzsR.zzwa.zzPg.zziw().zziS() ? "1" : "0");
            }
            this.zzsM.zza(this.zzsN, "ttc");
            if (zzbs.zzbD().zzhr() != null) {
                zzbs.zzbD().zzhr().zza(this.zzsM);
            }
            this.zzaw();
            if (this.zzsR.zzcc()) {
                this.zzas();
            }
        }
        if (zzafe2.zzMf != null) {
            zzbs.zzbz().zza(this.zzsR.zzqF, zzafe2.zzMf);
        }
    }

    protected abstract boolean zza(@Nullable zzafe var1, zzafe var2);

    public void onAdClicked() {
        if (this.zzsR.zzwa == null) {
            zzafq.zzaT((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        zzafq.zzaC((String)"Pinging click URLs.");
        if (this.zzsR.zzwc != null) {
            this.zzsR.zzwc.zzhd();
        }
        if (this.zzsR.zzwa.zzMc != null) {
            zzbs.zzbz();
            zzagy.zza(this.zzsR.zzqF, this.zzsR.zzvV.zzaR, this.zzb(this.zzsR.zzwa.zzMc));
        }
        if (this.zzsR.zzwd != null) {
            try {
                this.zzsR.zzwd.onAdClicked();
                return;
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not notify onAdClicked event.", (Throwable)remoteException);
            }
        }
    }

    @Override
    public final void zzan() {
        this.zzaq();
    }

    @Override
    public final void onAppEvent(String string, @Nullable String string2) {
        if (this.zzsR.zzwf != null) {
            try {
                this.zzsR.zzwf.onAppEvent(string, string2);
                return;
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call the AppEventListener.", (Throwable)remoteException);
            }
        }
    }

    public final void zzao() {
        zzbo.zzcz((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzsR.zzwa == null) {
            zzafq.zzaT((String)"Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzafq.zzaC((String)"Pinging manual tracking URLs.");
        if (this.zzsR.zzwa.zzTq != null && !this.zzsR.zzwa.zzXV) {
            zzbs.zzbz();
            zzagy.zza(this.zzsR.zzqF, this.zzsR.zzvV.zzaR, this.zzsR.zzwa.zzTq);
            this.zzsR.zzwa.zzXV = true;
        }
    }

    public void pause() {
        zzbo.zzcz((String)"pause must be called on the main UI thread.");
    }

    public void resume() {
        zzbo.zzcz((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzb(zzir zzir2) {
        if (this.zzsR.zzvW == null) {
            return false;
        }
        ViewParent viewParent = this.zzsR.zzvW.getParent();
        if (!(viewParent instanceof View)) {
            return false;
        }
        View view = (View)viewParent;
        return zzbs.zzbz().zza(view, view.getContext());
    }

    public final void zza(zzjo zzjo2) {
        zzbo.zzcz((String)"setAdListener must be called on the main UI thread.");
        this.zzsR.zzwe = zzjo2;
    }

    public final void zza(zzadc zzadc2) {
        zzbo.zzcz((String)"setRewardedVideoAdListener can only be called from the UI thread.");
        this.zzsR.zzwr = zzadc2;
    }

    public final void setUserId(String string) {
        zzafq.zzaT((String)"RewardedVideoAd.setUserId() is deprecated. Please do not call this method.");
    }

    public final void zza(zzjl zzjl2) {
        zzbo.zzcz((String)"setAdListener must be called on the main UI thread.");
        this.zzsR.zzwd = zzjl2;
    }

    public final void zza(zziv zziv2) {
        zzbo.zzcz((String)"setAdSize must be called on the main UI thread.");
        this.zzsR.zzvZ = zziv2;
        if (this.zzsR.zzwa != null && this.zzsR.zzwa.zzPg != null && this.zzsR.zzwv == 0) {
            this.zzsR.zzwa.zzPg.zza(zziv2);
        }
        if (this.zzsR.zzvW == null) {
            return;
        }
        if (this.zzsR.zzvW.getChildCount() > 1) {
            this.zzsR.zzvW.removeView(this.zzsR.zzvW.getNextView());
        }
        this.zzsR.zzvW.setMinimumWidth(zziv2.widthPixels);
        this.zzsR.zzvW.setMinimumHeight(zziv2.heightPixels);
        this.zzsR.zzvW.requestLayout();
    }

    public final void zza(zzke zzke2) {
        zzbo.zzcz((String)"setAppEventListener must be called on the main UI thread.");
        this.zzsR.zzwf = zzke2;
    }

    public void zza(zzxf zzxf2) {
        zzafq.zzaT((String)"setInAppPurchaseListener is deprecated and should not be called.");
    }

    public void zza(zznh zznh2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    public final void zza(zzxn zzxn2, String string) {
        zzafq.zzaT((String)"setPlayStorePurchaseParams is deprecated and should not be called.");
    }

    public final void zza(zzkk zzkk2) {
        zzbo.zzcz((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzsR.zzwg = zzkk2;
    }

    public final void stopLoading() {
        zzbo.zzcz((String)"stopLoading must be called on the main UI thread.");
        this.zzsP = false;
        this.zzsR.zze(true);
    }

    public final boolean isLoading() {
        return this.zzsP;
    }

    public zzks getVideoController() {
        return null;
    }

    public final void zza(@Nullable zzlx zzlx2) {
        zzbo.zzcz((String)"setVideoOptions must be called on the main UI thread.");
        this.zzsR.zzwm = zzlx2;
    }

    public final void zza(@Nullable zzky zzky2) {
        zzbo.zzcz((String)"setIconAdOptions must be called on the main UI thread.");
        this.zzsR.zzwn = zzky2;
    }

    public void setImmersiveMode(boolean bl) {
        throw new IllegalStateException("onImmersiveModeUpdated is not supported for current ad type");
    }

    private static long zzr(String string) {
        int n = string.indexOf("ufe");
        int n2 = string.indexOf(44, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        try {
            return Long.parseLong(string.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzafq.zzaT((String)"Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzafq.zzaT((String)"Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected final void zzb(View view) {
        zzbu zzbu2 = this.zzsR.zzvW;
        if (zzbu2 != null) {
            zzbu2.addView(view, zzbs.zzbB().zzhW());
        }
    }

    protected void zzap() {
        zzafq.zzaS((String)"Ad closing.");
        if (this.zzsR.zzwe != null) {
            try {
                this.zzsR.zzwe.onAdClosed();
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call AdListener.onAdClosed().", (Throwable)remoteException);
            }
        }
        if (this.zzsR.zzwr != null) {
            try {
                this.zzsR.zzwr.onRewardedVideoAdClosed();
                return;
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdClosed().", (Throwable)remoteException);
            }
        }
    }

    protected final void zzaq() {
        zzafq.zzaS((String)"Ad leaving application.");
        if (this.zzsR.zzwe != null) {
            try {
                this.zzsR.zzwe.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
            }
        }
        if (this.zzsR.zzwr != null) {
            try {
                this.zzsR.zzwr.onRewardedVideoAdLeftApplication();
                return;
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call  RewardedVideoAdListener.onRewardedVideoAdLeftApplication().", (Throwable)remoteException);
            }
        }
    }

    protected final void zzar() {
        zzafq.zzaS((String)"Ad opening.");
        if (this.zzsR.zzwe != null) {
            try {
                this.zzsR.zzwe.onAdOpened();
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call AdListener.onAdOpened().", (Throwable)remoteException);
            }
        }
        if (this.zzsR.zzwr != null) {
            try {
                this.zzsR.zzwr.onRewardedVideoAdOpened();
                return;
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdOpened().", (Throwable)remoteException);
            }
        }
    }

    protected void zzas() {
        zzafq.zzaS((String)"Ad finished loading.");
        this.zzsP = false;
        if (this.zzsR.zzwe != null) {
            try {
                this.zzsR.zzwe.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
            }
        }
        if (this.zzsR.zzwr != null) {
            try {
                this.zzsR.zzwr.onRewardedVideoAdLoaded();
                return;
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdLoaded().", (Throwable)remoteException);
            }
        }
    }

    protected void zze(int n) {
        zzafq.zzaT((String)new StringBuilder(30).append("Failed to load ad: ").append(n).toString());
        this.zzsP = false;
        if (this.zzsR.zzwe != null) {
            try {
                this.zzsR.zzwe.onAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
            }
        }
        if (this.zzsR.zzwr != null) {
            try {
                this.zzsR.zzwr.onRewardedVideoAdFailedToLoad(n);
                return;
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdFailedToLoad().", (Throwable)remoteException);
            }
        }
    }

    public final void zzat() {
        zzafq.zzaS((String)"Ad impression.");
        if (this.zzsR.zzwe != null) {
            try {
                this.zzsR.zzwe.onAdImpression();
                return;
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call AdListener.onAdImpression().", (Throwable)remoteException);
            }
        }
    }

    public final void zzau() {
        zzafq.zzaS((String)"Ad clicked.");
        if (this.zzsR.zzwe != null) {
            try {
                this.zzsR.zzwe.onAdClicked();
                return;
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not call AdListener.onAdClicked().", (Throwable)remoteException);
            }
        }
    }

    protected final void zzav() {
        if (this.zzsR.zzwr == null) {
            return;
        }
        try {
            this.zzsR.zzwr.onRewardedVideoStarted();
            return;
        }
        catch (RemoteException remoteException) {
            zzafq.zzc((String)"Could not call RewardedVideoAdListener.onVideoStarted().", (Throwable)remoteException);
            return;
        }
    }

    protected final void zza(@Nullable zzaed zzaed2) {
        if (this.zzsR.zzwr == null) {
            return;
        }
        try {
            String string = "";
            int n = 1;
            if (zzaed2 != null) {
                string = zzaed2.type;
                n = zzaed2.zzWW;
            }
            this.zzsR.zzwr.zza((zzacu)new zzacp(string, n));
            return;
        }
        catch (RemoteException remoteException) {
            zzafq.zzc((String)"Could not call RewardedVideoAdListener.onRewarded().", (Throwable)remoteException);
            return;
        }
    }

    public final void zzaw() {
        zzafe zzafe2 = this.zzsR.zzwa;
        zza zza2 = this;
        if (zzafe2 == null || TextUtils.isEmpty((CharSequence)zzafe2.zzTK) || zzafe2.zzXW || !zzbs.zzbH().zzic()) {
            return;
        }
        zzafq.zzaC((String)"Sending troubleshooting signals to the server.");
        zzbs.zzbH().zza(zza2.zzsR.zzqF, zza2.zzsR.zzvV.zzaR, zzafe2.zzTK, zza2.zzsR.zzvT);
        zzafe2.zzXW = true;
    }

    @Override
    public final void zza(HashSet<zzafg> hashSet) {
        this.zzsR.zza(hashSet);
    }

    protected final List<String> zzb(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            arrayList.add(zzaey.zzb(string, this.zzsR.zzqF));
        }
        return arrayList;
    }

    public String getAdUnitId() {
        return this.zzsR.zzvT;
    }

    public final zzke zzax() {
        return this.zzsR.zzwf;
    }

    public final zzjo zzay() {
        return this.zzsR.zzwe;
    }
}

