/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzj;
import com.google.android.gms.internal.zzaca;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zzbgz;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zznl;
import java.util.Locale;

public final class zzacb {
    private int zzVF;
    private boolean zzVM;
    private boolean zzVN;
    private int zzVR;
    private int zzVV;
    private int zzVW;
    private String zzVI;
    private int zzVS;
    private int zzVT;
    private int zzVU;
    private boolean zzVZ;
    private int zzWa;
    private double zzVX;
    private boolean zzVY;
    private String zzWb;
    private String zzWc;
    private boolean zzVG;
    private boolean zzVH;
    private String zzVJ;
    private boolean zzVK;
    private boolean zzVL;
    private String zzVO;
    private String zzVP;
    private float zzxT;
    private int zzSI;
    private int zzSJ;
    private String zzVQ;
    private boolean zzWd;

    public zzacb(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzk(context);
        this.zzl(context);
        this.zzm(context);
        Locale locale = Locale.getDefault();
        this.zzVG = zzacb.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzVH = zzacb.zza(packageManager, "http://www.google.com") != null;
        this.zzVJ = locale.getCountry();
        zzji.zzds();
        this.zzVK = zzaix.zzik();
        this.zzVL = zzj.zzaI((Context)context);
        this.zzVO = locale.getLanguage();
        this.zzVP = zzacb.zzb(context, packageManager);
        this.zzVQ = zzacb.zza(context, packageManager);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzxT = displayMetrics.density;
        this.zzSI = displayMetrics.widthPixels;
        this.zzSJ = displayMetrics.heightPixels;
    }

    public zzacb(Context context, zzaca zzaca2) {
        context.getPackageManager();
        this.zzk(context);
        this.zzl(context);
        this.zzm(context);
        Context context2 = context;
        zzacb zzacb2 = this;
        this.zzWb = Build.FINGERPRINT;
        zzacb2.zzWc = Build.DEVICE;
        zzacb2.zzWd = zznl.zzi(context2);
        this.zzVG = zzaca2.zzVG;
        this.zzVH = zzaca2.zzVH;
        this.zzVJ = zzaca2.zzVJ;
        this.zzVK = zzaca2.zzVK;
        this.zzVL = zzaca2.zzVL;
        this.zzVO = zzaca2.zzVO;
        this.zzVP = zzaca2.zzVP;
        this.zzVQ = zzaca2.zzVQ;
        this.zzxT = zzaca2.zzxT;
        this.zzSI = zzaca2.zzSI;
        this.zzSJ = zzaca2.zzSJ;
    }

    private final void zzk(Context context) {
        zzbs.zzbz();
        AudioManager audioManager = zzagy.zzL(context);
        if (audioManager != null) {
            try {
                this.zzVF = audioManager.getMode();
                this.zzVM = audioManager.isMusicActive();
                this.zzVN = audioManager.isSpeakerphoneOn();
                this.zzVR = audioManager.getStreamVolume(3);
                this.zzVV = audioManager.getRingerMode();
                this.zzVW = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzbs.zzbD().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzVF = -2;
        this.zzVM = false;
        this.zzVN = false;
        this.zzVR = 0;
        this.zzVV = 0;
        this.zzVW = 0;
    }

    @TargetApi(value=16)
    private final void zzl(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzVI = telephonyManager.getNetworkOperator();
        this.zzVT = telephonyManager.getNetworkType();
        this.zzVU = telephonyManager.getPhoneType();
        this.zzVS = -2;
        this.zzVZ = false;
        this.zzWa = -1;
        zzbs.zzbz();
        if (zzagy.zzc(context, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzVS = networkInfo.getType();
                this.zzWa = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzVS = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzVZ = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzm(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzVX = (float)n2 / (float)n3;
            this.zzVY = n == 2 || n == 5;
            return;
        }
        this.zzVX = -1.0;
        this.zzVY = false;
    }

    private static String zza(Context context, PackageManager packageManager) {
        try {
            PackageInfo packageInfo = zzbgz.zzaP((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = String.valueOf(packageInfo.packageName);
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zzb(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzacb.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = zzbgz.zzaP((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = String.valueOf(activityInfo.packageName);
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        return packageManager.resolveActivity(intent, 65536);
    }

    public final zzaca zzgM() {
        return new zzaca(this.zzVF, this.zzVG, this.zzVH, this.zzVI, this.zzVJ, this.zzVK, this.zzVL, this.zzVM, this.zzVN, this.zzVO, this.zzVP, this.zzVQ, this.zzVR, this.zzVS, this.zzVT, this.zzVU, this.zzVV, this.zzVW, this.zzxT, this.zzSI, this.zzSJ, this.zzVX, this.zzVY, this.zzVZ, this.zzWa, this.zzWb, this.zzWd, this.zzWc);
    }
}

