/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzaiq;
import com.google.android.gms.internal.zzgf;
import com.google.android.gms.internal.zzgg;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzgi;
import com.google.android.gms.internal.zzgj;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzzm;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;

@zzzm
@TargetApi(value=14)
public final class zzge
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzxA;
    private final Context mApplicationContext;
    private Application zzxB;
    private final WindowManager zzwT;
    private final PowerManager zzwU;
    private final KeyguardManager zzwV;
    @Nullable
    private BroadcastReceiver zzxd;
    private WeakReference<ViewTreeObserver> zzxC;
    private WeakReference<View> zzxD;
    private zzgj zzxE;
    private zzaiq zzwz = new zzaiq(zzxA);
    private boolean zzxc = false;
    private int zzxF = -1;
    private HashSet<zzgi> zzxG = new HashSet();
    private DisplayMetrics zzxH;

    public zzge(Context context, View view) {
        this.mApplicationContext = context.getApplicationContext();
        this.zzwT = (WindowManager)context.getSystemService("window");
        this.zzwU = (PowerManager)this.mApplicationContext.getSystemService("power");
        this.zzwV = (KeyguardManager)context.getSystemService("keyguard");
        if (this.mApplicationContext instanceof Application) {
            this.zzxB = (Application)this.mApplicationContext;
            this.zzxE = new zzgj((Application)this.mApplicationContext, this);
        }
        this.zzxH = context.getResources().getDisplayMetrics();
        View view2 = view;
        zzge zzge2 = this;
        View view3 = zzge2.zzxD != null ? (View)zzge2.zzxD.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzge2);
            zzge2.zze(view3);
        }
        zzge2.zzxD = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzbs.zzbB().isAttachedToWindow(view2)) {
                zzge2.zzd(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzge2);
        }
    }

    public final void zza(zzgi zzgi2) {
        this.zzxG.add(zzgi2);
        this.zzh(3);
    }

    public final void zzb(zzgi zzgi2) {
        this.zzxG.remove(zzgi2);
    }

    private final void zzcA() {
        zzbs.zzbz();
        zzagy.zzZr.post((Runnable)new zzgf(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzxF = -1;
        this.zzd(view);
        this.zzh(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzxF = -1;
        this.zzh(3);
        this.zzcA();
        this.zze(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzxD == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzxD.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzxF = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzh(3);
        this.zzcA();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzh(3);
        this.zzcA();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzh(3);
        this.zzcA();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzh(3);
        this.zzcA();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzh(3);
        this.zzcA();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzh(3);
        this.zzcA();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzh(3);
        this.zzcA();
    }

    public final void onGlobalLayout() {
        this.zzh(2);
        this.zzcA();
    }

    public final void onScrollChanged() {
        this.zzh(1);
    }

    public final void zzcB() {
        this.zzh(4);
    }

    private final void zzh(int n) {
        boolean bl;
        if (this.zzxG.size() == 0) {
            return;
        }
        if (this.zzxD == null) {
            return;
        }
        View view = (View)this.zzxD.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        Rect rect5 = new Rect();
        new Rect().right = this.zzwT.getDefaultDisplay().getWidth();
        rect5.bottom = this.zzwT.getDefaultDisplay().getHeight();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzafq.zzb((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzxF != -1 ? this.zzxF : n2;
        boolean bl6 = bl = !bl3 && zzbs.zzbz().zza(view, this.zzwU, this.zzwV) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzwz.tryAcquire() && bl == this.zzxc) {
            return;
        }
        if (!bl && !this.zzxc && n == 1) {
            return;
        }
        zzgh zzgh2 = new zzgh(zzbs.zzbF().elapsedRealtime(), this.zzwU.isScreenOn(), view != null ? zzbs.zzbB().isAttachedToWindow(view) : false, view != null ? view.getWindowVisibility() : 8, this.zza(rect5), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzxH.density, bl);
        Iterator<zzgi> iterator = this.zzxG.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzgh2);
        }
        this.zzxc = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzi(rect.left), this.zzi(rect.top), this.zzi(rect.right), this.zzi(rect.bottom));
    }

    private final int zzi(int n) {
        float f = this.zzxH.density;
        return (int)((float)n / f);
    }

    private final void zzd(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzxC = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzge zzge2 = this;
        if (zzge2.zzxd == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzge2.zzxd = new zzgg(zzge2);
            zzge2.mApplicationContext.registerReceiver(zzge2.zzxd, intentFilter);
        }
        if (this.zzxB != null) {
            try {
                this.zzxB.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzxE);
                return;
            }
            catch (Exception exception) {
                zzafq.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzxC != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzxC.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzxC = null;
            }
        }
        catch (Exception exception) {
            zzafq.zzb((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzafq.zzb((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzge zzge2 = this;
        if (zzge2.zzxd != null) {
            try {
                zzge2.mApplicationContext.unregisterReceiver(zzge2.zzxd);
            }
            catch (IllegalStateException illegalStateException) {
                zzafq.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzbs.zzbD().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzge2.zzxd = null;
        }
        if (this.zzxB != null) {
            try {
                this.zzxB.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzxE);
                return;
            }
            catch (Exception exception) {
                zzafq.zzb((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    static /* synthetic */ void zza(zzge zzge2, int n) {
        zzge2.zzh(3);
    }

    static {
        zzme<Long> zzme2 = zzmo.zzEt;
        zzxA = zzbs.zzbL().zzd(zzme2);
    }
}

