/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.internal.zzgt;
import com.google.android.gms.internal.zzgu;
import com.google.android.gms.internal.zzha;
import com.google.android.gms.internal.zzhb;
import com.google.android.gms.internal.zzhd;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzzk;
import com.google.android.gms.internal.zzzm;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzzm
@TargetApi(value=14)
public final class zzgz
extends Thread {
    private boolean mStarted = false;
    private boolean zzyz = false;
    private boolean zzak = false;
    private final Object mLock;
    private final zzgu zzyA;
    private final zzzk zzyB;
    private final int zzyC;
    private final int zzxY;
    private final int zzyD;
    private final int zzya;
    private final int zzyE;
    private final int zzyF;
    private final int zzyG;
    private final int zzyH;
    private final String zzyI;
    private final boolean zzyJ;

    public zzgz(zzgu zzgu2, zzzk zzzk2) {
        this.zzyA = zzgu2;
        this.zzyB = zzzk2;
        this.mLock = new Object();
        zzme<Object> zzme2 = zzmo.zzCW;
        this.zzxY = zzbs.zzbL().zzd(zzme2);
        zzme2 = zzmo.zzCX;
        this.zzyD = zzbs.zzbL().zzd(zzme2);
        zzme2 = zzmo.zzCY;
        this.zzya = zzbs.zzbL().zzd(zzme2);
        zzme2 = zzmo.zzCZ;
        this.zzyE = zzbs.zzbL().zzd(zzme2);
        zzme2 = zzmo.zzDc;
        this.zzyF = zzbs.zzbL().zzd(zzme2);
        zzme2 = zzmo.zzDe;
        this.zzyG = zzbs.zzbL().zzd(zzme2);
        zzme2 = zzmo.zzDf;
        this.zzyH = zzbs.zzbL().zzd(zzme2);
        zzme2 = zzmo.zzDa;
        this.zzyC = zzbs.zzbL().zzd(zzme2);
        zzme2 = zzmo.zzDh;
        this.zzyI = (String)((Object)zzbs.zzbL().zzd(zzme2));
        zzme2 = zzmo.zzDj;
        this.zzyJ = (Boolean)((Object)zzbs.zzbL().zzd(zzme2));
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcM() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStarted) {
                zzafq.zzaC((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzgz.zzcN()) {
                    object = zzbs.zzbC().getActivity();
                    if (object == null) {
                        zzafq.zzaC((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzcP();
                    } else {
                        Activity activity = object;
                        zzgz zzgz2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Throwable throwable) {
                                zzbs.zzbD().zza(throwable, "ContentFetchTask.extractContent");
                                zzafq.zzaC((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                View view2 = view;
                                zzgz zzgz3 = zzgz2;
                                if (view2 != null) {
                                    view2.post((Runnable)new zzha(zzgz3, view2));
                                }
                            }
                        }
                    }
                } else {
                    zzafq.zzaC((String)"ContentFetchTask: sleeping");
                    this.zzcP();
                }
                Thread.sleep(this.zzyC * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzafq.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Throwable throwable) {
                zzafq.zzb((String)"Error in ContentFetchTask", (Throwable)throwable);
                this.zzyB.zza(throwable, "ContentFetchTask.run");
            }
            object = this.mLock;
            synchronized (object) {
                while (this.zzyz) {
                    try {
                        zzafq.zzaC((String)"ContentFetchTask: waiting");
                        this.mLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    final void zzf(View view) {
        try {
            zzgt zzgt2 = new zzgt(this.zzxY, this.zzyD, this.zzya, this.zzyE, this.zzyF, this.zzyG, this.zzyH);
            zzhd zzhd2 = this.zza(view, zzgt2);
            zzgt2.zzcJ();
            if (zzhd2.zzyR == 0 && zzhd2.zzyS == 0) {
                return;
            }
            if (zzhd2.zzyS == 0 && zzgt2.zzcK() == 0) {
                return;
            }
            if (zzhd2.zzyS == 0 && this.zzyA.zza(zzgt2)) {
                return;
            }
            this.zzyA.zzc(zzgt2);
            return;
        }
        catch (Exception exception) {
            zzafq.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            this.zzyB.zza(exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    private static boolean zzcN() {
        try {
            Context context = zzbs.zzbC().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzbs.zzbD().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    private final zzhd zza(@Nullable View view, zzgt zzgt2) {
        Object object;
        if (view == null) {
            return new zzhd(this, 0, 0);
        }
        Context context = zzbs.zzbC().getContext();
        if (context != null) {
            object = zzmo.zzDg;
            int n = context.getResources().getIdentifier(zzbs.zzbL().zzd(object), "id", context.getPackageName());
            String string2 = (String)view.getTag(n);
            if (!TextUtils.isEmpty((CharSequence)this.zzyI) && string2 != null && string2.equals(this.zzyI)) {
                return new zzhd(this, 0, 0);
            }
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string3 = charSequence.toString();
                zzgt2.zzb(string3, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzhd(this, 1, 0);
            }
            return new zzhd(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzajz)) {
            boolean bl2;
            zzgt2.zzcI();
            zzgt zzgt3 = zzgt2;
            WebView webView = (WebView)view;
            object = this;
            if (!zzq.zzsc()) {
                bl2 = false;
            } else {
                zzgt3.zzcI();
                webView.post((Runnable)new zzhb((zzgz)object, zzgt3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzhd(this, 0, 1);
            }
            return new zzhd(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzhd zzhd2 = this.zza(viewGroup.getChildAt(i), zzgt2);
                n += zzhd2.zzyR;
                n2 += zzhd2.zzyS;
            }
            return new zzhd(this, n, n2);
        }
        return new zzhd(this, 0, 0);
    }

    final void zza(zzgt zzgt2, WebView webView, String string2, boolean bl) {
        zzgt2.zzcH();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzyJ && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = String.valueOf(webView.getTitle());
                    zzgt2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzgt2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzgt2.zzcC()) {
                this.zzyA.zzb(zzgt2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzafq.zzaC((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzafq.zza((String)"Failed to get webview content.", (Throwable)throwable);
            this.zzyB.zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzgt zzcO() {
        return this.zzyA.zzcL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzyz = false;
            this.mLock.notifyAll();
            zzafq.zzaC((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzcP() {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.zzyz = true;
            zzafq.zzaC((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzcQ() {
        return this.zzyz;
    }
}

