/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzafq;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzajd;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzon;
import com.google.android.gms.internal.zzua;
import com.google.android.gms.internal.zzub;
import com.google.android.gms.internal.zzud;
import com.google.android.gms.internal.zzuf;
import com.google.android.gms.internal.zzug;
import com.google.android.gms.internal.zzuh;
import com.google.android.gms.internal.zzui;
import com.google.android.gms.internal.zzuq;
import com.google.android.gms.internal.zzut;
import com.google.android.gms.internal.zzuw;
import com.google.android.gms.internal.zzuz;
import com.google.android.gms.internal.zzvj;
import com.google.android.gms.internal.zzwc;
import com.google.android.gms.internal.zzzm;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzzm
public final class zzue
implements zzui {
    private final String zzMu;
    private final zzuq zzsZ;
    private final long zzMv;
    private final zzub zzMw;
    private final zzua zzMx;
    private zzir zzuV;
    private final zziv zzvb;
    private final Context mContext;
    private final Object mLock = new Object();
    private final zzajd zztY;
    private final boolean zzwL;
    private final zzon zztU;
    private final List<String> zztV;
    private final List<String> zzMy;
    private final List<String> zzMz;
    private final boolean zzMA;
    private zzut zzMB;
    private int zzMC = -2;
    private zzuz zzMD;

    public zzue(Context context, String string, zzuq zzuq2, zzub zzub2, zzua zzua2, zzir zzir2, zziv zziv2, zzajd zzajd2, boolean bl, boolean bl2, zzon zzon2, List<String> list, List<String> list2, List<String> list3) {
        this.mContext = context;
        this.zzsZ = zzuq2;
        this.zzMx = zzua2;
        this.zzMu = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string) ? this.zzfj() : string;
        this.zzMw = zzub2;
        this.zzMv = zzub2.zzMb != -1L ? zzub2.zzMb : 10000L;
        this.zzuV = zzir2;
        this.zzvb = zziv2;
        this.zztY = zzajd2;
        this.zzwL = bl;
        this.zzMA = bl2;
        this.zztU = zzon2;
        this.zztV = list;
        this.zzMy = list2;
        this.zzMz = list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.zzMB != null) {
                    this.zzMB.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzafq.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzMC = -1;
            this.mLock.notify();
            return;
        }
    }

    private final String zzfj() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzMx.zzLN)) {
                if (this.zzsZ.zzai(this.zzMx.zzLN)) {
                    return "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter";
                }
                return "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzafq.zzaT((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzo(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzMC = n;
            this.mLock.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(int n, zzuz zzuz2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzMC = 0;
            this.zzMD = zzuz2;
            this.mLock.notify();
            return;
        }
    }

    private static zzut zza(MediationAdapter mediationAdapter) {
        return new zzvj(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzuh zza(long l, long l2) {
        Object object = this.mLock;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            zzud zzud2 = new zzud();
            zzagy.zzZr.post((Runnable)new zzuf(this, zzud2));
            long l4 = l2;
            long l5 = l;
            long l6 = this.zzMv;
            zzue zzue2 = this;
            while (zzue2.zzMC == -2) {
                long l7 = l4;
                long l8 = l5;
                long l9 = l6;
                long l10 = l3;
                zzue zzue3 = zzue2;
                long l11 = SystemClock.elapsedRealtime();
                long l12 = l9 - (l11 - l10);
                long l13 = l7 - (l11 - l8);
                if (l12 <= 0L || l13 <= 0L) {
                    zzafq.zzaS((String)"Timed out waiting for adapter.");
                    zzue3.zzMC = 3;
                    continue;
                }
                try {
                    zzue3.mLock.wait(Math.min(l12, l13));
                }
                catch (InterruptedException interruptedException) {
                    zzue3.zzMC = -1;
                }
            }
            long l14 = zzbs.zzbF().elapsedRealtime() - l3;
            return new zzuh(this.zzMx, this.zzMB, this.zzMu, zzud2, this.zzMC, this.zzfk(), l14);
        }
    }

    private final zzuz zzfk() {
        if (this.zzMC != 0 || !this.zzfm()) {
            return null;
        }
        try {
            if (this.zzp(4) && this.zzMD != null && this.zzMD.zzfo() != 0) {
                return this.zzMD;
            }
        }
        catch (RemoteException remoteException) {
            zzafq.zzaT((String)"Could not get cpm value from MediationResponseMetadata");
        }
        int n = this.zzfn();
        return new zzug(n);
    }

    private final zzut zzfl() {
        String string = String.valueOf(this.zzMu);
        zzafq.zzaS((String)(string.length() != 0 ? "Instantiating mediation adapter: ".concat(string) : new String("Instantiating mediation adapter: ")));
        if (!this.zzwL && !this.zzMx.zzfi()) {
            zzme<Boolean> zzme2 = zzmo.zzEI;
            if (zzbs.zzbL().zzd(zzme2).booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzMu)) {
                return zzue.zza((MediationAdapter)new AdMobAdapter());
            }
            zzme2 = zzmo.zzEJ;
            if (zzbs.zzbL().zzd(zzme2).booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzMu)) {
                return zzue.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzMu)) {
                return new zzvj((MediationAdapter)new zzwc());
            }
        }
        try {
            return this.zzsZ.zzah(this.zzMu);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(this.zzMu);
            zzafq.zza((String)(string2.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string2) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private final void zza(zzud zzud2) {
        String string = this.zzaf(this.zzMx.zzLR);
        try {
            if (this.zztY.zzaaP < 4100000) {
                if (this.zzvb.zzAv) {
                    this.zzMB.zza(zzn.zzw((Object)this.mContext), this.zzuV, string, (zzuw)zzud2);
                    return;
                }
                this.zzMB.zza(zzn.zzw((Object)this.mContext), this.zzvb, this.zzuV, string, (zzuw)zzud2);
                return;
            }
            if (this.zzwL || this.zzMx.zzfi()) {
                ArrayList<String> arrayList = new ArrayList<String>(this.zztV);
                if (this.zzMy != null) {
                    for (String string2 : this.zzMy) {
                        String string3 = ":false";
                        if (this.zzMz != null && this.zzMz.contains(string2)) {
                            string3 = ":true";
                        }
                        String string4 = string3;
                        arrayList.add(new StringBuilder(7 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("custom:").append(string2).append(string4).toString());
                    }
                }
                this.zzMB.zza(zzn.zzw((Object)this.mContext), this.zzuV, string, this.zzMx.zzLJ, (zzuw)zzud2, this.zztU, arrayList);
                return;
            }
            if (this.zzvb.zzAv) {
                this.zzMB.zza(zzn.zzw((Object)this.mContext), this.zzuV, string, this.zzMx.zzLJ, (zzuw)zzud2);
                return;
            }
            if (this.zzMA) {
                if (this.zzMx.zzLU != null) {
                    this.zzMB.zza(zzn.zzw((Object)this.mContext), this.zzuV, string, this.zzMx.zzLJ, (zzuw)zzud2, new zzon(zzue.zzag(this.zzMx.zzLY)), this.zzMx.zzLX);
                    return;
                }
                this.zzMB.zza(zzn.zzw((Object)this.mContext), this.zzvb, this.zzuV, string, this.zzMx.zzLJ, (zzuw)zzud2);
                return;
            }
            this.zzMB.zza(zzn.zzw((Object)this.mContext), this.zzvb, this.zzuV, string, this.zzMx.zzLJ, (zzuw)zzud2);
            return;
        }
        catch (RemoteException remoteException) {
            zzafq.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzo(5);
            return;
        }
    }

    private final boolean zzp(int n) {
        Bundle bundle;
        try {
            bundle = this.zzwL ? this.zzMB.zzft() : (this.zzvb.zzAv ? this.zzMB.getInterstitialAdapterInfo() : this.zzMB.zzfs());
        }
        catch (RemoteException remoteException) {
            zzafq.zzaT((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private final boolean zzfm() {
        return this.zzMw.zzMl != -1;
    }

    private final String zzaf(String string) {
        if (string == null || !this.zzfm() || this.zzp(2)) {
            return string;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzafq.zzaT((String)"Could not remove field. Returning the original value");
            return string;
        }
    }

    private final int zzfn() {
        JSONObject jSONObject;
        if (this.zzMx.zzLR == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzMx.zzLR);
        }
        catch (JSONException jSONException) {
            zzafq.zzaT((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzMu)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzp(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static NativeAdOptions zzag(String string) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string == null) {
            return builder.build();
        }
        try {
            String string2;
            JSONObject jSONObject = new JSONObject(string);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string3 = string2 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation("landscape".equals(string3) ? 2 : ("portrait".equals(string3) ? 1 : ("any".equals(string3) ? 0 : -1)));
        }
        catch (JSONException jSONException) {
            zzafq.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    static /* synthetic */ Object zza(zzue zzue2) {
        return zzue2.mLock;
    }

    static /* synthetic */ int zzb(zzue zzue2) {
        return zzue2.zzMC;
    }

    static /* synthetic */ zzut zza(zzue zzue2, zzut zzut2) {
        zzue2.zzMB = zzut2;
        return zzue2.zzMB;
    }

    static /* synthetic */ zzut zzc(zzue zzue2) {
        return zzue2.zzfl();
    }

    static /* synthetic */ zzut zzd(zzue zzue2) {
        return zzue2.zzMB;
    }

    static /* synthetic */ boolean zze(zzue zzue2) {
        return zzue2.zzfm();
    }

    static /* synthetic */ boolean zza(zzue zzue2, int n) {
        return zzue2.zzp(1);
    }

    static /* synthetic */ String zzf(zzue zzue2) {
        return zzue2.zzMu;
    }

    static /* synthetic */ void zza(zzue zzue2, zzud zzud2) {
        zzue2.zza(zzud2);
    }
}

