/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzagy;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.internal.zzwn;
import com.google.android.gms.internal.zzwo;
import com.google.android.gms.internal.zzwt;
import com.google.android.gms.internal.zzzm;
import java.util.Map;

@zzzm
public final class zzwm
extends zzwt {
    private final Map<String, String> zzHc;
    private final Context mContext;

    public zzwm(zzajz zzajz2, Map<String, String> map) {
        super(zzajz2, "storePicture");
        this.zzHc = map;
        this.mContext = zzajz2.zzis();
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzan("Activity context is not available");
            return;
        }
        zzbs.zzbz();
        if (!zzagy.zzH(this.mContext).zzdG()) {
            this.zzan("Feature is not supported by the device.");
            return;
        }
        String string2 = this.zzHc.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzan("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzan(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        String string4 = Uri.parse((String)string2).getLastPathSegment();
        zzbs.zzbz();
        if (!zzagy.zzaK(string4)) {
            String string5 = String.valueOf(string4);
            this.zzan(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzbs.zzbD().getResources();
        zzbs.zzbz();
        AlertDialog.Builder builder = zzagy.zzG(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s1) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s2) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzwn(this, string2, string4));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzwo(this));
        builder.create().show();
    }

    static /* synthetic */ Context zza(zzwm zzwm2) {
        return zzwm2.mContext;
    }
}

