/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zza;
import com.google.android.gms.ads.internal.overlay.zzae;
import com.google.android.gms.ads.internal.overlay.zzaf;
import com.google.android.gms.ads.internal.overlay.zzaj;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.ads.internal.overlay.zzr;
import com.google.android.gms.ads.internal.overlay.zzs;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzahe;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zzakb;
import com.google.android.gms.internal.zzig;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzwy;
import com.google.android.gms.internal.zzzn;
import java.util.Collections;

@zzzn
public final class zzm
extends zzwy
implements zzaj {
    private static int zzOF = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzOG;
    private zzaka zzJH;
    private zzr zzOH;
    private zzae zzOI;
    private boolean zzOJ = false;
    private FrameLayout zzOK;
    private WebChromeClient.CustomViewCallback zzOL;
    private boolean zzOM = false;
    private boolean zzON = false;
    private zzq zzOO;
    private boolean zzOP = false;
    private int zzOQ = 0;
    private final Object zzOR = new Object();
    private Runnable zzOS;
    private boolean zzOT;
    private boolean zzOU;
    private boolean zzOV = false;
    private boolean zzOW = false;
    private boolean zzOX = true;

    public zzm(Activity activity) {
        this.mActivity = activity;
    }

    public final void close() {
        this.zzOQ = 2;
        this.mActivity.finish();
    }

    public final void zzfI() {
        if (this.zzOG != null && this.zzOJ) {
            this.setRequestedOrientation(this.zzOG.orientation);
        }
        if (this.zzOK != null) {
            this.mActivity.setContentView((View)this.zzOO);
            this.zzOU = true;
            this.zzOK.removeAllViews();
            this.zzOK = null;
        }
        if (this.zzOL != null) {
            this.zzOL.onCustomViewHidden();
            this.zzOL = null;
        }
        this.zzOJ = false;
    }

    @Override
    public final void zzfJ() {
        this.zzOQ = 1;
        this.mActivity.finish();
    }

    public final void onBackPressed() {
        this.zzOQ = 0;
    }

    public final boolean zzfK() {
        this.zzOQ = 0;
        if (this.zzJH == null) {
            return true;
        }
        boolean bl = this.zzJH.zziC();
        if (!bl) {
            this.zzJH.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public final void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzOM = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzOG = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzOG == null) {
                throw new zzp("Could not get info for ad overlay.");
            }
            if (this.zzOG.zzvT.zzaaP > 7500000) {
                this.zzOQ = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzOX = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzON = this.zzOG.zzPo != null ? this.zzOG.zzPo.zzur : false;
            zzme<Boolean> zzme2 = zzmo.zzFh;
            if (zzbs.zzbL().zzd(zzme2).booleanValue() && this.zzON && this.zzOG.zzPo.zzuw != -1) {
                new zzs(this, null).zzhL();
            }
            if (bundle == null) {
                if (this.zzOG.zzPf != null && this.zzOX) {
                    this.zzOG.zzPf.zzaB();
                }
                if (this.zzOG.zzPm != 1 && this.zzOG.zzPe != null) {
                    this.zzOG.zzPe.onAdClicked();
                }
            }
            this.zzOO = new zzq((Context)this.mActivity, this.zzOG.zzPn, this.zzOG.zzvT.zzaP);
            this.zzOO.setId(1000);
            switch (this.zzOG.zzPm) {
                case 1: {
                    this.zzs(false);
                    return;
                }
                case 2: {
                    this.zzOH = new zzr(this.zzOG.zzPg);
                    this.zzs(false);
                    return;
                }
                case 3: {
                    this.zzs(true);
                    return;
                }
                case 4: {
                    if (this.zzOM) {
                        this.zzOQ = 3;
                        this.mActivity.finish();
                        return;
                    }
                    zzbs.zzbw();
                    if (zza.zza((Context)this.mActivity, this.zzOG.zzPd, this.zzOG.zzPl)) break;
                    this.zzOQ = 3;
                    this.mActivity.finish();
                    return;
                }
                default: {
                    throw new zzp("Could not determine ad overlay type.");
                }
            }
            return;
        }
        catch (zzp zzp2) {
            zzafr.zzaT((String)zzp2.getMessage());
            this.zzOQ = 3;
            this.mActivity.finish();
            return;
        }
    }

    public final void onRestart() {
    }

    public final void onStart() {
        zzme<Boolean> zzme2 = zzmo.zzGA;
        if (zzbs.zzbL().zzd(zzme2).booleanValue()) {
            if (this.zzJH != null && !this.zzJH.isDestroyed()) {
                zzbs.zzbB();
                zzahe.zzl(this.zzJH);
                return;
            }
            zzafr.zzaT((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onResume() {
        if (this.zzOG != null && this.zzOG.zzPm == 4) {
            if (this.zzOM) {
                this.zzOQ = 3;
                this.mActivity.finish();
            } else {
                this.zzOM = true;
            }
        }
        if (this.zzOG.zzPf != null) {
            this.zzOG.zzPf.onResume();
        }
        zzme<Boolean> zzme2 = zzmo.zzGA;
        if (!zzbs.zzbL().zzd(zzme2).booleanValue()) {
            if (this.zzJH != null && !this.zzJH.isDestroyed()) {
                zzbs.zzbB();
                zzahe.zzl(this.zzJH);
                return;
            }
            zzafr.zzaT((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onPause() {
        this.zzfI();
        if (this.zzOG.zzPf != null) {
            this.zzOG.zzPf.onPause();
        }
        zzme<Boolean> zzme2 = zzmo.zzGA;
        if (!(zzbs.zzbL().zzd(zzme2).booleanValue() || this.zzJH == null || this.mActivity.isFinishing() && this.zzOH != null)) {
            zzbs.zzbB();
            zzahe.zzk(this.zzJH);
        }
        this.zzfM();
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
    }

    public final void zzo(IObjectWrapper iObjectWrapper) {
        zzme<Boolean> zzme2 = zzmo.zzGz;
        if (zzbs.zzbL().zzd(zzme2).booleanValue() && com.google.android.gms.common.util.zzq.isAtLeastN()) {
            Configuration configuration = (Configuration)com.google.android.gms.dynamic.zzn.zzE((IObjectWrapper)iObjectWrapper);
            zzbs.zzbz();
            if (zzagz.zza(this.mActivity, configuration)) {
                this.mActivity.getWindow().addFlags(1024);
                this.mActivity.getWindow().clearFlags(2048);
                return;
            }
            this.mActivity.getWindow().addFlags(2048);
            this.mActivity.getWindow().clearFlags(1024);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzOM);
    }

    public final void onStop() {
        zzme<Boolean> zzme2 = zzmo.zzGA;
        if (zzbs.zzbL().zzd(zzme2).booleanValue() && this.zzJH != null && (!this.mActivity.isFinishing() || this.zzOH == null)) {
            zzbs.zzbB();
            zzahe.zzk(this.zzJH);
        }
        this.zzfM();
    }

    public final void onDestroy() {
        if (this.zzJH != null) {
            this.zzOO.removeView(this.zzJH.getView());
        }
        this.zzfM();
    }

    private final void zzr(boolean bl) {
        zzme<Integer> zzme2 = zzmo.zzGB;
        int n = zzbs.zzbL().zzd(zzme2);
        zzaf zzaf2 = new zzaf();
        new zzaf().size = 50;
        zzaf2.paddingLeft = bl ? n : 0;
        zzaf2.paddingRight = bl ? 0 : n;
        zzaf2.paddingTop = 0;
        zzaf2.paddingBottom = n;
        this.zzOI = new zzae((Context)this.mActivity, zzaf2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzOI.zza(bl, this.zzOG.zzPj);
        this.zzOO.addView((View)this.zzOI, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void zzaa() {
        this.zzOU = true;
    }

    public final void zza(boolean bl, boolean bl2) {
        if (this.zzOI != null) {
            this.zzOI.zza(bl, bl2);
        }
    }

    public final void zzfL() {
        this.zzOO.removeView((View)this.zzOI);
        this.zzr(true);
    }

    public final void setRequestedOrientation(int n) {
        this.mActivity.setRequestedOrientation(n);
    }

    public final void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzOK = new FrameLayout((Context)this.mActivity);
        this.zzOK.setBackgroundColor(-16777216);
        this.zzOK.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzOK);
        this.zzOU = true;
        this.zzOL = customViewCallback;
        this.zzOJ = true;
    }

    private final void zzs(boolean bl) throws zzp {
        zzakb zzakb2;
        boolean bl2;
        zzme<Boolean> zzme2;
        Window window;
        if (!this.zzOU) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zzp("Invalid activity, no window available.");
        }
        boolean bl3 = true;
        if (com.google.android.gms.common.util.zzq.isAtLeastN()) {
            zzme2 = zzmo.zzGz;
            if (zzbs.zzbL().zzd(zzme2).booleanValue()) {
                zzbs.zzbz();
                bl3 = zzagz.zza(this.mActivity, this.mActivity.getResources().getConfiguration());
            }
        }
        boolean bl4 = bl2 = this.zzOG.zzPo != null && this.zzOG.zzPo.zzus;
        if ((!this.zzON || bl2) && bl3) {
            window.setFlags(1024, 1024);
            zzme2 = zzmo.zzDT;
            if (zzbs.zzbL().zzd(zzme2).booleanValue() && com.google.android.gms.common.util.zzq.zzsc() && this.zzOG.zzPo != null && this.zzOG.zzPo.zzux) {
                window.getDecorView().setSystemUiVisibility(4098);
            }
        }
        boolean bl5 = (zzakb2 = this.zzOG.zzPg.zziw()) != null ? zzakb2.zzcn() : false;
        this.zzOP = false;
        if (bl5) {
            if (this.zzOG.orientation == zzbs.zzbB().zzhT()) {
                this.zzOP = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzOG.orientation == zzbs.zzbB().zzhU()) {
                this.zzOP = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl6 = this.zzOP;
        zzafr.zzaC((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl6).toString());
        this.setRequestedOrientation(this.zzOG.orientation);
        if (zzbs.zzbB().zza(window)) {
            zzafr.zzaC((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzON) {
            this.zzOO.setBackgroundColor(-16777216);
        } else {
            this.zzOO.setBackgroundColor(zzOF);
        }
        this.mActivity.setContentView((View)this.zzOO);
        this.zzOU = true;
        if (bl) {
            try {
                this.zzJH = zzbs.zzbA().zza((Context)this.mActivity, this.zzOG.zzPg.zzam(), true, bl5, null, this.zzOG.zzvT, null, null, this.zzOG.zzPg.zzak(), zzig.zzde());
            }
            catch (Exception exception) {
                throw new zzp("Could not obtain webview for the overlay.");
            }
            this.zzJH.zziw().zza(null, null, this.zzOG.zzPh, this.zzOG.zzPl, true, null, this.zzOG.zzPg.zziw().zziO(), null, null);
            this.zzJH.zziw().zza(new zzn(this));
            if (this.zzOG.url != null) {
                this.zzJH.loadUrl(this.zzOG.url);
            } else if (this.zzOG.zzPk != null) {
                this.zzJH.loadDataWithBaseURL(this.zzOG.zzPi, this.zzOG.zzPk, "text/html", "UTF-8", null);
            } else {
                throw new zzp("No URL or HTML to display in ad overlay.");
            }
            if (this.zzOG.zzPg != null) {
                this.zzOG.zzPg.zzc(this);
            }
        } else {
            this.zzJH = this.zzOG.zzPg;
            this.zzJH.setContext((Context)this.mActivity);
        }
        this.zzJH.zzb(this);
        ViewParent viewParent = this.zzJH.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzJH.getView());
        }
        if (this.zzON) {
            this.zzJH.zziN();
        }
        this.zzOO.addView(this.zzJH.getView(), -1, -1);
        if (!bl && !this.zzOP) {
            this.zzfP();
        }
        this.zzr(bl5);
        if (this.zzJH.zzix()) {
            this.zza(bl5, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzfM() {
        if (!this.mActivity.isFinishing() || this.zzOV) {
            return;
        }
        this.zzOV = true;
        if (this.zzJH != null) {
            int n = this.zzOQ;
            this.zzJH.zzA(n);
            Object object = this.zzOR;
            synchronized (object) {
                if (!this.zzOT && this.zzJH.zziI()) {
                    this.zzOS = new zzo(this);
                    zzme<Long> zzme2 = zzmo.zzDS;
                    zzagz.zzZr.postDelayed(this.zzOS, zzbs.zzbL().zzd(zzme2).longValue());
                    return;
                }
            }
        }
        this.zzfN();
    }

    final void zzfN() {
        if (this.zzOW) {
            return;
        }
        this.zzOW = true;
        if (this.zzJH != null) {
            this.zzOO.removeView(this.zzJH.getView());
            if (this.zzOH != null) {
                this.zzJH.setContext(this.zzOH.zzqD);
                this.zzJH.zzA(false);
                this.zzOH.parent.addView(this.zzJH.getView(), this.zzOH.index, this.zzOH.zzPa);
                this.zzOH = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzJH.setContext(this.mActivity.getApplicationContext());
            }
            this.zzJH = null;
        }
        if (this.zzOG != null && this.zzOG.zzPf != null) {
            this.zzOG.zzPf.zzaA();
        }
    }

    public final void zzfO() {
        if (this.zzOP) {
            this.zzOP = false;
            this.zzfP();
        }
    }

    private final void zzfP() {
        this.zzJH.zzfP();
    }

    public final void zzfQ() {
        this.zzOO.zzOZ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzfR() {
        Object object = this.zzOR;
        synchronized (object) {
            this.zzOT = true;
            if (this.zzOS != null) {
                zzagz.zzZr.removeCallbacks(this.zzOS);
                zzagz.zzZr.post(this.zzOS);
            }
            return;
        }
    }

    static /* synthetic */ Activity zza(zzm zzm2) {
        return zzm2.mActivity;
    }
}

