/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzaff;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzair;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zzfg;
import com.google.android.gms.internal.zzfj;
import com.google.android.gms.internal.zzfl;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzgd;
import com.google.android.gms.internal.zzgs;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzzn;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzn
public final class zzfi
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private Object mLock = new Object();
    private final WeakReference<zzaff> zzwN;
    private WeakReference<ViewTreeObserver> zzwO;
    private final zzgs zzwP;
    protected final zzfg zzwQ;
    private final Context mApplicationContext;
    private final WindowManager zzwR;
    private final PowerManager zzwS;
    private final KeyguardManager zzwT;
    private final DisplayMetrics zzwU;
    @Nullable
    private zzfp zzwV;
    private boolean zzwW;
    private boolean zzuV = false;
    private boolean zzwX = false;
    private boolean zzwY;
    private boolean zzwZ;
    private boolean zzxa;
    @Nullable
    private BroadcastReceiver zzxb;
    private final HashSet<Object> zzxc = new HashSet();
    private zzair zzwx;
    private final HashSet<zzgd> zzxd = new HashSet();
    private final Rect zzxe = new Rect();
    private final zzfl zzxf;
    private float zzxg;

    public zzfi(Context context, zziv zziv2, zzaff zzaff2, zzaje zzaje2, zzgs zzgs2) {
        this.zzwN = new WeakReference<zzaff>(zzaff2);
        this.zzwP = zzgs2;
        this.zzwO = new WeakReference<Object>(null);
        this.zzwY = true;
        this.zzxa = false;
        this.zzwx = new zzair(200L);
        this.zzwQ = new zzfg(UUID.randomUUID().toString(), zzaje2, zziv2.zzAs, zzaff2.zzXL, zzaff2.zzcn(), zziv2.zzAv);
        this.zzwR = (WindowManager)context.getSystemService("window");
        this.zzwS = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzwT = (KeyguardManager)context.getSystemService("keyguard");
        this.mApplicationContext = context;
        this.zzxf = new zzfl(this, new Handler());
        this.mApplicationContext.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.zzxf);
        this.zzwU = context.getResources().getDisplayMetrics();
        Display display = this.zzwR.getDefaultDisplay();
        this.zzxe.right = display.getWidth();
        this.zzxe.bottom = display.getHeight();
        this.zzcp();
    }

    public final void zzcp() {
        zzbs.zzbz();
        this.zzxg = zzagz.zzM(this.mApplicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzcq() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzwY) {
                this.zzwZ = true;
                try {
                    JSONObject jSONObject = this.zzcu();
                    jSONObject.put("doneReasonCode", (Object)"u");
                    JSONObject jSONObject2 = jSONObject;
                    this.zza(jSONObject2, true);
                }
                catch (JSONException jSONException) {
                    zzafr.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzafr.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzwQ.zzcm());
                zzafr.zzaC((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zzg(int n) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            block13: {
                Iterator<zzgd> iterator = this.zzxd.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().zzcy()) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            if (!bl2 || !this.zzwY) {
                return;
            }
            View view = this.zzwP.zzcv();
            boolean bl3 = view != null && zzbs.zzbz().zza(view, this.zzwS, this.zzwT);
            boolean bl4 = bl = view != null && bl3 && view.getGlobalVisibleRect(new Rect(), null);
            if (this.zzwP.zzcw()) {
                this.zzcq();
                return;
            }
            if (n == 1 && !this.zzwx.tryAcquire() && bl == this.zzxa) {
                return;
            }
            if (!bl && !this.zzxa && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zza(view, (Boolean)bl3);
                this.zza(jSONObject, false);
                this.zzxa = bl;
            }
            catch (RuntimeException | JSONException throwable) {
                zzafr.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            zzfi zzfi2 = this;
            View view2 = zzfi2.zzwP.zzcx().zzcv();
            if (view2 != null) {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)zzfi2.zzwO.get();
                ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
                if (viewTreeObserver2 != viewTreeObserver) {
                    zzfi2.zzct();
                    if (!zzfi2.zzwW || viewTreeObserver != null && viewTreeObserver.isAlive()) {
                        zzfi2.zzwW = true;
                        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)zzfi2);
                        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)zzfi2);
                    }
                    zzfi2.zzwO = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
                }
            }
            this.zzcr();
            return;
        }
    }

    private final void zzcr() {
        if (this.zzwV != null) {
            this.zzwV.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzcs() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzwY;
        }
    }

    private static int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    final boolean zzb(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzwQ.zzcm());
    }

    final void zzb(zzaka zzaka2, Map<String, String> map) {
        this.zzg(3);
    }

    final void zza(zzgd zzgd2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzwQ.zzcm());
        zzafr.zzaC((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzgd2);
    }

    final void zzc(Map<String, String> map) {
        if (!map.containsKey("isVisible")) {
            return;
        }
        if (!"1".equals(map.get("isVisible"))) {
            "true".equals(map.get("isVisible"));
        }
        Iterator<Object> iterator = this.zzxc.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private final void zzct() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzwO.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private final JSONObject zzcu() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = jSONObject.put("afmaVersion", (Object)this.zzwQ.zzck()).put("activeViewJSON", (Object)this.zzwQ.zzcl()).put("timestamp", zzbs.zzbF().elapsedRealtime()).put("adFormat", (Object)this.zzwQ.zzcj()).put("hashCode", (Object)this.zzwQ.zzcm()).put("isMraid", this.zzwQ.zzcn()).put("isStopped", this.zzwX).put("isPaused", this.zzuV).put("isNative", this.zzwQ.zzco()).put("isScreenOn", this.isScreenOn());
        zzbs.zzbz();
        JSONObject jSONObject3 = jSONObject2.put("appMuted", zzagz.zzbh());
        zzbs.zzbz();
        jSONObject3.put("appVolume", (double)zzagz.zzbf()).put("deviceVolume", (double)this.zzxg);
        return jSONObject;
    }

    private static JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    private final void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = zzfi.zza(jSONObject);
            boolean bl2 = bl;
            JSONObject jSONObject3 = jSONObject2;
            zzfi zzfi2 = this;
            ArrayList<zzgd> arrayList = new ArrayList<zzgd>(zzfi2.zzxd);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzgd zzgd2 = arrayList.get(i);
                zzgd2.zzb(jSONObject3, bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            zzafr.zzb((String)"Skipping active view message.", (Throwable)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzgd zzgd2) {
        if (this.zzxd.isEmpty()) {
            zzfi zzfi2 = this;
            Object object = zzfi2.mLock;
            synchronized (object) {
                if (zzfi2.zzxb != null) {
                } else {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    zzfi2.zzxb = new zzfj(zzfi2);
                    zzfi2.mApplicationContext.registerReceiver(zzfi2.zzxb, intentFilter);
                }
            }
            this.zzg(3);
        }
        this.zzxd.add(zzgd2);
        try {
            JSONObject jSONObject = zzfi.zza(this.zza(this.zzwP.zzcv(), null));
            zzgd2.zzb(jSONObject, false);
            return;
        }
        catch (JSONException jSONException) {
            zzafr.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzgd zzgd2) {
        this.zzxd.remove(zzgd2);
        zzgd2.zzcz();
        if (this.zzxd.isEmpty()) {
            zzfi zzfi2 = this;
            Object object = zzfi2.mLock;
            synchronized (object) {
                zzfi2.zzct();
                zzfi zzfi3 = zzfi2;
                Object object2 = zzfi3.mLock;
                synchronized (object2) {
                    if (zzfi3.zzxb != null) {
                        try {
                            zzfi3.mApplicationContext.unregisterReceiver(zzfi3.zzxb);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzafr.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                        }
                        catch (Exception exception) {
                            zzbs.zzbD().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                        }
                        zzfi3.zzxb = null;
                    }
                }
                zzfi2.mApplicationContext.getContentResolver().unregisterContentObserver((ContentObserver)zzfi2.zzxf);
                zzfi2.zzwY = false;
                zzfi2.zzcr();
                zzfi3 = zzfi2;
                ArrayList<zzgd> arrayList = new ArrayList<zzgd>(zzfi3.zzxd);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    zzgd zzgd3 = arrayList.get(i);
                    zzgd zzgd4 = zzgd3;
                    zzfi3.zzb(zzgd4);
                }
                return;
            }
        }
    }

    private final JSONObject zza(@Nullable View view, @Nullable Boolean bl) throws JSONException {
        if (view == null) {
            zzfi zzfi2 = this;
            return zzfi2.zzcu().put("isAttachedToWindow", false).put("isScreenOn", zzfi2.isScreenOn()).put("isVisible", false);
        }
        boolean bl2 = zzbs.zzbB().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzafr.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        Rect rect = new Rect();
        new Rect().left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        boolean bl3 = view.getGlobalVisibleRect(rect2, null);
        Rect rect3 = new Rect();
        boolean bl4 = view.getLocalVisibleRect(rect3);
        Rect rect4 = new Rect();
        view.getHitRect(rect4);
        JSONObject jSONObject = this.zzcu();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl2).put("viewBox", (Object)new JSONObject().put("top", zzfi.zza(this.zzxe.top, this.zzwU)).put("bottom", zzfi.zza(this.zzxe.bottom, this.zzwU)).put("left", zzfi.zza(this.zzxe.left, this.zzwU)).put("right", zzfi.zza(this.zzxe.right, this.zzwU))).put("adBox", (Object)new JSONObject().put("top", zzfi.zza(rect.top, this.zzwU)).put("bottom", zzfi.zza(rect.bottom, this.zzwU)).put("left", zzfi.zza(rect.left, this.zzwU)).put("right", zzfi.zza(rect.right, this.zzwU))).put("globalVisibleBox", (Object)new JSONObject().put("top", zzfi.zza(rect2.top, this.zzwU)).put("bottom", zzfi.zza(rect2.bottom, this.zzwU)).put("left", zzfi.zza(rect2.left, this.zzwU)).put("right", zzfi.zza(rect2.right, this.zzwU))).put("globalVisibleBoxVisible", bl3).put("localVisibleBox", (Object)new JSONObject().put("top", zzfi.zza(rect3.top, this.zzwU)).put("bottom", zzfi.zza(rect3.bottom, this.zzwU)).put("left", zzfi.zza(rect3.left, this.zzwU)).put("right", zzfi.zza(rect3.right, this.zzwU))).put("localVisibleBoxVisible", bl4).put("hitBox", (Object)new JSONObject().put("top", zzfi.zza(rect4.top, this.zzwU)).put("bottom", zzfi.zza(rect4.bottom, this.zzwU)).put("left", zzfi.zza(rect4.left, this.zzwU)).put("right", zzfi.zza(rect4.right, this.zzwU))).put("screenDensity", (double)this.zzwU.density);
        if (bl == null) {
            bl = zzbs.zzbz().zza(view, this.zzwS, this.zzwT);
        }
        jSONObject.put("isVisible", bl.booleanValue());
        return jSONObject;
    }

    private final boolean isScreenOn() {
        if (Build.VERSION.SDK_INT >= 20) {
            return this.zzwS.isInteractive();
        }
        return this.zzwS.isScreenOn();
    }

    public final void onScrollChanged() {
        this.zzg(1);
    }

    public final void onGlobalLayout() {
        this.zzg(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzfp zzfp2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzwV = zzfp2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzwX = true;
            this.zzg(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzuV = true;
            this.zzg(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzuV = false;
            this.zzg(3);
            return;
        }
    }
}

