/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.overlay.zzaa;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzaiw;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzajz;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzrd;
import com.google.android.gms.internal.zzzn;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@zzzn
public final class zzrw
implements zzrd {
    private boolean zzJK;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                zzji.zzds();
                n2 = zzaiy.zzc((Context)context, (int)Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzafr.zzaT((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    @Override
    public final void zza(zzaka zzaka2, Map<String, String> map) {
        Object object;
        Object object2;
        String string2 = map.get("action");
        if (string2 == null) {
            zzafr.zzaT((String)"Action missing from video GMSG.");
            return;
        }
        if (zzafr.zzz((int)3)) {
            object2 = new JSONObject(map);
            object2.remove("google.afma.Notify_dt");
            object = String.valueOf(object2.toString());
            zzafr.zzaC((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(object).length()).append("Video GMSG: ").append(string2).append(" ").append((String)object).toString());
        }
        if ("background".equals(string2)) {
            object2 = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object2)) {
                zzafr.zzaT((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object2);
                zzaka2.setBackgroundColor(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzafr.zzaT((String)"Invalid color parameter in video GMSG.");
                return;
            }
        }
        if ("decoderProps".equals(string2)) {
            object2 = map.get("mimeTypes");
            if (object2 == null) {
                zzafr.zzaT((String)"No MIME types specified for decoder properties inspection.");
                zzaa.zza(zzaka2, "missingMimeTypes");
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                zzafr.zzaT((String)"Video decoder properties available on API versions >= 16.");
                zzaa.zza(zzaka2, "deficientApiVersion");
                return;
            }
            object = new HashMap();
            for (String string3 : ((String)object2).split(",")) {
                object.put(string3, zzaiw.zzaQ(string3.trim()));
            }
            zzaa.zzc(zzaka2, (Map<String, List<Map<String, Object>>>)object);
            return;
        }
        object2 = zzaka2.zziE();
        if (object2 == null) {
            zzafr.zzaT((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzaka2.getContext();
            int n2 = zzrw.zza(context, map, "x", 0);
            int n3 = zzrw.zza(context, map, "y", 0);
            int n4 = zzrw.zza(context, map, "w", -1);
            int n5 = zzrw.zza(context, map, "h", -1);
            zzme<Boolean> zzme2 = zzmo.zzFB;
            if (zzbs.zzbL().zzd(zzme2).booleanValue()) {
                n4 = Math.min(n4, zzaka2.getMeasuredWidth() - n2);
                n5 = Math.min(n5, zzaka2.getMeasuredHeight() - n3);
            }
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean(map.get("spherical"));
            if (bl && ((zzajz)object2).zzip() == null) {
                zzaq zzaq2 = new zzaq(map.get("flags"));
                ((zzajz)object2).zza(n2, n3, n4, n5, n, bl3, zzaq2);
                return;
            }
            ((zzajz)object2).zze(n2, n3, n4, n5);
            return;
        }
        zzaa zzaa2 = ((zzajz)object2).zzip();
        if (zzaa2 == null) {
            zzaa.zzh(zzaka2);
            return;
        }
        if ("click".equals(string2)) {
            Context context = zzaka2.getContext();
            int n = zzrw.zza(context, map, "x", 0);
            int n6 = zzrw.zza(context, map, "y", 0);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
            zzaa2.zze(motionEvent);
            motionEvent.recycle();
            return;
        }
        if ("currentTime".equals(string2)) {
            String string4 = map.get("time");
            if (string4 == null) {
                zzafr.zzaT((String)"Time parameter missing from currentTime video GMSG.");
                return;
            }
            try {
                int n = (int)(Float.parseFloat(string4) * 1000.0f);
                zzaa2.seekTo(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = String.valueOf(string4);
                zzafr.zzaT((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                return;
            }
        }
        if ("hide".equals(string2)) {
            zzaa2.setVisibility(4);
            return;
        }
        if ("load".equals(string2)) {
            zzaa2.zzfY();
            return;
        }
        if ("muted".equals(string2)) {
            if (Boolean.parseBoolean(map.get("muted"))) {
                zzaa2.zzfZ();
                return;
            }
            zzaa2.zzga();
            return;
        }
        if ("pause".equals(string2)) {
            zzaa2.pause();
            return;
        }
        if ("play".equals(string2)) {
            zzaa2.play();
            return;
        }
        if ("show".equals(string2)) {
            zzaa2.setVisibility(0);
            return;
        }
        if ("src".equals(string2)) {
            zzaa2.zzaq(map.get("src"));
            return;
        }
        if ("touchMove".equals(string2)) {
            Context context = zzaka2.getContext();
            int n = zzrw.zza(context, map, "dx", 0);
            int n7 = zzrw.zza(context, map, "dy", 0);
            zzaa2.zza(n, n7);
            if (!this.zzJK) {
                zzaka2.zziu().zzfQ();
                this.zzJK = true;
            }
            return;
        }
        if ("volume".equals(string2)) {
            String string6 = map.get("volume");
            if (string6 == null) {
                zzafr.zzaT((String)"Level parameter missing from volume video GMSG.");
                return;
            }
            try {
                float f = Float.parseFloat(string6);
                zzaa2.zzb(f);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = String.valueOf(string6);
                zzafr.zzaT((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                return;
            }
        }
        if ("watermark".equals(string2)) {
            zzaa2.zzgb();
            return;
        }
        String string8 = String.valueOf(string2);
        zzafr.zzaT((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
    }
}

