/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Parcel;
import android.support.annotation.Nullable;
import android.util.Base64;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzacc;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzsi;
import com.google.android.gms.internal.zztm;
import com.google.android.gms.internal.zztn;
import com.google.android.gms.internal.zzto;
import com.google.android.gms.internal.zztp;
import com.google.android.gms.internal.zztr;
import com.google.android.gms.internal.zzzn;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@zzzn
public final class zztl {
    private final Map<zztm, zztn> zzKo = new HashMap<zztm, zztn>();
    private final LinkedList<zztm> zzKp = new LinkedList();
    @Nullable
    private zzsi zzKq;

    final void zza(zzsi zzsi2) {
        if (this.zzKq == null) {
            this.zzKq = zzsi2.zzeF();
            zztl zztl2 = this;
            if (zztl2.zzKq != null) {
                SharedPreferences sharedPreferences = zztl2.zzKq.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0);
                zztl zztl3 = zztl2;
                while (zztl3.zzKp.size() > 0) {
                    zztm zztm2 = zztl3.zzKp.remove();
                    zztn zztn2 = zztl3.zzKo.get(zztm2);
                    zztl.zza("Flushing interstitial queue for %s.", zztm2);
                    while (zztn2.size() > 0) {
                        zztn2.zzm(null).zzKv.zzbb();
                    }
                    zztl3.zzKo.remove(zztm2);
                }
                try {
                    zztm zztm2;
                    HashMap<String, zztm> hashMap = new HashMap<String, zztm>();
                    for (Map.Entry stringArray : sharedPreferences.getAll().entrySet()) {
                        if (((String)stringArray.getKey()).equals("PoolKeys")) continue;
                        zztr zztr2 = zztr.zzab((String)stringArray.getValue());
                        zztm2 = new zztm(zztr2.zzuT, zztr2.zztV, zztr2.zzKt);
                        if (zztl2.zzKo.containsKey(zztm2)) continue;
                        zztn zztn2 = new zztn(zztr2.zzuT, zztr2.zztV, zztr2.zzKt);
                        zztl2.zzKo.put(zztm2, zztn2);
                        hashMap.put(zztm2.toString(), zztm2);
                        zztl.zza("Restored interstitial queue for %s.", zztm2);
                    }
                    for (String string2 : zztl.zzY(sharedPreferences.getString("PoolKeys", ""))) {
                        zztm2 = (zztm)hashMap.get(string2);
                        if (!zztl2.zzKo.containsKey(zztm2)) continue;
                        zztl2.zzKp.add(zztm2);
                    }
                    return;
                }
                catch (IOException | RuntimeException exception) {
                    zzbs.zzbD().zza(exception, "InterstitialAdPool.restore");
                    zzafr.zzc((String)"Malformed preferences value for InterstitialAdPool.", (Throwable)exception);
                    zztl2.zzKo.clear();
                    zztl2.zzKp.clear();
                }
            }
        }
    }

    @Nullable
    final zzto zza(zzir zzir2, String string2) {
        Object object;
        Object object2;
        zzme<Integer> zzme2;
        String string3;
        if (zztl.zzZ(string2)) {
            return null;
        }
        Context context = this.zzKq.getApplicationContext();
        int n = new zzacc((Context)context).zzgM().zzVS;
        zzir zzir3 = zztl.zzk(zzir2);
        zztm zztm2 = new zztm(zzir3, string3 = zztl.zzaa(string2), n);
        zztn zztn2 = this.zzKo.get(zztm2);
        if (zztn2 == null) {
            zztl.zza("Interstitial pool created at %s.", zztm2);
            zztn2 = new zztn(zzir3, string3, n);
            this.zzKo.put(zztm2, zztn2);
        }
        this.zzKp.remove(zztm2);
        this.zzKp.add(zztm2);
        zztn2.zzeL();
        while (true) {
            zzme2 = zzmo.zzEc;
            if (this.zzKp.size() <= zzbs.zzbL().zzd(zzme2)) break;
            object2 = this.zzKp.remove();
            object = this.zzKo.get(object2);
            zztl.zza("Evicting interstitial queue for %s.", (zztm)object2);
            while (((zztn)object).size() > 0) {
                zzto zzto2 = ((zztn)object).zzm(null);
                if (zzto2.zzKz) {
                    zztp.zzeN().zzeP();
                }
                zzto2.zzKv.zzbb();
            }
            this.zzKo.remove(object2);
        }
        while (zztn2.size() > 0) {
            object2 = zztn2.zzm(zzir3);
            if (((zzto)object2).zzKz) {
                zzme2 = zzmo.zzEe;
                if (zzbs.zzbF().currentTimeMillis() - ((zzto)object2).zzKy > 1000L * (long)zzbs.zzbL().zzd(zzme2).intValue()) {
                    zztl.zza("Expired interstitial at %s.", zztm2);
                    zztp.zzeN().zzeO();
                    continue;
                }
            }
            object = ((zzto)object2).zzKw != null ? " (inline) " : " ";
            zztl.zza(new StringBuilder(34 + String.valueOf(object).length()).append("Pooled interstitial").append((String)object).append("returned at %s.").toString(), zztm2);
            return object2;
        }
        return null;
    }

    final void zzb(zzir zzir2, String string2) {
        String string3;
        if (this.zzKq == null) {
            return;
        }
        Context context = this.zzKq.getApplicationContext();
        int n = new zzacc((Context)context).zzgM().zzVS;
        zzir zzir3 = zztl.zzk(zzir2);
        zztm zztm2 = new zztm(zzir3, string3 = zztl.zzaa(string2), n);
        zztn zztn2 = this.zzKo.get(zztm2);
        if (zztn2 == null) {
            zztl.zza("Interstitial pool created at %s.", zztm2);
            zztn2 = new zztn(zzir3, string3, n);
            this.zzKo.put(zztm2, zztn2);
        }
        zztn2.zza(this.zzKq, zzir2);
        zztn2.zzeL();
        zztl.zza("Inline entry added to the queue at %s.", zztm2);
    }

    final void zzeG() {
        Object object;
        if (this.zzKq == null) {
            return;
        }
        for (Map.Entry<zztm, zztn> entry : this.zzKo.entrySet()) {
            int n;
            zztm zztm2 = entry.getKey();
            zztn zztn2 = entry.getValue();
            if (zzafr.zzz((int)2)) {
                n = zztn2.size();
                int n2 = zztn2.zzeJ();
                if (n2 < n) {
                    zzafr.v(String.format("Loading %s/%s pooled interstitials for %s.", n - n2, n, zztm2));
                }
            }
            n = 0 + zztn2.zzeK();
            while (true) {
                object = zzmo.zzEd;
                if (zztn2.size() >= (Integer)zzbs.zzbL().zzd(object)) break;
                zztl.zza("Pooling and loading one new interstitial for %s.", zztm2);
                if (!zztn2.zzb(this.zzKq)) continue;
                ++n;
            }
            zztp.zzeN().zzn(n);
        }
        object = this;
        if (((zztl)object).zzKq != null) {
            SharedPreferences.Editor editor = ((zztl)object).zzKq.getApplicationContext().getSharedPreferences("com.google.android.gms.ads.internal.interstitial.InterstitialAdPool", 0).edit();
            editor.clear();
            for (Map.Entry<zztm, zztn> entry : ((zztl)object).zzKo.entrySet()) {
                zztm zztm3 = entry.getKey();
                zztn zztn3 = entry.getValue();
                if (!zztn3.zzeM()) continue;
                String string2 = new zztr(zztn3).zzeW();
                String string3 = zztm3.toString();
                editor.putString(string3, string2);
                zztl.zza("Saved interstitial queue for %s.", zztm3);
            }
            editor.putString("PoolKeys", super.zzeH());
            editor.apply();
        }
    }

    private final String zzeH() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator iterator = this.zzKp.iterator();
            while (iterator.hasNext()) {
                String string2 = ((zztm)iterator.next()).toString();
                stringBuilder.append(Base64.encodeToString((byte[])string2.getBytes("UTF-8"), (int)0));
                if (!iterator.hasNext()) continue;
                stringBuilder.append("\u0000");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    private static String[] zzY(String string2) {
        try {
            String[] stringArray = string2.split("\u0000");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = new String(Base64.decode((String)stringArray[i], (int)0), "UTF-8");
            }
            return stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String[0];
        }
    }

    private static boolean zzZ(String string2) {
        try {
            zzme<String> zzme2 = zzmo.zzEf;
            return Pattern.matches(zzbs.zzbL().zzd(zzme2), string2);
        }
        catch (RuntimeException runtimeException) {
            zzbs.zzbD().zza(runtimeException, "InterstitialAdPool.isExcludedAdUnit");
            return false;
        }
    }

    static Set<String> zzi(zzir zzir2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(zzir2.extras.keySet());
        Bundle bundle = zzir2.zzzX.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            hashSet.addAll(bundle.keySet());
        }
        return hashSet;
    }

    static zzir zzj(zzir zzir2) {
        zzir zzir3 = zztl.zzl(zzir2);
        String string2 = "_skipMediation";
        zzir zzir4 = zzir3;
        Bundle bundle = zzir3.zzzX.getBundle("com.google.ads.mediation.admob.AdMobAdapter");
        if (bundle != null) {
            bundle.putBoolean(string2, true);
        }
        zzir4.extras.putBoolean(string2, true);
        return zzir3;
    }

    private static zzir zzk(zzir zzir2) {
        zzir zzir3 = zztl.zzl(zzir2);
        zzme<String> zzme2 = zzmo.zzEb;
        for (String string2 : zzbs.zzbL().zzd(zzme2).split(",")) {
            zztl.zzc(zzir3.zzzX, string2);
            String string3 = "com.google.ads.mediation.admob.AdMobAdapter/";
            if (!string2.startsWith(string3)) continue;
            String string4 = string2.replaceFirst(string3, "");
            zztl.zzc(zzir3.extras, string4);
        }
        return zzir3;
    }

    private static String zzaa(String string2) {
        try {
            Matcher matcher = Pattern.compile("([^/]+/[0-9]+).*").matcher(string2);
            if (matcher.matches()) {
                return matcher.group(1);
            }
        }
        catch (RuntimeException runtimeException) {}
        return string2;
    }

    private static zzir zzl(zzir zzir2) {
        Parcel parcel = Parcel.obtain();
        zzir2.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        zzir zzir3 = (zzir)zzir.CREATOR.createFromParcel(parcel);
        parcel.recycle();
        zzme<Boolean> zzme2 = zzmo.zzDR;
        if (zzbs.zzbL().zzd(zzme2).booleanValue()) {
            zzir.zzh((zzir)zzir3);
        }
        return zzir3;
    }

    private static void zzc(Bundle bundle, String string2) {
        String[] stringArray;
        while ((stringArray = string2.split("/", 2)).length != 0) {
            String string3 = stringArray[0];
            if (stringArray.length == 1) {
                bundle.remove(string3);
                return;
            }
            Bundle bundle2 = bundle.getBundle(string3);
            if (bundle2 == null) {
                return;
            }
            string2 = stringArray[1];
            bundle = bundle2;
        }
        return;
    }

    private static void zza(String string2, zztm zztm2) {
        if (zzafr.zzz((int)2)) {
            zzafr.v(String.format(string2, zztm2));
        }
    }
}

