/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import com.google.ads.mediation.AdUrlAdapter;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.ads.mediation.MediationAdapter;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzon;
import com.google.android.gms.internal.zzua;
import com.google.android.gms.internal.zzub;
import com.google.android.gms.internal.zzud;
import com.google.android.gms.internal.zzuf;
import com.google.android.gms.internal.zzug;
import com.google.android.gms.internal.zzuh;
import com.google.android.gms.internal.zzui;
import com.google.android.gms.internal.zzuq;
import com.google.android.gms.internal.zzut;
import com.google.android.gms.internal.zzuw;
import com.google.android.gms.internal.zzuz;
import com.google.android.gms.internal.zzvj;
import com.google.android.gms.internal.zzwd;
import com.google.android.gms.internal.zzzn;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

@zzzn
public final class zzue
implements zzui {
    private final String zzMs;
    private final zzuq zzsX;
    private final long zzMt;
    private final zzub zzMu;
    private final zzua zzMv;
    private zzir zzuT;
    private final zziv zzuZ;
    private final Context mContext;
    private final Object mLock = new Object();
    private final zzaje zztW;
    private final boolean zzwJ;
    private final zzon zztS;
    private final List<String> zztT;
    private final List<String> zzMw;
    private final List<String> zzMx;
    private final boolean zzMy;
    private zzut zzMz;
    private int zzMA = -2;
    private zzuz zzMB;

    public zzue(Context context, String string, zzuq zzuq2, zzub zzub2, zzua zzua2, zzir zzir2, zziv zziv2, zzaje zzaje2, boolean bl, boolean bl2, zzon zzon2, List<String> list, List<String> list2, List<String> list3) {
        this.mContext = context;
        this.zzsX = zzuq2;
        this.zzMv = zzua2;
        this.zzMs = "com.google.ads.mediation.customevent.CustomEventAdapter".equals(string) ? this.zzfj() : string;
        this.zzMu = zzub2;
        this.zzMt = zzub2.zzLZ != -1L ? zzub2.zzLZ : 10000L;
        this.zzuT = zzir2;
        this.zzuZ = zziv2;
        this.zztW = zzaje2;
        this.zzwJ = bl;
        this.zzMy = bl2;
        this.zztS = zzon2;
        this.zztT = list;
        this.zzMw = list2;
        this.zzMx = list3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cancel() {
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.zzMz != null) {
                    this.zzMz.destroy();
                }
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not destroy mediation adapter.", (Throwable)remoteException);
            }
            this.zzMA = -1;
            this.mLock.notify();
            return;
        }
    }

    private final String zzfj() {
        try {
            if (!TextUtils.isEmpty((CharSequence)this.zzMv.zzLL)) {
                if (this.zzsX.zzai(this.zzMv.zzLL)) {
                    return "com.google.android.gms.ads.mediation.customevent.CustomEventAdapter";
                }
                return "com.google.ads.mediation.customevent.CustomEventAdapter";
            }
        }
        catch (RemoteException remoteException) {
            zzafr.zzaT((String)"Fail to determine the custom event's version, assuming the old one.");
        }
        return "com.google.ads.mediation.customevent.CustomEventAdapter";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzo(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzMA = n;
            this.mLock.notify();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(int n, zzuz zzuz2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzMA = 0;
            this.zzMB = zzuz2;
            this.mLock.notify();
            return;
        }
    }

    private static zzut zza(MediationAdapter mediationAdapter) {
        return new zzvj(mediationAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final zzuh zza(long l, long l2) {
        Object object = this.mLock;
        synchronized (object) {
            long l3 = SystemClock.elapsedRealtime();
            zzud zzud2 = new zzud();
            zzagz.zzZr.post((Runnable)new zzuf(this, zzud2));
            long l4 = l2;
            long l5 = l;
            long l6 = this.zzMt;
            zzue zzue2 = this;
            while (zzue2.zzMA == -2) {
                long l7 = l4;
                long l8 = l5;
                long l9 = l6;
                long l10 = l3;
                zzue zzue3 = zzue2;
                long l11 = SystemClock.elapsedRealtime();
                long l12 = l9 - (l11 - l10);
                long l13 = l7 - (l11 - l8);
                if (l12 <= 0L || l13 <= 0L) {
                    zzafr.zzaS((String)"Timed out waiting for adapter.");
                    zzue3.zzMA = 3;
                    continue;
                }
                try {
                    zzue3.mLock.wait(Math.min(l12, l13));
                }
                catch (InterruptedException interruptedException) {
                    zzue3.zzMA = -1;
                }
            }
            long l14 = zzbs.zzbF().elapsedRealtime() - l3;
            return new zzuh(this.zzMv, this.zzMz, this.zzMs, zzud2, this.zzMA, this.zzfk(), l14);
        }
    }

    private final zzuz zzfk() {
        if (this.zzMA != 0 || !this.zzfm()) {
            return null;
        }
        try {
            if (this.zzp(4) && this.zzMB != null && this.zzMB.zzfo() != 0) {
                return this.zzMB;
            }
        }
        catch (RemoteException remoteException) {
            zzafr.zzaT((String)"Could not get cpm value from MediationResponseMetadata");
        }
        int n = this.zzfn();
        return new zzug(n);
    }

    private final zzut zzfl() {
        String string = String.valueOf(this.zzMs);
        zzafr.zzaS((String)(string.length() != 0 ? "Instantiating mediation adapter: ".concat(string) : new String("Instantiating mediation adapter: ")));
        if (!this.zzwJ && !this.zzMv.zzfi()) {
            zzme<Boolean> zzme2 = zzmo.zzEG;
            if (zzbs.zzbL().zzd(zzme2).booleanValue() && "com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzMs)) {
                return zzue.zza((MediationAdapter)new AdMobAdapter());
            }
            zzme2 = zzmo.zzEH;
            if (zzbs.zzbL().zzd(zzme2).booleanValue() && "com.google.ads.mediation.AdUrlAdapter".equals(this.zzMs)) {
                return zzue.zza((MediationAdapter)new AdUrlAdapter());
            }
            if ("com.google.ads.mediation.admob.AdMobCustomTabsAdapter".equals(this.zzMs)) {
                return new zzvj((MediationAdapter)new zzwd());
            }
        }
        try {
            return this.zzsX.zzah(this.zzMs);
        }
        catch (RemoteException remoteException) {
            String string2 = String.valueOf(this.zzMs);
            zzafr.zza((String)(string2.length() != 0 ? "Could not instantiate mediation adapter: ".concat(string2) : new String("Could not instantiate mediation adapter: ")), (Throwable)remoteException);
            return null;
        }
    }

    private final void zza(zzud zzud2) {
        String string = this.zzaf(this.zzMv.zzLP);
        try {
            if (this.zztW.zzaaP < 4100000) {
                if (this.zzuZ.zzAt) {
                    this.zzMz.zza(zzn.zzw((Object)this.mContext), this.zzuT, string, (zzuw)zzud2);
                    return;
                }
                this.zzMz.zza(zzn.zzw((Object)this.mContext), this.zzuZ, this.zzuT, string, (zzuw)zzud2);
                return;
            }
            if (this.zzwJ || this.zzMv.zzfi()) {
                ArrayList<String> arrayList = new ArrayList<String>(this.zztT);
                if (this.zzMw != null) {
                    for (String string2 : this.zzMw) {
                        String string3 = ":false";
                        if (this.zzMx != null && this.zzMx.contains(string2)) {
                            string3 = ":true";
                        }
                        String string4 = string3;
                        arrayList.add(new StringBuilder(7 + String.valueOf(string2).length() + String.valueOf(string4).length()).append("custom:").append(string2).append(string4).toString());
                    }
                }
                this.zzMz.zza(zzn.zzw((Object)this.mContext), this.zzuT, string, this.zzMv.zzLH, (zzuw)zzud2, this.zztS, arrayList);
                return;
            }
            if (this.zzuZ.zzAt) {
                this.zzMz.zza(zzn.zzw((Object)this.mContext), this.zzuT, string, this.zzMv.zzLH, (zzuw)zzud2);
                return;
            }
            if (this.zzMy) {
                if (this.zzMv.zzLS != null) {
                    this.zzMz.zza(zzn.zzw((Object)this.mContext), this.zzuT, string, this.zzMv.zzLH, (zzuw)zzud2, new zzon(zzue.zzag(this.zzMv.zzLW)), this.zzMv.zzLV);
                    return;
                }
                this.zzMz.zza(zzn.zzw((Object)this.mContext), this.zzuZ, this.zzuT, string, this.zzMv.zzLH, (zzuw)zzud2);
                return;
            }
            this.zzMz.zza(zzn.zzw((Object)this.mContext), this.zzuZ, this.zzuT, string, this.zzMv.zzLH, (zzuw)zzud2);
            return;
        }
        catch (RemoteException remoteException) {
            zzafr.zzc((String)"Could not request ad from mediation adapter.", (Throwable)remoteException);
            this.zzo(5);
            return;
        }
    }

    private final boolean zzp(int n) {
        Bundle bundle;
        try {
            bundle = this.zzwJ ? this.zzMz.zzft() : (this.zzuZ.zzAt ? this.zzMz.getInterstitialAdapterInfo() : this.zzMz.zzfs());
        }
        catch (RemoteException remoteException) {
            zzafr.zzaT((String)"Could not get adapter info. Returning false");
            return false;
        }
        if (bundle != null) {
            int n2 = bundle.getInt("capabilities", 0);
            return (n & n2) == n;
        }
        return false;
    }

    private final boolean zzfm() {
        return this.zzMu.zzMj != -1;
    }

    private final String zzaf(String string) {
        if (string == null || !this.zzfm() || this.zzp(2)) {
            return string;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            jSONObject.remove("cpm_floor_cents");
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            zzafr.zzaT((String)"Could not remove field. Returning the original value");
            return string;
        }
    }

    private final int zzfn() {
        JSONObject jSONObject;
        if (this.zzMv.zzLP == null) {
            return 0;
        }
        try {
            jSONObject = new JSONObject(this.zzMv.zzLP);
        }
        catch (JSONException jSONException) {
            zzafr.zzaT((String)"Could not convert to json. Returning 0");
            return 0;
        }
        if ("com.google.ads.mediation.admob.AdMobAdapter".equals(this.zzMs)) {
            return jSONObject.optInt("cpm_cents", 0);
        }
        int n = 0;
        if (this.zzp(2)) {
            n = jSONObject.optInt("cpm_floor_cents", 0);
        }
        if (n == 0) {
            n = jSONObject.optInt("penalized_average_cpm_cents", 0);
        }
        return n;
    }

    private static NativeAdOptions zzag(String string) {
        NativeAdOptions.Builder builder = new NativeAdOptions.Builder();
        if (string == null) {
            return builder.build();
        }
        try {
            String string2;
            JSONObject jSONObject = new JSONObject(string);
            builder.setRequestMultipleImages(jSONObject.optBoolean("multiple_images", false));
            builder.setReturnUrlsForImageAssets(jSONObject.optBoolean("only_urls", false));
            String string3 = string2 = jSONObject.optString("native_image_orientation", "any");
            builder.setImageOrientation("landscape".equals(string3) ? 2 : ("portrait".equals(string3) ? 1 : ("any".equals(string3) ? 0 : -1)));
        }
        catch (JSONException jSONException) {
            zzafr.zzc((String)"Exception occurred when creating native ad options", (Throwable)jSONException);
        }
        return builder.build();
    }

    static /* synthetic */ Object zza(zzue zzue2) {
        return zzue2.mLock;
    }

    static /* synthetic */ int zzb(zzue zzue2) {
        return zzue2.zzMA;
    }

    static /* synthetic */ zzut zza(zzue zzue2, zzut zzut2) {
        zzue2.zzMz = zzut2;
        return zzue2.zzMz;
    }

    static /* synthetic */ zzut zzc(zzue zzue2) {
        return zzue2.zzfl();
    }

    static /* synthetic */ zzut zzd(zzue zzue2) {
        return zzue2.zzMz;
    }

    static /* synthetic */ boolean zze(zzue zzue2) {
        return zzue2.zzfm();
    }

    static /* synthetic */ boolean zza(zzue zzue2, int n) {
        return zzue2.zzp(1);
    }

    static /* synthetic */ String zzf(zzue zzue2) {
        return zzue2.zzMs;
    }

    static /* synthetic */ void zza(zzue zzue2, zzud zzud2) {
        zzue2.zza(zzud2);
    }
}

