/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.util.zzf;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzwl;
import com.google.android.gms.internal.zzwu;
import com.google.android.gms.internal.zzwv;
import com.google.android.gms.internal.zzzn;
import java.util.Map;
import java.util.Set;

@zzzn
public final class zzwk
extends zzwu {
    private static Set<String> zzNy = zzf.zzb((Object[])new String[]{"top-left", "top-right", "top-center", "center", "bottom-left", "bottom-right", "bottom-center"});
    private String zzNz = "top-right";
    private boolean zzNA = true;
    private int zzNB = 0;
    private int zzNC = 0;
    private int zzrX = -1;
    private int zzND = 0;
    private int zzNE = 0;
    private int zzrW = -1;
    private final Object mLock = new Object();
    private final zzaka zzJH;
    private final Activity zzNo;
    private zziv zzuZ;
    private ImageView zzNF;
    private LinearLayout zzNG;
    private zzwv zzNH;
    private PopupWindow zzNI;
    private RelativeLayout zzNJ;
    private ViewGroup zzNK;

    public zzwk(zzaka zzaka2, zzwv zzwv2) {
        super(zzaka2, "resize");
        this.zzJH = zzaka2;
        this.zzNo = zzaka2.zzis();
        this.zzNH = zzwv2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(Map<String, String> map) {
        Object object = this.mLock;
        synchronized (object) {
            Bitmap bitmap;
            String string2;
            if (this.zzNo == null) {
                this.zzan("Not an activity context. Cannot resize.");
                return;
            }
            if (this.zzJH.zzam() == null) {
                this.zzan("Webview is not yet available, size is not set.");
                return;
            }
            if (this.zzJH.zzam().zzAt) {
                this.zzan("Is interstitial. Cannot resize an interstitial.");
                return;
            }
            if (this.zzJH.zziA()) {
                this.zzan("Cannot resize an expanded banner.");
                return;
            }
            Map<String, String> map2 = map;
            zzwk zzwk2 = this;
            if (!TextUtils.isEmpty((CharSequence)map2.get("width"))) {
                zzbs.zzbz();
                zzwk2.zzrW = zzagz.zzaJ(map2.get("width"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("height"))) {
                zzbs.zzbz();
                zzwk2.zzrX = zzagz.zzaJ(map2.get("height"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetX"))) {
                zzbs.zzbz();
                zzwk2.zzND = zzagz.zzaJ(map2.get("offsetX"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("offsetY"))) {
                zzbs.zzbz();
                zzwk2.zzNE = zzagz.zzaJ(map2.get("offsetY"));
            }
            if (!TextUtils.isEmpty((CharSequence)map2.get("allowOffscreen"))) {
                zzwk2.zzNA = Boolean.parseBoolean(map2.get("allowOffscreen"));
            }
            if (!TextUtils.isEmpty((CharSequence)(string2 = map2.get("customClosePosition")))) {
                zzwk2.zzNz = string2;
            }
            zzwk2 = this;
            if (!(zzwk2.zzrW >= 0 && zzwk2.zzrX >= 0)) {
                this.zzan("Invalid width and height options. Cannot resize.");
                return;
            }
            Window window = this.zzNo.getWindow();
            if (window == null || window.getDecorView() == null) {
                this.zzan("Activity context is not ready, cannot get window or decor view.");
                return;
            }
            int[] nArray = this.zzfB();
            if (nArray == null) {
                this.zzan("Resize location out of screen or close button is not visible.");
                return;
            }
            zzji.zzds();
            int n = zzaiy.zzc((Context)this.zzNo, (int)this.zzrW);
            zzji.zzds();
            int n2 = zzaiy.zzc((Context)this.zzNo, (int)this.zzrX);
            ViewParent viewParent = this.zzJH.getView().getParent();
            if (viewParent != null && viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(this.zzJH.getView());
                if (this.zzNI == null) {
                    this.zzNK = (ViewGroup)viewParent;
                    zzbs.zzbz();
                    bitmap = zzagz.zzl(this.zzJH.getView());
                    this.zzNF = new ImageView((Context)this.zzNo);
                    this.zzNF.setImageBitmap(bitmap);
                    this.zzuZ = this.zzJH.zzam();
                    this.zzNK.addView((View)this.zzNF);
                } else {
                    this.zzNI.dismiss();
                }
            } else {
                this.zzan("Webview is detached, probably in the middle of a resize or expand.");
                return;
            }
            this.zzNJ = new RelativeLayout((Context)this.zzNo);
            this.zzNJ.setBackgroundColor(0);
            this.zzNJ.setLayoutParams(new ViewGroup.LayoutParams(n, n2));
            zzbs.zzbz();
            this.zzNI = zzagz.zza((View)this.zzNJ, n, n2, false);
            this.zzNI.setOutsideTouchable(true);
            this.zzNI.setTouchable(true);
            this.zzNI.setClippingEnabled(!this.zzNA);
            this.zzNJ.addView(this.zzJH.getView(), -1, -1);
            this.zzNG = new LinearLayout((Context)this.zzNo);
            zzji.zzds();
            int n3 = zzaiy.zzc((Context)this.zzNo, (int)50);
            zzji.zzds();
            bitmap = new RelativeLayout.LayoutParams(n3, zzaiy.zzc((Context)this.zzNo, (int)50));
            switch (this.zzNz) {
                case "top-left": {
                    bitmap.addRule(10);
                    bitmap.addRule(9);
                    break;
                }
                case "top-center": {
                    bitmap.addRule(10);
                    bitmap.addRule(14);
                    break;
                }
                case "center": {
                    bitmap.addRule(13);
                    break;
                }
                case "bottom-left": {
                    bitmap.addRule(12);
                    bitmap.addRule(9);
                    break;
                }
                case "bottom-center": {
                    bitmap.addRule(12);
                    bitmap.addRule(14);
                    break;
                }
                case "bottom-right": {
                    bitmap.addRule(12);
                    bitmap.addRule(11);
                    break;
                }
                default: {
                    bitmap.addRule(10);
                    bitmap.addRule(11);
                }
            }
            this.zzNG.setOnClickListener((View.OnClickListener)new zzwl(this));
            this.zzNG.setContentDescription((CharSequence)"Close button");
            this.zzNJ.addView((View)this.zzNG, (ViewGroup.LayoutParams)bitmap);
            try {
                View view = window.getDecorView();
                zzji.zzds();
                int n4 = zzaiy.zzc((Context)this.zzNo, (int)nArray[0]);
                zzji.zzds();
                this.zzNI.showAtLocation(view, 0, n4, zzaiy.zzc((Context)this.zzNo, (int)nArray[1]));
            }
            catch (RuntimeException runtimeException) {
                String string3 = String.valueOf(runtimeException.getMessage());
                this.zzan(string3.length() != 0 ? "Cannot show popup window: ".concat(string3) : new String("Cannot show popup window: "));
                this.zzNJ.removeView(this.zzJH.getView());
                if (this.zzNK != null) {
                    this.zzNK.removeView((View)this.zzNF);
                    this.zzNK.addView(this.zzJH.getView());
                    this.zzJH.zza(this.zzuZ);
                }
                return;
            }
            int n5 = nArray[1];
            int n6 = nArray[0];
            zzwk2 = this;
            if (zzwk2.zzNH != null) {
                zzwk2.zzNH.zza(n6, n5, zzwk2.zzrW, zzwk2.zzrX);
            }
            this.zzJH.zza(new zziv((Context)this.zzNo, new AdSize(this.zzrW, this.zzrX)));
            this.zza(nArray[0], nArray[1]);
            this.zzap("resized");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzk(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzNI != null) {
                this.zzNI.dismiss();
                this.zzNJ.removeView(this.zzJH.getView());
                if (this.zzNK != null) {
                    this.zzNK.removeView((View)this.zzNF);
                    this.zzNK.addView(this.zzJH.getView());
                    this.zzJH.zza(this.zzuZ);
                }
                if (bl) {
                    this.zzap("default");
                    if (this.zzNH != null) {
                        this.zzNH.zzaN();
                    }
                }
                this.zzNI = null;
                this.zzNJ = null;
                this.zzNK = null;
                this.zzNG = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int[] zzfB() {
        zzwk zzwk2 = this;
        int[] nArray = zzbs.zzbz().zzg(zzwk2.zzNo);
        int[] nArray2 = zzbs.zzbz().zzh(zzwk2.zzNo);
        int n = nArray[0];
        int n2 = nArray[1];
        if (zzwk2.zzrW < 50 || zzwk2.zzrW > n) {
            zzafr.zzaT((String)"Width is too small or too large.");
            return null;
        }
        if (zzwk2.zzrX < 50 || zzwk2.zzrX > n2) {
            zzafr.zzaT((String)"Height is too small or too large.");
            return null;
        }
        if (zzwk2.zzrX == n2 && zzwk2.zzrW == n) {
            zzafr.zzaT((String)"Cannot resize to a full-screen ad.");
            return null;
        }
        if (zzwk2.zzNA) {
            int n3;
            int n4;
            switch (zzwk2.zzNz) {
                case "top-left": {
                    n4 = zzwk2.zzNB + zzwk2.zzND;
                    n3 = zzwk2.zzNC + zzwk2.zzNE;
                    break;
                }
                case "top-center": {
                    n4 = zzwk2.zzNB + zzwk2.zzND + zzwk2.zzrW / 2 - 25;
                    n3 = zzwk2.zzNC + zzwk2.zzNE;
                    break;
                }
                case "center": {
                    n4 = zzwk2.zzNB + zzwk2.zzND + zzwk2.zzrW / 2 - 25;
                    n3 = zzwk2.zzNC + zzwk2.zzNE + zzwk2.zzrX / 2 - 25;
                    break;
                }
                case "bottom-left": {
                    n4 = zzwk2.zzNB + zzwk2.zzND;
                    n3 = zzwk2.zzNC + zzwk2.zzNE + zzwk2.zzrX - 50;
                    break;
                }
                case "bottom-center": {
                    n4 = zzwk2.zzNB + zzwk2.zzND + zzwk2.zzrW / 2 - 25;
                    n3 = zzwk2.zzNC + zzwk2.zzNE + zzwk2.zzrX - 50;
                    break;
                }
                case "bottom-right": {
                    n4 = zzwk2.zzNB + zzwk2.zzND + zzwk2.zzrW - 50;
                    n3 = zzwk2.zzNC + zzwk2.zzNE + zzwk2.zzrX - 50;
                    break;
                }
                default: {
                    n4 = zzwk2.zzNB + zzwk2.zzND + zzwk2.zzrW - 50;
                    n3 = zzwk2.zzNC + zzwk2.zzNE;
                }
            }
            if (n4 < 0) return null;
            if (n4 + 50 > n) return null;
            if (n3 < nArray2[0]) return null;
            if (n3 + 50 > nArray2[1]) {
                return null;
            }
        }
        boolean bl = true;
        if (!bl) {
            return null;
        }
        if (this.zzNA) {
            return new int[]{this.zzNB + this.zzND, this.zzNC + this.zzNE};
        }
        int[] nArray3 = zzbs.zzbz().zzg(this.zzNo);
        int[] nArray4 = zzbs.zzbz().zzh(this.zzNo);
        int n5 = nArray3[0];
        int n6 = this.zzNB + this.zzND;
        int n7 = this.zzNC + this.zzNE;
        if (n6 < 0) {
            n6 = 0;
        } else if (n6 + this.zzrW > n5) {
            n6 = n5 - this.zzrW;
        }
        if (n7 < nArray4[0]) {
            n7 = nArray4[0];
            return new int[]{n6, n7};
        } else {
            if (n7 + this.zzrX <= nArray4[1]) return new int[]{n6, n7};
            n7 = nArray4[1] - this.zzrX;
        }
        return new int[]{n6, n7};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(int n, int n2, boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzNB = n;
            this.zzNC = n2;
            if (this.zzNI != null && bl) {
                int[] nArray = this.zzfB();
                if (nArray != null) {
                    zzji.zzds();
                    int n3 = zzaiy.zzc((Context)this.zzNo, (int)nArray[0]);
                    zzji.zzds();
                    this.zzNI.update(n3, zzaiy.zzc((Context)this.zzNo, (int)nArray[1]), this.zzNI.getWidth(), this.zzNI.getHeight());
                    this.zza(nArray[0], nArray[1]);
                } else {
                    this.zzk(true);
                }
            }
            return;
        }
    }

    private final void zza(int n, int n2) {
        int n3 = zzbs.zzbz().zzh(this.zzNo)[0];
        this.zzb(n, n2 - n3, this.zzrW, this.zzrX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzfC() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzNI != null;
        }
    }

    public final void zzb(int n, int n2) {
        this.zzNB = n;
        this.zzNC = n2;
    }
}

