/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.net.Uri;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzaka;
import com.google.android.gms.internal.zzwo;
import com.google.android.gms.internal.zzwp;
import com.google.android.gms.internal.zzwu;
import com.google.android.gms.internal.zzzn;
import java.util.Map;

@zzzn
public final class zzwn
extends zzwu {
    private final Map<String, String> zzHa;
    private final Context mContext;

    public zzwn(zzaka zzaka2, Map<String, String> map) {
        super(zzaka2, "storePicture");
        this.zzHa = map;
        this.mContext = zzaka2.zzis();
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzan("Activity context is not available");
            return;
        }
        zzbs.zzbz();
        if (!zzagz.zzH(this.mContext).zzdG()) {
            this.zzan("Feature is not supported by the device.");
            return;
        }
        String string2 = this.zzHa.get("iurl");
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.zzan("Image url cannot be empty.");
            return;
        }
        if (!URLUtil.isValidUrl((String)string2)) {
            String string3 = String.valueOf(string2);
            this.zzan(string3.length() != 0 ? "Invalid image url: ".concat(string3) : new String("Invalid image url: "));
            return;
        }
        String string4 = Uri.parse((String)string2).getLastPathSegment();
        zzbs.zzbz();
        if (!zzagz.zzaK(string4)) {
            String string5 = String.valueOf(string4);
            this.zzan(string5.length() != 0 ? "Image type not recognized: ".concat(string5) : new String("Image type not recognized: "));
            return;
        }
        Resources resources = zzbs.zzbD().getResources();
        zzbs.zzbz();
        AlertDialog.Builder builder = zzagz.zzG(this.mContext);
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s1) : "Save image"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s2) : "Allow Ad to store image in Picture gallery?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzwo(this, string2, string4));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzwp(this));
        builder.create().show();
    }

    static /* synthetic */ Context zza(zzwn zzwn2) {
        return zzwn2.mContext;
    }
}

