/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewParent;
import com.google.android.gms.ads.internal.overlay.zzag;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzbi;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.ads.internal.zzbt;
import com.google.android.gms.ads.internal.zzbu;
import com.google.android.gms.ads.internal.zzc;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.internal.zzbo;
import com.google.android.gms.common.util.zzj;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzacq;
import com.google.android.gms.internal.zzacv;
import com.google.android.gms.internal.zzadd;
import com.google.android.gms.internal.zzaee;
import com.google.android.gms.internal.zzaez;
import com.google.android.gms.internal.zzaff;
import com.google.android.gms.internal.zzafg;
import com.google.android.gms.internal.zzafh;
import com.google.android.gms.internal.zzafm;
import com.google.android.gms.internal.zzafn;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzagz;
import com.google.android.gms.internal.zzaiy;
import com.google.android.gms.internal.zzfh;
import com.google.android.gms.internal.zzim;
import com.google.android.gms.internal.zzir;
import com.google.android.gms.internal.zzis;
import com.google.android.gms.internal.zziv;
import com.google.android.gms.internal.zzji;
import com.google.android.gms.internal.zzjl;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzka;
import com.google.android.gms.internal.zzke;
import com.google.android.gms.internal.zzkk;
import com.google.android.gms.internal.zzks;
import com.google.android.gms.internal.zzky;
import com.google.android.gms.internal.zzlv;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzmz;
import com.google.android.gms.internal.zznb;
import com.google.android.gms.internal.zznh;
import com.google.android.gms.internal.zzqk;
import com.google.android.gms.internal.zzxg;
import com.google.android.gms.internal.zzxo;
import com.google.android.gms.internal.zzxy;
import com.google.android.gms.internal.zzzn;
import com.google.android.gms.internal.zzzp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;

@zzzn
public abstract class zza
extends zzka
implements zzag,
zzafm,
zzim,
zzqk,
zzxy,
zzzp {
    protected zznb zzsK;
    private zzmz zzsL;
    private zzmz zzsM;
    protected boolean zzsN = false;
    protected final zzbi zzsO;
    protected final zzbt zzsP;
    @Nullable
    protected transient zzir zzsQ;
    protected final zzfh zzsR;
    protected final zzv zzsS;

    public final zzv zzak() {
        return this.zzsS;
    }

    zza(zzbt zzbt2, @Nullable zzbi zzbi2, zzv zzv2) {
        this.zzsP = zzbt2;
        this.zzsO = new zzbi(this);
        this.zzsS = zzv2;
        zzbs.zzbz().zzE(this.zzsP.zzqD);
        zzbs.zzbD().zzd(this.zzsP.zzqD, this.zzsP.zzvT);
        zzbs.zzbE().initialize(this.zzsP.zzqD);
        this.zzsR = zzbs.zzbD().zzhG();
        zzbs.zzbC().initialize(this.zzsP.zzqD);
        zza zza2 = this;
        zzme<Long> zzme2 = zzmo.zzFE;
        if (zzbs.zzbL().zzd(zzme2).booleanValue()) {
            CountDownLatch countDownLatch;
            Timer timer = new Timer();
            zzme2 = zzmo.zzFG;
            CountDownLatch countDownLatch2 = countDownLatch = new CountDownLatch((Integer)((Object)zzbs.zzbL().zzd(zzme2)));
            Timer timer2 = timer;
            zzme2 = zza2;
            zzb zzb2 = new zzb((zza)((Object)zzme2), countDownLatch2, timer2);
            zzme2 = zzmo.zzFF;
            timer.schedule((TimerTask)zzb2, 0L, (long)zzbs.zzbL().zzd(zzme2));
        }
    }

    public void destroy() {
        zzbt zzbt2;
        zzbo.zzcz((String)"destroy must be called on the main UI thread.");
        this.zzsO.cancel();
        this.zzsR.zzh(this.zzsP.zzvY);
        zzbt zzbt3 = zzbt2 = this.zzsP;
        if (zzbt2.zzvU != null) {
            zzbt3.zzvU.zzcg();
        }
        zzbt2.zzwc = null;
        zzbt2.zzwd = null;
        zzbt2.zzwo = null;
        zzbt2.zzwe = null;
        zzbt2.zze(false);
        if (zzbt2.zzvU != null) {
            zzbt2.zzvU.removeAllViews();
        }
        zzbt2.zzca();
        zzbt2.zzcb();
        zzbt2.zzvY = null;
    }

    public final IObjectWrapper zzal() {
        zzbo.zzcz((String)"getAdFrame must be called on the main UI thread.");
        return zzn.zzw((Object)((Object)this.zzsP.zzvU));
    }

    @Nullable
    public final zziv zzam() {
        zzbo.zzcz((String)"getAdSize must be called on the main UI thread.");
        if (this.zzsP.zzvX == null) {
            return null;
        }
        return new zzlv(this.zzsP.zzvX);
    }

    public final boolean isReady() {
        zzbo.zzcz((String)"isLoaded must be called on the main UI thread.");
        return this.zzsP.zzvV == null && this.zzsP.zzvW == null && this.zzsP.zzvY != null;
    }

    public void setManualImpressionsEnabled(boolean bl) {
        throw new UnsupportedOperationException("Attempt to call setManualImpressionsEnabled for an unsupported ad type.");
    }

    public boolean zza(zzir zzir2) {
        zzbo.zzcz((String)"loadAd must be called on the main UI thread.");
        zzbs.zzbE().zzcX();
        Object object = zzmo.zzDR;
        if (zzbs.zzbL().zzd(object).booleanValue()) {
            zzir.zzh((zzir)zzir2);
        }
        Object object2 = zzir2;
        zzir zzir3 = zzir2 = zzj.zzaI((Context)this.zzsP.zzqD) && object2.zzzV != null ? new zzis(object2).zza(null).zzdj() : object2;
        if (this.zzsP.zzvV != null || this.zzsP.zzvW != null) {
            if (this.zzsQ != null) {
                zzafr.zzaT((String)"Aborting last ad request since another ad request is already in progress. The current request object will still be cached for future refreshes.");
            } else {
                zzafr.zzaT((String)"Loading already in progress, saving this object for future refreshes.");
            }
            this.zzsQ = zzir2;
            return false;
        }
        zzafr.zzaS((String)"Starting ad request.");
        object = this;
        object2 = zzmo.zzCQ;
        this.zzsK = new zznb((Boolean)zzbs.zzbL().zzd(object2), "load_ad", ((zza)object).zzsP.zzvX.zzAs);
        ((zza)object).zzsL = new zzmz(-1L, null, null);
        ((zza)object).zzsM = new zzmz(-1L, null, null);
        this.zzsL = this.zzsK.zzdS();
        if (zzir2.zzzQ) {
            zzafr.zzaS((String)"This request is sent from a test device.");
        } else {
            zzji.zzds();
            String string = String.valueOf(zzaiy.zzV((Context)this.zzsP.zzqD));
            zzafr.zzaS((String)new StringBuilder(71 + String.valueOf(string).length()).append("Use AdRequest.Builder.addTestDevice(\"").append(string).append("\") to get test ads on this device.").toString());
        }
        this.zzsO.zzf(zzir2);
        this.zzsN = this.zza(zzir2, this.zzsK);
        return this.zzsN;
    }

    protected abstract boolean zza(zzir var1, zznb var2);

    @Override
    public final void zza(zzafg zzafg2) {
        long l;
        if (zzafg2.zzXY.zzTs != -1L && !TextUtils.isEmpty((CharSequence)zzafg2.zzXY.zzTB) && (l = zza.zzr(zzafg2.zzXY.zzTB)) != -1L) {
            zzmz zzmz2 = this.zzsK.zzc(zzafg2.zzXY.zzTs + l);
            this.zzsK.zza(zzmz2, "stc");
        }
        this.zzsK.zzO(zzafg2.zzXY.zzTB);
        this.zzsK.zza(this.zzsL, "arf");
        this.zzsM = this.zzsK.zzdS();
        this.zzsK.zzh("gqi", zzafg2.zzXY.zzTC);
        this.zzsP.zzvV = null;
        this.zzsP.zzvZ = zzafg2;
        zzafg2.zzXX.zza(new zzc(this, zzafg2));
        zzafg2.zzXX.zzdf();
        this.zza(zzafg2, this.zzsK);
    }

    protected abstract void zza(zzafg var1, zznb var2);

    boolean zza(zzaff zzaff2) {
        return false;
    }

    @Override
    public void zzb(zzaff zzaff2) {
        this.zzsK.zza(this.zzsM, "awr");
        this.zzsP.zzvW = null;
        if (zzaff2.errorCode != -2 && zzaff2.errorCode != 3) {
            zzbs.zzbD().zzb(this.zzsP.zzbZ());
        }
        if (zzaff2.errorCode == -1) {
            this.zzsN = false;
            return;
        }
        if (this.zza(zzaff2)) {
            zzafr.zzaC((String)"Ad refresh scheduled.");
        }
        if (zzaff2.errorCode != -2) {
            this.zze(zzaff2.errorCode);
            return;
        }
        if (this.zzsP.zzwr == null) {
            this.zzsP.zzwr = new zzafn(this.zzsP.zzvR);
        }
        this.zzsR.zzg(this.zzsP.zzvY);
        if (this.zza(this.zzsP.zzvY, zzaff2)) {
            this.zzsP.zzvY = zzaff2;
            zzbt zzbt2 = this.zzsP;
            if (zzbt2.zzwa != null) {
                if (zzbt2.zzvY != null) {
                    zzbt2.zzwa.zzh(zzbt2.zzvY.zzXR);
                    zzbt2.zzwa.zzi(zzbt2.zzvY.zzXS);
                    zzbt2.zzwa.zzw(zzbt2.zzvY.zzTo);
                }
                zzbt2.zzwa.zzv(zzbt2.zzvX.zzAt);
            }
            this.zzsK.zzh("is_mraid", this.zzsP.zzvY.zzcn() ? "1" : "0");
            this.zzsK.zzh("is_mediation", this.zzsP.zzvY.zzTo ? "1" : "0");
            if (this.zzsP.zzvY.zzPg != null && this.zzsP.zzvY.zzPg.zziw() != null) {
                this.zzsK.zzh("is_delay_pl", this.zzsP.zzvY.zzPg.zziw().zziS() ? "1" : "0");
            }
            this.zzsK.zza(this.zzsL, "ttc");
            if (zzbs.zzbD().zzhr() != null) {
                zzbs.zzbD().zzhr().zza(this.zzsK);
            }
            this.zzaw();
            if (this.zzsP.zzcc()) {
                this.zzas();
            }
        }
        if (zzaff2.zzMd != null) {
            zzbs.zzbz().zza(this.zzsP.zzqD, zzaff2.zzMd);
        }
    }

    protected abstract boolean zza(@Nullable zzaff var1, zzaff var2);

    public void onAdClicked() {
        if (this.zzsP.zzvY == null) {
            zzafr.zzaT((String)"Ad state was null when trying to ping click URLs.");
            return;
        }
        zzafr.zzaC((String)"Pinging click URLs.");
        if (this.zzsP.zzwa != null) {
            this.zzsP.zzwa.zzhd();
        }
        if (this.zzsP.zzvY.zzMa != null) {
            zzbs.zzbz();
            zzagz.zza(this.zzsP.zzqD, this.zzsP.zzvT.zzaP, this.zzb(this.zzsP.zzvY.zzMa));
        }
        if (this.zzsP.zzwb != null) {
            try {
                this.zzsP.zzwb.onAdClicked();
                return;
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not notify onAdClicked event.", (Throwable)remoteException);
            }
        }
    }

    @Override
    public final void zzan() {
        this.zzaq();
    }

    @Override
    public final void onAppEvent(String string, @Nullable String string2) {
        if (this.zzsP.zzwd != null) {
            try {
                this.zzsP.zzwd.onAppEvent(string, string2);
                return;
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call the AppEventListener.", (Throwable)remoteException);
            }
        }
    }

    public final void zzao() {
        zzbo.zzcz((String)"recordManualImpression must be called on the main UI thread.");
        if (this.zzsP.zzvY == null) {
            zzafr.zzaT((String)"Ad state was null when trying to ping manual tracking URLs.");
            return;
        }
        zzafr.zzaC((String)"Pinging manual tracking URLs.");
        if (this.zzsP.zzvY.zzTq != null && !this.zzsP.zzvY.zzXV) {
            zzbs.zzbz();
            zzagz.zza(this.zzsP.zzqD, this.zzsP.zzvT.zzaP, this.zzsP.zzvY.zzTq);
            this.zzsP.zzvY.zzXV = true;
        }
    }

    public void pause() {
        zzbo.zzcz((String)"pause must be called on the main UI thread.");
    }

    public void resume() {
        zzbo.zzcz((String)"resume must be called on the main UI thread.");
    }

    protected boolean zzb(zzir zzir2) {
        if (this.zzsP.zzvU == null) {
            return false;
        }
        ViewParent viewParent = this.zzsP.zzvU.getParent();
        if (!(viewParent instanceof View)) {
            return false;
        }
        View view = (View)viewParent;
        return zzbs.zzbz().zza(view, view.getContext());
    }

    public final void zza(zzjo zzjo2) {
        zzbo.zzcz((String)"setAdListener must be called on the main UI thread.");
        this.zzsP.zzwc = zzjo2;
    }

    public final void zza(zzadd zzadd2) {
        zzbo.zzcz((String)"setRewardedVideoAdListener can only be called from the UI thread.");
        this.zzsP.zzwp = zzadd2;
    }

    public final void setUserId(String string) {
        zzafr.zzaT((String)"RewardedVideoAd.setUserId() is deprecated. Please do not call this method.");
    }

    public final void zza(zzjl zzjl2) {
        zzbo.zzcz((String)"setAdListener must be called on the main UI thread.");
        this.zzsP.zzwb = zzjl2;
    }

    public final void zza(zziv zziv2) {
        zzbo.zzcz((String)"setAdSize must be called on the main UI thread.");
        this.zzsP.zzvX = zziv2;
        if (this.zzsP.zzvY != null && this.zzsP.zzvY.zzPg != null && this.zzsP.zzwt == 0) {
            this.zzsP.zzvY.zzPg.zza(zziv2);
        }
        if (this.zzsP.zzvU == null) {
            return;
        }
        if (this.zzsP.zzvU.getChildCount() > 1) {
            this.zzsP.zzvU.removeView(this.zzsP.zzvU.getNextView());
        }
        this.zzsP.zzvU.setMinimumWidth(zziv2.widthPixels);
        this.zzsP.zzvU.setMinimumHeight(zziv2.heightPixels);
        this.zzsP.zzvU.requestLayout();
    }

    public final void zza(zzke zzke2) {
        zzbo.zzcz((String)"setAppEventListener must be called on the main UI thread.");
        this.zzsP.zzwd = zzke2;
    }

    public void zza(zzxg zzxg2) {
        zzafr.zzaT((String)"setInAppPurchaseListener is deprecated and should not be called.");
    }

    public void zza(zznh zznh2) {
        throw new IllegalStateException("setOnCustomRenderedAdLoadedListener is not supported for current ad type");
    }

    public final void zza(zzxo zzxo2, String string) {
        zzafr.zzaT((String)"setPlayStorePurchaseParams is deprecated and should not be called.");
    }

    public final void zza(zzkk zzkk2) {
        zzbo.zzcz((String)"setCorrelationIdProvider must be called on the main UI thread");
        this.zzsP.zzwe = zzkk2;
    }

    public final void stopLoading() {
        zzbo.zzcz((String)"stopLoading must be called on the main UI thread.");
        this.zzsN = false;
        this.zzsP.zze(true);
    }

    public final boolean isLoading() {
        return this.zzsN;
    }

    public zzks getVideoController() {
        return null;
    }

    public final void zza(@Nullable zzlx zzlx2) {
        zzbo.zzcz((String)"setVideoOptions must be called on the main UI thread.");
        this.zzsP.zzwk = zzlx2;
    }

    public final void zza(@Nullable zzky zzky2) {
        zzbo.zzcz((String)"setIconAdOptions must be called on the main UI thread.");
        this.zzsP.zzwl = zzky2;
    }

    public void setImmersiveMode(boolean bl) {
        throw new IllegalStateException("onImmersiveModeUpdated is not supported for current ad type");
    }

    private static long zzr(String string) {
        int n = string.indexOf("ufe");
        int n2 = string.indexOf(44, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        try {
            return Long.parseLong(string.substring(n + 4, n2));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            zzafr.zzaT((String)"Invalid index for Url fetch time in CSI latency info.");
        }
        catch (NumberFormatException numberFormatException) {
            zzafr.zzaT((String)"Cannot find valid format of Url fetch time in CSI latency info.");
        }
        return -1L;
    }

    protected final void zzb(View view) {
        zzbu zzbu2 = this.zzsP.zzvU;
        if (zzbu2 != null) {
            zzbu2.addView(view, zzbs.zzbB().zzhW());
        }
    }

    protected void zzap() {
        zzafr.zzaS((String)"Ad closing.");
        if (this.zzsP.zzwc != null) {
            try {
                this.zzsP.zzwc.onAdClosed();
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call AdListener.onAdClosed().", (Throwable)remoteException);
            }
        }
        if (this.zzsP.zzwp != null) {
            try {
                this.zzsP.zzwp.onRewardedVideoAdClosed();
                return;
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdClosed().", (Throwable)remoteException);
            }
        }
    }

    protected final void zzaq() {
        zzafr.zzaS((String)"Ad leaving application.");
        if (this.zzsP.zzwc != null) {
            try {
                this.zzsP.zzwc.onAdLeftApplication();
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call AdListener.onAdLeftApplication().", (Throwable)remoteException);
            }
        }
        if (this.zzsP.zzwp != null) {
            try {
                this.zzsP.zzwp.onRewardedVideoAdLeftApplication();
                return;
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call  RewardedVideoAdListener.onRewardedVideoAdLeftApplication().", (Throwable)remoteException);
            }
        }
    }

    protected final void zzar() {
        zzafr.zzaS((String)"Ad opening.");
        if (this.zzsP.zzwc != null) {
            try {
                this.zzsP.zzwc.onAdOpened();
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call AdListener.onAdOpened().", (Throwable)remoteException);
            }
        }
        if (this.zzsP.zzwp != null) {
            try {
                this.zzsP.zzwp.onRewardedVideoAdOpened();
                return;
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdOpened().", (Throwable)remoteException);
            }
        }
    }

    protected void zzas() {
        zzafr.zzaS((String)"Ad finished loading.");
        this.zzsN = false;
        if (this.zzsP.zzwc != null) {
            try {
                this.zzsP.zzwc.onAdLoaded();
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call AdListener.onAdLoaded().", (Throwable)remoteException);
            }
        }
        if (this.zzsP.zzwp != null) {
            try {
                this.zzsP.zzwp.onRewardedVideoAdLoaded();
                return;
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdLoaded().", (Throwable)remoteException);
            }
        }
    }

    protected void zze(int n) {
        zzafr.zzaT((String)new StringBuilder(30).append("Failed to load ad: ").append(n).toString());
        this.zzsN = false;
        if (this.zzsP.zzwc != null) {
            try {
                this.zzsP.zzwc.onAdFailedToLoad(n);
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call AdListener.onAdFailedToLoad().", (Throwable)remoteException);
            }
        }
        if (this.zzsP.zzwp != null) {
            try {
                this.zzsP.zzwp.onRewardedVideoAdFailedToLoad(n);
                return;
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call RewardedVideoAdListener.onRewardedVideoAdFailedToLoad().", (Throwable)remoteException);
            }
        }
    }

    public final void zzat() {
        zzafr.zzaS((String)"Ad impression.");
        if (this.zzsP.zzwc != null) {
            try {
                this.zzsP.zzwc.onAdImpression();
                return;
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call AdListener.onAdImpression().", (Throwable)remoteException);
            }
        }
    }

    public final void zzau() {
        zzafr.zzaS((String)"Ad clicked.");
        if (this.zzsP.zzwc != null) {
            try {
                this.zzsP.zzwc.onAdClicked();
                return;
            }
            catch (RemoteException remoteException) {
                zzafr.zzc((String)"Could not call AdListener.onAdClicked().", (Throwable)remoteException);
            }
        }
    }

    protected final void zzav() {
        if (this.zzsP.zzwp == null) {
            return;
        }
        try {
            this.zzsP.zzwp.onRewardedVideoStarted();
            return;
        }
        catch (RemoteException remoteException) {
            zzafr.zzc((String)"Could not call RewardedVideoAdListener.onVideoStarted().", (Throwable)remoteException);
            return;
        }
    }

    protected final void zza(@Nullable zzaee zzaee2) {
        if (this.zzsP.zzwp == null) {
            return;
        }
        try {
            String string = "";
            int n = 1;
            if (zzaee2 != null) {
                string = zzaee2.type;
                n = zzaee2.zzWW;
            }
            this.zzsP.zzwp.zza((zzacv)new zzacq(string, n));
            return;
        }
        catch (RemoteException remoteException) {
            zzafr.zzc((String)"Could not call RewardedVideoAdListener.onRewarded().", (Throwable)remoteException);
            return;
        }
    }

    public final void zzaw() {
        zzaff zzaff2 = this.zzsP.zzvY;
        zza zza2 = this;
        if (zzaff2 == null || TextUtils.isEmpty((CharSequence)zzaff2.zzTK) || zzaff2.zzXW || !zzbs.zzbH().zzic()) {
            return;
        }
        zzafr.zzaC((String)"Sending troubleshooting signals to the server.");
        zzbs.zzbH().zza(zza2.zzsP.zzqD, zza2.zzsP.zzvT.zzaP, zzaff2.zzTK, zza2.zzsP.zzvR);
        zzaff2.zzXW = true;
    }

    @Override
    public final void zza(HashSet<zzafh> hashSet) {
        this.zzsP.zza(hashSet);
    }

    protected final List<String> zzb(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            arrayList.add(zzaez.zzb(string, this.zzsP.zzqD));
        }
        return arrayList;
    }

    public String getAdUnitId() {
        return this.zzsP.zzvR;
    }

    public final zzke zzax() {
        return this.zzsP.zzwd;
    }

    public final zzjo zzay() {
        return this.zzsP.zzwc;
    }
}

