/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.text.TextUtils;
import android.webkit.WebSettings;
import com.google.android.gms.ads.internal.zzbs;
import com.google.android.gms.common.zzo;
import com.google.android.gms.internal.zzafr;
import com.google.android.gms.internal.zzahm;
import com.google.android.gms.internal.zzait;
import com.google.android.gms.internal.zzaiu;
import com.google.android.gms.internal.zzaiv;
import java.io.File;

@TargetApi(value=17)
public class zzahk
extends zzahm {
    @Override
    public final boolean zza(Context context, WebSettings webSettings) {
        super.zza(context, webSettings);
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        return true;
    }

    @Override
    public final String getDefaultUserAgent(Context context) {
        Context context2 = context;
        zzaiu zzaiu2 = zzaiu.zzif();
        Context context3 = context2;
        zzaiu zzaiu3 = zzaiu2;
        if (TextUtils.isEmpty((CharSequence)zzaiu2.zzJP)) {
            String string2;
            Context context4 = zzo.getRemoteContext((Context)context3);
            zzaiu3.zzJP = string2 = zzait.zzb(new zzaiv(zzaiu3, context4, context3));
        }
        return zzaiu2.zzJP;
    }

    @Override
    public final void zzR(Context context) {
        Context context2 = context;
        zzaiu zzaiu2 = zzaiu.zzif();
        zzafr.v("Updating user agent.");
        String string2 = WebSettings.getDefaultUserAgent((Context)context2);
        if (!string2.equals(zzaiu2.zzJP)) {
            Context context3 = zzo.getRemoteContext((Context)context2);
            if (context3 == null) {
                String string3 = WebSettings.getDefaultUserAgent((Context)context2);
                SharedPreferences.Editor editor = context2.getSharedPreferences("admob_user_agent", 0).edit().putString("user_agent", string3);
                if (context3 == null) {
                    editor.apply();
                } else {
                    String string4 = "admob_user_agent";
                    SharedPreferences.Editor editor2 = editor;
                    Context context4 = context2;
                    File file = new File(context4.getApplicationInfo().dataDir, "shared_prefs");
                    File file2 = file.getParentFile();
                    if (file2 != null) {
                        file2.setExecutable(true, false);
                    }
                    file.setExecutable(true, false);
                    editor2.commit();
                    new File(file, String.valueOf(string4).concat(".xml")).setReadable(true, false);
                }
            }
            zzaiu2.zzJP = string2;
        }
        zzafr.v("User agent is updated.");
        zzbs.zzbD().zzhH();
    }

    @Override
    public final Drawable zza(Context context, Bitmap bitmap, boolean bl, float f) {
        if (!bl || f <= 0.0f || f > 25.0f) {
            return new BitmapDrawable(context.getResources(), bitmap);
        }
        try {
            Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (boolean)false);
            Bitmap bitmap3 = Bitmap.createBitmap((Bitmap)bitmap2);
            RenderScript renderScript = RenderScript.create((Context)context);
            ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
            Allocation allocation = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap2);
            Allocation allocation2 = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap3);
            scriptIntrinsicBlur.setRadius(f);
            scriptIntrinsicBlur.setInput(allocation);
            scriptIntrinsicBlur.forEach(allocation2);
            allocation2.copyTo(bitmap3);
            return new BitmapDrawable(context.getResources(), bitmap3);
        }
        catch (RuntimeException runtimeException) {
            return new BitmapDrawable(context.getResources(), bitmap);
        }
    }
}

