/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zza;
import com.google.android.gms.ads.internal.overlay.zzae;
import com.google.android.gms.ads.internal.overlay.zzaf;
import com.google.android.gms.ads.internal.overlay.zzaj;
import com.google.android.gms.ads.internal.overlay.zzn;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.ads.internal.overlay.zzr;
import com.google.android.gms.ads.internal.overlay.zzs;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzahk;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzxh;
import com.google.android.gms.internal.zzzt;
import java.util.Collections;

@zzzt
public final class zzm
extends zzxh
implements zzaj {
    private static int zzcfy = Color.argb((int)0, (int)0, (int)0, (int)0);
    private final Activity mActivity;
    AdOverlayInfoParcel zzcfz;
    private zzakk zzbvz;
    private zzr zzcga;
    private zzae zzcgb;
    private boolean zzcgc = false;
    private FrameLayout zzcgd;
    private WebChromeClient.CustomViewCallback zzcge;
    private boolean zzcgf = false;
    private boolean zzcgg = false;
    private zzq zzcgh;
    private boolean zzcgi = false;
    private int zzcgj = 0;
    private final Object zzcgk = new Object();
    private Runnable zzcgl;
    private boolean zzcgm;
    private boolean zzcgn;
    private boolean zzcgo = false;
    private boolean zzcgp = false;
    private boolean zzcgq = true;

    public zzm(Activity activity) {
        this.mActivity = activity;
    }

    public final void close() {
        this.zzcgj = 2;
        this.mActivity.finish();
    }

    public final void zzml() {
        if (this.zzcfz != null && this.zzcgc) {
            this.setRequestedOrientation(this.zzcfz.orientation);
        }
        if (this.zzcgd != null) {
            this.mActivity.setContentView((View)this.zzcgh);
            this.zzcgn = true;
            this.zzcgd.removeAllViews();
            this.zzcgd = null;
        }
        if (this.zzcge != null) {
            this.zzcge.onCustomViewHidden();
            this.zzcge = null;
        }
        this.zzcgc = false;
    }

    @Override
    public final void zzmm() {
        this.zzcgj = 1;
        this.mActivity.finish();
    }

    public final void onBackPressed() {
        this.zzcgj = 0;
    }

    public final boolean zzmn() {
        this.zzcgj = 0;
        if (this.zzbvz == null) {
            return true;
        }
        boolean bl = this.zzbvz.zzsh();
        if (!bl) {
            this.zzbvz.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public final void onCreate(Bundle bundle) {
        this.mActivity.requestWindowFeature(1);
        this.zzcgf = bundle != null ? bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false) : false;
        try {
            this.zzcfz = AdOverlayInfoParcel.zzb(this.mActivity.getIntent());
            if (this.zzcfz == null) {
                throw new zzp("Could not get info for ad overlay.");
            }
            if (this.zzcfz.zzatj.zzdem > 7500000) {
                this.zzcgj = 3;
            }
            if (this.mActivity.getIntent() != null) {
                this.zzcgq = this.mActivity.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzcgg = this.zzcfz.zzchh != null ? this.zzcfz.zzchh.zzapy : false;
            zzmk<Boolean> zzmk2 = zzmu.zzbmi;
            if (zzbv.zzen().zzd(zzmk2).booleanValue() && this.zzcgg && this.zzcfz.zzchh.zzaqd != -1) {
                new zzs(this, null).zzqq();
            }
            if (bundle == null) {
                if (this.zzcfz.zzcgy != null && this.zzcgq) {
                    this.zzcfz.zzcgy.zzca();
                }
                if (this.zzcfz.zzchf != 1 && this.zzcfz.zzcgx != null) {
                    this.zzcfz.zzcgx.onAdClicked();
                }
            }
            this.zzcgh = new zzq((Context)this.mActivity, this.zzcfz.zzchg, this.zzcfz.zzatj.zzcp);
            this.zzcgh.setId(1000);
            switch (this.zzcfz.zzchf) {
                case 1: {
                    this.zzt(false);
                    return;
                }
                case 2: {
                    this.zzcga = new zzr(this.zzcfz.zzcgz);
                    this.zzt(false);
                    return;
                }
                case 3: {
                    this.zzt(true);
                    return;
                }
                case 4: {
                    if (this.zzcgf) {
                        this.zzcgj = 3;
                        this.mActivity.finish();
                        return;
                    }
                    zzbv.zzdx();
                    if (zza.zza((Context)this.mActivity, this.zzcfz.zzcgw, this.zzcfz.zzche)) break;
                    this.zzcgj = 3;
                    this.mActivity.finish();
                    return;
                }
                default: {
                    throw new zzp("Could not determine ad overlay type.");
                }
            }
            return;
        }
        catch (zzp zzp2) {
            zzafx.zzcs((String)zzp2.getMessage());
            this.zzcgj = 3;
            this.mActivity.finish();
            return;
        }
    }

    public final void onRestart() {
    }

    public final void onStart() {
        zzmk<Boolean> zzmk2 = zzmu.zzbpf;
        if (zzbv.zzen().zzd(zzmk2).booleanValue()) {
            if (this.zzbvz != null && !this.zzbvz.isDestroyed()) {
                zzbv.zzec();
                zzahk.zzl(this.zzbvz);
                return;
            }
            zzafx.zzcs((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onResume() {
        if (this.zzcfz != null && this.zzcfz.zzchf == 4) {
            if (this.zzcgf) {
                this.zzcgj = 3;
                this.mActivity.finish();
            } else {
                this.zzcgf = true;
            }
        }
        if (this.zzcfz.zzcgy != null) {
            this.zzcfz.zzcgy.onResume();
        }
        zzmk<Boolean> zzmk2 = zzmu.zzbpf;
        if (!zzbv.zzen().zzd(zzmk2).booleanValue()) {
            if (this.zzbvz != null && !this.zzbvz.isDestroyed()) {
                zzbv.zzec();
                zzahk.zzl(this.zzbvz);
                return;
            }
            zzafx.zzcs((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onPause() {
        this.zzml();
        if (this.zzcfz.zzcgy != null) {
            this.zzcfz.zzcgy.onPause();
        }
        zzmk<Boolean> zzmk2 = zzmu.zzbpf;
        if (!(zzbv.zzen().zzd(zzmk2).booleanValue() || this.zzbvz == null || this.mActivity.isFinishing() && this.zzcga != null)) {
            zzbv.zzec();
            zzahk.zzk(this.zzbvz);
        }
        this.zzmp();
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
    }

    public final void zzo(IObjectWrapper iObjectWrapper) {
        zzmk<Boolean> zzmk2 = zzmu.zzbpe;
        if (zzbv.zzen().zzd(zzmk2).booleanValue() && com.google.android.gms.common.util.zzp.isAtLeastN()) {
            Configuration configuration = (Configuration)com.google.android.gms.dynamic.zzn.zzab((IObjectWrapper)iObjectWrapper);
            zzbv.zzea();
            if (zzahf.zza(this.mActivity, configuration)) {
                this.mActivity.getWindow().addFlags(1024);
                this.mActivity.getWindow().clearFlags(2048);
                return;
            }
            this.mActivity.getWindow().addFlags(2048);
            this.mActivity.getWindow().clearFlags(1024);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzcgf);
    }

    public final void onStop() {
        zzmk<Boolean> zzmk2 = zzmu.zzbpf;
        if (zzbv.zzen().zzd(zzmk2).booleanValue() && this.zzbvz != null && (!this.mActivity.isFinishing() || this.zzcga == null)) {
            zzbv.zzec();
            zzahk.zzk(this.zzbvz);
        }
        this.zzmp();
    }

    public final void onDestroy() {
        if (this.zzbvz != null) {
            zzakk zzakk2 = this.zzbvz;
            if (zzakk2 == null) {
                throw null;
            }
            this.zzcgh.removeView((View)zzakk2);
        }
        this.zzmp();
    }

    private final void zzs(boolean bl) {
        zzmk<Integer> zzmk2 = zzmu.zzbpg;
        int n = zzbv.zzen().zzd(zzmk2);
        zzaf zzaf2 = new zzaf();
        new zzaf().size = 50;
        zzaf2.paddingLeft = bl ? n : 0;
        zzaf2.paddingRight = bl ? 0 : n;
        zzaf2.paddingTop = 0;
        zzaf2.paddingBottom = n;
        this.zzcgb = new zzae((Context)this.mActivity, zzaf2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zzcgb.zza(bl, this.zzcfz.zzchc);
        this.zzcgh.addView((View)this.zzcgb, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void zzay() {
        this.zzcgn = true;
    }

    public final void zza(boolean bl, boolean bl2) {
        if (this.zzcgb != null) {
            this.zzcgb.zza(bl, bl2);
        }
    }

    public final void zzmo() {
        this.zzcgh.removeView((View)this.zzcgb);
        this.zzs(true);
    }

    public final void setRequestedOrientation(int n) {
        this.mActivity.setRequestedOrientation(n);
    }

    public final void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzcgd = new FrameLayout((Context)this.mActivity);
        this.zzcgd.setBackgroundColor(-16777216);
        this.zzcgd.addView(view, -1, -1);
        this.mActivity.setContentView((View)this.zzcgd);
        this.zzcgn = true;
        this.zzcge = customViewCallback;
        this.zzcgc = true;
    }

    private final void zzt(boolean bl) throws zzp {
        zzakl zzakl2;
        boolean bl2;
        zzmk<Boolean> zzmk2;
        Window window;
        if (!this.zzcgn) {
            this.mActivity.requestWindowFeature(1);
        }
        if ((window = this.mActivity.getWindow()) == null) {
            throw new zzp("Invalid activity, no window available.");
        }
        boolean bl3 = true;
        if (com.google.android.gms.common.util.zzp.isAtLeastN()) {
            zzmk2 = zzmu.zzbpe;
            if (zzbv.zzen().zzd(zzmk2).booleanValue()) {
                zzbv.zzea();
                bl3 = zzahf.zza(this.mActivity, this.mActivity.getResources().getConfiguration());
            }
        }
        boolean bl4 = bl2 = this.zzcfz.zzchh != null && this.zzcfz.zzchh.zzapz;
        if ((!this.zzcgg || bl2) && bl3) {
            window.setFlags(1024, 1024);
            zzmk2 = zzmu.zzbjv;
            if (zzbv.zzen().zzd(zzmk2).booleanValue() && com.google.android.gms.common.util.zzp.zzalh() && this.zzcfz.zzchh != null && this.zzcfz.zzchh.zzaqe) {
                window.getDecorView().setSystemUiVisibility(4098);
            }
        }
        boolean bl5 = (zzakl2 = this.zzcfz.zzcgz.zzsb()) != null ? zzakl2.zzfo() : false;
        this.zzcgi = false;
        if (bl5) {
            if (this.zzcfz.orientation == zzbv.zzec().zzqy()) {
                this.zzcgi = this.mActivity.getResources().getConfiguration().orientation == 1;
            } else if (this.zzcfz.orientation == zzbv.zzec().zzqz()) {
                this.zzcgi = this.mActivity.getResources().getConfiguration().orientation == 2;
            }
        }
        boolean bl6 = this.zzcgi;
        zzafx.zzcb((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl6).toString());
        this.setRequestedOrientation(this.zzcfz.orientation);
        if (zzbv.zzec().zza(window)) {
            zzafx.zzcb((String)"Hardware acceleration on the AdActivity window enabled.");
        }
        if (!this.zzcgg) {
            this.zzcgh.setBackgroundColor(-16777216);
        } else {
            this.zzcgh.setBackgroundColor(zzcfy);
        }
        this.mActivity.setContentView((View)this.zzcgh);
        this.zzcgn = true;
        if (bl) {
            try {
                this.zzbvz = zzbv.zzeb().zza((Context)this.mActivity, this.zzcfz.zzcgz.zzbl(), true, bl5, null, this.zzcfz.zzatj, null, null, this.zzcfz.zzcgz.zzbj(), zzil.zzhf());
            }
            catch (Exception exception) {
                throw new zzp("Could not obtain webview for the overlay.");
            }
            this.zzbvz.zzsb().zza(null, null, this.zzcfz.zzcha, this.zzcfz.zzche, true, null, this.zzcfz.zzcgz.zzsb().zzst(), null, null);
            this.zzbvz.zzsb().zza(new zzn(this));
            if (this.zzcfz.url != null) {
                this.zzbvz.loadUrl(this.zzcfz.url);
            } else if (this.zzcfz.zzchd != null) {
                this.zzbvz.loadDataWithBaseURL(this.zzcfz.zzchb, this.zzcfz.zzchd, "text/html", "UTF-8", null);
            } else {
                throw new zzp("No URL or HTML to display in ad overlay.");
            }
            if (this.zzcfz.zzcgz != null) {
                this.zzcfz.zzcgz.zzc(this);
            }
        } else {
            this.zzbvz = this.zzcfz.zzcgz;
            this.zzbvz.setContext((Context)this.mActivity);
        }
        this.zzbvz.zzb(this);
        ViewParent viewParent = this.zzbvz.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            zzakk zzakk2 = this.zzbvz;
            if (zzakk2 == null) {
                throw null;
            }
            ((ViewGroup)viewParent).removeView((View)zzakk2);
        }
        if (this.zzcgg) {
            this.zzbvz.zzss();
        }
        zzakk zzakk3 = this.zzbvz;
        if (zzakk3 == null) {
            throw null;
        }
        this.zzcgh.addView((View)zzakk3, -1, -1);
        if (!bl && !this.zzcgi) {
            this.zzms();
        }
        this.zzs(bl5);
        if (this.zzbvz.zzsc()) {
            this.zza(bl5, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzmp() {
        if (!this.mActivity.isFinishing() || this.zzcgo) {
            return;
        }
        this.zzcgo = true;
        if (this.zzbvz != null) {
            int n = this.zzcgj;
            this.zzbvz.zzae(n);
            Object object = this.zzcgk;
            synchronized (object) {
                if (!this.zzcgm && this.zzbvz.zzsn()) {
                    this.zzcgl = new zzo(this);
                    zzmk<Long> zzmk2 = zzmu.zzbju;
                    zzahf.zzdbo.postDelayed(this.zzcgl, zzbv.zzen().zzd(zzmk2).longValue());
                    return;
                }
            }
        }
        this.zzmq();
    }

    final void zzmq() {
        if (this.zzcgp) {
            return;
        }
        this.zzcgp = true;
        if (this.zzbvz != null) {
            zzakk zzakk2 = this.zzbvz;
            if (zzakk2 == null) {
                throw null;
            }
            this.zzcgh.removeView((View)zzakk2);
            if (this.zzcga != null) {
                this.zzbvz.setContext(this.zzcga.zzaie);
                this.zzbvz.zzab(false);
                zzakk zzakk3 = this.zzbvz;
                if (zzakk3 == null) {
                    throw null;
                }
                this.zzcga.parent.addView((View)zzakk3, this.zzcga.index, this.zzcga.zzcgt);
                this.zzcga = null;
            } else if (this.mActivity.getApplicationContext() != null) {
                this.zzbvz.setContext(this.mActivity.getApplicationContext());
            }
            this.zzbvz = null;
        }
        if (this.zzcfz != null && this.zzcfz.zzcgy != null) {
            this.zzcfz.zzcgy.zzbz();
        }
    }

    public final void zzmr() {
        if (this.zzcgi) {
            this.zzcgi = false;
            this.zzms();
        }
    }

    private final void zzms() {
        this.zzbvz.zzms();
    }

    public final void zzmt() {
        this.zzcgh.zzcgs = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzmu() {
        Object object = this.zzcgk;
        synchronized (object) {
            this.zzcgm = true;
            if (this.zzcgl != null) {
                zzahf.zzdbo.removeCallbacks(this.zzcgl);
                zzahf.zzdbo.post(this.zzcgl);
            }
            return;
        }
    }

    static /* synthetic */ Activity zza(zzm zzm2) {
        return zzm2.mActivity;
    }
}

