/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.internal.zzach;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzbdp;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zznr;
import java.util.Locale;

public final class zzaci {
    private int zzcue;
    private boolean zzcul;
    private boolean zzcum;
    private int zzcuq;
    private int zzcuu;
    private int zzcuv;
    private String zzcuh;
    private int zzcur;
    private int zzcus;
    private int zzcut;
    private boolean zzcuy;
    private int zzcuz;
    private double zzcuw;
    private boolean zzcux;
    private String zzcva;
    private String zzcvb;
    private boolean zzcuf;
    private boolean zzcug;
    private String zzcui;
    private boolean zzcuj;
    private boolean zzcuk;
    private String zzcun;
    private String zzcuo;
    private float zzaxh;
    private int zzcof;
    private int zzcog;
    private String zzcup;
    private boolean zzcvc;

    public zzaci(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzm(context);
        this.zzn(context);
        this.zzo(context);
        Locale locale = Locale.getDefault();
        this.zzcuf = zzaci.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzcug = zzaci.zza(packageManager, "http://www.google.com") != null;
        this.zzcui = locale.getCountry();
        zzjo.zzhu();
        this.zzcuj = zzaje.zzrp();
        this.zzcuk = zzi.zzcl((Context)context);
        this.zzcun = locale.getLanguage();
        this.zzcuo = zzaci.zzb(context, packageManager);
        this.zzcup = zzaci.zza(context, packageManager);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzaxh = displayMetrics.density;
        this.zzcof = displayMetrics.widthPixels;
        this.zzcog = displayMetrics.heightPixels;
    }

    public zzaci(Context context, zzach zzach2) {
        context.getPackageManager();
        this.zzm(context);
        this.zzn(context);
        this.zzo(context);
        Context context2 = context;
        zzaci zzaci2 = this;
        this.zzcva = Build.FINGERPRINT;
        zzaci2.zzcvb = Build.DEVICE;
        zzaci2.zzcvc = zzp.zzald() && zznr.zzk(context2);
        this.zzcuf = zzach2.zzcuf;
        this.zzcug = zzach2.zzcug;
        this.zzcui = zzach2.zzcui;
        this.zzcuj = zzach2.zzcuj;
        this.zzcuk = zzach2.zzcuk;
        this.zzcun = zzach2.zzcun;
        this.zzcuo = zzach2.zzcuo;
        this.zzcup = zzach2.zzcup;
        this.zzaxh = zzach2.zzaxh;
        this.zzcof = zzach2.zzcof;
        this.zzcog = zzach2.zzcog;
    }

    private final void zzm(Context context) {
        zzbv.zzea();
        AudioManager audioManager = zzahf.zzao(context);
        if (audioManager != null) {
            try {
                this.zzcue = audioManager.getMode();
                this.zzcul = audioManager.isMusicActive();
                this.zzcum = audioManager.isSpeakerphoneOn();
                this.zzcuq = audioManager.getStreamVolume(3);
                this.zzcuu = audioManager.getRingerMode();
                this.zzcuv = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzbv.zzee().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzcue = -2;
        this.zzcul = false;
        this.zzcum = false;
        this.zzcuq = 0;
        this.zzcuu = 0;
        this.zzcuv = 0;
    }

    @TargetApi(value=16)
    private final void zzn(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzcuh = telephonyManager.getNetworkOperator();
        this.zzcus = telephonyManager.getNetworkType();
        this.zzcut = telephonyManager.getPhoneType();
        this.zzcur = -2;
        this.zzcuy = false;
        this.zzcuz = -1;
        zzbv.zzea();
        if (zzahf.zzc(context, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzcur = networkInfo.getType();
                this.zzcuz = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzcur = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzcuy = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzo(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzcuw = (float)n2 / (float)n3;
            this.zzcux = n == 2 || n == 5;
            return;
        }
        this.zzcuw = -1.0;
        this.zzcux = false;
    }

    private static String zza(Context context, PackageManager packageManager) {
        try {
            PackageInfo packageInfo = zzbdp.zzcs((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zzb(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzaci.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = zzbdp.zzcs((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
        return packageManager.resolveActivity(intent, 65536);
    }

    public final zzach zzop() {
        return new zzach(this.zzcue, this.zzcuf, this.zzcug, this.zzcuh, this.zzcui, this.zzcuj, this.zzcuk, this.zzcul, this.zzcum, this.zzcun, this.zzcuo, this.zzcup, this.zzcuq, this.zzcur, this.zzcus, this.zzcut, this.zzcuu, this.zzcuv, this.zzaxh, this.zzcof, this.zzcog, this.zzcuw, this.zzcux, this.zzcuy, this.zzcuz, this.zzcva, this.zzcvc, this.zzcvb);
    }
}

