/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzajr;
import com.google.android.gms.internal.zzajs;
import com.google.android.gms.internal.zzzt;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzzt
public class zzajx<T>
implements zzajr<T> {
    private final Object mLock = new Object();
    private T mValue;
    private Throwable zzdfd;
    private boolean zzdfe;
    private boolean zzccj;
    private final zzajs zzdff = new zzajs();

    @Override
    public final void zza(Runnable runnable, Executor executor) {
        this.zzdff.zza(runnable, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(@Nullable T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzccj) {
                return;
            }
            if (this.zzrs()) {
                zzbv.zzee().zza(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.set");
                return;
            }
            this.zzdfe = true;
            this.mValue = t;
            this.mLock.notifyAll();
            this.zzdff.zzrr();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(Throwable throwable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzccj) {
                return;
            }
            if (this.zzrs()) {
                zzbv.zzee().zza(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.setException");
                return;
            }
            this.zzdfd = throwable;
            this.mLock.notifyAll();
            this.zzdff.zzrr();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws CancellationException, ExecutionException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzrs()) {
                this.mLock.wait();
            }
            if (this.zzdfd != null) {
                throw new ExecutionException(this.zzdfd);
            }
            if (this.zzccj) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzrs()) {
                long l2 = timeUnit.toMillis(l);
                if (l2 != 0L) {
                    this.mLock.wait(l2);
                }
            }
            if (this.zzdfd != null) {
                throw new ExecutionException(this.zzdfd);
            }
            if (!this.zzdfe) {
                throw new TimeoutException("SettableFuture timed out.");
            }
            if (this.zzccj) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (!bl) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzrs()) {
                return false;
            }
            this.zzccj = true;
            this.zzdfe = true;
            this.mLock.notifyAll();
            this.zzdff.zzrr();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzccj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzrs();
        }
    }

    private final boolean zzrs() {
        return this.zzdfd != null || this.zzdfe;
    }
}

