/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzdfy;
import com.google.android.gms.internal.zzdge;
import com.google.android.gms.internal.zzdgh;
import com.google.android.gms.internal.zzdgl;
import com.google.android.gms.internal.zzdgq;
import com.google.android.gms.internal.zzdii;
import com.google.android.gms.internal.zzdij;
import com.google.android.gms.internal.zzdik;
import com.google.android.gms.internal.zzedk;
import com.google.android.gms.internal.zzeer;
import com.google.android.gms.internal.zzeey;
import java.security.GeneralSecurityException;
import javax.crypto.spec.SecretKeySpec;

final class zzdhm
implements zzdgh<zzdgl, zzdge.zza, zzdge.zzb> {
    zzdhm() {
    }

    private final zzdgl zzaf(zzedk zzedk2) throws GeneralSecurityException {
        try {
            zzdge.zza zza2 = zzdge.zza.zzn(zzedk2);
            return this.zzc(zza2);
        }
        catch (zzeer zzeer2) {
            throw new GeneralSecurityException("invalid Hmac key");
        }
    }

    private final zzdgl zzc(zzdge.zza zza2) throws GeneralSecurityException {
        zzdge.zza zza3 = zza2;
        zzdik.zzp(zza3.getVersion(), 0);
        if (zza3.zzbjv().size() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdhm.zzc(zza3.zzbli());
        zzdfy zzdfy2 = zza2.zzbli().zzblo();
        byte[] byArray = zza2.zzbjv().toByteArray();
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HMAC");
        int n = zza2.zzbli().zzblp();
        switch (zzdfy2) {
            case zzkyx: {
                return new zzdii("HMACSHA1", secretKeySpec, n);
            }
            case zzkyz: {
                return new zzdii("HMACSHA256", secretKeySpec, n);
            }
            case zzkza: {
                return new zzdii("HMACSHA512", secretKeySpec, n);
            }
        }
        throw new GeneralSecurityException("unknown hash");
    }

    private final zzdge.zza zzag(zzedk zzedk2) throws GeneralSecurityException {
        try {
            zzdge.zzb zzb2 = zzdge.zzb.zzp(zzedk2);
            return this.zza(zzb2);
        }
        catch (zzeer zzeer2) {
            throw new GeneralSecurityException("invalid Hmac key format", zzeer2);
        }
    }

    @Override
    private final zzdge.zza zza(zzdge.zzb zzb2) throws GeneralSecurityException {
        zzdge.zzb zzb3 = zzb2;
        if (zzb3.getKeySize() < 16) {
            throw new GeneralSecurityException("key too short");
        }
        zzdhm.zzc(zzb3.zzbli());
        return (zzdge.zza)zzdge.zza.zzblj().zzfe(0).zzb(zzb2.zzbli()).zzo(zzedk.zzaq((byte[])zzdij.zzfn(zzb2.getKeySize()))).zzccr();
    }

    @Override
    public final zzdgq.zza zzs(zzedk zzedk2) throws GeneralSecurityException {
        zzedk zzedk3 = zzedk2;
        zzdge.zza zza2 = this.zzag(zzedk3);
        return (zzdgq.zza)zzdgq.zza.zzbmh().zznw("type.googleapis.com/google.cloud.crypto.tink.HmacKey").zzw(zza2.zzcbi()).zzb(zzdgq.zza.zzb.zzlat).zzccr();
    }

    private static void zzc(zzdge.zzc zzc2) throws GeneralSecurityException {
        if (zzc2.zzblp() < 10) {
            throw new GeneralSecurityException("tag size too small");
        }
        switch (zzc2.zzblo()) {
            case zzkyx: {
                if (zzc2.zzblp() <= 20) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzkyz: {
                if (zzc2.zzblp() <= 32) break;
                throw new GeneralSecurityException("tag size too big");
            }
            case zzkza: {
                if (zzc2.zzblp() <= 64) break;
                throw new GeneralSecurityException("tag size too big");
            }
            default: {
                throw new GeneralSecurityException("unknown hash type");
            }
        }
    }

    @Override
    public final /* synthetic */ zzeey zzb(zzeey zzeey2) throws GeneralSecurityException {
        return this.zza((zzdge.zzb)zzeey2);
    }

    @Override
    public final /* synthetic */ zzeey zzr(zzedk zzedk2) throws GeneralSecurityException {
        return this.zzag(zzedk2);
    }

    @Override
    public final /* synthetic */ Object zza(zzeey zzeey2) throws GeneralSecurityException {
        return this.zzc((zzdge.zza)zzeey2);
    }

    @Override
    public final /* synthetic */ Object zzq(zzedk zzedk2) throws GeneralSecurityException {
        return this.zzaf(zzedk2);
    }
}

