/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.provider.Settings;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafi;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzaix;
import com.google.android.gms.internal.zzajk;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzfk;
import com.google.android.gms.internal.zzfn;
import com.google.android.gms.internal.zzfp;
import com.google.android.gms.internal.zzft;
import com.google.android.gms.internal.zzgh;
import com.google.android.gms.internal.zzgw;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzzt;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzt
public final class zzfm
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private Object mLock = new Object();
    private final WeakReference<zzafi> zzavd;
    private WeakReference<ViewTreeObserver> zzave;
    private final zzgw zzavf;
    protected final zzfk zzavg;
    private final Context mApplicationContext;
    private final WindowManager zzavh;
    private final PowerManager zzavi;
    private final KeyguardManager zzavj;
    private final DisplayMetrics zzavk;
    @Nullable
    private zzft zzavl;
    private boolean zzavm;
    private boolean zzark = false;
    private boolean zzavn = false;
    private boolean zzavo;
    private boolean zzavp;
    private boolean zzavq;
    @Nullable
    private BroadcastReceiver zzavr;
    private final HashSet<Object> zzavs = new HashSet();
    private zzaix zzaun;
    private final HashSet<zzgh> zzavt = new HashSet();
    private final Rect zzavu = new Rect();
    private final zzfp zzavv;
    private float zzavw;

    public zzfm(Context context, zzjb zzjb2, zzafi zzafi2, zzajk zzajk2, zzgw zzgw2) {
        this.zzavd = new WeakReference<zzafi>(zzafi2);
        this.zzavf = zzgw2;
        this.zzave = new WeakReference<Object>(null);
        this.zzavo = true;
        this.zzavq = false;
        this.zzaun = new zzaix(200L);
        this.zzavg = new zzfk(UUID.randomUUID().toString(), zzajk2, zzjb2.zzbcq, zzafi2.zzcyc, zzafi2.zzfo(), zzjb2.zzbct);
        this.zzavh = (WindowManager)context.getSystemService("window");
        this.zzavi = (PowerManager)context.getApplicationContext().getSystemService("power");
        this.zzavj = (KeyguardManager)context.getSystemService("keyguard");
        this.mApplicationContext = context;
        this.zzavv = new zzfp(this, new Handler());
        this.mApplicationContext.getContentResolver().registerContentObserver(Settings.System.CONTENT_URI, true, (ContentObserver)this.zzavv);
        this.zzavk = context.getResources().getDisplayMetrics();
        Display display = this.zzavh.getDefaultDisplay();
        this.zzavu.right = display.getWidth();
        this.zzavu.bottom = display.getHeight();
        this.zzfq();
    }

    public final void zzfq() {
        zzbv.zzea();
        this.zzavw = zzahf.zzap(this.mApplicationContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzfr() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzavo) {
                this.zzavp = true;
                try {
                    JSONObject jSONObject = this.zzfv();
                    jSONObject.put("doneReasonCode", (Object)"u");
                    JSONObject jSONObject2 = jSONObject;
                    this.zza(jSONObject2, true);
                }
                catch (JSONException jSONException) {
                    zzafx.zzb((String)"JSON failure while processing active view data.", (Throwable)jSONException);
                }
                catch (RuntimeException runtimeException) {
                    zzafx.zzb((String)"Failure while processing active view data.", (Throwable)runtimeException);
                }
                String string2 = String.valueOf(this.zzavg.zzfn());
                zzafx.zzcb((String)(string2.length() != 0 ? "Untracking ad unit: ".concat(string2) : new String("Untracking ad unit: ")));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void zzj(int n) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl;
            boolean bl2;
            block13: {
                Iterator<zzgh> iterator = this.zzavt.iterator();
                while (iterator.hasNext()) {
                    if (!iterator.next().zzfz()) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
            if (!bl2 || !this.zzavo) {
                return;
            }
            View view = this.zzavf.zzfw();
            boolean bl3 = view != null && zzbv.zzea().zza(view, this.zzavi, this.zzavj);
            boolean bl4 = bl = view != null && bl3 && view.getGlobalVisibleRect(new Rect(), null);
            if (this.zzavf.zzfx()) {
                this.zzfr();
                return;
            }
            if (n == 1 && !this.zzaun.tryAcquire() && bl == this.zzavq) {
                return;
            }
            if (!bl && !this.zzavq && n == 1) {
                return;
            }
            try {
                JSONObject jSONObject = this.zza(view, (Boolean)bl3);
                this.zza(jSONObject, false);
                this.zzavq = bl;
            }
            catch (RuntimeException | JSONException throwable) {
                zzafx.zza((String)"Active view update failed.", (Throwable)throwable);
            }
            zzfm zzfm2 = this;
            View view2 = zzfm2.zzavf.zzfy().zzfw();
            if (view2 != null) {
                ViewTreeObserver viewTreeObserver = (ViewTreeObserver)zzfm2.zzave.get();
                ViewTreeObserver viewTreeObserver2 = view2.getViewTreeObserver();
                if (viewTreeObserver2 != viewTreeObserver) {
                    zzfm2.zzfu();
                    if (!zzfm2.zzavm || viewTreeObserver != null && viewTreeObserver.isAlive()) {
                        zzfm2.zzavm = true;
                        viewTreeObserver2.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)zzfm2);
                        viewTreeObserver2.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)zzfm2);
                    }
                    zzfm2.zzave = new WeakReference<ViewTreeObserver>(viewTreeObserver2);
                }
            }
            this.zzfs();
            return;
        }
    }

    private final void zzfs() {
        if (this.zzavl != null) {
            this.zzavl.zza(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzft() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzavo;
        }
    }

    private static int zza(int n, DisplayMetrics displayMetrics) {
        float f = displayMetrics.density;
        return (int)((float)n / f);
    }

    final boolean zzc(@Nullable Map<String, String> map) {
        if (map == null) {
            return false;
        }
        String string2 = map.get("hashCode");
        return !TextUtils.isEmpty((CharSequence)string2) && string2.equals(this.zzavg.zzfn());
    }

    final void zzb(zzakk zzakk2, Map<String, String> map) {
        if (zzakk2 == null) {
            throw null;
        }
        this.zzj(3);
    }

    final void zza(zzgh zzgh2, Map<String, String> map) {
        String string2 = String.valueOf(this.zzavg.zzfn());
        zzafx.zzcb((String)(string2.length() != 0 ? "Received request to untrack: ".concat(string2) : new String("Received request to untrack: ")));
        this.zzb(zzgh2);
    }

    final void zzd(Map<String, String> map) {
        if (!map.containsKey("isVisible")) {
            return;
        }
        if (!"1".equals(map.get("isVisible"))) {
            "true".equals(map.get("isVisible"));
        }
        Iterator<Object> iterator = this.zzavs.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private final void zzfu() {
        ViewTreeObserver viewTreeObserver = (ViewTreeObserver)this.zzave.get();
        if (viewTreeObserver == null || !viewTreeObserver.isAlive()) {
            return;
        }
        viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    private final JSONObject zzfv() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = jSONObject.put("afmaVersion", (Object)this.zzavg.zzfl()).put("activeViewJSON", (Object)this.zzavg.zzfm()).put("timestamp", zzbv.zzeg().elapsedRealtime()).put("adFormat", (Object)this.zzavg.zzfk()).put("hashCode", (Object)this.zzavg.zzfn()).put("isMraid", this.zzavg.zzfo()).put("isStopped", this.zzavn).put("isPaused", this.zzark).put("isNative", this.zzavg.zzfp()).put("isScreenOn", this.isScreenOn());
        zzbv.zzea();
        JSONObject jSONObject3 = jSONObject2.put("appMuted", zzahf.zzdg());
        zzbv.zzea();
        jSONObject3.put("appVolume", (double)zzahf.zzde()).put("deviceVolume", (double)this.zzavw);
        return jSONObject;
    }

    private static JSONObject zza(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONArray.put((Object)jSONObject);
        jSONObject2.put("units", (Object)jSONArray);
        return jSONObject2;
    }

    private final void zza(JSONObject jSONObject, boolean bl) {
        try {
            JSONObject jSONObject2 = zzfm.zza(jSONObject);
            boolean bl2 = bl;
            JSONObject jSONObject3 = jSONObject2;
            zzfm zzfm2 = this;
            ArrayList<zzgh> arrayList = new ArrayList<zzgh>(zzfm2.zzavt);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzgh zzgh2 = arrayList.get(i);
                zzgh2.zzb(jSONObject3, bl2);
            }
            return;
        }
        catch (Throwable throwable) {
            zzafx.zzb((String)"Skipping active view message.", (Throwable)throwable);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzgh zzgh2) {
        if (this.zzavt.isEmpty()) {
            zzfm zzfm2 = this;
            Object object = zzfm2.mLock;
            synchronized (object) {
                if (zzfm2.zzavr != null) {
                } else {
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.SCREEN_ON");
                    intentFilter.addAction("android.intent.action.SCREEN_OFF");
                    zzfm2.zzavr = new zzfn(zzfm2);
                    zzfm2.mApplicationContext.registerReceiver(zzfm2.zzavr, intentFilter);
                }
            }
            this.zzj(3);
        }
        this.zzavt.add(zzgh2);
        try {
            JSONObject jSONObject = zzfm.zza(this.zza(this.zzavf.zzfw(), null));
            zzgh2.zzb(jSONObject, false);
            return;
        }
        catch (JSONException jSONException) {
            zzafx.zzb((String)"Skipping measurement update for new client.", (Throwable)jSONException);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzgh zzgh2) {
        this.zzavt.remove(zzgh2);
        zzgh2.zzga();
        if (this.zzavt.isEmpty()) {
            zzfm zzfm2 = this;
            Object object = zzfm2.mLock;
            synchronized (object) {
                zzfm2.zzfu();
                zzfm zzfm3 = zzfm2;
                Object object2 = zzfm3.mLock;
                synchronized (object2) {
                    if (zzfm3.zzavr != null) {
                        try {
                            zzfm3.mApplicationContext.unregisterReceiver(zzfm3.zzavr);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzafx.zzb((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
                        }
                        catch (Exception exception) {
                            zzbv.zzee().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
                        }
                        zzfm3.zzavr = null;
                    }
                }
                zzfm2.mApplicationContext.getContentResolver().unregisterContentObserver((ContentObserver)zzfm2.zzavv);
                zzfm2.zzavo = false;
                zzfm2.zzfs();
                zzfm3 = zzfm2;
                ArrayList<zzgh> arrayList = new ArrayList<zzgh>(zzfm3.zzavt);
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    zzgh zzgh3 = arrayList.get(i);
                    zzgh zzgh4 = zzgh3;
                    zzfm3.zzb(zzgh4);
                }
                return;
            }
        }
    }

    private final JSONObject zza(@Nullable View view, @Nullable Boolean bl) throws JSONException {
        if (view == null) {
            zzfm zzfm2 = this;
            return zzfm2.zzfv().put("isAttachedToWindow", false).put("isScreenOn", zzfm2.isScreenOn()).put("isVisible", false);
        }
        boolean bl2 = zzbv.zzec().isAttachedToWindow(view);
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        try {
            view.getLocationOnScreen(nArray);
            view.getLocationInWindow(nArray2);
        }
        catch (Exception exception) {
            zzafx.zzb((String)"Failure getting view location.", (Throwable)exception);
        }
        Rect rect = new Rect();
        new Rect().left = nArray[0];
        rect.top = nArray[1];
        rect.right = rect.left + view.getWidth();
        rect.bottom = rect.top + view.getHeight();
        Rect rect2 = new Rect();
        boolean bl3 = view.getGlobalVisibleRect(rect2, null);
        Rect rect3 = new Rect();
        boolean bl4 = view.getLocalVisibleRect(rect3);
        Rect rect4 = new Rect();
        view.getHitRect(rect4);
        JSONObject jSONObject = this.zzfv();
        jSONObject.put("windowVisibility", view.getWindowVisibility()).put("isAttachedToWindow", bl2).put("viewBox", (Object)new JSONObject().put("top", zzfm.zza(this.zzavu.top, this.zzavk)).put("bottom", zzfm.zza(this.zzavu.bottom, this.zzavk)).put("left", zzfm.zza(this.zzavu.left, this.zzavk)).put("right", zzfm.zza(this.zzavu.right, this.zzavk))).put("adBox", (Object)new JSONObject().put("top", zzfm.zza(rect.top, this.zzavk)).put("bottom", zzfm.zza(rect.bottom, this.zzavk)).put("left", zzfm.zza(rect.left, this.zzavk)).put("right", zzfm.zza(rect.right, this.zzavk))).put("globalVisibleBox", (Object)new JSONObject().put("top", zzfm.zza(rect2.top, this.zzavk)).put("bottom", zzfm.zza(rect2.bottom, this.zzavk)).put("left", zzfm.zza(rect2.left, this.zzavk)).put("right", zzfm.zza(rect2.right, this.zzavk))).put("globalVisibleBoxVisible", bl3).put("localVisibleBox", (Object)new JSONObject().put("top", zzfm.zza(rect3.top, this.zzavk)).put("bottom", zzfm.zza(rect3.bottom, this.zzavk)).put("left", zzfm.zza(rect3.left, this.zzavk)).put("right", zzfm.zza(rect3.right, this.zzavk))).put("localVisibleBoxVisible", bl4).put("hitBox", (Object)new JSONObject().put("top", zzfm.zza(rect4.top, this.zzavk)).put("bottom", zzfm.zza(rect4.bottom, this.zzavk)).put("left", zzfm.zza(rect4.left, this.zzavk)).put("right", zzfm.zza(rect4.right, this.zzavk))).put("screenDensity", (double)this.zzavk.density);
        if (bl == null) {
            bl = zzbv.zzea().zza(view, this.zzavi, this.zzavj);
        }
        jSONObject.put("isVisible", bl.booleanValue());
        return jSONObject;
    }

    private final boolean isScreenOn() {
        if (Build.VERSION.SDK_INT >= 20) {
            return this.zzavi.isInteractive();
        }
        return this.zzavi.isScreenOn();
    }

    public final void onScrollChanged() {
        this.zzj(1);
    }

    public final void onGlobalLayout() {
        this.zzj(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzft zzft2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzavl = zzft2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzavn = true;
            this.zzj(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pause() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzark = true;
            this.zzj(3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzark = false;
            this.zzj(3);
            return;
        }
    }
}

