/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.internal.zzbp;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.zzn;
import com.google.android.gms.internal.zzaey;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzajk;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzakw;
import com.google.android.gms.internal.zzcv;
import com.google.android.gms.internal.zzil;
import com.google.android.gms.internal.zzjb;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zznt;
import com.google.android.gms.internal.zznu;
import com.google.android.gms.internal.zzoc;
import com.google.android.gms.internal.zzoe;
import com.google.android.gms.internal.zzof;
import com.google.android.gms.internal.zzog;
import com.google.android.gms.internal.zzoh;
import com.google.android.gms.internal.zzoj;
import com.google.android.gms.internal.zzok;
import com.google.android.gms.internal.zzol;
import com.google.android.gms.internal.zzom;
import com.google.android.gms.internal.zzos;
import com.google.android.gms.internal.zzpc;
import com.google.android.gms.internal.zzpd;
import com.google.android.gms.internal.zzym;
import com.google.android.gms.internal.zzzt;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzzt
public class zzoi
implements zzoe {
    private final Object mLock = new Object();
    private final zzof zzbsm;
    private final Context mContext;
    @Nullable
    private final JSONObject zzbsp;
    @Nullable
    private zzym zzaqz;
    @Nullable
    private final zzog zzbsq;
    private final zzcv zzbsr;
    @Nullable
    private final zzajk zzapc;
    boolean zzbss;
    @Nullable
    private String zzbst;
    @Nullable
    private zzaey zzapr;
    private WeakReference<View> zzbsu = null;

    public zzoi(Context context, zzof zzof2, @Nullable zzym zzym2, zzcv zzcv2, @Nullable JSONObject jSONObject, @Nullable zzog zzog2, @Nullable zzajk zzajk2, @Nullable String string) {
        this.mContext = context;
        this.zzbsm = zzof2;
        this.zzaqz = zzym2;
        this.zzbsr = zzcv2;
        this.zzbsp = jSONObject;
        this.zzbsq = zzog2;
        this.zzapc = zzajk2;
        this.zzbst = string;
    }

    @Override
    @Nullable
    public View zza(View.OnClickListener onClickListener, boolean bl) {
        zznt zznt2 = this.zzbsq.zzjl();
        if (zznt2 == null) {
            return null;
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        if (!bl) {
            switch (zznt2.zzjf()) {
                case 0: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(9);
                    break;
                }
                case 3: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(9);
                    break;
                }
                case 2: {
                    layoutParams.addRule(12);
                    layoutParams.addRule(11);
                    break;
                }
                default: {
                    layoutParams.addRule(10);
                    layoutParams.addRule(11);
                }
            }
        }
        zznu zznu2 = new zznu(this.mContext, zznt2, layoutParams);
        zznu2.setOnClickListener(onClickListener);
        zzmk<String> zzmk2 = zzmu.zzbnb;
        zznu2.setContentDescription(zzbv.zzen().zzd(zzmk2));
        return zznu2;
    }

    @Override
    public boolean zzjr() {
        zznt zznt2 = this.zzbsq.zzjl();
        return zznt2 != null && zznt2.zzjg();
    }

    private final boolean zzaq(String string) {
        JSONObject jSONObject = this.zzbsp.optJSONObject("allow_pub_event_reporting");
        if (jSONObject == null) {
            return false;
        }
        return jSONObject.optBoolean(string, false);
    }

    @Override
    public final void zza(View view, String string, @Nullable Bundle bundle, Map<String, WeakReference<View>> map, View view2) {
        JSONObject jSONObject = this.zza(map, view2);
        JSONObject jSONObject2 = this.zzi(view2);
        JSONObject jSONObject3 = zzoi.zzj(view2);
        JSONObject jSONObject4 = null;
        try {
            JSONObject jSONObject5 = zzbv.zzea().zza(bundle, null);
            jSONObject4 = new JSONObject();
            jSONObject4.put("click_point", (Object)jSONObject5);
            jSONObject4.put("asset_id", (Object)string);
        }
        catch (Exception exception) {
            zzafx.zzb((String)"Error occured while grabbing click signals.", (Throwable)exception);
        }
        this.zza(view, jSONObject2, jSONObject, jSONObject3, string, jSONObject4, null);
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map, Bundle bundle, View view2) {
        zzbp.zzfx((String)"performClick must be called on the main UI thread.");
        if (map != null) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view3 = (View)entry.getValue().get();
                if (!view.equals(view3)) continue;
                this.zza(view, entry.getKey(), bundle, map, view2);
                return;
            }
        }
        if ("2".equals(this.zzbsq.zzjk())) {
            this.zza(view, "2099", bundle, map, view2);
            return;
        }
        if ("1".equals(this.zzbsq.zzjk())) {
            this.zza(view, "1099", bundle, map, view2);
        }
    }

    @Override
    public final void performClick(Bundle bundle) {
        if (bundle == null) {
            zzafx.zzcb((String)"Click data is null. No click is reported.");
            return;
        }
        if (!this.zzaq("click_reporting")) {
            zzafx.e((String)"The ad slot cannot handle external click events. You must be whitelisted to be able to report your click events.");
            return;
        }
        String string = bundle.getBundle("click_signal").getString("asset_id");
        JSONObject jSONObject = zzbv.zzea().zza(bundle, null);
        this.zza(null, null, null, null, string, null, jSONObject);
    }

    private final void zza(View view, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, String string, JSONObject jSONObject4, JSONObject jSONObject5) {
        zzbp.zzfx((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zzbsp);
            if (jSONObject2 != null) {
                jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject6.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject4 != null) {
                jSONObject6.put("click_signal", (Object)jSONObject4);
            }
            if (jSONObject3 != null) {
                jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            }
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("asset_id", (Object)string);
            jSONObject7.put("template", (Object)this.zzbsq.zzjk());
            jSONObject7.put("has_custom_click_handler", this.zzbsm.zzr(this.zzbsq.getCustomTemplateId()) != null);
            jSONObject6.put("has_custom_click_handler", this.zzbsm.zzr(this.zzbsq.getCustomTemplateId()) != null);
            try {
                JSONObject jSONObject8 = this.zzbsp.optJSONObject("tracking_urls_and_actions");
                if (jSONObject8 == null) {
                    jSONObject8 = new JSONObject();
                }
                String string2 = jSONObject8.optString("click_string");
                String string3 = this.zzbsr.zzac().zza(this.mContext, string2, view);
                jSONObject7.put("click_signals", (Object)string3);
            }
            catch (Exception exception) {
                zzafx.zzb((String)"Exception obtaining click signals", (Throwable)exception);
            }
            jSONObject6.put("click", (Object)jSONObject7);
            if (jSONObject5 != null) {
                jSONObject6.put("provided_signals", (Object)jSONObject5);
            }
            jSONObject6.put("ads_id", (Object)this.zzbst);
            this.zzaqz.zza(new zzoj(this, jSONObject6));
            return;
        }
        catch (JSONException jSONException) {
            zzafx.zzb((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final void zzd(MotionEvent motionEvent) {
        this.zzbsr.zza(motionEvent);
    }

    @Override
    public final void reportTouchEvent(Bundle bundle) {
        if (bundle == null) {
            zzafx.zzcb((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        if (!this.zzaq("touch_reporting")) {
            zzafx.e((String)"The ad slot cannot handle external touch events. You must be whitelisted to be able to report your touch events.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzbsr.zzac().zza(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(View view, Map<String, WeakReference<View>> map) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzbss) {
                return;
            }
            if (!view.isShown()) {
                return;
            }
            if (!view.getGlobalVisibleRect(new Rect(), null)) {
                return;
            }
            this.zza(view, map);
            return;
        }
    }

    @Override
    public void zza(View view, Map<String, WeakReference<View>> map) {
        JSONObject jSONObject = this.zzi(view);
        JSONObject jSONObject2 = this.zza(map, view);
        JSONObject jSONObject3 = zzoi.zzj(view);
        this.zza(jSONObject, jSONObject2, jSONObject3, null);
    }

    @Override
    public final boolean recordImpression(Bundle bundle) {
        if (!this.zzaq("impression_reporting")) {
            zzafx.e((String)"The ad slot cannot handle external impression events. You must be whitelisted to whitelisted to be able to report your impression events.");
            return false;
        }
        JSONObject jSONObject = zzbv.zzea().zza(bundle, null);
        return this.zza(null, null, null, jSONObject);
    }

    private final boolean zza(JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, JSONObject jSONObject4) {
        zzbp.zzfx((String)"recordImpression must be called on the main UI thread.");
        this.zzbss = true;
        try {
            JSONObject jSONObject5 = new JSONObject();
            jSONObject5.put("ad", (Object)this.zzbsp);
            jSONObject5.put("ads_id", (Object)this.zzbst);
            if (jSONObject2 != null) {
                jSONObject5.put("asset_view_signal", (Object)jSONObject2);
            }
            if (jSONObject != null) {
                jSONObject5.put("ad_view_signal", (Object)jSONObject);
            }
            if (jSONObject3 != null) {
                jSONObject5.put("scroll_view_signal", (Object)jSONObject3);
            }
            if (jSONObject4 != null) {
                jSONObject5.put("provided_signals", (Object)jSONObject4);
            }
            this.zzaqz.zza(new zzok(this, jSONObject5));
            this.zzaqz.zza(new zzol(this.zzbsm, this.zzbst));
        }
        catch (JSONException jSONException) {
            zzafx.zzb((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        this.zzbsm.zza(this);
        this.zzbsm.zzbv();
        return true;
    }

    @Override
    public final View zzjw() {
        if (this.zzbsu != null) {
            return (View)this.zzbsu.get();
        }
        return null;
    }

    @Override
    public final void zzg(View view) {
        this.zzbsu = new WeakReference<View>(view);
    }

    public void zza(View view, Map<String, WeakReference<View>> map, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        zzmk<Boolean> zzmk2 = zzmu.zzbmz;
        if (!zzbv.zzen().zzd(zzmk2).booleanValue()) {
            return;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            View view2 = (View)iterator.next().getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(onTouchListener);
            view2.setClickable(true);
            view2.setOnClickListener(onClickListener);
        }
    }

    @Override
    public void zzb(View view, Map<String, WeakReference<View>> map) {
        zzmk<Boolean> zzmk2 = zzmu.zzbmy;
        if (zzbv.zzen().zzd(zzmk2).booleanValue()) {
            return;
        }
        view.setOnTouchListener(null);
        view.setClickable(false);
        view.setOnClickListener(null);
        if (map == null) {
            return;
        }
        Iterator<Map.Entry<String, WeakReference<View>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            View view2 = (View)iterator.next().getValue().get();
            if (view2 == null) continue;
            view2.setOnTouchListener(null);
            view2.setClickable(false);
            view2.setOnClickListener(null);
        }
    }

    public zzakk zzju() throws zzakw {
        if (this.zzbsp == null || this.zzbsp.optJSONObject("overlay") == null) {
            return null;
        }
        Object object = this;
        zzajk zzajk2 = ((zzoi)object).zzapc;
        zzcv zzcv2 = ((zzoi)object).zzbsr;
        zzjb zzjb2 = zzjb.zzi((Context)((zzoi)object).mContext);
        Context context = ((zzoi)object).mContext;
        zzakk zzakk2 = zzbv.zzeb().zza(context, zzjb2, false, false, zzcv2, zzajk2, null, null, null, zzil.zzhf());
        if (zzakk2 == null) {
            throw null;
        }
        ((View)zzakk2).setVisibility(8);
        object = new zzom(zzakk2);
        this.zzaqz.zza(new zzos((zzom)object));
        return zzakk2;
    }

    public final void zze(Map<String, WeakReference<View>> map) {
        if (this.zzbsq.zzjm() != null) {
            if ("2".equals(this.zzbsq.zzjk())) {
                zzbv.zzee().zzb(this.mContext, this.zzbsm.getAdUnitId(), this.zzbsq.zzjk(), map.containsKey("2011"));
                return;
            }
            if ("1".equals(this.zzbsq.zzjk())) {
                zzbv.zzee().zzb(this.mContext, this.zzbsm.getAdUnitId(), this.zzbsq.zzjk(), map.containsKey("1009"));
            }
        }
    }

    @Override
    public final void zza(View view, zzoc zzoc2) {
        Object object;
        zzpc zzpc2;
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        View view2 = this.zzbsq.zzjm();
        if (view2 != null) {
            ViewParent viewParent = view2.getParent();
            if (viewParent instanceof ViewGroup) {
                ((ViewGroup)viewParent).removeView(view2);
            }
            ((FrameLayout)view).addView(view2, (ViewGroup.LayoutParams)layoutParams);
            this.zzbsm.zza(zzoc2);
            return;
        }
        if (!(this.zzbsq instanceof zzoh)) {
            return;
        }
        zzoh zzoh2 = (zzoh)this.zzbsq;
        if (zzoh2.getImages() != null && zzoh2.getImages().size() > 0 && (zzpc2 = (object = zzoh2.getImages().get(0)) instanceof IBinder ? zzpd.zzk((IBinder)((IBinder)object)) : null) != null) {
            try {
                IObjectWrapper iObjectWrapper = zzpc2.zzjh();
                if (iObjectWrapper != null) {
                    Drawable drawable2 = (Drawable)zzn.zzab((IObjectWrapper)iObjectWrapper);
                    object = this;
                    ImageView imageView = new ImageView(((zzoi)object).mContext);
                    imageView.setImageDrawable(drawable2);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                    ((FrameLayout)view).addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
                }
                return;
            }
            catch (RemoteException remoteException) {
                zzafx.zzcs((String)"Could not get drawable from image");
            }
        }
    }

    @Override
    public final void zzjx() {
        this.zzbsm.zzcn();
    }

    @Override
    public void zzjv() {
        this.zzaqz.zzlf();
    }

    @Override
    public final Context getContext() {
        return this.mContext;
    }

    private static int[] zzh(View view) {
        int[] nArray = new int[2];
        view.getLocationOnScreen(nArray);
        return nArray;
    }

    private final int zzr(int n) {
        zzjo.zzhu();
        return zzaje.zzd((Context)this.mContext, (int)n);
    }

    private final JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", this.zzr(rect.right - rect.left));
        jSONObject.put("height", this.zzr(rect.bottom - rect.top));
        jSONObject.put("x", this.zzr(rect.left));
        jSONObject.put("y", this.zzr(rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private final JSONObject zzi(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            JSONObject jSONObject2;
            int[] nArray = zzoi.zzh(view);
            JSONObject jSONObject3 = new JSONObject();
            jSONObject3.put("width", this.zzr(view.getMeasuredWidth()));
            jSONObject3.put("height", this.zzr(view.getMeasuredHeight()));
            jSONObject3.put("x", this.zzr(nArray[0]));
            jSONObject3.put("y", this.zzr(nArray[1]));
            jSONObject3.put("relative_to", (Object)"window");
            jSONObject.put("frame", (Object)jSONObject3);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                jSONObject2 = this.zzb(rect);
            } else {
                jSONObject2 = new JSONObject();
                jSONObject2.put("width", 0);
                jSONObject2.put("height", 0);
                jSONObject2.put("x", this.zzr(nArray[0]));
                jSONObject2.put("y", this.zzr(nArray[1]));
                jSONObject2.put("relative_to", (Object)"window");
            }
            jSONObject.put("visible_bounds", (Object)jSONObject2);
        }
        catch (Exception exception) {
            zzafx.zzcs((String)"Unable to get native ad view bounding box");
        }
        return jSONObject;
    }

    private static JSONObject zzj(View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzbv.zzea();
            int n = zzahf.zzp(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    private final JSONObject zza(Map<String, WeakReference<View>> map, View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzoi.zzh(view);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            int[] nArray2 = zzoi.zzh(view2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                JSONObject jSONObject4;
                jSONObject3.put("width", this.zzr(view2.getMeasuredWidth()));
                jSONObject3.put("height", this.zzr(view2.getMeasuredHeight()));
                jSONObject3.put("x", this.zzr(nArray2[0] - nArray[0]));
                jSONObject3.put("y", this.zzr(nArray2[1] - nArray[1]));
                jSONObject3.put("relative_to", (Object)"ad_view");
                jSONObject2.put("frame", (Object)jSONObject3);
                Rect rect = new Rect();
                if (view2.getLocalVisibleRect(rect)) {
                    jSONObject4 = this.zzb(rect);
                } else {
                    jSONObject4 = new JSONObject();
                    jSONObject4.put("width", 0);
                    jSONObject4.put("height", 0);
                    jSONObject4.put("x", this.zzr(nArray2[0] - nArray[0]));
                    jSONObject4.put("y", this.zzr(nArray2[1] - nArray[1]));
                    jSONObject4.put("relative_to", (Object)"ad_view");
                }
                jSONObject2.put("visible_bounds", (Object)jSONObject4);
                if (view2 instanceof TextView) {
                    TextView textView = (TextView)view2;
                    jSONObject2.put("text_color", textView.getCurrentTextColor());
                    jSONObject2.put("font_size", (double)textView.getTextSize());
                    jSONObject2.put("text", (Object)textView.getText());
                }
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                zzafx.zzcs((String)"Unable to get asset views information");
            }
        }
        return jSONObject;
    }

    @Nullable
    public final zzaey zzjy() {
        if (zzbv.zzez().zzt(this.mContext)) {
            if (this.zzapr == null) {
                this.zzapr = new zzaey(this.mContext, this.zzbsm.getAdUnitId());
            }
            return this.zzapr;
        }
        return null;
    }
}

