/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.overlay.zzaa;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafx;
import com.google.android.gms.internal.zzajc;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzakj;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzjo;
import com.google.android.gms.internal.zzmk;
import com.google.android.gms.internal.zzmu;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzzt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@zzzt
public final class zzsg
implements zzrn {
    private boolean zzbwc;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                zzjo.zzhu();
                n2 = zzaje.zzc((Context)context, (int)Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzafx.zzcs((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    @Override
    public final void zza(zzakk zzakk2, Map<String, String> map) {
        Object object;
        Object object2;
        String string2 = map.get("action");
        if (string2 == null) {
            zzafx.zzcs((String)"Action missing from video GMSG.");
            return;
        }
        if (zzafx.zzad((int)3)) {
            object2 = new JSONObject(map);
            object2.remove("google.afma.Notify_dt");
            object = object2.toString();
            zzafx.zzcb((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(object).length()).append("Video GMSG: ").append(string2).append(" ").append((String)object).toString());
        }
        if ("background".equals(string2)) {
            object2 = map.get("color");
            if (TextUtils.isEmpty((CharSequence)object2)) {
                zzafx.zzcs((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object2);
                zzakk2.setBackgroundColor(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzafx.zzcs((String)"Invalid color parameter in video GMSG.");
                return;
            }
        }
        if ("decoderProps".equals(string2)) {
            object2 = map.get("mimeTypes");
            if (object2 == null) {
                zzafx.zzcs((String)"No MIME types specified for decoder properties inspection.");
                zzaa.zza(zzakk2, "missingMimeTypes");
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                zzafx.zzcs((String)"Video decoder properties available on API versions >= 16.");
                zzaa.zza(zzakk2, "deficientApiVersion");
                return;
            }
            object = new HashMap();
            for (String string3 : ((String)object2).split(",")) {
                object.put(string3, zzajc.zzcp(string3.trim()));
            }
            zzaa.zzc(zzakk2, (Map<String, List<Map<String, Object>>>)object);
            return;
        }
        object2 = zzakk2.zzsj();
        if (object2 == null) {
            zzafx.zzcs((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzakk2.getContext();
            int n2 = zzsg.zza(context, map, "x", 0);
            int n3 = zzsg.zza(context, map, "y", 0);
            int n4 = zzsg.zza(context, map, "w", -1);
            int n5 = zzsg.zza(context, map, "h", -1);
            zzmk<Boolean> zzmk2 = zzmu.zzbnc;
            if (zzbv.zzen().zzd(zzmk2).booleanValue()) {
                n4 = Math.min(n4, zzakk2.getMeasuredWidth() - n2);
                n5 = Math.min(n5, zzakk2.getMeasuredHeight() - n3);
            }
            try {
                n = Integer.parseInt(map.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean(map.get("spherical"));
            if (bl && ((zzakj)object2).zzru() == null) {
                zzaq zzaq2 = new zzaq(map.get("flags"));
                ((zzakj)object2).zza(n2, n3, n4, n5, n, bl3, zzaq2);
                return;
            }
            ((zzakj)object2).zze(n2, n3, n4, n5);
            return;
        }
        zzaa zzaa2 = ((zzakj)object2).zzru();
        if (zzaa2 == null) {
            zzaa.zzh(zzakk2);
            return;
        }
        if ("click".equals(string2)) {
            Context context = zzakk2.getContext();
            int n = zzsg.zza(context, map, "x", 0);
            int n6 = zzsg.zza(context, map, "y", 0);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
            zzaa2.zze(motionEvent);
            motionEvent.recycle();
            return;
        }
        if ("currentTime".equals(string2)) {
            String string4 = map.get("time");
            if (string4 == null) {
                zzafx.zzcs((String)"Time parameter missing from currentTime video GMSG.");
                return;
            }
            try {
                int n = (int)(Float.parseFloat(string4) * 1000.0f);
                zzaa2.seekTo(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = String.valueOf(string4);
                zzafx.zzcs((String)(string5.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string5) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                return;
            }
        }
        if ("hide".equals(string2)) {
            zzaa2.setVisibility(4);
            return;
        }
        if ("load".equals(string2)) {
            zzaa2.zznb();
            return;
        }
        if ("muted".equals(string2)) {
            if (Boolean.parseBoolean(map.get("muted"))) {
                zzaa2.zznc();
                return;
            }
            zzaa2.zznd();
            return;
        }
        if ("pause".equals(string2)) {
            zzaa2.pause();
            return;
        }
        if ("play".equals(string2)) {
            zzaa2.play();
            return;
        }
        if ("show".equals(string2)) {
            zzaa2.setVisibility(0);
            return;
        }
        if ("src".equals(string2)) {
            zzaa2.zzbq(map.get("src"));
            return;
        }
        if ("touchMove".equals(string2)) {
            Context context = zzakk2.getContext();
            int n = zzsg.zza(context, map, "dx", 0);
            int n7 = zzsg.zza(context, map, "dy", 0);
            zzaa2.zza(n, n7);
            if (!this.zzbwc) {
                zzakk2.zzrz().zzmt();
                this.zzbwc = true;
            }
            return;
        }
        if ("volume".equals(string2)) {
            String string6 = map.get("volume");
            if (string6 == null) {
                zzafx.zzcs((String)"Level parameter missing from volume video GMSG.");
                return;
            }
            try {
                float f = Float.parseFloat(string6);
                zzaa2.zzb(f);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = String.valueOf(string6);
                zzafx.zzcs((String)(string7.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string7) : new String("Could not parse volume parameter from volume video GMSG: ")));
                return;
            }
        }
        if ("watermark".equals(string2)) {
            zzaa2.zzne();
            return;
        }
        String string8 = String.valueOf(string2);
        zzafx.zzcs((String)(string8.length() != 0 ? "Unknown video action: ".concat(string8) : new String("Unknown video action: ")));
    }
}

