/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.provider.CalendarContract;
import android.text.TextUtils;
import com.google.android.gms.R;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzahf;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzwr;
import com.google.android.gms.internal.zzws;
import com.google.android.gms.internal.zzxd;
import com.google.android.gms.internal.zzzt;
import java.util.Map;

@zzzt
public final class zzwq
extends zzxd {
    private final Map<String, String> zzbqo;
    private final Context mContext;
    private String zzcdl;
    private long zzcdm;
    private long zzcdn;
    private String zzcdo;
    private String zzcdp;

    public zzwq(zzakk zzakk2, Map<String, String> map) {
        super(zzakk2, "createCalendarEvent");
        this.zzbqo = map;
        this.mContext = zzakk2.zzrx();
        zzwq zzwq2 = this;
        zzwq2.zzcdl = zzwq2.zzbl("description");
        zzwq2.zzcdo = zzwq2.zzbl("summary");
        zzwq2.zzcdm = zzwq2.zzbm("start_ticks");
        zzwq2.zzcdn = zzwq2.zzbm("end_ticks");
        zzwq2.zzcdp = zzwq2.zzbl("location");
    }

    private final String zzbl(String string2) {
        if (TextUtils.isEmpty((CharSequence)this.zzbqo.get(string2))) {
            return "";
        }
        return this.zzbqo.get(string2);
    }

    private final long zzbm(String string2) {
        String string3 = this.zzbqo.get(string2);
        if (string3 == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public final void execute() {
        if (this.mContext == null) {
            this.zzbn("Activity context is not available.");
            return;
        }
        zzbv.zzea();
        if (!zzahf.zzak(this.mContext).zzij()) {
            this.zzbn("This feature is not available on the device.");
            return;
        }
        zzbv.zzea();
        AlertDialog.Builder builder = zzahf.zzaj(this.mContext);
        Resources resources = zzbv.zzee().getResources();
        builder.setTitle((CharSequence)(resources != null ? resources.getString(R.string.s5) : "Create calendar event"));
        builder.setMessage((CharSequence)(resources != null ? resources.getString(R.string.s6) : "Allow Ad to create a calendar event?"));
        builder.setPositiveButton((CharSequence)(resources != null ? resources.getString(R.string.s3) : "Accept"), (DialogInterface.OnClickListener)new zzwr(this));
        builder.setNegativeButton((CharSequence)(resources != null ? resources.getString(R.string.s4) : "Decline"), (DialogInterface.OnClickListener)new zzws(this));
        builder.create().show();
    }

    @TargetApi(value=14)
    final Intent createIntent() {
        Intent intent = new Intent("android.intent.action.EDIT").setData(CalendarContract.Events.CONTENT_URI);
        intent.putExtra("title", this.zzcdl);
        intent.putExtra("eventLocation", this.zzcdp);
        intent.putExtra("description", this.zzcdo);
        if (this.zzcdm > -1L) {
            intent.putExtra("beginTime", this.zzcdm);
        }
        if (this.zzcdn > -1L) {
            intent.putExtra("endTime", this.zzcdn);
        }
        intent.setFlags(0x10000000);
        return intent;
    }

    static /* synthetic */ Context zza(zzwq zzwq2) {
        return zzwq2.mContext;
    }
}

