/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzaha;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzrg;
import com.google.android.gms.internal.zzri;
import com.google.android.gms.internal.zzrk;
import com.google.android.gms.internal.zzrl;
import com.google.android.gms.internal.zzrm;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzzn;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzzn
public final class zzrh
implements zzrg {
    private final Context mContext;
    private final zzajl zzaor;

    public zzrh(Context context, zzajl zzajl2) {
        this.mContext = context;
        this.zzaor = zzajl2;
    }

    private static zzrl zzc(JSONObject jSONObject) {
        String string2 = jSONObject.optString("http_request_id");
        String string3 = jSONObject.optString("url");
        String string4 = jSONObject.optString("post_body", null);
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            zzafy.zzb((String)"Error constructing http request.", (Throwable)malformedURLException);
        }
        ArrayList<zzrk> arrayList = new ArrayList<zzrk>();
        JSONArray jSONArray = jSONObject.optJSONArray("headers");
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i);
            if (jSONObject2 == null) continue;
            String string5 = jSONObject2.optString("key");
            String string6 = jSONObject2.optString("value");
            arrayList.add(new zzrk(string5, string6));
        }
        return new zzrl(string2, uRL, arrayList, string4);
    }

    private static JSONObject zza(zzrn zzrn2) {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("http_request_id", (Object)zzrn2.zzkd());
            if (zzrn2.getBody() != null) {
                jSONObject.put("body", (Object)zzrn2.getBody());
            }
            JSONArray jSONArray = new JSONArray();
            for (zzrk zzrk2 : zzrn2.zzki()) {
                jSONArray.put((Object)new JSONObject().put("key", (Object)zzrk2.getKey()).put("value", (Object)zzrk2.getValue()));
            }
            jSONObject.put("headers", (Object)jSONArray);
            jSONObject.put("response_code", zzrn2.getResponseCode());
        }
        catch (JSONException jSONException) {
            zzafy.zzb((String)"Error constructing JSON for http response.", (Throwable)jSONException);
        }
        return jSONObject;
    }

    private final zzrm zza(zzrl zzrl2) {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object2;
            Object object3;
            httpURLConnection = (HttpURLConnection)zzrl2.zzke().openConnection();
            zzbv.zzea().zza(this.mContext, this.zzaor.zzcp, false, httpURLConnection);
            ArrayList<zzrk> arrayList = zzrl2.zzkf();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                zzrk zzrk2 = arrayList.get(i);
                object3 = zzrk2;
                httpURLConnection.addRequestProperty(((zzrk)object3).getKey(), ((zzrk)object3).getValue());
            }
            if (!TextUtils.isEmpty((CharSequence)zzrl2.zzkg())) {
                httpURLConnection.setDoOutput(true);
                object2 = zzrl2.zzkg().getBytes();
                httpURLConnection.setFixedLengthStreamingMode(((Object)object2).length);
                object3 = new BufferedOutputStream(httpURLConnection.getOutputStream());
                ((FilterOutputStream)object3).write((byte[])object2);
                ((FilterOutputStream)object3).close();
            }
            object2 = new ArrayList();
            if (httpURLConnection.getHeaderFields() != null) {
                for (Map.Entry object4 : httpURLConnection.getHeaderFields().entrySet()) {
                    for (String string2 : (List)object4.getValue()) {
                        ((ArrayList)object2).add(new zzrk((String)object4.getKey(), string2));
                    }
                }
            }
            String string3 = zzrl2.zzkd();
            int n2 = httpURLConnection.getResponseCode();
            zzbv.zzea();
            object3 = new zzrn(string3, n2, (List<zzrk>)object2, zzahg.zza(new InputStreamReader(httpURLConnection.getInputStream())));
            zzrm zzrm2 = new zzrm(this, true, (zzrn)object3, null);
            return zzrm2;
        }
        catch (Exception exception) {
            zzrm zzrm2 = new zzrm(this, false, null, exception.toString());
            return zzrm2;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    public final JSONObject zzaq(String string2) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string2);
        }
        catch (JSONException jSONException) {
            zzafy.e((String)"The request is not a valid JSON.");
            try {
                return new JSONObject().put("success", false);
            }
            catch (JSONException jSONException2) {
                return new JSONObject();
            }
        }
        JSONObject jSONObject2 = new JSONObject();
        String string3 = "";
        try {
            string3 = jSONObject.optString("http_request_id");
            zzrl zzrl2 = zzrh.zzc(jSONObject);
            zzrm zzrm2 = this.zza(zzrl2);
            if (zzrm2.isSuccess()) {
                JSONObject jSONObject3 = zzrh.zza(zzrm2.zzkh());
                jSONObject2.put("response", (Object)jSONObject3);
                jSONObject2.put("success", true);
            } else {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)zzrm2.getReason());
            }
        }
        catch (Exception exception) {
            try {
                jSONObject2.put("response", (Object)new JSONObject().put("http_request_id", (Object)string3));
                jSONObject2.put("success", false);
                jSONObject2.put("reason", (Object)exception.toString());
            }
            catch (JSONException jSONException) {}
        }
        return jSONObject2;
    }

    @Override
    public final void zza(zzakl zzakl2, Map<String, String> map) {
        zzaha.zza(new zzri(this, map, zzakl2));
    }
}

