/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import com.google.android.gms.ads.internal.overlay.zzap;
import com.google.android.gms.ads.internal.overlay.zzaq;
import com.google.android.gms.ads.internal.overlay.zzar;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzh;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzk;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzx;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzhs;
import com.google.android.gms.internal.zzzn;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@zzzn
@TargetApi(value=14)
public final class zzd
extends zzy
implements MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener,
TextureView.SurfaceTextureListener {
    private static final Map<Integer, String> zzcfg = new HashMap<Integer, String>();
    private final zzar zzcfh;
    private final boolean zzcfi;
    private int zzcfj = 0;
    private int zzcfk = 0;
    private MediaPlayer zzcfl;
    private Uri zzcfm;
    private int zzcfn;
    private int zzcfo;
    private int zzcfp;
    private int zzcfq;
    private int zzcfr;
    private zzap zzcfs;
    private boolean zzcft;
    private int zzcfu;
    private zzx zzcfv;

    public zzd(Context context, boolean bl, boolean bl2, zzaq zzaq2, zzar zzar2) {
        super(context);
        this.setSurfaceTextureListener(this);
        this.zzcfh = zzar2;
        this.zzcft = bl;
        this.zzcfi = bl2;
        this.zzcfh.zza(this);
    }

    @Override
    public final String zzmj() {
        String string = String.valueOf(this.zzcft ? " spherical" : "");
        if (string.length() != 0) {
            return "MediaPlayer".concat(string);
        }
        return new String("MediaPlayer");
    }

    @Override
    public final void zza(zzx zzx2) {
        this.zzcfv = zzx2;
    }

    @Override
    public final void setVideoPath(String string) {
        Uri uri = Uri.parse((String)string);
        zzd zzd2 = this;
        zzhs zzhs2 = zzhs.zzd(uri);
        zzd2.zzcfm = zzhs2 == null ? uri : Uri.parse((String)zzhs2.url);
        zzd2.zzcfu = 0;
        zzd2.zzmk();
        zzd2.requestLayout();
        zzd2.invalidate();
    }

    @Override
    public final void stop() {
        zzafy.v("AdMediaPlayerView stop");
        if (this.zzcfl != null) {
            this.zzcfl.stop();
            this.zzcfl.release();
            this.zzcfl = null;
            this.zzv(0);
            this.zzcfk = 0;
        }
        this.zzcfh.onStop();
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        zzafy.v(new StringBuilder(57).append("AdMediaPlayerView size changed: ").append(n).append(" x ").append(n2).toString());
        this.zzcfn = mediaPlayer.getVideoWidth();
        this.zzcfo = mediaPlayer.getVideoHeight();
        if (this.zzcfn != 0 && this.zzcfo != 0) {
            this.requestLayout();
        }
    }

    public final void onPrepared(MediaPlayer mediaPlayer) {
        zzafy.v("AdMediaPlayerView prepared");
        this.zzv(2);
        this.zzcfh.zzmz();
        zzahg.zzdca.post((Runnable)new zze(this));
        this.zzcfn = mediaPlayer.getVideoWidth();
        this.zzcfo = mediaPlayer.getVideoHeight();
        if (this.zzcfu != 0) {
            ((zzy)this).seekTo(this.zzcfu);
        }
        this.zzml();
        int n = this.zzcfn;
        int n2 = this.zzcfo;
        zzafy.zzcq((String)new StringBuilder(62).append("AdMediaPlayerView stream dimensions: ").append(n).append(" x ").append(n2).toString());
        if (this.zzcfk == 3) {
            ((zzy)this).play();
        }
        ((zzy)this).zzmn();
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        zzafy.v("AdMediaPlayerView completion");
        this.zzv(5);
        this.zzcfk = 5;
        zzahg.zzdca.post((Runnable)new zzf(this));
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzcfg.get(n);
        String string2 = zzcfg.get(n2);
        zzafy.v(new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer info: ").append(string).append(":").append(string2).toString());
        return true;
    }

    public final boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
        String string = zzcfg.get(n);
        String string2 = zzcfg.get(n2);
        zzafy.zzcr((String)new StringBuilder(38 + String.valueOf(string).length() + String.valueOf(string2).length()).append("AdMediaPlayerView MediaPlayer error: ").append(string).append(":").append(string2).toString());
        this.zzv(-1);
        this.zzcfk = -1;
        zzahg.zzdca.post((Runnable)new zzg(this, string, string2));
        return true;
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzcfp = n;
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        zzafy.v("AdMediaPlayerView surface created");
        this.zzmk();
        zzahg.zzdca.post((Runnable)new zzh(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        boolean bl;
        zzafy.v("AdMediaPlayerView surface changed");
        boolean bl2 = this.zzcfk == 3;
        boolean bl3 = bl = this.zzcfn == n && this.zzcfo == n2;
        if (this.zzcfl != null && bl2 && bl) {
            if (this.zzcfu != 0) {
                ((zzy)this).seekTo(this.zzcfu);
            }
            ((zzy)this).play();
        }
        if (this.zzcfs != null) {
            this.zzcfs.zzf(n, n2);
        }
        zzahg.zzdca.post((Runnable)new zzi(this, n, n2));
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        zzafy.v("AdMediaPlayerView surface destroyed");
        if (this.zzcfl != null && this.zzcfu == 0) {
            this.zzcfu = this.zzcfl.getCurrentPosition();
        }
        if (this.zzcfs != null) {
            this.zzcfs.zznl();
        }
        zzahg.zzdca.post((Runnable)new zzj(this));
        this.zzr(true);
        return true;
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzcfh.zzb(this);
        this.zzchl.zza(surfaceTexture, this.zzcfv);
    }

    protected final void onMeasure(int n, int n2) {
        int n3 = zzd.getDefaultSize((int)this.zzcfn, (int)n);
        int n4 = zzd.getDefaultSize((int)this.zzcfo, (int)n2);
        if (this.zzcfn > 0 && this.zzcfo > 0 && this.zzcfs == null) {
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            if (n5 == 0x40000000 && n7 == 0x40000000) {
                n4 = n8;
                n3 = n6;
                if (this.zzcfn * n4 < n3 * this.zzcfo) {
                    n3 = n4 * this.zzcfn / this.zzcfo;
                } else if (this.zzcfn * n4 > n3 * this.zzcfo) {
                    n4 = n3 * this.zzcfo / this.zzcfn;
                }
            } else if (n5 == 0x40000000) {
                n3 = n6;
                n4 = n3 * this.zzcfo / this.zzcfn;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                }
            } else if (n7 == 0x40000000) {
                n4 = n8;
                n3 = n4 * this.zzcfn / this.zzcfo;
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                }
            } else {
                n3 = this.zzcfn;
                n4 = this.zzcfo;
                if (n7 == Integer.MIN_VALUE && n4 > n8) {
                    n4 = n8;
                    n3 = n4 * this.zzcfn / this.zzcfo;
                }
                if (n5 == Integer.MIN_VALUE && n3 > n6) {
                    n3 = n6;
                    n4 = n3 * this.zzcfo / this.zzcfn;
                }
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzcfs != null) {
            this.zzcfs.zzf(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzcfq > 0 && this.zzcfq != n3 || this.zzcfr > 0 && this.zzcfr != n4) {
                this.zzml();
            }
            this.zzcfq = n3;
            this.zzcfr = n4;
        }
    }

    public final String toString() {
        String string = this.getClass().getName();
        String string2 = Integer.toHexString(this.hashCode());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("@").append(string2).toString();
    }

    private final void zzmk() {
        zzafy.v("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzcfm == null || surfaceTexture == null) {
            return;
        }
        this.zzr(false);
        try {
            Surface surface;
            zzbv.zzes();
            this.zzcfl = new MediaPlayer();
            this.zzcfl.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzcfl.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzcfl.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzcfl.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzcfl.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzcfl.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzcfp = 0;
            if (this.zzcft) {
                this.zzcfs = new zzap(this.getContext());
                this.zzcfs.zza(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzcfs.start();
                surface = this.zzcfs.zznm();
                if (surface != null) {
                    surfaceTexture = surface;
                } else {
                    this.zzcfs.zznl();
                    this.zzcfs = null;
                }
            }
            this.zzcfl.setDataSource(this.getContext(), this.zzcfm);
            zzbv.zzet();
            SurfaceTexture surfaceTexture2 = surfaceTexture;
            surface = new Surface(surfaceTexture2);
            this.zzcfl.setSurface(surface);
            this.zzcfl.setAudioStreamType(3);
            this.zzcfl.setScreenOnWhilePlaying(true);
            this.zzcfl.prepareAsync();
            this.zzv(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string = String.valueOf(this.zzcfm);
            zzafy.zzc((String)new StringBuilder(36 + String.valueOf(string).length()).append("Failed to initialize MediaPlayer at ").append(string).toString(), (Throwable)exception);
            this.onError(this.zzcfl, 1, 0);
            return;
        }
    }

    private final void zzml() {
        if (!this.zzcfi) {
            return;
        }
        if (this.zzmm() && this.zzcfl.getCurrentPosition() > 0 && this.zzcfk != 3) {
            zzafy.v("AdMediaPlayerView nudging MediaPlayer");
            this.zza(0.0f);
            this.zzcfl.start();
            int n = this.zzcfl.getCurrentPosition();
            long l = zzbv.zzeg().currentTimeMillis();
            while (this.zzmm() && this.zzcfl.getCurrentPosition() == n && zzbv.zzeg().currentTimeMillis() - l <= 250L) {
            }
            this.zzcfl.pause();
            ((zzy)this).zzmn();
        }
    }

    private final void zzr(boolean bl) {
        zzafy.v("AdMediaPlayerView release");
        if (this.zzcfs != null) {
            this.zzcfs.zznl();
            this.zzcfs = null;
        }
        if (this.zzcfl != null) {
            this.zzcfl.reset();
            this.zzcfl.release();
            this.zzcfl = null;
            this.zzv(0);
            if (bl) {
                this.zzcfk = 0;
                this.zzcfk = 0;
            }
        }
    }

    @Override
    public final void play() {
        zzafy.v("AdMediaPlayerView play");
        if (this.zzmm()) {
            this.zzcfl.start();
            this.zzv(3);
            this.zzchl.zzna();
            zzahg.zzdca.post((Runnable)new zzk(this));
        }
        this.zzcfk = 3;
    }

    @Override
    public final void pause() {
        zzafy.v("AdMediaPlayerView pause");
        if (this.zzmm() && this.zzcfl.isPlaying()) {
            this.zzcfl.pause();
            this.zzv(4);
            zzahg.zzdca.post((Runnable)new zzl(this));
        }
        this.zzcfk = 4;
    }

    @Override
    public final int getDuration() {
        if (this.zzmm()) {
            return this.zzcfl.getDuration();
        }
        return -1;
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzmm()) {
            return this.zzcfl.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final void seekTo(int n) {
        zzafy.v(new StringBuilder(34).append("AdMediaPlayerView seek ").append(n).toString());
        if (this.zzmm()) {
            this.zzcfl.seekTo(n);
            this.zzcfu = 0;
            return;
        }
        this.zzcfu = n;
    }

    private final boolean zzmm() {
        return this.zzcfl != null && this.zzcfj != -1 && this.zzcfj != 0 && this.zzcfj != 1;
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzcfs != null) {
            this.zzcfs.zzb(f, f2);
        }
    }

    @Override
    public final int getVideoWidth() {
        if (this.zzcfl != null) {
            return this.zzcfl.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final int getVideoHeight() {
        if (this.zzcfl != null) {
            return this.zzcfl.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final void zzmn() {
        this.zza(this.zzchm.zzns());
    }

    private final void zza(float f) {
        if (this.zzcfl != null) {
            try {
                this.zzcfl.setVolume(f, f);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                return;
            }
        }
        zzafy.zzcr((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
    }

    private final void zzv(int n) {
        if (n == 3) {
            this.zzcfh.zznp();
            this.zzchm.zznp();
        } else if (this.zzcfj == 3) {
            this.zzcfh.zznq();
            this.zzchm.zznq();
        }
        this.zzcfj = n;
    }

    static /* synthetic */ zzx zza(zzd zzd2) {
        return zzd2.zzcfv;
    }

    static {
        if (Build.VERSION.SDK_INT >= 17) {
            zzcfg.put(-1004, "MEDIA_ERROR_IO");
            zzcfg.put(-1007, "MEDIA_ERROR_MALFORMED");
            zzcfg.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
            zzcfg.put(-110, "MEDIA_ERROR_TIMED_OUT");
            zzcfg.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        }
        zzcfg.put(100, "MEDIA_ERROR_SERVER_DIED");
        zzcfg.put(1, "MEDIA_ERROR_UNKNOWN");
        zzcfg.put(1, "MEDIA_INFO_UNKNOWN");
        zzcfg.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzcfg.put(701, "MEDIA_INFO_BUFFERING_START");
        zzcfg.put(702, "MEDIA_INFO_BUFFERING_END");
        zzcfg.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzcfg.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzcfg.put(802, "MEDIA_INFO_METADATA_UPDATE");
        if (Build.VERSION.SDK_INT >= 19) {
            zzcfg.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
            zzcfg.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
        }
    }
}

