/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.zzi;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzaci;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzajf;
import com.google.android.gms.internal.zzbed;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zznk;
import java.util.Locale;

public final class zzacj {
    private int zzcuq;
    private boolean zzcux;
    private boolean zzcuy;
    private int zzcvc;
    private int zzcvg;
    private int zzcvh;
    private String zzcut;
    private int zzcvd;
    private int zzcve;
    private int zzcvf;
    private boolean zzcvk;
    private int zzcvl;
    private double zzcvi;
    private boolean zzcvj;
    private String zzcvm;
    private String zzcvn;
    private boolean zzcur;
    private boolean zzcus;
    private String zzcuu;
    private boolean zzcuv;
    private boolean zzcuw;
    private String zzcuz;
    private String zzcva;
    private float zzawy;
    private int zzcop;
    private int zzcoq;
    private String zzcvb;
    private boolean zzcvo;

    public zzacj(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzl(context);
        this.zzm(context);
        this.zzn(context);
        Locale locale = Locale.getDefault();
        this.zzcur = zzacj.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzcus = zzacj.zza(packageManager, "http://www.google.com") != null;
        this.zzcuu = locale.getCountry();
        zzjh.zzhu();
        this.zzcuv = zzajf.zzrs();
        this.zzcuw = zzi.zzck((Context)context);
        this.zzcuz = locale.getLanguage();
        this.zzcva = zzacj.zzb(context, packageManager);
        this.zzcvb = zzacj.zza(context, packageManager);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzawy = displayMetrics.density;
        this.zzcop = displayMetrics.widthPixels;
        this.zzcoq = displayMetrics.heightPixels;
    }

    public zzacj(Context context, zzaci zzaci2) {
        context.getPackageManager();
        this.zzl(context);
        this.zzm(context);
        this.zzn(context);
        Context context2 = context;
        zzacj zzacj2 = this;
        this.zzcvm = Build.FINGERPRINT;
        zzacj2.zzcvn = Build.DEVICE;
        zzacj2.zzcvo = zzq.zzald() && zznk.zzj(context2);
        this.zzcur = zzaci2.zzcur;
        this.zzcus = zzaci2.zzcus;
        this.zzcuu = zzaci2.zzcuu;
        this.zzcuv = zzaci2.zzcuv;
        this.zzcuw = zzaci2.zzcuw;
        this.zzcuz = zzaci2.zzcuz;
        this.zzcva = zzaci2.zzcva;
        this.zzcvb = zzaci2.zzcvb;
        this.zzawy = zzaci2.zzawy;
        this.zzcop = zzaci2.zzcop;
        this.zzcoq = zzaci2.zzcoq;
    }

    private final void zzl(Context context) {
        zzbv.zzea();
        AudioManager audioManager = zzahg.zzan(context);
        if (audioManager != null) {
            try {
                this.zzcuq = audioManager.getMode();
                this.zzcux = audioManager.isMusicActive();
                this.zzcuy = audioManager.isSpeakerphoneOn();
                this.zzcvc = audioManager.getStreamVolume(3);
                this.zzcvg = audioManager.getRingerMode();
                this.zzcvh = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzbv.zzee().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzcuq = -2;
        this.zzcux = false;
        this.zzcuy = false;
        this.zzcvc = 0;
        this.zzcvg = 0;
        this.zzcvh = 0;
    }

    @TargetApi(value=16)
    private final void zzm(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzcut = telephonyManager.getNetworkOperator();
        this.zzcve = telephonyManager.getNetworkType();
        this.zzcvf = telephonyManager.getPhoneType();
        this.zzcvd = -2;
        this.zzcvk = false;
        this.zzcvl = -1;
        zzbv.zzea();
        if (zzahg.zzc(context, context.getPackageName(), "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzcvd = networkInfo.getType();
                this.zzcvl = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzcvd = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzcvk = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzn(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzcvi = (float)n2 / (float)n3;
            this.zzcvj = n == 2 || n == 5;
            return;
        }
        this.zzcvi = -1.0;
        this.zzcvj = false;
    }

    private static String zza(Context context, PackageManager packageManager) {
        try {
            PackageInfo packageInfo = zzbed.zzcr((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zzb(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzacj.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = zzbed.zzcr((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }
        catch (Throwable throwable) {
            zzbv.zzee().zza(throwable, "DeviceInfo.getResolveInfo");
            return null;
        }
    }

    public final zzaci zzos() {
        return new zzaci(this.zzcuq, this.zzcur, this.zzcus, this.zzcut, this.zzcuu, this.zzcuv, this.zzcuw, this.zzcux, this.zzcuy, this.zzcuz, this.zzcva, this.zzcvb, this.zzcvc, this.zzcvd, this.zzcve, this.zzcvf, this.zzcvg, this.zzcvh, this.zzawy, this.zzcop, this.zzcoq, this.zzcvi, this.zzcvj, this.zzcvk, this.zzcvl, this.zzcvm, this.zzcvo, this.zzcvn);
    }
}

