/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.internal.zzajs;
import com.google.android.gms.internal.zzajt;
import com.google.android.gms.internal.zzzn;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzzn
public class zzajy<T>
implements zzajs<T> {
    private final Object mLock = new Object();
    private T mValue;
    private Throwable zzdfp;
    private boolean zzdfq;
    private boolean zzccl;
    private final zzajt zzdfr = new zzajt();

    @Override
    public final void zza(Runnable runnable, Executor executor) {
        this.zzdfr.zza(runnable, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(@Nullable T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzccl) {
                return;
            }
            if (this.zzrv()) {
                zzbv.zzee().zza(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.set");
                return;
            }
            this.zzdfq = true;
            this.mValue = t;
            this.mLock.notifyAll();
            this.zzdfr.zzru();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(Throwable throwable) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzccl) {
                return;
            }
            if (this.zzrv()) {
                zzbv.zzee().zza(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.setException");
                return;
            }
            this.zzdfp = throwable;
            this.mLock.notifyAll();
            this.zzdfr.zzru();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws CancellationException, ExecutionException, InterruptedException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzrv()) {
                this.mLock.wait();
            }
            if (this.zzdfp != null) {
                throw new ExecutionException(this.zzdfp);
            }
            if (this.zzccl) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzrv()) {
                long l2 = timeUnit.toMillis(l);
                if (l2 != 0L) {
                    this.mLock.wait(l2);
                }
            }
            if (this.zzdfp != null) {
                throw new ExecutionException(this.zzdfp);
            }
            if (!this.zzdfq) {
                throw new TimeoutException("SettableFuture timed out.");
            }
            if (this.zzccl) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.mValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (!bl) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzrv()) {
                return false;
            }
            this.zzccl = true;
            this.zzdfq = true;
            this.mLock.notifyAll();
            this.zzdfr.zzru();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzccl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzrv();
        }
    }

    private final boolean zzrv() {
        return this.zzdfp != null || this.zzdfq;
    }
}

