/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.zzbo;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.ads.internal.zzv;
import com.google.android.gms.common.util.zzq;
import com.google.android.gms.internal.zzafy;
import com.google.android.gms.internal.zzahg;
import com.google.android.gms.internal.zzahl;
import com.google.android.gms.internal.zzaje;
import com.google.android.gms.internal.zzajf;
import com.google.android.gms.internal.zzajl;
import com.google.android.gms.internal.zzakg;
import com.google.android.gms.internal.zzakk;
import com.google.android.gms.internal.zzakl;
import com.google.android.gms.internal.zzakm;
import com.google.android.gms.internal.zzala;
import com.google.android.gms.internal.zzalb;
import com.google.android.gms.internal.zzalc;
import com.google.android.gms.internal.zzald;
import com.google.android.gms.internal.zzalg;
import com.google.android.gms.internal.zzcs;
import com.google.android.gms.internal.zzfz;
import com.google.android.gms.internal.zzhz;
import com.google.android.gms.internal.zziu;
import com.google.android.gms.internal.zzjh;
import com.google.android.gms.internal.zzmd;
import com.google.android.gms.internal.zzmn;
import com.google.android.gms.internal.zzmt;
import com.google.android.gms.internal.zzmy;
import com.google.android.gms.internal.zzmz;
import com.google.android.gms.internal.zzna;
import com.google.android.gms.internal.zznv;
import com.google.android.gms.internal.zzrg;
import com.google.android.gms.internal.zzsd;
import com.google.android.gms.internal.zzse;
import com.google.android.gms.internal.zzwx;
import com.google.android.gms.internal.zzzn;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

@zzzn
final class zzakz
extends WebView
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzakl {
    private final zzalc zzdhe;
    private final Object mLock = new Object();
    @Nullable
    private final zzcs zzbsr;
    private final zzajl zzaos;
    private final zzbo zzdhf;
    private final zzv zzaml;
    private zzakm zzdhg;
    private zzm zzdhh;
    private zziu zzarf;
    private boolean zzdhi;
    private boolean zzdhj;
    private boolean zzdhk;
    private boolean zzdhl;
    private Boolean zzdad;
    private int zzdhm;
    private boolean zzdhn = true;
    private boolean zzdho = false;
    private String zzcjw = "";
    private zzald zzdhp;
    private boolean zzdhq;
    private boolean zzdhr;
    private zznv zzdhs;
    private int zzdht;
    private int zzdhu;
    private zzmy zzdhv;
    private zzmy zzcjx;
    private zzmy zzdhw;
    private zzmz zzdhx;
    private WeakReference<View.OnClickListener> zzdhy;
    private zzm zzdhz;
    private boolean zzdia;
    private zzaje zzauj;
    private int zzcev = -1;
    private int zzceu = -1;
    private int zzcex = -1;
    private int zzcey = -1;
    private Map<String, zzse> zzdib;
    private final WindowManager zzauy;
    private final zzhz zzcnr;

    static zzakz zzb(Context context, zziu zziu2, boolean bl, boolean bl2, @Nullable zzcs zzcs2, zzajl zzajl2, zzna zzna2, zzbo zzbo2, zzv zzv2, zzhz zzhz2) {
        zzalc zzalc2 = new zzalc(context);
        return new zzakz(zzalc2, zziu2, bl, bl2, zzcs2, zzajl2, zzna2, zzbo2, zzv2, zzhz2);
    }

    private zzakz(zzalc zzalc2, zziu zziu2, boolean bl, boolean bl2, @Nullable zzcs zzcs2, zzajl zzajl2, zzna zzna2, zzbo zzbo2, zzv zzv2, zzhz zzhz2) {
        super((Context)zzalc2);
        this.zzdhe = zzalc2;
        this.zzarf = zziu2;
        this.zzdhk = bl;
        this.zzdhm = -1;
        this.zzbsr = zzcs2;
        this.zzaos = zzajl2;
        this.zzdhf = zzbo2;
        this.zzaml = zzv2;
        this.zzauy = (WindowManager)this.getContext().getSystemService("window");
        this.zzcnr = zzhz2;
        this.setBackgroundColor(0);
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        try {
            webSettings.setJavaScriptEnabled(true);
        }
        catch (NullPointerException nullPointerException) {
            zzafy.zzb((String)"Unable to enable Javascript.", (Throwable)nullPointerException);
        }
        webSettings.setSavePassword(false);
        webSettings.setSupportMultipleWindows(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(2);
        }
        WebSettings webSettings2 = webSettings;
        String string2 = zzajl2.zzcq;
        zzalc zzalc3 = zzalc2;
        zzahg zzahg2 = zzbv.zzea();
        webSettings2.setUserAgentString(zzahg2.zzr((Context)zzalc3, string2));
        zzbv.zzec().zza(this.getContext(), webSettings);
        this.setDownloadListener(this);
        this.zztl();
        if (zzq.zzalf()) {
            this.addJavascriptInterface(new zzalg(this), "googleAdsJsInterface");
        }
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.zzauj = new zzaje(this.zzdhe.zzsa(), (View)this, this, null);
        this.zzd(zzna2);
        zzbv.zzec().zzat((Context)zzalc2);
    }

    @Override
    public final void setWebViewClient(WebViewClient webViewClient) {
        super.setWebViewClient(webViewClient);
        if (webViewClient instanceof zzakm) {
            this.zzdhg = (zzakm)webViewClient;
        }
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final zzv zzbi() {
        return this.zzaml;
    }

    private final boolean zztj() {
        int n;
        int n2;
        if (!this.zzdhg.zzfo() && !this.zzdhg.zzsx()) {
            return false;
        }
        zzbv.zzea();
        DisplayMetrics displayMetrics = zzahg.zza(this.zzauy);
        zzjh.zzhu();
        int n3 = zzajf.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.widthPixels);
        zzjh.zzhu();
        int n4 = zzajf.zzb((DisplayMetrics)displayMetrics, (int)displayMetrics.heightPixels);
        Activity activity = this.zzdhe.zzsa();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzbv.zzea();
            int[] nArray = zzahg.zzf(activity);
            zzjh.zzhu();
            n2 = zzajf.zzb((DisplayMetrics)displayMetrics, (int)nArray[0]);
            zzjh.zzhu();
            n = zzajf.zzb((DisplayMetrics)displayMetrics, (int)nArray[1]);
        }
        if (this.zzceu == n3 && this.zzcev == n4 && this.zzcex == n2 && this.zzcey == n) {
            return false;
        }
        boolean bl = this.zzceu != n3 || this.zzcev != n4;
        this.zzceu = n3;
        this.zzcev = n4;
        this.zzcex = n2;
        this.zzcey = n;
        new zzwx(this).zza(n3, n4, n2, n, displayMetrics.density, this.zzauy.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final void zza(String string2, Map<String, ?> map) {
        JSONObject jSONObject;
        try {
            jSONObject = zzbv.zzea().zzk(map);
        }
        catch (JSONException jSONException) {
            zzafy.zzcr((String)"Could not convert parameters to JSON.");
            return;
        }
        this.zzb(string2, jSONObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=19)
    public final void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                zzafy.zzcr((String)"The webview is destroyed. Ignoring action.");
                if (valueCallback != null) {
                    valueCallback.onReceiveValue(null);
                }
                return;
            }
            super.evaluateJavascript(string2, valueCallback);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzcu(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.loadUrl(string2);
            } else {
                zzafy.zzcr((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadUrl(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                try {
                    super.loadUrl(string2);
                }
                catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError throwable) {
                    zzbv.zzee().zza(throwable, "AdWebViewImpl.loadUrl");
                    zzafy.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
                }
            } else {
                zzafy.zzcr((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcs(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                super.loadUrl(string2);
            }
            catch (Exception | IncompatibleClassChangeError | NoClassDefFoundError | UnsatisfiedLinkError throwable) {
                zzbv.zzee().zza(throwable, "AdWebViewImpl.loadUrlUnsafe");
                zzafy.zzc((String)"Could not call loadUrl. ", (Throwable)throwable);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadData(String string2, String string3, String string4) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadData(string2, string3, string4);
            } else {
                zzafy.zzcr((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            } else {
                zzafy.zzcr((String)"The webview is destroyed. Ignoring action.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzcv(String string2) {
        if (zzq.zzalh()) {
            Object object;
            zzakz zzakz2;
            if (this.zzqb() == null) {
                zzakz2 = this;
                object = zzakz2.mLock;
                synchronized (object) {
                    zzakz2.zzdad = zzbv.zzee().zzqb();
                    if (zzakz2.zzdad == null) {
                        try {
                            String string3 = "(function(){})()";
                            zzakz2.evaluateJavascript(string3, null);
                            zzakz2.zza(true);
                        }
                        catch (IllegalStateException illegalStateException) {
                            zzakz2.zza(false);
                        }
                    }
                }
            }
            if (this.zzqb().booleanValue()) {
                object = string2;
                zzakz2 = this;
                Object object2 = zzakz2.mLock;
                synchronized (object2) {
                    if (!zzakz2.isDestroyed()) {
                        zzakz2.evaluateJavascript((String)object, null);
                    } else {
                        zzafy.zzcr((String)"The webview is destroyed. Ignoring action.");
                    }
                    return;
                }
            }
            String string4 = String.valueOf(string2);
            this.zzcu(string4.length() != 0 ? "javascript:".concat(string4) : new String("javascript:"));
            return;
        }
        String string5 = String.valueOf(string2);
        this.zzcu(string5.length() != 0 ? "javascript:".concat(string5) : new String("javascript:"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(Boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdad = bl;
        }
        zzbv.zzee().zza(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Boolean zzqb() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdad;
        }
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        this.zzg(string2, string3);
    }

    @Override
    public final void zzg(String string2, String string3) {
        String string4 = new StringBuilder(3 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("(").append(string3).append(");").toString();
        this.zzcv(string4);
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        String string3 = jSONObject.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(window.AFMA_ReceiveMessage || function() {})('");
        stringBuilder.append(string2);
        stringBuilder.append("'");
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(");");
        String string4 = String.valueOf(stringBuilder.toString());
        zzafy.zzca((String)(string4.length() != 0 ? "Dispatching AFMA event: ".concat(string4) : new String("Dispatching AFMA event: ")));
        this.zzcv(stringBuilder.toString());
    }

    @Override
    public final void zzry() {
        this.zztk();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzaos.zzcq);
        this.zza("onhide", hashMap);
    }

    @Override
    public final void zzae(int n) {
        if (n == 0) {
            zzakz zzakz2 = this;
            zzmt.zza(zzakz2.zzdhx.zziu(), zzakz2.zzcjx, "aebb2");
        }
        this.zztk();
        if (this.zzdhx.zziu() != null) {
            this.zzdhx.zziu().zzf("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzaos.zzcq);
        this.zza("onhide", hashMap);
    }

    private final void zztk() {
        zzmt.zza(this.zzdhx.zziu(), this.zzcjx, "aeh2");
    }

    @Override
    public final void zzmv() {
        if (this.zzdhv == null) {
            zzmt.zza(this.zzdhx.zziu(), this.zzcjx, "aes2");
            this.zzdhv = zzmt.zzb(this.zzdhx.zziu());
            this.zzdhx.zza("native:view_show", this.zzdhv);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzaos.zzcq);
        this.zza("onshow", hashMap);
    }

    @Override
    public final void zzrz() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        zzbv.zzea();
        hashMap.put("app_muted", String.valueOf(zzahg.zzdg()));
        zzbv.zzea();
        hashMap.put("app_volume", String.valueOf(zzahg.zzde()));
        zzbv.zzea();
        hashMap.put("device_volume", String.valueOf(zzahg.zzao(this.getContext())));
        this.zza("volume", hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzm zzsc() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzm zzsd() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zziu zzbk() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzarf;
        }
    }

    @Override
    public final zzakm zzse() {
        return this.zzdhg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsf() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhi;
        }
    }

    @Override
    public final zzcs zzsg() {
        return this.zzbsr;
    }

    @Override
    public final zzajl zzsh() {
        return this.zzaos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsi() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhk;
        }
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzbv.zzea();
            zzahg.zzb(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzafy.zzca((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzdhg.zzsx()) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.zzdhs != null) {
                    this.zzdhs.zzc(motionEvent);
                }
            }
        } else if (this.zzbsr != null) {
            this.zzbsr.zza(motionEvent);
        }
        if (this.isDestroyed()) {
            return false;
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        zzmd<Boolean> zzmd2 = zzmn.zzbjd;
        if (zzbv.zzen().zzd(zzmd2).booleanValue()) {
            float f = motionEvent.getAxisValue(9);
            float f2 = motionEvent.getAxisValue(10);
            if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
                return false;
            }
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"DrawAllocation"})
    protected final void onMeasure(int n, int n2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isDestroyed()) {
                this.setMeasuredDimension(0, 0);
                return;
            }
            if (this.isInEditMode() || this.zzdhk || this.zzarf.zzbcz) {
                super.onMeasure(n, n2);
                return;
            }
            if (this.zzarf.zzbda) {
                int n3;
                Object object2 = zzmn.zzbna;
                if (zzbv.zzen().zzd(object2).booleanValue() || !zzq.zzalf()) {
                    super.onMeasure(n, n2);
                    return;
                }
                object2 = this;
                this.zza("/contentHeight", new zzala((zzakz)object2));
                String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
                this.zzcv(string2);
                float f = this.zzdhe.getResources().getDisplayMetrics().density;
                int n4 = View.MeasureSpec.getSize((int)n);
                switch (this.zzdhu) {
                    case -1: {
                        n3 = View.MeasureSpec.getSize((int)n2);
                        break;
                    }
                    default: {
                        n3 = (int)((float)this.zzdhu * f);
                    }
                }
                this.setMeasuredDimension(n4, n3);
                return;
            }
            if (this.zzarf.zzbcx) {
                DisplayMetrics displayMetrics = new DisplayMetrics();
                this.zzauy.getDefaultDisplay().getMetrics(displayMetrics);
                this.setMeasuredDimension(displayMetrics.widthPixels, displayMetrics.heightPixels);
                return;
            }
            int n5 = View.MeasureSpec.getMode((int)n);
            int n6 = View.MeasureSpec.getSize((int)n);
            int n7 = View.MeasureSpec.getMode((int)n2);
            int n8 = View.MeasureSpec.getSize((int)n2);
            int n9 = Integer.MAX_VALUE;
            if (n5 == Integer.MIN_VALUE || n5 == 0x40000000) {
                n9 = n6;
            }
            int n10 = Integer.MAX_VALUE;
            if (n7 == Integer.MIN_VALUE || n7 == 0x40000000) {
                n10 = n8;
            }
            if (this.zzarf.widthPixels > n9 || this.zzarf.heightPixels > n10) {
                float f = this.zzdhe.getResources().getDisplayMetrics().density;
                int n11 = (int)((float)this.zzarf.widthPixels / f);
                int n12 = (int)((float)this.zzarf.heightPixels / f);
                int n13 = (int)((float)n6 / f);
                int n14 = (int)((float)n8 / f);
                zzafy.zzcr((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n11).append("x").append(n12).append(" dp, but only has ").append(n13).append("x").append(n14).append(" dp.").toString());
                if (this.getVisibility() != 8) {
                    this.setVisibility(4);
                }
                this.setMeasuredDimension(0, 0);
            } else {
                if (this.getVisibility() != 8) {
                    this.setVisibility(0);
                }
                this.setMeasuredDimension(this.zzarf.widthPixels, this.zzarf.heightPixels);
            }
            return;
        }
    }

    public final void onGlobalLayout() {
        boolean bl = this.zztj();
        zzm zzm2 = this.zzsc();
        if (zzm2 != null && bl) {
            zzm2.zzmu();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(Context context, zziu zziu2, zzna zzna2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzauj.zzrp();
            this.setContext(context);
            this.zzdhh = null;
            this.zzarf = zziu2;
            this.zzdhk = false;
            this.zzdhi = false;
            this.zzcjw = "";
            this.zzdhm = -1;
            zzbv.zzec();
            zzahl.zzk(this);
            this.loadUrl("about:blank");
            this.zzdhg.reset();
            this.setOnTouchListener(null);
            this.setOnClickListener(null);
            this.zzdhn = true;
            this.zzdho = false;
            this.zzdhp = null;
            this.zzd(zzna2);
            this.zzdhq = false;
            this.zzdht = 0;
            zzbv.zzex();
            zzsd.zze(this);
            this.zztn();
            return;
        }
    }

    private final void zzd(zzna zzna2) {
        this.zzto();
        this.zzdhx = new zzmz(new zzna(true, "make_wv", this.zzarf.zzbcw));
        this.zzdhx.zziu().zzc(zzna2);
        this.zzcjx = zzmt.zzb(this.zzdhx.zziu());
        this.zzdhx.zza("native:view_create", this.zzcjx);
        this.zzdhw = null;
        this.zzdhv = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(zzm zzm2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhh = zzm2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(zzm zzm2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhz = zzm2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zziu zziu2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzarf = zziu2;
            this.requestLayout();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzab(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl2 = bl != this.zzdhk;
            this.zzdhk = bl;
            this.zztl();
            if (bl2) {
                new zzwx(this).zzbo(bl ? "expanded" : "default");
            }
            return;
        }
    }

    @Override
    public final void zzsr() {
        this.zzauj.zzro();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onAttachedToWindow() {
        Object object = this.mLock;
        synchronized (object) {
            super.onAttachedToWindow();
            if (!this.isDestroyed()) {
                this.zzauj.onAttachedToWindow();
            }
            boolean bl = this.zzdhq;
            if (this.zzdhg != null && this.zzdhg.zzsx()) {
                bl = true;
                if (!this.zzdhr) {
                    ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                    ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdhg.zzsy();
                    if (onGlobalLayoutListener != null) {
                        zzbv.zzey();
                        zzakz zzakz2 = this;
                        if (zzakz2 == null) {
                            throw null;
                        }
                        zzakg.zza((View)zzakz2, onGlobalLayoutListener);
                    }
                    if ((onScrollChangedListener = this.zzdhg.zzsz()) != null) {
                        zzbv.zzey();
                        zzakz zzakz3 = this;
                        if (zzakz3 == null) {
                            throw null;
                        }
                        zzakg.zza((View)zzakz3, onScrollChangedListener);
                    }
                    this.zzdhr = true;
                }
                this.zztj();
            }
            this.zzag(bl);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.isDestroyed()) {
                this.zzauj.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzdhr && this.zzdhg != null && this.zzdhg.zzsx() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                ViewTreeObserver.OnScrollChangedListener onScrollChangedListener;
                ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = this.zzdhg.zzsy();
                if (onGlobalLayoutListener != null) {
                    zzbv.zzec().zza(this.getViewTreeObserver(), onGlobalLayoutListener);
                }
                if ((onScrollChangedListener = this.zzdhg.zzsz()) != null) {
                    this.getViewTreeObserver().removeOnScrollChangedListener(onScrollChangedListener);
                }
                this.zzdhr = false;
            }
        }
        this.zzag(false);
    }

    @Override
    public final void setContext(Context context) {
        this.zzdhe.setBaseContext(context);
        this.zzauj.zzi(this.zzdhe.zzsa());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzac(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdhh != null) {
                this.zzdhh.zza(this.zzdhg.zzfo(), bl);
            } else {
                this.zzdhi = bl;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getRequestedOrientation() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setRequestedOrientation(int n) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhm = n;
            if (this.zzdhh != null) {
                this.zzdhh.setRequestedOrientation(this.zzdhm);
            }
            return;
        }
    }

    @Override
    public final Activity zzsa() {
        return this.zzdhe.zzsa();
    }

    @Override
    public final Context zzsb() {
        return this.zzdhe.zzsb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zztl() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdhk || this.zzarf.zzbcx) {
                zzafy.zzca((String)"Enabling hardware acceleration on an overlay.");
                this.zztm();
            } else if (Build.VERSION.SDK_INT < 18) {
                zzafy.zzca((String)"Disabling hardware acceleration on an AdView.");
                zzakz zzakz2 = this;
                Object object2 = zzakz2.mLock;
                synchronized (object2) {
                    if (!zzakz2.zzdhl) {
                        zzbv.zzec().zzr((View)zzakz2);
                    }
                    zzakz2.zzdhl = true;
                }
            } else {
                zzafy.zzca((String)"Enabling hardware acceleration on an AdView.");
                this.zztm();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zztm() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdhl) {
                zzbv.zzec().zzq((View)this);
            }
            this.zzdhl = false;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzto();
            this.zzauj.zzrp();
            if (this.zzdhh != null) {
                this.zzdhh.close();
                this.zzdhh.onDestroy();
                this.zzdhh = null;
            }
            this.zzdhg.reset();
            if (this.zzdhj) {
                return;
            }
            zzbv.zzex();
            zzsd.zze(this);
            this.zztn();
            this.zzdhj = true;
            zzafy.v("Initiating WebView self destruct sequence in 3...");
            this.zzdhg.zztb();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void finalize() throws Throwable {
        try {
            if (this.mLock != null) {
                Object object = this.mLock;
                synchronized (object) {
                    if (!this.zzdhj) {
                        this.zzdhg.reset();
                        zzbv.zzex();
                        zzsd.zze(this);
                        this.zztn();
                        this.zzqp();
                    }
                }
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzsj() {
        Object object = this.mLock;
        synchronized (object) {
            zzafy.v("Destroying WebView!");
            this.zzqp();
            zzahg.zzdca.post((Runnable)new zzalb(this));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzqp() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.zzdia) {
                this.zzdia = true;
                zzbv.zzee().zzqp();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhj;
        }
    }

    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
        if (this.zzdhg != null && this.zzdhg.zzti() != null) {
            this.zzdhg.zzti().zzcr();
        }
    }

    @Override
    public final void zzss() {
        if (this.zzdhw == null) {
            this.zzdhw = zzmt.zzb(this.zzdhx.zziu());
            this.zzdhx.zza("native:view_load", this.zzdhw);
        }
    }

    @Override
    public final void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzafy.zzb((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzafy.zzb((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzafy.zzb((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzad(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhn = bl;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsk() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsl() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdho;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzci() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdho = true;
            if (this.zzdhf != null) {
                this.zzdhf.zzci();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcj() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdho = false;
            if (this.zzdhf != null) {
                this.zzdhf.zzcj();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zztn() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdib = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzct(String string2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzcjw = string2 == null ? "" : string2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getRequestId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcjw;
        }
    }

    @Override
    public final zzakk zzsm() {
        return null;
    }

    @Override
    public final zzmy zzsn() {
        return this.zzcjx;
    }

    @Override
    public final zzmz zzso() {
        return this.zzdhx;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzdhy = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final View.OnClickListener zzst() {
        return (View.OnClickListener)this.zzdhy.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzb(zznv zznv2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhs = zznv2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zznv zzsu() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzald zzsp() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdhp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzald zzald2) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzdhp != null) {
                zzafy.e((String)"Attempt to create multiple AdWebViewVideoControllers.");
                return;
            }
            this.zzdhp = zzald2;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzsq() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzdht > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzae(boolean bl) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdht += bl ? 1 : -1;
            if (this.zzdht <= 0 && this.zzdhh != null) {
                this.zzdhh.zzmx();
            }
            return;
        }
    }

    private final void zzto() {
        if (this.zzdhx == null) {
            return;
        }
        zzna zzna2 = this.zzdhx.zziu();
        if (zzna2 != null && zzbv.zzee().zzpw() != null) {
            zzbv.zzee().zzpw().zza(zzna2);
        }
    }

    @Override
    public final void zzsv() {
        this.setBackgroundColor(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzfz zzfz2) {
        Object object = this.mLock;
        synchronized (object) {
            this.zzdhq = zzfz2.zzawz;
        }
        this.zzag(zzfz2.zzawz);
    }

    private final void zzag(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        this.zza("onAdVisibilityChanged", hashMap);
    }

    @Override
    public final void zza(String string2, zzrg zzrg2) {
        if (this.zzdhg != null) {
            this.zzdhg.zza(string2, zzrg2);
        }
    }

    @Override
    public final void zzb(String string2, zzrg zzrg2) {
        if (this.zzdhg != null) {
            this.zzdhg.zzb(string2, zzrg2);
        }
    }

    static /* synthetic */ Object zza(zzakz zzakz2) {
        return zzakz2.mLock;
    }

    static /* synthetic */ int zzb(zzakz zzakz2) {
        return zzakz2.zzdhu;
    }

    static /* synthetic */ int zza(zzakz zzakz2, int n) {
        zzakz2.zzdhu = n;
        return zzakz2.zzdhu;
    }

    static /* synthetic */ void zzc(zzakz zzakz2) {
        super.destroy();
    }
}

